/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   lib/legacy/legacy-data-mixin.html
 */

/// <reference path="class.d.ts" />
/// <reference path="../../polymer.d.ts" />
/// <reference path="../utils/mixin.d.ts" />
/// <reference path="../utils/templatize.d.ts" />

declare class UndefinedArgumentError extends Error {
  constructor(message: any, arg: any);
}

declare namespace Polymer {


  /**
   * Mixin to selectively add back Polymer 1.x's `undefined` rules
   * governing when observers & computing functions run based
   * on all arguments being defined (reference https://www.polymer-project.org/1.0/docs/devguide/observers#multi-property-observers).
   *
   * When loaded, all legacy elements (defined with `Polymer({...})`)
   * will have the mixin applied. The mixin only restores legacy data handling
   * if `_legacyUndefinedCheck: true` is set on the element's prototype.
   *
   * This mixin is intended for use to help migration from Polymer 1.x to
   * 2.x+ by allowing legacy code to work while identifying observers and
   * computing functions that need undefined checks to work without
   * the mixin in Polymer 2.
   */
  function LegacyDataMixin<T extends new (...args: any[]) => {}>(base: T): T & LegacyDataMixinConstructor;

  interface LegacyDataMixinConstructor {
    new(...args: any[]): LegacyDataMixin;

    /**
     * Overrides `Polyer.PropertyEffects` to wrap effect functions to
     * catch `UndefinedArgumentError`s and warn.
     *
     * @param templateInfo Template metadata to add effect to
     * @param prop Property that should trigger the effect
     * @param effect Effect metadata object
     */
    _addTemplatePropertyEffect(templateInfo: object|null, prop: string, effect?: object|null): void;
  }

  interface LegacyDataMixin {
    readonly _legacyUndefinedCheck: any;

    /**
     * Overrides `Polyer.PropertyEffects` to wrap effect functions to
     * catch `UndefinedArgumentError`s and warn.
     *
     * @param property Property that should trigger the effect
     * @param type Effect type, from this.PROPERTY_EFFECT_TYPES
     * @param effect Effect metadata object
     */
    _addPropertyEffect(property: string, type: string, effect?: object|null): void;
  }
}

declare class LegacyDataMixin extends superClass {

  /**
   * Overrides `Polyer.PropertyEffects` to wrap effect functions to
   * catch `UndefinedArgumentError`s and warn.
   *
   * @param templateInfo Template metadata to add effect to
   * @param prop Property that should trigger the effect
   * @param effect Effect metadata object
   */
  static _addTemplatePropertyEffect(templateInfo: object|null, prop: string, effect?: object|null): void;

  /**
   * Overrides `Polyer.PropertyEffects` to wrap effect functions to
   * catch `UndefinedArgumentError`s and warn.
   *
   * @param property Property that should trigger the effect
   * @param type Effect type, from this.PROPERTY_EFFECT_TYPES
   * @param effect Effect metadata object
   */
  _addPropertyEffect(property: string, type: string, effect?: object|null): void;
}
