/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util;

import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class CMCSProperties
extends Properties {
    public static final String JAAS_CONTEXT = "logincontext";
    public static final String PORTAL_TITLE = "portaltitle";
    public static final String PORTAL_ACCOUNT = "portalid";
    public static final String PORTAL_ROOT = "portalrootid";
    public static final String PORTAL_ANNOTATOR = "portalannotatorid";
    public static final String SAM_SERVER = "samserver";
    public static final String SAM_PING_PATH = "sampingpath";
    public static final String SPECIES_DICTIONARY_SERVICE = "speciesdictionaryservice";
    public static final String FEEDBACK_TO_ADDRESS = "feedback_to_address";
    public static final String FEEDBACK_FROM_ADDRESS = "feedback_from_address";
    public static final String FEEDBACK_PRODUCT = "feedback_product";
    public static final String FEEDBACK_REP_PLATFORM = "feedback_rep_platform";
    public static final String FEEDBACK_BUG_SEVERITY = "feedback_bug_severity";
    public static final String FEEDBACK_PRIORITY = "feedback_priority";
    public static final String FEEDBACK_OP_SYS = "feedback_op_sys";
    public static final String FEEDBACK_COMPONENT = "feedback_component";
    public static final String FEEDBACK_GROUPSET = "feedback_groupset";
    public static final String MESSAGE_SERVER = "msgserver";
    public static final String MESSAGE_PORT = "msgport";
    public static final String MAILHOST = "mailhost";
    public static final String NED_SENDER = "nedsender";
    public static final String NED_SUBJECT = "nedsubject";
    public static final String QMAIL_HOST = "qmail_host";
    public static final String QMAIL_VIRTUAL_HOST = "qmail_virtual_host";
    public static final String QMAIL_USER = "qmail_user";
    public static final String QMAIL_USER_ID = "qmail_user_id";
    public static final String QMAIL_INSTALLED = "qmail_installed";
    public static final String CMCS_VERSION = "cmcsversion";
    public static final String SAM_VERSION = "samversion";
    public static final String CHEF_VERSION = "chefversion";
    public static final String JETSPEED_VERSION = "jetspeedversion";
    public static final String USER_AGREEMENT_VERSION = "user_agreement_version";
    public static final String SAM_CHANGE = "samchangenotify";
    public static final String SAM_ACCESS = "samaccessnotify";
    public static final String SAM_METHOD = "sammethod";
    public static final String SAM_URL = "samurl";
    public static final String SAM_URLDISPLAYNAME = "samurldn";
    public static final String SAM_URLCONTENTTYPE = "samurlct";
    public static final String SAM_URLRESOURCETYPE = "samurlrt";
    public static final String SAM_USER = "samuser";
    public static final String SAM_STATUS = "samstatus";
    public static final String SAM_TIME = "samtimestamp";
    public static final String SAM_NEWURL = "samnewurl";
    public static final String SAM_NEWURLDISPLAYNAME = "samnewurldn";
    public static final String SAM_TYPE = "samtype";
    public static final String SAM_SIZE = "samsize";
    public static final String SAM_TRANSTO = "samtransto";
    public static final String SAM_TRANSBY = "samtransby";
    public static final String SAM_PROPERTIESADDED = "sampropadd";
    public static final String SAM_PROPFINDTYPE = "sampftype";
    public static final String SAM_PROPFINDDEPTH = "sampfdepth";
    public static final String SAM_DAVPROPSREQUESTED = "sampfpropsrequested";
    public static final String JMS_TIME = "jmstimestamp";
    public static final String PORTAL_USER = "portaluser";
    public static final String NODE_ID = "nodeid";
    public static final String PORTAL_OBJECTS_PATH = "portalobjects";
    public static final String PORTAL_PATHS = "portalpaths";
    public static final String PORTAL_CLASSES = "portalclasses";
    public static final String PORTAL_OBJECTS_SUFFIX = "portalobjectsuffix";
    public static final String USERS_PATH = "users";
    public static final String REALMS_PATH = "realms";
    public static final String GROUPS_PATH = "groups";
    public static final String BOOKMARKS_PATH = "bookmarks";
    public static final String TOOLS_PATH = "tools";
    public static final String TASKS_PATH = "tasks";
    public static final String INTEREST_PATH = "interest";
    public static final String DATAREQUEST_PATH = "datarequest";
    public static final String EXPERTISEPROFILE_PATH = "expertiseprofile";
    public static final String PROPERTY_CATEGORIES = "categories";
    public static final String CMCS_NAMESPACE = "cmcsns";
    public static final String DC_NAMESPACE = "dcns";
    public static final String DCTERMS_NAMESPACE = "dctermsns";
    public static final String CMCSEXP_NAMESPACE = "cmcsexpns";
    public static final String CMCSINT_NAMESPACE = "cmcsint";
    public static final String DAV_NAMESPACE = "davns";
    public static final String RDF_NAMESPACE = "rdfns";
    public static final String XLINK_NAMESPACE = "xlinkns";
    public static final String SAMMMS_NAMESPACE = "sammmsns";
    public static final String SLIDE_NAMESPACE = "slidens";
    public static final String PEDIGREEXML_HEADER = "pedigreexmlheader";
    public static final String PEDIGREEXSL_FILENAME = "pedigreexslfilename";
    public static final String KEYWORDS_LIST = "subjectlist";
    public static final String CHEMPROPS_LIST = "chemicalpropertylist";
    public static final String ALLPROP_ID = "allprop";
    public static final String CREATOR_ID = "creator";
    public static final String KEYWORD_ID = "keyword";
    public static final String SPECIES_ID = "hasspecies";
    public static final String SPECIESCAS_ID = "speciescas";
    public static final String SPECIESNAME_ID = "speciesname";
    public static final String SPECIESFORMULA_ID = "speciesformula";
    public static final String CHEMPROP_ID = "chemicalproperty";
    public static final String RESOURCEURL_ID = "resourceurl";
    public static final String TITLE_ID = "title";
    public static final String CONTENTLENGTH_ID = "contentlength";
    public static final String ORIGINALDATE_ID = "originaldate";
    public static final String DAV_CREATION_DATE = "davcreationdate";
    public static final String DAV_OWNER = "davowner";
    public static final String CONTENTTYPE_ID = "contenttype";
    public static final String RESOURCETYPE_ID = "resourcetype";
    public static final String HASTRANSLATIONS_ID = "hastranslations";
    public static final String CHILDREN_ID = "children";
    public static final String DESCRIPTION_ID = "description";
    public static final String CONDITIONS_ID = "conditions";
    public static final String ABRIDGED_PROPERTIES = "abridgedproperties";
    public static final String ABRIDGED_PROPERTY_NAMES = "abridgedpropertynames";
    public static final String EXPLORERPROPERTY_LIST = "explorerpropertylist";
    public static final String ANNOTATION_PROPERTIES = "annotationproperties";
    public static final String ANNOTATION_ROOT = "annotationroot";
    public static final String ANNOTATION_LINK = "annotationlink";
    public static final String BAG_PROPERTIES = "bagproperties";
    public static final String GRAPHABLE_PROPERTIES = "graphproperties";
    public static final String XLINK_PROPERTIES = "xlinkproperties";
    public static final String SPECIES_PROPERTIES = "speciesproperties";
    public static final String DEFAULT_PROPERTIES = "defaultproperties";
    private static final String PROPERTIES_RESOURCE = "knecs.properties";
    private static CMCSProperties mInstance = null;
    public static final String DAV_SEQ_NUMBER_PATH = "davsequencenumberpath";
    public static final String DAV_SEQ_NUMBER_PROP_NAME = "davsequencenumberpropertyname";
    public static final String BSE_CONTRIBUTORID = "BseContributorId";
    public static final String BSE_DOWNLOADID = "BseDownloadId";
    public static final String STATISTICS_LOGGERS = "StatisticsLoggers";

    protected CMCSProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_RESOURCE);
        try {
            super.load(is);
            LoggerUtils.getLogger().info("CmcsPropertie loaded " + this.size());
        }
        catch (IOException ex) {
            Logger log = LoggerUtils.getLogger();
            log.warning("Unable to load properties from knecs.properties");
        }
    }

    public static CMCSProperties getCMCSProperties() {
        if (mInstance == null) {
            mInstance = new CMCSProperties();
        }
        return mInstance;
    }

    public static NSProperty getPropertyAsNSProperty(String key) {
        NSProperty retVal = null;
        String prop = CMCSProperties.getCMCSProperties().getProperty(key);
        if (prop != null) {
            retVal = new NSProperty(prop);
        }
        return retVal;
    }

    public static Vector getPropertyAsVector(String key) {
        Vector<String> propVec = null;
        String prop = CMCSProperties.getCMCSProperties().getProperty(key);
        if (prop != null) {
            propVec = new Vector<String>();
            StringTokenizer st = null;
            if (prop.startsWith("\\")) {
                String delim = prop.substring(1, 2);
                st = new StringTokenizer(prop.substring(2), delim);
            } else {
                st = new StringTokenizer(prop);
            }
            while (st.hasMoreTokens()) {
                propVec.add(st.nextToken().trim());
            }
        }
        return propVec;
    }

    public static Vector getPropertyAsNSPropertyVector(String key) {
        Vector<NSProperty> propNameVec = null;
        Vector tmpVec = CMCSProperties.getPropertyAsVector(key);
        if (tmpVec != null) {
            propNameVec = new Vector<NSProperty>(tmpVec.size());
            for (int i = 0; i < tmpVec.size(); ++i) {
                propNameVec.add(new NSProperty((String)tmpVec.get(i)));
            }
        }
        return propNameVec;
    }

    public static String getServerPath() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String serverUrl = props.getProperty(SAM_SERVER);
        String ret = null;
        try {
            URL url = new URL(serverUrl);
            String path = url.getPath();
            if (path.equals("/") || path.equals("\\")) {
                path = "";
            }
            if (path.endsWith("/") || path.endsWith("\\")) {
                path = path.substring(0, path.length() - 1);
            }
            ret = path;
        }
        catch (Exception e) {
            Logger log = LoggerUtils.getLogger();
            log.warning(e.toString());
            log.warning(LoggerUtils.getStackTrace(e));
        }
        return ret;
    }
}

