      subroutine grid_init(rtdb,geom,
     ,     ncenters,
     ,     oskel,leb,dosympts,qsh)
      implicit none
#include "mafdecls.fh"
#include "rtdb.fh"
#include "util.fh"
#include "geom.fh"
#include "errquit.fh"
#include "global.fh"
#include "stdio.fh"
c
      integer rtdb,geom
      integer ncenters
      logical leb,dosympts,oskel
      integer qsh(3,*)! [in]
c
      integer filesize,memsize
      logical owritefile
      logical grid_test_mem,grid_file_open
      external grid_test_mem,grid_file_open
      integer nq_list ! [in] generated by grid_list, unused in grid_test_mem
      integer nqlen,mxnrad
      integer eaftype,eaf_size_in_dbl,gsize
      character*255 gridfilename
      double precision enuc
c
c     get list of grid pts
c     
      if (.not. rtdb_get(rtdb, 'dft:mxnrad', mt_int, 1, mxnrad))
     &     call errquit('gridv0: rtdb_get failed', 119, RTDB_ERR)
      nqlen = ncenters*mxnrad
      call grid_list(rtdb, qsh, nqlen, nq_list)
c
c     temp set gridfilename to gridpts
c     Grid_pts caching/file information (from scf_get_info)
c
      if (.not. rtdb_get(rtdb, 'grid:filesize',
     $     MT_INT, 1, filesize)) filesize = 0
      if (.not. rtdb_get(rtdb, 'grid:memsize',
     $     MT_INT, 1, memsize)) memsize = 0
      if (.not. rtdb_get(rtdb, 'grid:eaf_size_in_dbl',
     $     MT_INT, 1, eaf_size_in_dbl)) then
c     give at least 6mb dbles plus 50 pctage load imbalance on guessize
c
         gsize=(2*nq_list*150*4)/(ga_nnodes()*100)
         eaf_size_in_dbl = max(6*1024*1024,gsize)
c     grabbing 1/5 of avail mem at least?
         eaf_size_in_dbl=max(eaf_size_in_dbl,
     C        MA_inquire_avail(mt_dbl)/5)
      if (.not. rtdb_put(rtdb, 'grid:eaf_size_in_dbl',
     $     MT_INT, 1, eaf_size_in_dbl)) call
     C     errquit('grid_init:rtdb_put failed',0,0)
      endif
      if(util_print('grinfodebug',print_debug).and.
     G     ga_nodeid().eq.0) then
         write(luout,*) ' grinit: formula gsize ',
     C        (2*nq_list*150*4)/(ga_nnodes()*100)
         write(luout,*) ' grinit:   chosen size ',eaf_size_in_dbl
         call util_flush(luout)
      endif

c
c     The opening routine will put the .pid on the grid_pts filename
c     (hence even tho' parallel file, open as sequential)
c
      call util_file_name('gridpts',.true.,.false.,gridfilename)
c
      owritefile= .false.
c
      if (filesize.gt.0 .or. memsize.gt.0) then
         if(.not.geom_nuc_rep_energy(geom, enuc)) 
     .        call errquit(' gridquad: enucrep failed ',0, GEOM_ERR)
         if (.not. grid_file_open(enuc,
     .        gridfilename, memsize, filesize,eaf_size_in_dbl))
     $        call errquit('grid_tasks: opening gridpts?', 0, DISK_ERR)
      endif
c
      owritefile= grid_test_mem (rtdb, nq_list)
c
      call grid_buckinit(rtdb)
      if (.not. rtdb_get(rtdb, 'dft:gridsym',
     $     MT_LOG, 1, dosympts)) dosympts=oskel
      dosympts=dosympts.and.leb
      return
      end
c $Id: grid_init.F 21783 2012-01-13 19:10:52Z edo $
