#! /bin/sh
# Generated by niminst

if [ $# -eq 1 ] ; then
  case $1 in
    "--help"|"-h"|"help"|"h")
      echo "Nim deinstallation script"
      echo "Usage: [sudo] sh deinstall.sh DIR"
      echo "Where DIR may be:"
      echo "  /usr/bin"
      echo "  /usr/local/bin"
      echo "  /opt"
      echo "  <some other dir> (treated like '/opt')"
      exit 1
      ;;
    "/usr/bin")
      bindir=/usr/bin
      configdir=/etc
      libdir=/usr/lib/nim
      docdir=/usr/share/nim/doc
      datadir=/usr/share/nim/data
      ;;
    "/usr/local/bin")
      bindir=/usr/local/bin
      configdir=/etc
      libdir=/usr/local/lib/nim
      docdir=/usr/local/share/nim/doc
      datadir=/usr/local/share/nim/data
      ;;
    *)
      bindir="$1/nim/bin"
      configdir="$1/nim/config"
      libdir="$1/nim/lib"
      docdir="$1/nim/doc"
      datadir="$1/nim/data"
      ;;
  esac
  echo "removing files..."

  rm -f $bindir/nim
  rm -f $configdir/nim.cfg
  rm -f $configdir/nimdoc.cfg
  rm -f $configdir/nimdoc.tex.cfg
  rm -rf $docdir
  rm -rf $datadir
  rm -rf $libdir

  echo "deinstallation successful"
else
  echo "Nim deinstallation script"
  echo "Usage: [sudo] sh deinstall.sh DIR"
  echo "Where DIR may be:"
  echo "  /usr/bin"
  echo "  /usr/local/bin"
  echo "  /opt"
  echo "  <some other dir> (treated like '/opt')"
  exit 1
fi

