/* pdu-ipx.c
 
   PDU builder for IPX packets

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* XXX FIXME: support for IPX is almost non-existant and needs to be
 * finished */

#include "pbuild-priv.h"
#include "pdu-ipx.h"

static void
build(const GNode *pdu, void *dest)
{
    struct ipxhdr *ipx;
#if 0
    uint16_t u16;
#endif

    ipx = dest;

    ipx->ipx_type = num_next(_pb_pdata(pdu, "type") );
    ipx->ipx_tctrl = 0;

    ipx->ipx_source = *(struct ipx_address *) _pb_pdata(pdu, "src");
#if 0
    u16 = htons(num_next(hdr_data->source_sock) );
    SSVAL(ipx, offsetof(struct ipxhdr, ipx_source.sock), u16);
#endif

    ipx->ipx_dest = *(struct ipx_address *) _pb_pdata(pdu, "dst");
#if 0
    u16 = htons(num_next(hdr_data->dest_sock) );
    SSVAL(ipx, offsetof(struct ipxhdr, ipx_dest.sock), u16);
#endif
}

static void
postbuild(const GNode *pdu, void *dest, void *prev_pdu_hdr _U_)
{
    struct ipxhdr *ipx;
    uint16_t cksum, u16;
    void *field;
    size_t opts_len, payload_len;

    ipx = dest;

    /* If we have a numspec for the checksum we force a (most likely bogus)
     * checksum, otherwise we calculate the real.
     */
    if ( (field = _pb_pdata(pdu, "cksum") ) )
	cksum = htons(num_next(field) );
    else {
	opts_len = ( (struct node_data *) pdu->data)->_data_pdu.opts_len;
	payload_len = ( (struct node_data *) pdu->data)->_data_pdu.payload_len;

	u16 = htons(sizeof(struct ipxhdr) + opts_len + payload_len);
	SSVAL(ipx, offsetof(struct ipxhdr, ipx_pktsize), u16);

	/* Must be 0 before calculating cksum! */
	SSVAL(ipx, offsetof(struct ipxhdr, ipx_checksum), 0);

	cksum = _pb_cksum(dest, sizeof(struct ipxhdr) + opts_len);
    }

    SSVAL(ipx, offsetof(struct ipxhdr, ipx_checksum), cksum);
}

#if 0
static void
pdu_ipxhdr_dumper(pdu_t *p, const char *prefix)
{
    struct ipxhdr_options *hdr_data;

    hdr_data = p->header_data;

    printf("%s  Parameters:\n", prefix);
    printf("%s    Source IPX address: %s\n", prefix,
	   pdu_ipx_to_ascii(&hdr_data->ipx_source) );
    printf("%s    Source socket: %s\n",
	   prefix, num_info(hdr_data->source_sock) );
    printf("%s    Destination IPX address: %s\n", prefix,
	   pdu_ipx_to_ascii(&hdr_data->ipx_dest) );
    printf("%s    Destination socket: %s\n",
	   prefix, num_info(hdr_data->dest_sock) );
    printf("%s    IPX type: %s\n", prefix, num_info(hdr_data->ipx_type) );
}
#endif

static pdu_t pdu_ipx = {
    .name = "ipx",
    .description = "IPX packet",
    .documented_in = "?",
    .len = sizeof(struct ipxhdr),
    .fields = (field_t []) {
	{.name = "type", .type = PDU_FTYPE_NUMTYPE},
	{.name = "src", .type = PDU_FTYPE_NUMTYPE},
	{.name = "dst", .type = PDU_FTYPE_NUMTYPE},
	{.name = "cksum", .type = PDU_FTYPE_NUMTYPE},
	{.name = NULL}
    },
    .build = &build,
    .postbuild = &postbuild
};

void
_pb_register_ipx(void)
{
    _pb_register_protocol(&pdu_ipx);
}
