/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.websvc.saas.services.strikeiron.ui;

import java.awt.Color;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceData;
import org.openide.util.NbBundle;

/**
 *
 * @author  nam
 */
public class HeaderPanel extends javax.swing.JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TO_OVERRIDE = NbBundle.getMessage(HeaderPanel.class, "MSG_ClickToOverride");
    
    /** Creates new form HeaderPanel */
    public HeaderPanel() {
        initComponents();
    }
    
    private WsdlServiceData service;
    void setServiceData(WsdlServiceData service) {
        this.service = service;
    }

    /**
     * Set the title of the header panel. The title is backed by a JLabel
     * so a subset of HTML text is allowable.
     *
     * @param  title  new title text.
     */
    void setTitle(String title) {
        jlTitle.setText(title);
    }
    
    public String getPackageName() {
        String name = tfPackageName.getText().trim();
        if (name.equals(TO_OVERRIDE)) {
            name = ""; //NOI18N
        }
        return name;
    }
    
    public void setPackageName(String name) {
        if (name == null || name.length() == 0) {
            tfPackageName.setText(TO_OVERRIDE);
            tfPackageName.setForeground(Color.GRAY);
        }
    }
    
    public void addFocusListener(java.awt.event.FocusAdapter l) {
        tfPackageName.addFocusListener(l);
    }
    
    public void removeFocusListener(java.awt.event.FocusAdapter l) {
        tfPackageName.removeFocusListener(l);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jlTitle = new javax.swing.JLabel();
        jlPackageName = new javax.swing.JLabel();
        tfPackageName = new javax.swing.JTextField();

        jlTitle.setLabelFor(this);
        jlTitle.setText("<dynamic>"); // NOI18N

        jlPackageName.setDisplayedMnemonic('P');
        jlPackageName.setLabelFor(tfPackageName);
        jlPackageName.setText(org.openide.util.NbBundle.getMessage(HeaderPanel.class, "HeaderPanel.jlPackageName.text")); // NOI18N

        tfPackageName.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                tfPackageNameMouseClicked(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jlTitle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 436, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jlPackageName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 98, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(tfPackageName, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 328, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jlTitle)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jlPackageName)
                    .add(tfPackageName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jlTitle.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(HeaderPanel.class, "HeaderPanel.jlTitle.AccessibleContext.accessibleDescription")); // NOI18N
        jlPackageName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(HeaderPanel.class, "HeaderPanel.jlPackageName.AccessibleContext.accessibleDescription")); // NOI18N
        tfPackageName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(HeaderPanel.class, "HeaderPanel.tfPackageName.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(HeaderPanel.class, "HeaderPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void tfPackageNameMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tfPackageNameMouseClicked
        tfPackageName.selectAll();
        tfPackageName.setForeground(Color.BLACK);

    }//GEN-LAST:event_tfPackageNameMouseClicked
        
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jlPackageName;
    private javax.swing.JLabel jlTitle;
    private javax.swing.JTextField tfPackageName;
    // End of variables declaration//GEN-END:variables
    
}
