! (C) Copyright 2013 ECMWF.
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation nor
! does it submit to any jurisdiction.

#include "fckit/fctest.h"

! -----------------------------------------------------------------------------

TESTSUITE(fctest_stretchedrotatedgaussiangrid)

! -----------------------------------------------------------------------------

TESTSUITE_INIT
  use atlas_module
  call atlas_library%initialise()
END_TESTSUITE_INIT

! -----------------------------------------------------------------------------

TESTSUITE_FINALIZE
  use atlas_module
  call atlas_library%finalise()
END_TESTSUITE_FINALIZE

! ----------------------------------------------------------------------------

TEST( arpege_t31c24 )
  ! Grid provided by Philippe Marguinaud, Meteo France
  use atlas_module
  implicit none
  type(atlas_ReducedGaussianGrid) :: grid
  type(atlas_LonLatRectangularDomain) :: bounding_box

  real(dp) :: lonlat(3376)

  integer, parameter :: nx(32) = &
  [ 20, 27, 32, 40, 45, 48, 60, 60, 64, 64, 64, 64, 64, 64, 64, 64, &
    64, 64, 64, 64, 64, 64, 64, 64, 60, 60, 48, 45, 40, 32, 27, 20 ]
  real(dp), parameter :: stretch = 2.4_dp
  real(dp), parameter :: centre(2) = [2.0_dp, 46.7_dp]
  real(dp), parameter :: angle = 180.0_dp
  integer :: i, j, jglo

  lonlat = [  1.99999999999999600_dp,  44.93291171299576092_dp, &
         &    2.77237262934735273_dp,  45.01674523281888440_dp, &
         &    3.47555862489311007_dp,  45.26073815098433784_dp, &
         &    4.04494770792090641_dp,  45.64287023699112211_dp, &
         &    4.42528132740345281_dp,  46.12813070368466839_dp, &
         &    4.57569351104372046_dp,  46.67109320702403608_dp, &
         &    4.47479391972813190_dp,  47.21956618120344018_dp, &
         &    4.12512266986032206_dp,  47.71926346185548340_dp, &
         &    3.55581027759415491_dp,  48.11926090196744354_dp, &
         &    2.82200931024728874_dp,  48.37772379915030996_dp, &
         &    1.99999999999999556_dp,  48.46708828700425187_dp, &
         &    1.17799068975270305_dp,  48.37772379915030996_dp, &
         &    0.44418972240583693_dp,  48.11926090196744354_dp, &
         &   -0.12512266986032983_dp,  47.71926346185548340_dp, &
         &   -0.47479391972814028_dp,  47.21956618120344018_dp, &
         &   -0.57569351104372879_dp,  46.67109320702403608_dp, &
         &   -0.42528132740346147_dp,  46.12813070368466839_dp, &
         &   -0.04494770792091433_dp,  45.64287023699112211_dp, &
         &    0.52444137510688182_dp,  45.26073815098433784_dp, &
         &    1.22762737065263883_dp,  45.01674523281888440_dp, &
         &    1.99999999999999556_dp,  42.63725270983827897_dp, &
         &    3.27473332072834422_dp,  42.73934376403467184_dp, &
         &    4.49349321557291415_dp,  43.04109625964867547_dp, &
         &    5.60127364516099924_dp,  43.52904513460186564_dp, &
         &    6.54514794659825672_dp,  44.18107605134951399_dp, &
         &    7.27568782798168190_dp,  44.96693492678289061_dp, &
         &    7.74887351496657040_dp,  45.84898874281991965_dp, &
         &    7.92867515230084408_dp,  46.78330526703850012_dp, &
         &    7.79040894364469949_dp,  47.72115423047301164_dp, &
         &    7.32476598915540844_dp,  48.61105462603097038_dp, &
         &    6.54204071489340944_dp,  49.40147266886311428_dp, &
         &    5.47559260124316793_dp,  50.04417716102324221_dp, &
         &    4.18315343237871584_dp,  50.49806364409691639_dp, &
         &    2.74458547194322389_dp,  50.73299668020899134_dp, &
         &    1.25541452805676457_dp,  50.73299668020899134_dp, &
         &   -0.18315343237872406_dp,  50.49806364409691639_dp, &
         &   -1.47559260124317815_dp,  50.04417716102324221_dp, &
         &   -2.54204071489341921_dp,  49.40147266886311428_dp, &
         &   -3.32476598915541599_dp,  48.61105462603097038_dp, &
         &   -3.79040894364470748_dp,  47.72115423047301164_dp, &
         &   -3.92867515230085296_dp,  46.78330526703850012_dp, &
         &   -3.74887351496657928_dp,  45.84898874281991965_dp, &
         &   -3.27568782798168812_dp,  44.96693492678289061_dp, &
         &   -2.54514794659826427_dp,  44.18107605134951399_dp, &
         &   -1.60127364516100812_dp,  43.52904513460186564_dp, &
         &   -0.49349321557292075_dp,  43.04109625964867547_dp, &
         &    0.72526667927164967_dp,  42.73934376403467184_dp, &
         &    1.99999999999999556_dp,  40.31236211945285675_dp, &
         &    3.63376292032076975_dp,  40.42261301497919845_dp, &
         &    5.22173788476928014_dp,  40.75019560382368411_dp, &
         &    6.71826031811739099_dp,  41.28563184510834105_dp, &
         &    8.07794770476515467_dp,  42.01322983391511201_dp, &
         &    9.25594876339864392_dp,  42.91123363953519743_dp, &
         &   10.20837670733705771_dp,  43.95202523375940729_dp, &
         &   10.89307303713296271_dp,  45.10238649522262477_dp, &
         &   11.27090590027328432_dp,  46.32385288536406875_dp, &
         &   11.30784824781773779_dp,  47.57322688923063225_dp, &
         &   10.97806564551987840_dp,  48.80336562297891589_dp, &
         &   10.26810804950859612_dp,  49.96440199105025926_dp, &
         &    9.18197003975669723_dp,  51.00557820511744467_dp, &
         &    7.74622775989939338_dp,  51.87782553848720823_dp, &
         &    6.01378910799337074_dp,  52.53707313311167582_dp, &
         &    4.06435502534209725_dp,  52.94800110445672203_dp, &
         &    1.99999999999999600_dp,  53.08763788054714894_dp, &
         &   -0.06435502534210560_dp,  52.94800110445672203_dp, &
         &   -2.01378910799337962_dp,  52.53707313311167582_dp, &
         &   -3.74622775989940182_dp,  51.87782553848720823_dp, &
         &   -5.18197003975670256_dp,  51.00557820511744467_dp, &
         &   -6.26810804950860057_dp,  49.96440199105025926_dp, &
         &   -6.97806564551988551_dp,  48.80336562297891589_dp, &
         &   -7.30784824781774667_dp,  47.57322688923063225_dp, &
         &   -7.27090590027329498_dp,  46.32385288536406875_dp, &
         &   -6.89307303713297248_dp,  45.10238649522262477_dp, &
         &   -6.20837670733706481_dp,  43.95202523375940729_dp, &
         &   -5.25594876339865458_dp,  42.91123363953519743_dp, &
         &   -4.07794770476516355_dp,  42.01322983391511201_dp, &
         &   -2.71826031811739988_dp,  41.28563184510834105_dp, &
         &   -1.22173788476928813_dp,  40.75019560382368411_dp, &
         &    0.36623707967922192_dp,  40.42261301497919845_dp, &
         &    1.99999999999999600_dp,  37.95945956416753120_dp, &
         &    3.72994195085756930_dp,  38.05275970261258323_dp, &
         &    5.43190111561111433_dp,  38.33106975566338548_dp, &
         &    7.07783882564464850_dp,  38.78962916423042628_dp, &
         &    8.63959771096107509_dp,  39.42053684981195261_dp, &
         &   10.08882962579568954_dp,  40.21279467492543347_dp, &
         &   11.39692139773956114_dp,  41.15235690381517486_dp, &
         &   12.53494002107632888_dp,  42.22217718966415845_dp, &
         &   13.47363915243209043_dp,  43.40224634648851065_dp, &
         &   14.18359521918176469_dp,  44.66961909752426152_dp, &
         &   14.63557388477568644_dp,  45.99843704779454612_dp, &
         &   14.80126342211737089_dp,  47.35996933207513848_dp, &
         &   14.65454278958190670_dp,  48.72271255422421632_dp, &
         &   14.17346129570704250_dp,  50.05261748260089405_dp, &
         &   13.34306219743110233_dp,  51.31353838046217675_dp, &
         &   12.15903975007321236_dp,  52.46802323745790630_dp, &
         &   10.63193584333677499_dp,  53.47856301011842106_dp, &
         &    8.79116029542177024_dp,  54.30937174533021761_dp, &
         &    6.68766853851381526_dp,  54.92865613654313961_dp, &
         &    4.39391037845720334_dp,  55.31115535850048559_dp, &
         &    1.99999999999999600_dp,  55.44054043583248159_dp, &
         &   -0.39391037845721066_dp,  55.31115535850048559_dp, &
         &   -2.68766853851382415_dp,  54.92865613654313961_dp, &
         &   -4.79116029542177646_dp,  54.30937174533021761_dp, &
         &   -6.63193584333678299_dp,  53.47856301011842106_dp, &
         &   -8.15903975007321947_dp,  52.46802323745790630_dp, &
         &   -9.34306219743110766_dp,  51.31353838046217675_dp, &
         &  -10.17346129570704960_dp,  50.05261748260089405_dp, &
         &  -10.65454278958191559_dp,  48.72271255422421632_dp, &
         &  -10.80126342211738155_dp,  47.35996933207513848_dp, &
         &  -10.63557388477569354_dp,  45.99843704779454612_dp, &
         &  -10.18359521918177357_dp,  44.66961909752426152_dp, &
         &   -9.47363915243210286_dp,  43.40224634648851065_dp, &
         &   -8.53494002107633776_dp,  42.22217718966415845_dp, &
         &   -7.39692139773957003_dp,  41.15235690381517486_dp, &
         &   -6.08882962579569842_dp,  40.21279467492543347_dp, &
         &   -4.63959771096108220_dp,  39.42053684981195261_dp, &
         &   -3.07783882564465516_dp,  38.78962916423042628_dp, &
         &   -1.43190111561112299_dp,  38.33106975566338548_dp, &
         &    0.27005804914242265_dp,  38.05275970261258323_dp, &
         &    1.99999999999999600_dp,  35.57084905987729684_dp, &
         &    3.89475329148972449_dp,  35.66164776728690811_dp, &
         &    5.76748883913266752_dp,  35.93289207465146262_dp, &
         &    7.59612881396671380_dp,  36.38113516165864070_dp, &
         &    9.35846198524136241_dp,  37.00065953311393940_dp, &
         &   11.03204592267791284_dp,  37.78351258180431671_dp, &
         &   12.59407748901272228_dp,  38.71954642363609622_dp, &
         &   14.02123063562953753_dp,  39.79645326718445375_dp, &
         &   15.28946940417034384_dp,  40.99978674800681233_dp, &
         &   16.37385639149118433_dp,  42.31296002482778107_dp, &
         &   17.24839405994832120_dp,  43.71721334442865725_dp, &
         &   17.88595991605807711_dp,  45.19154778206701195_dp, &
         &   18.25842850603561374_dp,  46.71262882888417067_dp, &
         &   18.33711398818940452_dp,  48.25467471095996785_dp, &
         &   18.09371358173445188_dp,  49.78936139305309894_dp, &
         &   17.50197280996727400_dp,  51.28580055994029152_dp, &
         &   16.54030106040206149_dp,  52.71067834344860614_dp, &
         &   15.19549149366584473_dp,  54.02867680201524081_dp, &
         &   13.46747450557555048_dp,  55.20332460427978560_dp, &
         &   11.37460140494845717_dp,  56.19841400024800038_dp, &
         &    8.95834334902436602_dp,  56.98004544675784899_dp, &
         &    6.28571777452580616_dp,  57.51919556269155720_dp, &
         &    3.44765611568870733_dp,  57.79446760315521914_dp, &
         &    0.55234388431128512_dp,  57.79446760315521914_dp, &
         &   -2.28571777452581371_dp,  57.51919556269155720_dp, &
         &   -4.95834334902437313_dp,  56.98004544675784899_dp, &
         &   -7.37460140494846428_dp,  56.19841400024800038_dp, &
         &   -9.46747450557555759_dp,  55.20332460427978560_dp, &
         &  -11.19549149366585006_dp,  54.02867680201524081_dp, &
         &  -12.54030106040206860_dp,  52.71067834344860614_dp, &
         &  -13.50197280996728288_dp,  51.28580055994029152_dp, &
         &  -14.09371358173445721_dp,  49.78936139305309894_dp, &
         &  -14.33711398818941340_dp,  48.25467471095996785_dp, &
         &  -14.25842850603561907_dp,  46.71262882888417067_dp, &
         &  -13.88595991605808244_dp,  45.19154778206701195_dp, &
         &  -13.24839405994833008_dp,  43.71721334442865725_dp, &
         &  -12.37385639149119498_dp,  42.31296002482778107_dp, &
         &  -11.28946940417035272_dp,  40.99978674800681233_dp, &
         &  -10.02123063562954464_dp,  39.79645326718445375_dp, &
         &   -8.59407748901273116_dp,  38.71954642363609622_dp, &
         &   -7.03204592267792172_dp,  37.78351258180431671_dp, &
         &   -5.35846198524136952_dp,  37.00065953311393940_dp, &
         &   -3.59612881396672091_dp,  36.38113516165864070_dp, &
         &   -1.76748883913267574_dp,  35.93289207465146262_dp, &
         &    0.10524670851026705_dp,  35.66164776728690811_dp, &
         &    1.99999999999999600_dp,  33.13704588354342917_dp, &
         &    4.09718755711548610_dp,  33.23124463343540214_dp, &
         &    6.17473678976558027_dp,  33.51283479810019372_dp, &
         &    8.21297051898842767_dp,  33.97880825794451454_dp, &
         &   10.19211732580419394_dp,  34.62418375193038855_dp, &
         &   12.09222434325374529_dp,  35.44205010622848562_dp, &
         &   13.89302536639832120_dp,  36.42361680044041350_dp, &
         &   15.57375501535205942_dp,  37.55826279697889447_dp, &
         &   17.11290455740948246_dp,  38.83357308646102268_dp, &
         &   18.48792157318536056_dp,  40.23535159216240942_dp, &
         &   19.67486490585671888_dp,  41.74759899443786537_dp, &
         &   20.64804001511417653_dp,  43.35244484209054860_dp, &
         &   21.37966075266355404_dp,  45.03002540480565585_dp, &
         &   21.83961562141898582_dp,  46.75830290430587155_dp, &
         &   21.99546453290828296_dp,  48.51282952087984768_dp, &
         &   21.81285996059914467_dp,  50.26647329190694080_dp, &
         &   21.25667322722224029_dp,  51.98914605534769606_dp, &
         &   20.29319722451073105_dp,  53.64760968250063655_dp, &
         &   18.89384545876525578_dp,  55.20548791890712437_dp, &
         &   17.04067793585433321_dp,  56.62367212326139310_dp, &
         &   14.73370655373201643_dp,  57.86135900031617751_dp, &
         &   11.99912115224313958_dp,  58.87795079119066344_dp, &
         &    8.89637618755807047_dp,  59.63591573610307250_dp, &
         &    5.52099396835736211_dp,  60.10440004572244277_dp, &
         &    1.99999999999999645_dp,  60.26295411645657651_dp, &
         &   -1.52099396835736900_dp,  60.10440004572244277_dp, &
         &   -4.89637618755807846_dp,  59.63591573610307250_dp, &
         &   -7.99912115224314757_dp,  58.87795079119066344_dp, &
         &  -10.73370655373202531_dp,  57.86135900031617751_dp, &
         &  -13.04067793585434032_dp,  56.62367212326139310_dp, &
         &  -14.89384545876526467_dp,  55.20548791890712437_dp, &
         &  -16.29319722451073460_dp,  53.64760968250063655_dp, &
         &  -17.25667322722224739_dp,  51.98914605534769606_dp, &
         &  -17.81285996059915178_dp,  50.26647329190694080_dp, &
         &  -17.99546453290829362_dp,  48.51282952087984768_dp, &
         &  -17.83961562141899648_dp,  46.75830290430587155_dp, &
         &  -17.37966075266356114_dp,  45.03002540480565585_dp, &
         &  -16.64804001511417653_dp,  43.35244484209054860_dp, &
         &  -15.67486490585672598_dp,  41.74759899443786537_dp, &
         &  -14.48792157318536944_dp,  40.23535159216240942_dp, &
         &  -13.11290455740949135_dp,  38.83357308646102268_dp, &
         &  -11.57375501535207007_dp,  37.55826279697889447_dp, &
         &   -9.89302536639833185_dp,  36.42361680044041350_dp, &
         &   -8.09222434325375239_dp,  35.44205010622848562_dp, &
         &   -6.19211732580420193_dp,  34.62418375193038855_dp, &
         &   -4.21297051898843566_dp,  33.97880825794451454_dp, &
         &   -2.17473678976558960_dp,  33.51283479810019372_dp, &
         &   -0.09718755711549353_dp,  33.23124463343540214_dp, &
         &    1.99999999999999600_dp,  30.64757019281734074_dp, &
         &    3.92669240244598505_dp,  30.71678191817960268_dp, &
         &    5.84270801296843700_dp,  30.92395598105918353_dp, &
         &    7.73736939611796171_dp,  31.26771342119434749_dp, &
         &    9.59999239238874047_dp,  31.74577019145994683_dp, &
         &   11.41986936545086984_dp,  32.35495718584155611_dp, &
         &   13.18623692372253586_dp,  33.09124574576952682_dp, &
         &   14.88822378743806851_dp,  33.94977626735131793_dp, &
         &   16.51477509868480453_dp,  34.92488704934376642_dp, &
         &   18.05455017155122732_dp,  36.01014014726423795_dp, &
         &   19.49579145727240714_dp,  37.19834072287546434_dp, &
         &   20.82616341777591984_dp,  38.48154618161253637_dp, &
         &   22.03256121225549435_dp,  39.85106125278488065_dp, &
         &   23.10089088783405131_dp,  41.29741507659190347_dp, &
         &   24.01582559662802652_dp,  42.81031632956308641_dp, &
         &   24.76054697060166987_dp,  44.37858250245571412_dp, &
         &   25.31648826424518717_dp,  45.99003977573201496_dp, &
         &   25.66310777053267245_dp,  47.63139077670033572_dp, &
         &   25.77773936992416637_dp,  49.28804930270956675_dp, &
         &   25.63559425749198795_dp,  50.94394459368972150_dp, &
         &   25.21002592824931199_dp,  52.58130404832083116_dp, &
         &   24.47321926655621738_dp,  54.18043392376822709_dp, &
         &   23.39751805719552991_dp,  55.71953428872550518_dp, &
         &   21.95764487214750105_dp,  57.17460858105235388_dp, &
         &   20.13405311103923623_dp,  58.51955862209560166_dp, &
         &   17.91751559979281083_dp,  59.72658657388572578_dp, &
         &   15.31471471060360479_dp,  60.76704034614789407_dp, &
         &   12.35401191716921154_dp,  61.61281120273996237_dp, &
         &    9.08984714396560278_dp,  62.23829052070698253_dp, &
         &    5.60371952785031446_dp,  62.62270582496653049_dp, &
         &    1.99999999999999556_dp,  62.75242980718265784_dp, &
         &   -1.60371952785032224_dp,  62.62270582496653049_dp, &
         &   -5.08984714396560900_dp,  62.23829052070698253_dp, &
         &   -8.35401191716922042_dp,  61.61281120273996237_dp, &
         &  -11.31471471060361367_dp,  60.76704034614789407_dp, &
         &  -13.91751559979281616_dp,  59.72658657388572578_dp, &
         &  -16.13405311103924689_dp,  58.51955862209560166_dp, &
         &  -17.95764487214750815_dp,  57.17460858105235388_dp, &
         &  -19.39751805719554056_dp,  55.71953428872550518_dp, &
         &  -20.47321926655623159_dp,  54.18043392376822709_dp, &
         &  -21.21002592824931554_dp,  52.58130404832083116_dp, &
         &  -21.63559425749199860_dp,  50.94394459368972150_dp, &
         &  -21.77773936992418058_dp,  49.28804930270956675_dp, &
         &  -21.66310777053267955_dp,  47.63139077670033572_dp, &
         &  -21.31648826424519783_dp,  45.99003977573201496_dp, &
         &  -20.76054697060167697_dp,  44.37858250245571412_dp, &
         &  -20.01582559662803362_dp,  42.81031632956308641_dp, &
         &  -19.10089088783406197_dp,  41.29741507659190347_dp, &
         &  -18.03256121225550146_dp,  39.85106125278488065_dp, &
         &  -16.82616341777592694_dp,  38.48154618161253637_dp, &
         &  -15.49579145727241603_dp,  37.19834072287546434_dp, &
         &  -14.05455017155123620_dp,  36.01014014726423795_dp, &
         &  -12.51477509868481341_dp,  34.92488704934376642_dp, &
         &  -10.88822378743808095_dp,  33.94977626735131793_dp, &
         &   -9.18623692372254474_dp,  33.09124574576952682_dp, &
         &   -7.41986936545088049_dp,  32.35495718584155611_dp, &
         &   -5.59999239238874935_dp,  31.74577019145994683_dp, &
         &   -3.73736939611796970_dp,  31.26771342119434749_dp, &
         &   -1.84270801296844478_dp,  30.92395598105918353_dp, &
         &    0.07330759755400772_dp,  30.71678191817960268_dp, &
         &    1.99999999999999600_dp,  28.09100109536852230_dp, &
         &    4.16843782661930362_dp,  28.16889262543881145_dp, &
         &    6.32564933647368566_dp,  28.40205318377053345_dp, &
         &    8.46042949045145143_dp,  28.78894734383437992_dp, &
         &   10.56160821625925195_dp,  29.32703776203888069_dp, &
         &   12.61804920168178690_dp,  30.01281590885307438_dp, &
         &   14.61862699669389087_dp,  30.84184157026976436_dp, &
         &   16.55217628249286577_dp,  31.80878785141789322_dp, &
         &   18.40740784814350306_dp,  32.90748779465315010_dp, &
         &   20.17278641740253420_dp,  34.13097826525053335_dp, &
         &   21.83636590786353437_dp,  35.47153642700349963_dp, &
         &   23.38557795842459797_dp,  36.92070387379718710_dp, &
         &   24.80696969977402233_dp,  38.46929323359992026_dp, &
         &   26.08588698105331716_dp,  40.10737174655498194_dp, &
         &   27.20610004359020806_dp,  41.82421587722975431_dp, &
         &   28.14937074714974585_dp,  43.60823042135866956_dp, &
         &   28.89496528133906494_dp,  45.44682484300304282_dp, &
         &   29.41912613625676443_dp,  47.32623888788154431_dp, &
         &   29.69453569648833735_dp,  49.23130925676766623_dp, &
         &   29.68983696232584180_dp,  51.14517010976478417_dp, &
         &   29.36933297612858240_dp,  53.04888396821036167_dp, &
         &   28.69307609487012201_dp,  54.92100894435518654_dp, &
         &   27.61769060836896728_dp,  56.73712764036463341_dp, &
         &   26.09844461997003151_dp,  58.46939890910893922_dp, &
         &   24.09325961331439458_dp,  60.08625295311978931_dp, &
         &   21.56939664790981936_dp,  61.55243525845713748_dp, &
         &   18.51323316925390117_dp,  62.82970044453450953_dp, &
         &   14.94248311853021427_dp,  63.87850997409253040_dp, &
         &   10.91821393310038246_dp,  64.66099291349783584_dp, &
         &    6.55165837938126572_dp,  65.14506774788591770_dp, &
         &    1.99999999999999645_dp,  65.30899890463147983_dp, &
         &   -2.55165837938127327_dp,  65.14506774788591770_dp, &
         &   -6.91821393310038868_dp,  64.66099291349783584_dp, &
         &  -10.94248311853022138_dp,  63.87850997409253040_dp, &
         &  -14.51323316925390650_dp,  62.82970044453450953_dp, &
         &  -17.56939664790982647_dp,  61.55243525845713748_dp, &
         &  -20.09325961331440169_dp,  60.08625295311978931_dp, &
         &  -22.09844461997003862_dp,  58.46939890910893922_dp, &
         &  -23.61769060836897793_dp,  56.73712764036463341_dp, &
         &  -24.69307609487013266_dp,  54.92100894435518654_dp, &
         &  -25.36933297612859306_dp,  53.04888396821036167_dp, &
         &  -25.68983696232585245_dp,  51.14517010976478417_dp, &
         &  -25.69453569648835156_dp,  49.23130925676766623_dp, &
         &  -25.41912613625677508_dp,  47.32623888788154431_dp, &
         &  -24.89496528133907205_dp,  45.44682484300304282_dp, &
         &  -24.14937074714975651_dp,  43.60823042135866956_dp, &
         &  -23.20610004359021872_dp,  41.82421587722975431_dp, &
         &  -22.08588698105333137_dp,  40.10737174655498194_dp, &
         &  -20.80696969977403299_dp,  38.46929323359992026_dp, &
         &  -19.38557795842460862_dp,  36.92070387379718710_dp, &
         &  -17.83636590786354148_dp,  35.47153642700349963_dp, &
         &  -16.17278641740254486_dp,  34.13097826525053335_dp, &
         &  -14.40740784814351372_dp,  32.90748779465315010_dp, &
         &  -12.55217628249287110_dp,  31.80878785141789322_dp, &
         &  -10.61862699669389798_dp,  30.84184157026976436_dp, &
         &   -8.61804920168179400_dp,  30.01281590885307438_dp, &
         &   -6.56160821625925994_dp,  29.32703776203888069_dp, &
         &   -4.46042949045146031_dp,  28.78894734383437992_dp, &
         &   -2.32564933647369187_dp,  28.40205318377053345_dp, &
         &   -0.16843782661931131_dp,  28.16889262543881145_dp, &
         &    1.99999999999999600_dp,  25.45485763546421154_dp, &
         &    4.25579267831604824_dp,  25.53081635683327377_dp, &
         &    6.50189378344491864_dp,  25.75824904385734015_dp, &
         &    8.72865139696445169_dp,  26.13583181560235502_dp, &
         &   10.92648650789847409_dp,  26.66137960320710931_dp, &
         &   13.08591371200912867_dp,  27.33187675649334025_dp, &
         &   15.19754366142444368_dp,  28.14351701208744316_dp, &
         &   17.25206214192900589_dp,  29.09175016726920759_dp, &
         &   19.24018123567453742_dp,  30.17133232687284305_dp, &
         &   21.15255849246134545_dp,  31.37637626233231813_dp, &
         &   22.97968026705780886_dp,  32.70039821822412307_dp, &
         &   24.71170528699354918_dp,  34.13635737784334623_dp, &
         &   26.33826403031282837_dp,  35.67668409468497259_dp, &
         &   27.84820859564654683_dp,  37.31329283883029291_dp, &
         &   29.22930648122764197_dp,  39.03757551632935474_dp, &
         &   30.46787020033522708_dp,  40.84037031204417190_dp, &
         &   31.54831327014242248_dp,  42.71190039889389567_dp, &
         &   32.45262246278107199_dp,  44.64167567492752653_dp, &
         &   33.15973753507462618_dp,  46.61834908938177335_dp, &
         &   33.64483525740958214_dp,  48.62951713112133945_dp, &
         &   33.87852862440772839_dp,  50.66145188613276673_dp, &
         &   33.82602201650912122_dp,  52.69875031809839783_dp, &
         &   33.44632120220701665_dp,  54.72388646563504011_dp, &
         &   32.69170289014788011_dp,  56.71665696607986717_dp, &
         &   31.50782877801381332_dp,  58.65352526302899605_dp, &
         &   29.83517004248913196_dp,  60.50690475312735828_dp, &
         &   27.61278608277912383_dp,  62.24449065808524040_dp, &
         &   24.78586461017365750_dp,  63.82887077001763032_dp, &
         &   21.31841683118042496_dp,  65.21781824976642383_dp, &
         &   17.21138564172178320_dp,  66.36584339331807314_dp, &
         &   12.52326664933801226_dp,  67.22759281764989225_dp, &
         &    7.38533547682125846_dp,  67.76325974975715383_dp, &
         &    1.99999999999999600_dp,  67.94514236453578349_dp, &
         &   -3.38533547682126690_dp,  67.76325974975715383_dp, &
         &   -8.52326664933801936_dp,  67.22759281764989225_dp, &
         &  -13.21138564172179031_dp,  66.36584339331807314_dp, &
         &  -17.31841683118043562_dp,  65.21781824976642383_dp, &
         &  -20.78586461017366460_dp,  63.82887077001763032_dp, &
         &  -23.61278608277912738_dp,  62.24449065808524040_dp, &
         &  -25.83517004248913906_dp,  60.50690475312735828_dp, &
         &  -27.50782877801382398_dp,  58.65352526302899605_dp, &
         &  -28.69170289014789077_dp,  56.71665696607986717_dp, &
         &  -29.44632120220701665_dp,  54.72388646563504011_dp, &
         &  -29.82602201650912477_dp,  52.69875031809839783_dp, &
         &  -29.87852862440772839_dp,  50.66145188613276673_dp, &
         &  -29.64483525740958925_dp,  48.62951713112133945_dp, &
         &  -29.15973753507462618_dp,  46.61834908938177335_dp, &
         &  -28.45262246278107554_dp,  44.64167567492752653_dp, &
         &  -27.54831327014242959_dp,  42.71190039889389567_dp, &
         &  -26.46787020033523774_dp,  40.84037031204417190_dp, &
         &  -25.22930648122764907_dp,  39.03757551632935474_dp, &
         &  -23.84820859564655038_dp,  37.31329283883029291_dp, &
         &  -22.33826403031283903_dp,  35.67668409468497259_dp, &
         &  -20.71170528699355629_dp,  34.13635737784334623_dp, &
         &  -18.97968026705781242_dp,  32.70039821822412307_dp, &
         &  -17.15255849246134900_dp,  31.37637626233231813_dp, &
         &  -15.24018123567454097_dp,  30.17133232687284305_dp, &
         &  -13.25206214192901299_dp,  29.09175016726920759_dp, &
         &  -11.19754366142445434_dp,  28.14351701208744316_dp, &
         &   -9.08591371200913933_dp,  27.33187675649334025_dp, &
         &   -6.92648650789848030_dp,  26.66137960320710931_dp, &
         &   -4.72865139696445969_dp,  26.13583181560235502_dp, &
         &   -2.50189378344492708_dp,  25.75824904385734015_dp, &
         &   -0.25579267831605540_dp,  25.53081635683327377_dp, &
         &    1.99999999999999556_dp,  22.72540973598210456_dp, &
         &    4.47629214130109165_dp,  22.80878975038074330_dp, &
         &    6.94242093509331060_dp,  23.05843251151436846_dp, &
         &    9.38829543151647350_dp,  23.47285525677742868_dp, &
         &   11.80396120930039139_dp,  24.04961640006232315_dp, &
         &   14.17964838758363122_dp,  24.78535803035031293_dp, &
         &   16.50579641562137567_dp,  25.67586152120415477_dp, &
         &   18.77304947679039060_dp,  26.71611272875198395_dp, &
         &   20.97221728412494102_dp,  27.90037270541385439_dp, &
         &   23.09419678103115103_dp,  29.22224954465700009_dp, &
         &   25.12985059268006793_dp,  30.67476685924402702_dp, &
         &   27.06983782140639860_dp,  32.25042441190934994_dp, &
         &   28.90439178940929921_dp,  33.94124647006630369_dp, &
         &   30.62303747247054275_dp,  35.73881343521246379_dp, &
         &   32.21423852322426029_dp,  37.63427208010365632_dp, &
         &   33.66495985223924237_dp,  39.61831917500946787_dp, &
         &   34.96012666362174315_dp,  41.68115224019865650_dp, &
         &   36.08195470333167520_dp,  43.81237943576640248_dp, &
         &   37.00911969333093765_dp,  46.00087796034757304_dp, &
         &   37.71572773969587189_dp,  48.23458650173874673_dp, &
         &   38.17004600591188535_dp,  50.50021197832979425_dp, &
         &   38.33296113360039925_dp,  52.78282385843581892_dp, &
         &   38.15616674923441565_dp,  55.06530104282313687_dp, &
         &   37.58017141013022666_dp,  57.32758829402004608_dp, &
         &   36.53242307522426557_dp,  59.54571651024583190_dp, &
         &   34.92626834358740950_dp,  61.69055635034530383_dp, &
         &   32.66225471925319113_dp,  63.72633555655123416_dp, &
         &   29.63456841105837825_dp,  65.60910965714572285_dp, &
         &   25.74696599568290623_dp,  67.28571148577094618_dp, &
         &   20.94303945184942251_dp,  68.69426490502790728_dp, &
         &   15.25145387811900122_dp,  69.76794994271870110_dp, &
         &    8.83336207267744022_dp,  70.44359392189112157_dp, &
         &    1.99999999999999600_dp,  70.67459026401789401_dp, &
         &   -4.83336207267745088_dp,  70.44359392189112157_dp, &
         &  -11.25145387811901188_dp,  69.76794994271870110_dp, &
         &  -16.94303945184943316_dp,  68.69426490502790728_dp, &
         &  -21.74696599568291333_dp,  67.28571148577094618_dp, &
         &  -25.63456841105838890_dp,  65.60910965714572285_dp, &
         &  -28.66225471925320534_dp,  63.72633555655123416_dp, &
         &  -30.92626834358741306_dp,  61.69055635034530383_dp, &
         &  -32.53242307522427978_dp,  59.54571651024583190_dp, &
         &  -33.58017141013024087_dp,  57.32758829402004608_dp, &
         &  -34.15616674923442986_dp,  55.06530104282313687_dp, &
         &  -34.33296113360040636_dp,  52.78282385843581892_dp, &
         &  -34.17004600591189956_dp,  50.50021197832979425_dp, &
         &  -33.71572773969587900_dp,  48.23458650173874673_dp, &
         &  -33.00911969333094476_dp,  46.00087796034757304_dp, &
         &  -32.08195470333168231_dp,  43.81237943576640248_dp, &
         &  -30.96012666362175025_dp,  41.68115224019865650_dp, &
         &  -29.66495985223924237_dp,  39.61831917500946787_dp, &
         &  -28.21423852322426740_dp,  37.63427208010365632_dp, &
         &  -26.62303747247054631_dp,  35.73881343521246379_dp, &
         &  -24.90439178940930276_dp,  33.94124647006630369_dp, &
         &  -23.06983782140640216_dp,  32.25042441190934994_dp, &
         &  -21.12985059268007149_dp,  30.67476685924402702_dp, &
         &  -19.09419678103115459_dp,  29.22224954465700009_dp, &
         &  -16.97221728412494102_dp,  27.90037270541385439_dp, &
         &  -14.77304947679039948_dp,  26.71611272875198395_dp, &
         &  -12.50579641562138455_dp,  25.67586152120415477_dp, &
         &  -10.17964838758364365_dp,  24.78535803035031293_dp, &
         &   -7.80396120930039938_dp,  24.04961640006232315_dp, &
         &   -5.38829543151647972_dp,  23.47285525677742868_dp, &
         &   -2.94242093509332037_dp,  23.05843251151436846_dp, &
         &   -0.47629214130110020_dp,  22.80878975038074330_dp, &
         &    1.99999999999999600_dp,  19.88744176867359670_dp, &
         &    4.69641128035122435_dp,  19.97822987242788884_dp, &
         &    7.38211423303385939_dp,  20.25003331964319031_dp, &
         &   10.04651538477556549_dp,  20.70118176192879389_dp, &
         &   12.67924035399200378_dp,  21.32893128539882710_dp, &
         &   15.27021753707410312_dp,  22.12952164603582617_dp, &
         &   17.80973254683686946_dp,  23.09825113914619976_dp, &
         &   20.28844626261447459_dp,  24.22956442487017270_dp, &
         &   22.69737092792362532_dp,  25.51714801636046204_dp, &
         &   25.02780000980339636_dp,  26.95402789495272344_dp, &
         &   27.27118821325056430_dp,  28.53266378578365448_dp, &
         &   29.41897786066868292_dp,  30.24503490367624536_dp, &
         &   31.46236656888654792_dp,  32.08271233019573287_dp, &
         &   33.39200856069422940_dp,  34.03691345955112979_dp, &
         &   35.19763777135730720_dp,  36.09853399317180589_dp, &
         &   36.86759479425492714_dp,  38.25815259440047811_dp, &
         &   38.38823113470312620_dp,  40.50600232791481403_dp, &
         &   39.74315247327933776_dp,  42.83190113242096686_dp, &
         &   40.91224672040999621_dp,  45.22513042719018728_dp, &
         &   41.87042151784342536_dp,  47.67424596736638165_dp, &
         &   42.58594887503602422_dp,  50.16679739569313057_dp, &
         &   43.01828312042781022_dp,  52.68892136253921876_dp, &
         &   43.11518954384546731_dp,  55.22475594928482678_dp, &
         &   42.80901819915838757_dp,  57.75559962131574565_dp, &
         &   42.01204327449660525_dp,  60.25870541573158334_dp, &
         &   40.61111913565843423_dp,  62.70556553816149403_dp, &
         &   38.46283411458643542_dp,  65.05952649321666570_dp, &
         &   35.39257932570031784_dp,  67.27265449907143591_dp, &
         &   31.20553396293055215_dp,  69.28213523998356038_dp, &
         &   25.72462936947633239_dp,  71.00751554077180572_dp, &
         &   18.87413258170036201_dp,  72.35214877025040892_dp, &
         &   10.80643587234801295_dp,  73.21444539538327945_dp, &
         &    1.99999999999999600_dp,  73.51255823132640899_dp, &
         &   -6.80643587234802006_dp,  73.21444539538327945_dp, &
         &  -14.87413258170037622_dp,  72.35214877025040892_dp, &
         &  -21.72462936947634304_dp,  71.00751554077180572_dp, &
         &  -27.20553396293055570_dp,  69.28213523998356038_dp, &
         &  -31.39257932570032139_dp,  67.27265449907143591_dp, &
         &  -34.46283411458643542_dp,  65.05952649321666570_dp, &
         &  -36.61111913565844134_dp,  62.70556553816149403_dp, &
         &  -38.01204327449661946_dp,  60.25870541573158334_dp, &
         &  -38.80901819915838047_dp,  57.75559962131574565_dp, &
         &  -39.11518954384547442_dp,  55.22475594928482678_dp, &
         &  -39.01828312042781022_dp,  52.68892136253921876_dp, &
         &  -38.58594887503603843_dp,  50.16679739569313057_dp, &
         &  -37.87042151784342536_dp,  47.67424596736638165_dp, &
         &  -36.91224672041000332_dp,  45.22513042719018728_dp, &
         &  -35.74315247327935197_dp,  42.83190113242096686_dp, &
         &  -34.38823113470313331_dp,  40.50600232791481403_dp, &
         &  -32.86759479425493424_dp,  38.25815259440047811_dp, &
         &  -31.19763777135731431_dp,  36.09853399317180589_dp, &
         &  -29.39200856069424717_dp,  34.03691345955112979_dp, &
         &  -27.46236656888655858_dp,  32.08271233019573287_dp, &
         &  -25.41897786066869003_dp,  30.24503490367624536_dp, &
         &  -23.27118821325056786_dp,  28.53266378578365448_dp, &
         &  -21.02780000980340702_dp,  26.95402789495272344_dp, &
         &  -18.69737092792362887_dp,  25.51714801636046204_dp, &
         &  -16.28844626261448170_dp,  24.22956442487017270_dp, &
         &  -13.80973254683687301_dp,  23.09825113914619976_dp, &
         &  -11.27021753707411023_dp,  22.12952164603582617_dp, &
         &   -8.67924035399200910_dp,  21.32893128539882710_dp, &
         &   -6.04651538477557171_dp,  20.70118176192879389_dp, &
         &   -3.38211423303386916_dp,  20.25003331964319031_dp, &
         &   -0.69641128035123179_dp,  19.97822987242788884_dp, &
         &    1.99999999999999556_dp,  16.92397162343523931_dp, &
         &    4.91799021933642688_dp,  17.02221659443387480_dp, &
         &    7.82460955068693664_dp,  17.31631470128239059_dp, &
         &   10.70865569654628935_dp,  17.80437171431731258_dp, &
         &   13.55924980839402139_dp,  18.48328342761256238_dp, &
         &   16.36596498789072385_dp,  19.34881113120014362_dp, &
         &   19.11891780975726363_dp,  20.39568010883170501_dp, &
         &   21.80881477377849720_dp,  21.61769490666709714_dp, &
         &   24.42694818201795570_dp,  23.00786444863284430_dp, &
         &   26.96513811238917668_dp,  24.55852997196867804_dp, &
         &   29.41561850057672345_dp,  26.26148912292403637_dp, &
         &   31.77086550998261671_dp,  28.10811023218007065_dp, &
         &   34.02336509370287132_dp,  30.08943159705432180_dp, &
         &   36.16531367916817175_dp,  32.19624133969532664_dp, &
         &   38.18824090805679106_dp,  34.41913389699745807_dp, &
         &   40.08253581911941410_dp,  36.74853923728758076_dp, &
         &   41.83684688715484867_dp,  39.17472027603687934_dp, &
         &   43.43731045663169255_dp,  41.68773239540036002_dp, &
         &   44.86653894639825779_dp,  44.27733603455973110_dp, &
         &   46.10226597817306526_dp,  46.93284831506371546_dp, &
         &   47.11549450115907689_dp,  49.64291142290011294_dp, &
         &   47.86791757533286074_dp,  52.39514197266055362_dp, &
         &   48.30826862884845241_dp,  55.17560336970880286_dp, &
         &   48.36709840828364548_dp,  57.96800639328736793_dp, &
         &   47.94927569193657035_dp,  60.75248226909388904_dp, &
         &   46.92334661203305046_dp,  63.50367340927639503_dp, &
         &   45.10709162054252630_dp,  66.18773615332521842_dp, &
         &   42.25028545833759352_dp,  68.75766348420629015_dp, &
         &   38.02194152863378918_dp,  71.14627956201685777_dp, &
         &   32.02735732207737840_dp,  73.25702648451857613_dp, &
         &   23.91726594386999949_dp,  74.95625177955801632_dp, &
         &   13.67376613190776347_dp,  76.07990221077976400_dp, &
         &    1.99999999999999600_dp,  76.47602837656475572_dp, &
         &   -9.67376613190777235_dp,  76.07990221077976400_dp, &
         &  -19.91726594387001015_dp,  74.95625177955801632_dp, &
         &  -28.02735732207739261_dp,  73.25702648451857613_dp, &
         &  -34.02194152863380339_dp,  71.14627956201685777_dp, &
         &  -38.25028545833759352_dp,  68.75766348420629015_dp, &
         &  -41.10709162054251919_dp,  66.18773615332521842_dp, &
         &  -42.92334661203306467_dp,  63.50367340927639503_dp, &
         &  -43.94927569193657746_dp,  60.75248226909388904_dp, &
         &  -44.36709840828364548_dp,  57.96800639328736793_dp, &
         &  -44.30826862884845241_dp,  55.17560336970880286_dp, &
         &  -43.86791757533286784_dp,  52.39514197266055362_dp, &
         &  -43.11549450115907689_dp,  49.64291142290011294_dp, &
         &  -42.10226597817306526_dp,  46.93284831506371546_dp, &
         &  -40.86653894639826490_dp,  44.27733603455973110_dp, &
         &  -39.43731045663169965_dp,  41.68773239540036002_dp, &
         &  -37.83684688715485578_dp,  39.17472027603687934_dp, &
         &  -36.08253581911941410_dp,  36.74853923728758076_dp, &
         &  -34.18824090805679816_dp,  34.41913389699745807_dp, &
         &  -32.16531367916818596_dp,  32.19624133969532664_dp, &
         &  -30.02336509370288908_dp,  30.08943159705432180_dp, &
         &  -27.77086550998262737_dp,  28.10811023218007065_dp, &
         &  -25.41561850057673766_dp,  26.26148912292403637_dp, &
         &  -22.96513811238918734_dp,  24.55852997196867804_dp, &
         &  -20.42694818201796636_dp,  23.00786444863284430_dp, &
         &  -17.80881477377850075_dp,  21.61769490666709714_dp, &
         &  -15.11891780975727251_dp,  20.39568010883170501_dp, &
         &  -12.36596498789073095_dp,  19.34881113120014362_dp, &
         &   -9.55924980839402849_dp,  18.48328342761256238_dp, &
         &   -6.70865569654630001_dp,  17.80437171431731258_dp, &
         &   -3.82460955068694464_dp,  17.31631470128239059_dp, &
         &   -0.91799021933643477_dp,  17.02221659443387480_dp, &
         &    1.99999999999999556_dp,  13.81592192037676625_dp, &
         &    5.14299451095195792_dp,  13.92173872937387102_dp, &
         &    8.27378779825514954_dp,  14.23846093632396581_dp, &
         &   11.38041466390652978_dp,  14.76392503362292530_dp, &
         &   14.45136393475438119_dp,  15.49459412897926924_dp, &
         &   17.47576217013061139_dp,  16.42565612762181004_dp, &
         &   20.44350999615491205_dp,  17.55115134744557182_dp, &
         &   23.34536199373425092_dp,  18.86412113035556004_dp, &
         &   26.17294518233925160_dp,  20.35676830949395466_dp, &
         &   28.91871466466540141_dp,  22.02062053097340311_dp, &
         &   31.57584735879237314_dp,  23.84668824688734645_dp, &
         &   34.13807554901531205_dp,  25.82561045671564415_dp, &
         &   36.59946098845733786_dp,  27.94778271439298933_dp, &
         &   38.95410730493897233_dp,  30.20346328869342756_dp, &
         &   41.19580324741197330_dp,  32.58285444844916867_dp, &
         &   43.31758136998609388_dp,  35.07615645611910082_dp, &
         &   45.31116510791174079_dp,  37.67359181604234664_dp, &
         &   47.16626004327477517_dp,  40.36539642075791789_dp, &
         &   48.86961926381131605_dp,  43.14177213432515856_dp, &
         &   50.40377244059970963_dp,  45.99279145534946167_dp, &
         &   51.74524369263552614_dp,  48.90823812634897649_dp, &
         &   52.86197695521289575_dp,  51.87735585154322138_dp, &
         &   53.70950811496559396_dp,  54.88845672164920586_dp, &
         &   54.22511448054331140_dp,  57.92830381592441569_dp, &
         &   54.31863539857850753_dp,  60.98111330635318694_dp, &
         &   53.85773173662808233_dp,  64.02688869849654907_dp, &
         &   52.64383991815974895_dp,  67.03853932314146391_dp, &
         &   50.37308749001456931_dp,  69.97672254379963874_dp, &
         &   46.57629367046713753_dp,  72.78039612779683409_dp, &
         &   40.54693285975561423_dp,  75.34972495190746145_dp, &
         &   31.34759503822197502_dp,  77.51867325981696411_dp, &
         &   18.24038894313819625_dp,  79.03039199474196153_dp, &
         &    1.99999999999999489_dp,  79.58407807962322522_dp, &
         &  -14.24038894313820691_dp,  79.03039199474196153_dp, &
         &  -27.34759503822198567_dp,  77.51867325981696411_dp, &
         &  -36.54693285975562134_dp,  75.34972495190746145_dp, &
         &  -42.57629367046714464_dp,  72.78039612779683409_dp, &
         &  -46.37308749001456931_dp,  69.97672254379963874_dp, &
         &  -48.64383991815974895_dp,  67.03853932314146391_dp, &
         &  -49.85773173662808233_dp,  64.02688869849654907_dp, &
         &  -50.31863539857852174_dp,  60.98111330635318694_dp, &
         &  -50.22511448054332561_dp,  57.92830381592441569_dp, &
         &  -49.70950811496560817_dp,  54.88845672164920586_dp, &
         &  -48.86197695521290996_dp,  51.87735585154322138_dp, &
         &  -47.74524369263553325_dp,  48.90823812634897649_dp, &
         &  -46.40377244059971673_dp,  45.99279145534946167_dp, &
         &  -44.86961926381133026_dp,  43.14177213432515856_dp, &
         &  -43.16626004327478938_dp,  40.36539642075791789_dp, &
         &  -41.31116510791174079_dp,  37.67359181604234664_dp, &
         &  -39.31758136998610098_dp,  35.07615645611910082_dp, &
         &  -37.19580324741197330_dp,  32.58285444844916867_dp, &
         &  -34.95410730493897233_dp,  30.20346328869342756_dp, &
         &  -32.59946098845735207_dp,  27.94778271439298933_dp, &
         &  -30.13807554901532626_dp,  25.82561045671564415_dp, &
         &  -27.57584735879238025_dp,  23.84668824688734645_dp, &
         &  -24.91871466466541207_dp,  22.02062053097340311_dp, &
         &  -22.17294518233926226_dp,  20.35676830949395466_dp, &
         &  -19.34536199373426157_dp,  18.86412113035556004_dp, &
         &  -16.44350999615492626_dp,  17.55115134744557182_dp, &
         &  -13.47576217013062028_dp,  16.42565612762181004_dp, &
         &  -10.45136393475438830_dp,  15.49459412897926924_dp, &
         &   -7.38041466390653600_dp,  14.76392503362292530_dp, &
         &   -4.27378779825515931_dp,  14.23846093632396581_dp, &
         &   -1.14299451095196680_dp,  13.92173872937387102_dp, &
         &    1.99999999999999600_dp,  10.54173785529561158_dp, &
         &    5.37360609917943943_dp,  10.65531494200142149_dp, &
         &    8.73395228112667965_dp,  10.99520717814031556_dp, &
         &   12.06809948196381832_dp,  11.55892497220584403_dp, &
         &   15.36372621835939078_dp,  12.34240842556757656_dp, &
         &   18.60937983520193129_dp,  13.34015413091371016_dp, &
         &   21.79466590782825364_dp,  14.54537904344351951_dp, &
         &   24.91036566952359266_dp,  15.95020993686824440_dp, &
         &   27.94847769357361855_dp,  17.54588626406437513_dp, &
         &   30.90218550361061745_dp,  19.32296477964253967_dp, &
         &   33.76575655354334060_dp,  21.27151577227775903_dp, &
         &   36.53437968696508875_dp,  23.38130282889363798_dp, &
         &   39.20394762734519389_dp,  25.64194033091114022_dp, &
         &   41.77078829775712165_dp,  28.04302503644353095_dp, &
         &   44.23134383513491485_dp,  30.57423988556289629_dp, &
         &   46.58178882927892772_dp,  33.22542941501406233_dp, &
         &   48.81756887288366187_dp,  35.98664677769215103_dp, &
         &   50.93282539675248444_dp,  38.84817223653458029_dp, &
         &   52.91964996438991164_dp,  41.80050199367043007_dp, &
         &   54.76707508825830928_dp,  44.83430401955754974_dp, &
         &   56.45964870701569538_dp,  47.94033352757975308_dp, &
         &   57.97533567047437231_dp,  51.10929358481432416_dp, &
         &   59.28230228211859298_dp,  54.33161333463023368_dp, &
         &   60.33378767939932885_dp,  57.59709162031844443_dp, &
         &   61.05957379451161415_dp,  60.89430451319173443_dp, &
         &   61.35114187047394552_dp,  64.20957103321013903_dp, &
         &   61.03453256694833584_dp,  67.52503657439316953_dp, &
         &   59.81801935702030448_dp,  70.81486693953938527_dp, &
         &   57.18593275925195485_dp,  74.03707888623914357_dp, &
         &   52.17735288037920327_dp,  77.11452529323830163_dp, &
         &   42.96575654499160635_dp,  79.88802174923021937_dp, &
         &   26.58690897303194944_dp,  82.01033616765489853_dp, &
         &    1.99999999999999756_dp,  82.85826214470436923_dp, &
         &  -22.58690897303195300_dp,  82.01033616765489853_dp, &
         &  -38.96575654499161345_dp,  79.88802174923021937_dp, &
         &  -48.17735288037921748_dp,  77.11452529323830163_dp, &
         &  -53.18593275925197617_dp,  74.03707888623914357_dp, &
         &  -55.81801935702031159_dp,  70.81486693953938527_dp, &
         &  -57.03453256694834295_dp,  67.52503657439316953_dp, &
         &  -57.35114187047395262_dp,  64.20957103321013903_dp, &
         &  -57.05957379451162836_dp,  60.89430451319173443_dp, &
         &  -56.33378767939933596_dp,  57.59709162031844443_dp, &
         &  -55.28230228211860720_dp,  54.33161333463023368_dp, &
         &  -53.97533567047437231_dp,  51.10929358481432416_dp, &
         &  -52.45964870701570248_dp,  47.94033352757975308_dp, &
         &  -50.76707508825830928_dp,  44.83430401955754974_dp, &
         &  -48.91964996438991875_dp,  41.80050199367043007_dp, &
         &  -46.93282539675249154_dp,  38.84817223653458029_dp, &
         &  -44.81756887288366897_dp,  35.98664677769215103_dp, &
         &  -42.58178882927894193_dp,  33.22542941501406233_dp, &
         &  -40.23134383513492196_dp,  30.57423988556289629_dp, &
         &  -37.77078829775713587_dp,  28.04302503644353095_dp, &
         &  -35.20394762734520100_dp,  25.64194033091114022_dp, &
         &  -32.53437968696510296_dp,  23.38130282889363798_dp, &
         &  -29.76575655354335481_dp,  21.27151577227775903_dp, &
         &  -26.90218550361062810_dp,  19.32296477964253967_dp, &
         &  -23.94847769357362921_dp,  17.54588626406437513_dp, &
         &  -20.91036566952360332_dp,  15.95020993686824440_dp, &
         &  -17.79466590782826074_dp,  14.54537904344351951_dp, &
         &  -14.60937983520194017_dp,  13.34015413091371016_dp, &
         &  -11.36372621835939611_dp,  12.34240842556757656_dp, &
         &   -8.06809948196382898_dp,  11.55892497220584403_dp, &
         &   -4.73395228112668676_dp,  10.99520717814031556_dp, &
         &   -1.37360609917944720_dp,  10.65531494200142149_dp, &
         &    1.99999999999999600_dp,   7.07694595379052860_dp, &
         &    5.61234064761578821_dp,   7.19855645524002874_dp, &
         &    9.21005712455210990_dp,   7.56241362477411005_dp, &
         &   12.77895396829166508_dp,   8.16563014493928208_dp, &
         &   16.30566013367806733_dp,   9.00350968307661859_dp, &
         &   19.77796305903054730_dp,  10.06971032975657643_dp, &
         &   23.18506021909562875_dp,  11.35645428598743756_dp, &
         &   26.51771689758311723_dp,  12.85476800444172873_dp, &
         &   29.76832854644279536_dp,  14.55473640862136264_dp, &
         &   32.93089420696504277_dp,  16.44575600838861362_dp, &
         &   36.00091302933286386_dp,  18.51677422677156315_dp, &
         &   38.97521854780546846_dp,  20.75650546647104022_dp, &
         &   41.85176517580521960_dp,  23.15361781597290403_dp, &
         &   44.62937881000767248_dp,  25.69688738457191945_dp, &
         &   47.30747895739604303_dp,  28.37531978094453677_dp, &
         &   49.88577372237665486_dp,  31.17824007995576707_dp, &
         &   52.36392121341754091_dp,  34.09535373993877982_dp, &
         &   54.74114071516557090_dp,  37.11678138456306897_dp, &
         &   57.01574257648425004_dp,  40.23307020728445593_dp, &
         &   59.18452370168172649_dp,  43.43518400478754415_dp, &
         &   61.24193904387428233_dp,  46.71447239476329827_dp, &
         &   63.17889520468774833_dp,  50.06261728049957327_dp, &
         &   64.98089250042356468_dp,  53.47155025248752480_dp, &
         &   66.62500642980749888_dp,  56.93332642202356197_dp, &
         &   68.07470870335012592_dp,  60.43992354246547904_dp, &
         &   69.27043361461275595_dp,  63.98289851135272244_dp, &
         &   70.11115128919476547_dp,  67.55274433031233627_dp, &
         &   70.41516373728855172_dp,  71.13755089586132385_dp, &
         &   69.82714145548160900_dp,  74.71983727667713993_dp, &
         &   67.56415050352947560_dp,  78.26774990878784877_dp, &
         &   61.58131858106001033_dp,  81.70467639663139892_dp, &
         &   45.28583165458982052_dp,  84.76914638163376026_dp, &
         &    1.99999999999999689_dp,  86.32305404620944955_dp, &
         &  -41.28583165458982762_dp,  84.76914638163376026_dp, &
         &  -57.58131858106002454_dp,  81.70467639663139892_dp, &
         &  -63.56415050352948981_dp,  78.26774990878784877_dp, &
         &  -65.82714145548162321_dp,  74.71983727667713993_dp, &
         &  -66.41516373728856593_dp,  71.13755089586132385_dp, &
         &  -66.11115128919477968_dp,  67.55274433031233627_dp, &
         &  -65.27043361461275595_dp,  63.98289851135272244_dp, &
         &  -64.07470870335011170_dp,  60.43992354246547904_dp, &
         &  -62.62500642980752019_dp,  56.93332642202356197_dp, &
         &  -60.98089250042357889_dp,  53.47155025248752480_dp, &
         &  -59.17889520468775544_dp,  50.06261728049957327_dp, &
         &  -57.24193904387428233_dp,  46.71447239476329827_dp, &
         &  -55.18452370168172649_dp,  43.43518400478754415_dp, &
         &  -53.01574257648425004_dp,  40.23307020728445593_dp, &
         &  -50.74114071516557800_dp,  37.11678138456306897_dp, &
         &  -48.36392121341754802_dp,  34.09535373993877982_dp, &
         &  -45.88577372237665486_dp,  31.17824007995576707_dp, &
         &  -43.30747895739605013_dp,  28.37531978094453677_dp, &
         &  -40.62937881000767959_dp,  25.69688738457191945_dp, &
         &  -37.85176517580522670_dp,  23.15361781597290403_dp, &
         &  -34.97521854780547557_dp,  20.75650546647104022_dp, &
         &  -32.00091302933286386_dp,  18.51677422677156315_dp, &
         &  -28.93089420696504632_dp,  16.44575600838861362_dp, &
         &  -25.76832854644280957_dp,  14.55473640862136264_dp, &
         &  -22.51771689758312434_dp,  12.85476800444172873_dp, &
         &  -19.18506021909564296_dp,  11.35645428598743756_dp, &
         &  -15.77796305903055796_dp,  10.06971032975657643_dp, &
         &  -12.30566013367807621_dp,   9.00350968307661859_dp, &
         &   -8.77895396829167574_dp,   8.16563014493928208_dp, &
         &   -5.21005712455211967_dp,   7.56241362477411005_dp, &
         &   -1.61234064761579732_dp,   7.19855645524002874_dp, &
         &    1.99999999999999556_dp,   3.39364961385021102_dp, &
         &    5.86220744039440511_dp,   3.52366797872772963_dp, &
         &    9.70801791517021506_dp,   3.91258202080964379_dp, &
         &   13.52160273595813145_dp,   4.55701513369246314_dp, &
         &   17.28822357553576694_dp,   5.45149036402020482_dp, &
         &   20.99466904928960531_dp,   6.58864168091601599_dp, &
         &   24.62957864939021135_dp,   7.95948261839810378_dp, &
         &   28.18364165385172626_dp,   9.55371034930797514_dp, &
         &   31.64967308093981302_dp,  11.36002298851478365_dp, &
         &   35.02258051120933402_dp,  13.36643021383323671_dp, &
         &   38.29924330014637235_dp,  15.56054131855884215_dp, &
         &   41.47832910130669859_dp,  17.92981963683195801_dp, &
         &   44.56007232189227807_dp,  20.46179708442632261_dp, &
         &   47.54603622089215520_dp,  23.14424674184217068_dp, &
         &   50.43887601207384819_dp,  25.96531465470105005_dp, &
         &   53.24211556220075892_dp,  28.91361425616476666_dp, &
         &   55.95994579953058690_dp,  31.97828811153562256_dp, &
         &   58.59704918478396252_dp,  35.14904222145087687_dp, &
         &   61.15845171105517863_dp,  38.41615810166681655_dp, &
         &   63.64940188352277062_dp,  41.77048747717444854_dp, &
         &   66.07527488350018530_dp,  45.20343384586799118_dp, &
         &   68.44149951448399349_dp,  48.70692450151241104_dp, &
         &   70.75350545455997064_dp,  52.27337593848611164_dp, &
         &   73.01668877482984499_dp,  55.89565494125256606_dp, &
         &   75.23639478559491067_dp,  59.56703711552955127_dp, &
         &   77.41791965045068480_dp,  63.28116415502339720_dp, &
         &   79.56653776770211550_dp,  67.03200075627316323_dp, &
         &   81.68757690134610527_dp,  70.81379178736983704_dp, &
         &   83.78661098119418682_dp,  74.62102007313750107_dp, &
         &   85.87003129087820241_dp,  78.44836496333871878_dp, &
         &   87.94730489861872513_dp,  82.29066165213365025_dp, &
         &   90.04670840724658376_dp,  86.14286053253557895_dp, &
         & -177.99999999999985789_dp,  89.99364961382421768_dp, &
         &  -86.04670840724655534_dp,  86.14286053253557895_dp, &
         &  -83.94730489861876777_dp,  82.29066165213365025_dp, &
         &  -81.87003129087820241_dp,  78.44836496333871878_dp, &
         &  -79.78661098119418682_dp,  74.62102007313750107_dp, &
         &  -77.68757690134613370_dp,  70.81379178736983704_dp, &
         &  -75.56653776770212971_dp,  67.03200075627316323_dp, &
         &  -73.41791965045068480_dp,  63.28116415502339720_dp, &
         &  -71.23639478559491067_dp,  59.56703711552955127_dp, &
         &  -69.01668877482984499_dp,  55.89565494125256606_dp, &
         &  -66.75350545455997064_dp,  52.27337593848611164_dp, &
         &  -64.44149951448400770_dp,  48.70692450151241104_dp, &
         &  -62.07527488350018530_dp,  45.20343384586799118_dp, &
         &  -59.64940188352277772_dp,  41.77048747717444854_dp, &
         &  -57.15845171105518574_dp,  38.41615810166681655_dp, &
         &  -54.59704918478396252_dp,  35.14904222145087687_dp, &
         &  -51.95994579953059400_dp,  31.97828811153562256_dp, &
         &  -49.24211556220076602_dp,  28.91361425616476666_dp, &
         &  -46.43887601207384819_dp,  25.96531465470105005_dp, &
         &  -43.54603622089217652_dp,  23.14424674184217068_dp, &
         &  -40.56007232189229228_dp,  20.46179708442632261_dp, &
         &  -37.47832910130670570_dp,  17.92981963683195801_dp, &
         &  -34.29924330014637945_dp,  15.56054131855884215_dp, &
         &  -31.02258051120933402_dp,  13.36643021383323671_dp, &
         &  -27.64967308093982012_dp,  11.36002298851478365_dp, &
         &  -24.18364165385173337_dp,   9.55371034930797514_dp, &
         &  -20.62957864939022556_dp,   7.95948261839810378_dp, &
         &  -16.99466904928961597_dp,   6.58864168091601599_dp, &
         &  -13.28822357553577582_dp,   5.45149036402020482_dp, &
         &   -9.52160273595813855_dp,   4.55701513369246314_dp, &
         &   -5.70801791517022572_dp,   3.91258202080964379_dp, &
         &   -1.86220744039441377_dp,   3.52366797872772963_dp, &
         &    1.99999999999999556_dp,  -0.54003843869415158_dp, &
         &    6.12693783758673050_dp,  -0.40111214042971866_dp, &
         &   10.23515434659413970_dp,   0.01431798130226895_dp, &
         &   14.30668142622436534_dp,   0.70226688878527466_dp, &
         &   18.32499114491300674_dp,   1.65629062554436168_dp, &
         &   22.27556116130715580_dp,   2.86776143955401341_dp, &
         &   26.14628266758476016_dp,   4.32621388981252775_dp, &
         &   29.92769777693464306_dp,   6.01973109672258033_dp, &
         &   33.61307490596014702_dp,   7.93534078498540918_dp, &
         &   37.19834740797973183_dp,  10.05939491571368904_dp, &
         &   40.68195074563112712_dp,  12.37791309905906267_dp, &
         &   44.06459700293881809_dp,  14.87687712846902421_dp, &
         &   47.34902402209520034_dp,  17.54247066454981052_dp, &
         &   50.53975201683548590_dp,  20.36126354510683711_dp, &
         &   53.64287529119709319_dp,  23.32034407821754485_dp, &
         &   56.66591251909911620_dp,  26.40740499964346455_dp, &
         &   59.61773745881250619_dp,  29.61078975921034129_dp, &
         &   62.50861449014276872_dp,  32.91950572923986584_dp, &
         &   65.35037195723165837_dp,  36.32321005821969351_dp, &
         &   68.15676435641833564_dp,  39.81217237539897269_dp, &
         &   70.94410839385281520_dp,  43.37721635788606989_dp, &
         &   73.73234087330637010_dp,  47.00963897352001908_dp, &
         &   76.54676554128549526_dp,  50.70110112272598712_dp, &
         &   79.42099130058548440_dp,  54.44347433172315220_dp, &
         &   82.40205491898922219_dp,  58.22861013398449614_dp, &
         &   85.55981529780903827_dp,  62.04795929474799721_dp, &
         &   89.00534896567364740_dp,  65.89187266757559769_dp, &
         &   92.93011750021230455_dp,  69.74815881341463353_dp, &
         &   97.69886509454546797_dp,  73.59868574092438109_dp, &
         &  104.10346048738931302_dp,  77.40995108179684792_dp, &
         &  114.19717929614462548_dp,  81.10053146183234674_dp, &
         &  134.58473801020662108_dp,  84.39088722277180921_dp, &
         & -178.00000000000002842_dp,  86.05996156130575514_dp, &
         & -130.58473801020659266_dp,  84.39088722277180921_dp, &
         & -110.19717929614465390_dp,  81.10053146183234674_dp, &
         & -100.10346048738929881_dp,  77.40995108179684792_dp, &
         &  -93.69886509454548218_dp,  73.59868574092438109_dp, &
         &  -88.93011750021230455_dp,  69.74815881341463353_dp, &
         &  -85.00534896567366161_dp,  65.89187266757559769_dp, &
         &  -81.55981529780905248_dp,  62.04795929474799721_dp, &
         &  -78.40205491898922219_dp,  58.22861013398449614_dp, &
         &  -75.42099130058548440_dp,  54.44347433172315220_dp, &
         &  -72.54676554128549526_dp,  50.70110112272598712_dp, &
         &  -69.73234087330638431_dp,  47.00963897352001908_dp, &
         &  -66.94410839385282941_dp,  43.37721635788606989_dp, &
         &  -64.15676435641836406_dp,  39.81217237539897269_dp, &
         &  -61.35037195723166548_dp,  36.32321005821969351_dp, &
         &  -58.50861449014277582_dp,  32.91950572923986584_dp, &
         &  -55.61773745881251330_dp,  29.61078975921034129_dp, &
         &  -52.66591251909913041_dp,  26.40740499964346455_dp, &
         &  -49.64287529119710030_dp,  23.32034407821754485_dp, &
         &  -46.53975201683548590_dp,  20.36126354510683711_dp, &
         &  -43.34902402209520034_dp,  17.54247066454981052_dp, &
         &  -40.06459700293881809_dp,  14.87687712846902421_dp, &
         &  -36.68195074563112712_dp,  12.37791309905906267_dp, &
         &  -33.19834740797973893_dp,  10.05939491571368904_dp, &
         &  -29.61307490596015057_dp,   7.93534078498540918_dp, &
         &  -25.92769777693465727_dp,   6.01973109672258033_dp, &
         &  -22.14628266758476371_dp,   4.32621388981252775_dp, &
         &  -18.27556116130716291_dp,   2.86776143955401341_dp, &
         &  -14.32499114491301384_dp,   1.65629062554436168_dp, &
         &  -10.30668142622437244_dp,   0.70226688878527466_dp, &
         &   -6.23515434659414680_dp,   0.01431798130226895_dp, &
         &   -2.12693783758673804_dp,  -0.40111214042971866_dp, &
         &    1.99999999999999556_dp,  -4.76061810234754645_dp, &
         &    6.41132592404072454_dp,  -4.61212239418478553_dp, &
         &   10.80084816537008230_dp,  -4.16824654595516098_dp, &
         &   15.14776873556008674_dp,  -3.43374257581263365_dp, &
         &   19.43320327160517635_dp,  -2.41626750988024641_dp, &
         &   23.64091162595336115_dp,  -1.12602081331554671_dp, &
         &   27.75780275269853448_dp,   0.42470591907018324_dp, &
         &   31.77420154083880988_dp,   2.22202305439570047_dp, &
         &   35.68389780238808129_dp,   4.25093893994811900_dp, &
         &   39.48402100288601702_dp,   6.49582334126627270_dp, &
         &   43.17479644658765636_dp,   8.94081392759362181_dp, &
         &   46.75924066894447861_dp,  11.57015196980179894_dp, &
         &   50.24284889074777283_dp,  14.36844259642658628_dp, &
         &   53.63331929525543273_dp,  17.32084182287968943_dp, &
         &   56.94035098918124049_dp,  20.41317688045037571_dp, &
         &   60.17554747078253286_dp,  23.63200834498020697_dp, &
         &   63.35245736607463840_dp,  26.96464262473803686_dp, &
         &   66.48679120890342631_dp,  30.39910192691253599_dp, &
         &   69.59687011372152199_dp,  33.92405612452549946_dp, &
         &   72.70439458886511375_dp,  37.52871692222674938_dp, &
         &   75.83567948061782715_dp,  41.20268880474466755_dp, &
         &   79.02360369831293951_dp,  44.93576201889581512_dp, &
         &   82.31071017117776023_dp,  48.71761719224470966_dp, &
         &   85.75424365182692554_dp,  52.53738247574246856_dp, &
         &   89.43460651588344490_dp,  56.38292751246400769_dp, &
         &   93.47013935832343634_dp,  60.23965935256792648_dp, &
         &   98.04421718085441739_dp,  64.08831694761893516_dp, &
         &  103.45761459629794388_dp,  67.90061168070626252_dp, &
         &  110.23509874248559015_dp,  71.62987479878029262_dp, &
         &  119.34882263320223217_dp,  75.18923730101467129_dp, &
         &  132.64763601333982024_dp,  78.39753950634394641_dp, &
         &  153.15668933029419918_dp,  80.85560324742944260_dp, &
         & -178.00000000000002842_dp,  81.83938189765245852_dp, &
         & -149.15668933029422760_dp,  80.85560324742944260_dp, &
         & -128.64763601333984866_dp,  78.39753950634394641_dp, &
         & -115.34882263320223217_dp,  75.18923730101467129_dp, &
         & -106.23509874248556173_dp,  71.62987479878029262_dp, &
         &  -99.45761459629794388_dp,  67.90061168070626252_dp, &
         &  -94.04421718085441739_dp,  64.08831694761893516_dp, &
         &  -89.47013935832346476_dp,  60.23965935256792648_dp, &
         &  -85.43460651588344490_dp,  56.38292751246400769_dp, &
         &  -81.75424365182695396_dp,  52.53738247574246856_dp, &
         &  -78.31071017117777444_dp,  48.71761719224470966_dp, &
         &  -75.02360369831293951_dp,  44.93576201889581512_dp, &
         &  -71.83567948061784136_dp,  41.20268880474466755_dp, &
         &  -68.70439458886511375_dp,  37.52871692222674938_dp, &
         &  -65.59687011372152199_dp,  33.92405612452549946_dp, &
         &  -62.48679120890344052_dp,  30.39910192691253599_dp, &
         &  -59.35245736607464551_dp,  26.96464262473803686_dp, &
         &  -56.17554747078254707_dp,  23.63200834498020697_dp, &
         &  -52.94035098918124760_dp,  20.41317688045037571_dp, &
         &  -49.63331929525544695_dp,  17.32084182287968943_dp, &
         &  -46.24284889074779414_dp,  14.36844259642658628_dp, &
         &  -42.75924066894448572_dp,  11.57015196980179894_dp, &
         &  -39.17479644658766347_dp,   8.94081392759362181_dp, &
         &  -35.48402100288603123_dp,   6.49582334126627270_dp, &
         &  -31.68389780238809195_dp,   4.25093893994811900_dp, &
         &  -27.77420154083882409_dp,   2.22202305439570047_dp, &
         &  -23.75780275269854513_dp,   0.42470591907018324_dp, &
         &  -19.64091162595336826_dp,  -1.12602081331554671_dp, &
         &  -15.43320327160518879_dp,  -2.41626750988024641_dp, &
         &  -11.14776873556009562_dp,  -3.43374257581263365_dp, &
         &   -6.80084816537009029_dp,  -4.16824654595516098_dp, &
         &   -2.41132592404073298_dp,  -4.61212239418478553_dp, &
         &    1.99999999999999556_dp,  -9.30985393851741705_dp, &
         &    6.72175805422021355_dp,  -9.15091230991673932_dp, &
         &   11.41756212661333514_dp,  -8.67603648837036268_dp, &
         &   16.06282113870961226_dp,  -7.89096231408012549_dp, &
         &   20.63552097548324227_dp,  -6.80489321395614688_dp, &
         &   25.11717183125960418_dp,  -5.43001433583735604_dp, &
         &   29.49342310484702523_dp,  -3.78089833576525836_dp, &
         &   33.75433817509684786_dp,  -1.87386656696368870_dp, &
         &   37.89437094593881028_dp,   0.27363605581641121_dp, &
         &   41.91211819209927114_dp,   2.64360721178193936_dp, &
         &   45.80993456941938291_dp,   5.21796518077428217_dp, &
         &   49.59349430020984784_dp,   7.97892504367260536_dp, &
         &   53.27137129744098587_dp,  10.90927185095380025_dp, &
         &   56.85469423510678411_dp,  13.99253787292509266_dp, &
         &   60.35691981311008192_dp,  17.21309536720795919_dp, &
         &   63.79375952890369206_dp,  20.55617726580611659_dp, &
         &   67.18329478816110623_dp,  24.00783659504739731_dp, &
         &   70.54632400302143935_dp,  27.55485191826680236_dp, &
         &   73.90700610430916129_dp,  31.18458087158649406_dp, &
         &   77.29390254081907585_dp,  34.88475663106463287_dp, &
         &   80.74158359961856490_dp,  38.64321178012773572_dp, &
         &   84.29307189810650414_dp,  42.44749809608728697_dp, &
         &   88.00357763838491110_dp,  46.28434439562811065_dp, &
         &   91.94629406419836926_dp,  50.13884820321026581_dp, &
         &   96.22157019495104180_dp,  53.99321139219064491_dp, &
         &  100.97173315822050199_dp,  57.82466562901674934_dp, &
         &  106.40541928769302160_dp,  61.60190913800559542_dp, &
         &  112.83745587761723073_dp,  65.27873175231235336_dp, &
         &  120.75095597801100666_dp,  68.78228497629521598_dp, &
         &  130.87442892417493567_dp,  71.99165187875782124_dp, &
         &  144.18467631053604805_dp,  74.70285264202438213_dp, &
         &  161.47781378002883912_dp,  76.59572545663588983_dp, &
         & -178.00000000000002842_dp,  77.29014606148258792_dp, &
         & -157.47781378002883912_dp,  76.59572545663588983_dp, &
         & -140.18467631053607647_dp,  74.70285264202438213_dp, &
         & -126.87442892417496410_dp,  71.99165187875782124_dp, &
         & -116.75095597801099245_dp,  68.78228497629521598_dp, &
         & -108.83745587761723073_dp,  65.27873175231235336_dp, &
         & -102.40541928769302160_dp,  61.60190913800559542_dp, &
         &  -96.97173315822051620_dp,  57.82466562901674934_dp, &
         &  -92.22157019495104180_dp,  53.99321139219064491_dp, &
         &  -87.94629406419838347_dp,  50.13884820321026581_dp, &
         &  -84.00357763838492531_dp,  46.28434439562811065_dp, &
         &  -80.29307189810650414_dp,  42.44749809608728697_dp, &
         &  -76.74158359961857911_dp,  38.64321178012773572_dp, &
         &  -73.29390254081907585_dp,  34.88475663106463287_dp, &
         &  -69.90700610430916129_dp,  31.18458087158649406_dp, &
         &  -66.54632400302145356_dp,  27.55485191826680236_dp, &
         &  -63.18329478816111333_dp,  24.00783659504739731_dp, &
         &  -59.79375952890369916_dp,  20.55617726580611659_dp, &
         &  -56.35691981311008192_dp,  17.21309536720795919_dp, &
         &  -52.85469423510679832_dp,  13.99253787292509266_dp, &
         &  -49.27137129744098587_dp,  10.90927185095380025_dp, &
         &  -45.59349430020986915_dp,   7.97892504367260536_dp, &
         &  -41.80993456941939712_dp,   5.21796518077428217_dp, &
         &  -37.91211819209929246_dp,   2.64360721178193936_dp, &
         &  -33.89437094593881739_dp,   0.27363605581641121_dp, &
         &  -29.75433817509685497_dp,  -1.87386656696368870_dp, &
         &  -25.49342310484703944_dp,  -3.78089833576525836_dp, &
         &  -21.11717183125961128_dp,  -5.43001433583735604_dp, &
         &  -16.63552097548325293_dp,  -6.80489321395614688_dp, &
         &  -12.06282113870962114_dp,  -7.89096231408012549_dp, &
         &   -7.41756212661334136_dp,  -8.67603648837036268_dp, &
         &   -2.72175805422022110_dp,  -9.15091230991673932_dp, &
         &    1.99999999999999556_dp, -14.23540593490034212_dp, &
         &    7.06707279862612125_dp, -14.06484423228424063_dp, &
         &   12.10248720394761790_dp, -13.55555303790300137_dp, &
         &   17.07647532339787944_dp, -12.71455858250937965_dp, &
         &   21.96281473836326015_dp, -11.55307649365679623_dp, &
         &   26.74006765897273041_dp, -10.08584610023314454_dp, &
         &   31.39231472226267528_dp,  -8.33033151194296018_dp, &
         &   35.90939060170597230_dp,  -6.30588392466837799_dp, &
         &   40.28670514160292271_dp,  -4.03294710811188395_dp, &
         &   44.52477649322944586_dp,  -1.53236497867592791_dp, &
         &   48.62861191461712451_dp,   1.17517574056815022_dp, &
         &   52.60705694133754662_dp,   4.06955754229703981_dp, &
         &   56.47220691225791711_dp,   7.13150506907926562_dp, &
         &   60.23894695811429756_dp,  10.34273467530950796_dp, &
         &   63.92466443809040300_dp,  13.68599977255221845_dp, &
         &   67.54916484650964037_dp,  17.14505004500527363_dp, &
         &   71.13481958525987636_dp,  20.70451849248449960_dp, &
         &   74.70698212428176532_dp,  24.34974403770184992_dp, &
         &   78.29472888122153051_dp,  28.06652943785655552_dp, &
         &   81.93201512996088809_dp,  31.84082402428231973_dp, &
         &   85.65938939021744147_dp,  35.65830698143167155_dp, &
         &   89.52649044264860834_dp,  39.50382677214758331_dp, &
         &   93.59567144235911940_dp,  43.36062114047545890_dp, &
         &   97.94726867835277062_dp,  47.20919167069192923_dp, &
         &  102.68725830824645584_dp,  51.02562354013957702_dp, &
         &  107.95825647893494192_dp,  54.77900423463843538_dp, &
         &  113.95470750710921948_dp,  58.42738157410047961_dp, &
         &  120.94158660124729465_dp,  61.91142197433249095_dp, &
         &  129.26976638159490562_dp,  65.14478524125112813_dp, &
         &  139.36255278451201889_dp,  68.00113945880528377_dp, &
         &  151.60742176334809983_dp,  70.30250402254893061_dp, &
         &  166.05644118521092878_dp,  71.82662636485281382_dp, &
         & -178.00000000000002842_dp,  72.36459406509962378_dp, &
         & -162.05644118521095720_dp,  71.82662636485281382_dp, &
         & -147.60742176334812825_dp,  70.30250402254893061_dp, &
         & -135.36255278451201889_dp,  68.00113945880528377_dp, &
         & -125.26976638159489141_dp,  65.14478524125112813_dp, &
         & -116.94158660124729465_dp,  61.91142197433249095_dp, &
         & -109.95470750710923369_dp,  58.42738157410047961_dp, &
         & -103.95825647893495614_dp,  54.77900423463843538_dp, &
         &  -98.68725830824647005_dp,  51.02562354013957702_dp, &
         &  -93.94726867835278483_dp,  47.20919167069192923_dp, &
         &  -89.59567144235911940_dp,  43.36062114047545890_dp, &
         &  -85.52649044264862255_dp,  39.50382677214758331_dp, &
         &  -81.65938939021744147_dp,  35.65830698143167155_dp, &
         &  -77.93201512996090230_dp,  31.84082402428231973_dp, &
         &  -74.29472888122153051_dp,  28.06652943785655552_dp, &
         &  -70.70698212428177953_dp,  24.34974403770184992_dp, &
         &  -67.13481958525987636_dp,  20.70451849248449960_dp, &
         &  -63.54916484650964748_dp,  17.14505004500527363_dp, &
         &  -59.92466443809041010_dp,  13.68599977255221845_dp, &
         &  -56.23894695811430466_dp,  10.34273467530950796_dp, &
         &  -52.47220691225792422_dp,   7.13150506907926562_dp, &
         &  -48.60705694133756083_dp,   4.06955754229703981_dp, &
         &  -44.62861191461713162_dp,   1.17517574056815022_dp, &
         &  -40.52477649322946007_dp,  -1.53236497867592791_dp, &
         &  -36.28670514160293692_dp,  -4.03294710811188395_dp, &
         &  -31.90939060170597941_dp,  -6.30588392466837799_dp, &
         &  -27.39231472226267883_dp,  -8.33033151194296018_dp, &
         &  -22.74006765897273752_dp, -10.08584610023314454_dp, &
         &  -17.96281473836326725_dp, -11.55307649365679623_dp, &
         &  -13.07647532339788832_dp, -12.71455858250937965_dp, &
         &   -8.10248720394762678_dp, -13.55555303790300137_dp, &
         &   -3.06707279862612925_dp, -14.06484423228424063_dp, &
         &    1.99999999999999600_dp, -19.59134287356426896_dp, &
         &    7.46002704385165138_dp, -19.40755726556070115_dp, &
         &   12.88033504279662367_dp, -18.85919797266866738_dp, &
         &   18.22391622121717347_dp, -17.95503295463869264_dp, &
         &   23.45879403720244127_dp, -16.70896594558295334_dp, &
         &   28.55966518490710015_dp, -15.13909773195327269_dp, &
         &   33.50874372060166451_dp, -13.26662598462660014_dp, &
         &   38.29585521437642370_dp, -11.11472732454917889_dp, &
         &   42.91794868987490474_dp,  -8.70753794849322738_dp, &
         &   47.37824652323212149_dp,  -6.06930752874207258_dp, &
         &   51.68524592294901510_dp,  -3.22375917751487107_dp, &
         &   55.85174332801063457_dp,  -0.19365520038940884_dp, &
         &   59.89399913408759346_dp,   2.99945241539763385_dp, &
         &   63.83111160507218784_dp,   6.33531713186757095_dp, &
         &   67.68463403089357655_dp,   9.79496963802120746_dp, &
         &   71.47845003929684538_dp,  13.36059248585088000_dp, &
         &   75.23891693218338617_dp,  17.01531594444593409_dp, &
         &   78.99529352424693229_dp,  20.74294398926493699_dp, &
         &   82.78048521884274180_dp,  24.52760876444716587_dp, &
         &   86.63216392910494790_dp,  28.35333972343855180_dp, &
         &   90.59435351833845118_dp,  32.20351875194761959_dp, &
         &   94.71961138434764393_dp,  36.06017287638244539_dp, &
         &   99.07197748871266185_dp,  39.90302877816822757_dp, &
         &  103.73088255981890882_dp,  43.70821480745370025_dp, &
         &  108.79614728017998004_dp,  47.44644408577498496_dp, &
         &  114.39390839554110357_dp,  51.08045112569507751_dp, &
         &  120.68240638414135901_dp,  54.56141374911145192_dp, &
         &  127.85428534979440940_dp,  57.82417470821775396_dp, &
         &  136.12712761110682891_dp,  60.78156430751474204_dp, &
         &  145.70578215046154469_dp,  63.31961305621511116_dp, &
         &  156.69437932769909594_dp,  65.29863962109097031_dp, &
         &  168.95645291666264143_dp,  66.56908368553207822_dp, &
         & -178.00000000000002842_dp,  67.00865712643570760_dp, &
         & -164.95645291666266985_dp,  66.56908368553207822_dp, &
         & -152.69437932769912436_dp,  65.29863962109097031_dp, &
         & -141.70578215046154469_dp,  63.31961305621511116_dp, &
         & -132.12712761110685733_dp,  60.78156430751474204_dp, &
         & -123.85428534979440940_dp,  57.82417470821775396_dp, &
         & -116.68240638414138743_dp,  54.56141374911145192_dp, &
         & -110.39390839554111778_dp,  51.08045112569507751_dp, &
         & -104.79614728017998004_dp,  47.44644408577498496_dp, &
         &  -99.73088255981890882_dp,  43.70821480745370025_dp, &
         &  -95.07197748871266185_dp,  39.90302877816822757_dp, &
         &  -90.71961138434764393_dp,  36.06017287638244539_dp, &
         &  -86.59435351833845118_dp,  32.20351875194761959_dp, &
         &  -82.63216392910496211_dp,  28.35333972343855180_dp, &
         &  -78.78048521884275601_dp,  24.52760876444716587_dp, &
         &  -74.99529352424694650_dp,  20.74294398926493699_dp, &
         &  -71.23891693218340038_dp,  17.01531594444593409_dp, &
         &  -67.47845003929684538_dp,  13.36059248585088000_dp, &
         &  -63.68463403089357655_dp,   9.79496963802120746_dp, &
         &  -59.83111160507219495_dp,   6.33531713186757095_dp, &
         &  -55.89399913408760057_dp,   2.99945241539763385_dp, &
         &  -51.85174332801064168_dp,  -0.19365520038940884_dp, &
         &  -47.68524592294902931_dp,  -3.22375917751487107_dp, &
         &  -43.37824652323212860_dp,  -6.06930752874207258_dp, &
         &  -38.91794868987490474_dp,  -8.70753794849322738_dp, &
         &  -34.29585521437643081_dp, -11.11472732454917889_dp, &
         &  -29.50874372060167872_dp, -13.26662598462660014_dp, &
         &  -24.55966518490711081_dp, -15.13909773195327269_dp, &
         &  -19.45879403720245193_dp, -16.70896594558295334_dp, &
         &  -14.22391622121718058_dp, -17.95503295463869264_dp, &
         &   -8.88033504279663255_dp, -18.85919797266866738_dp, &
         &   -3.46002704385166071_dp, -19.40755726556070115_dp, &
         &    1.99999999999999556_dp, -25.43837119820565817_dp, &
         &    7.91994134356474966_dp, -25.23910692117755517_dp, &
         &   13.78834011215970534_dp, -24.64516330804185529_dp, &
         &   19.55772615655293478_dp, -23.66774871950556403_dp, &
         &   25.18808138888132220_dp, -22.32448212182583092_dp, &
         &   30.64904852681420522_dp, -20.63801909702449677_dp, &
         &   35.92081946357622968_dp, -18.63449057116782726_dp, &
         &   40.99386004100856695_dp, -16.34197985921977292_dp, &
         &   45.86781613095838850_dp, -13.78920372951385431_dp, &
         &   50.54999441522539882_dp, -11.00448645615600007_dp, &
         &   55.05375641269628773_dp,  -8.01504773475606846_dp, &
         &   59.39706222812605318_dp,  -4.84657887125735343_dp, &
         &   63.60129716846514469_dp,  -1.52305829704237761_dp, &
         &   67.69043463465565935_dp,   1.93324784086672352_dp, &
         &   71.69053915995505122_dp,   5.50164833296652045_dp, &
         &   75.62959031828353318_dp,   9.16278970353470612_dp, &
         &   79.53760403336076479_dp,  12.89834287286321945_dp, &
         &   83.44703540885105042_dp,  16.69062430422997068_dp, &
         &   87.39346098727328638_dp,  20.52214967325533124_dp, &
         &   91.41655400532015108_dp,  24.37510563102819106_dp, &
         &   95.56137924921046078_dp,  28.23071203179445021_dp, &
         &   99.88003723653145016_dp,  32.06843215731343832_dp, &
         &  104.43366587620558050_dp,  35.86497163386139420_dp, &
         &  109.29473060869932510_dp,  39.59298941537671368_dp, &
         &  114.54933935400606515_dp,  43.21943287866469774_dp, &
         &  120.29889149413013172_dp,  46.70342202473147353_dp, &
         &  126.65952710171551132_dp,  49.99368843662634987_dp, &
         &  133.75638606304184464_dp,  53.02581189527145256_dp, &
         &  141.70772458687929429_dp,  55.72003625021812923_dp, &
         &  150.59283359977422379_dp,  57.98141283097308474_dp, &
         &  160.40162010671977555_dp,  59.70518607312001080_dp, &
         &  170.97884079028881388_dp,  60.79043532425958318_dp, &
         & -178.00000000000002842_dp,  61.16162880179432193_dp, &
         & -166.97884079028878546_dp,  60.79043532425958318_dp, &
         & -156.40162010671977555_dp,  59.70518607312001080_dp, &
         & -146.59283359977425221_dp,  57.98141283097308474_dp, &
         & -137.70772458687926587_dp,  55.72003625021812923_dp, &
         & -129.75638606304184464_dp,  53.02581189527145256_dp, &
         & -122.65952710171549711_dp,  49.99368843662634987_dp, &
         & -116.29889149413011751_dp,  46.70342202473147353_dp, &
         & -110.54933935400606515_dp,  43.21943287866469774_dp, &
         & -105.29473060869931089_dp,  39.59298941537671368_dp, &
         & -100.43366587620559471_dp,  35.86497163386139420_dp, &
         &  -95.88003723653146437_dp,  32.06843215731343832_dp, &
         &  -91.56137924921046078_dp,  28.23071203179445021_dp, &
         &  -87.41655400532016529_dp,  24.37510563102819106_dp, &
         &  -83.39346098727328638_dp,  20.52214967325533124_dp, &
         &  -79.44703540885105042_dp,  16.69062430422997068_dp, &
         &  -75.53760403336077900_dp,  12.89834287286321945_dp, &
         &  -71.62959031828354739_dp,   9.16278970353470612_dp, &
         &  -67.69053915995506543_dp,   5.50164833296652045_dp, &
         &  -63.69043463465567356_dp,   1.93324784086672352_dp, &
         &  -59.60129716846515180_dp,  -1.52305829704237761_dp, &
         &  -55.39706222812606740_dp,  -4.84657887125735343_dp, &
         &  -51.05375641269629483_dp,  -8.01504773475606846_dp, &
         &  -46.54999441522540593_dp, -11.00448645615600007_dp, &
         &  -41.86781613095839560_dp, -13.78920372951385431_dp, &
         &  -36.99386004100857406_dp, -16.34197985921977292_dp, &
         &  -31.92081946357624389_dp, -18.63449057116782726_dp, &
         &  -26.64904852681421943_dp, -20.63801909702449677_dp, &
         &  -21.18808138888132575_dp, -22.32448212182583092_dp, &
         &  -15.55772615655294011_dp, -23.66774871950556403_dp, &
         &   -9.78834011215971245_dp, -24.64516330804185529_dp, &
         &   -3.91994134356475854_dp, -25.23910692117755517_dp, &
         &    1.99999999999999600_dp, -31.84350531560286868_dp, &
         &    8.47781225763252877_dp, -31.62546289221583962_dp, &
         &   14.88583393507996711_dp, -30.97645080660140593_dp, &
         &   21.16079514785619509_dp, -29.91127029421520689_dp, &
         &   27.25113130544622919_dp, -28.45290874783366775_dp, &
         &   33.11998552133064067_dp, -26.63042818683534207_dp, &
         &   38.74589265732009835_dp, -24.47666503668304117_dp, &
         &   44.12160159745183563_dp, -22.02610835172851722_dp, &
         &   49.25177543408178593_dp, -19.31318879069118211_dp, &
         &   54.15029168417838434_dp, -16.37106576006627279_dp, &
         &   58.83767345094592827_dp, -13.23089104518995640_dp, &
         &   63.33895182482493169_dp,  -9.92146778444056032_dp, &
         &   67.68207179147748320_dp,  -6.46920580966549874_dp, &
         &   71.89683474738467339_dp,  -2.89828246890513030_dp, &
         &   76.01431282527251199_dp,   0.76906207426874740_dp, &
         &   80.06665407661380129_dp,   4.51214364124032485_dp, &
         &   84.08720437104130951_dp,   8.31139512800513636_dp, &
         &   88.11088800598805904_dp,  12.14788119395578647_dp, &
         &   92.17480572169650088_dp,  16.00276430383186366_dp, &
         &   96.31902021078285259_dp,  19.85670886149115333_dp, &
         &  100.58749981932022877_dp,  23.68920100972959730_dp, &
         &  105.02917319698201482_dp,  27.47775433026597725_dp, &
         &  109.69899804029304846_dp,  31.19696754875727152_dp, &
         &  114.65884380836618561_dp,  34.81740352705595143_dp, &
         &  119.97779813807069615_dp,  38.30427835916992052_dp, &
         &  125.73118977168117283_dp,  41.61600262291977259_dp, &
         &  131.99715883033749719_dp,  44.70273256173389598_dp, &
         &  138.84908760812987794_dp,  47.50530446205828383_dp, &
         &  146.34201331309026273_dp,  49.95526128262041254_dp, &
         &  154.49218436749947614_dp,  51.97706503648645082_dp, &
         &  163.25249258416440057_dp,  53.49372597518600259_dp, &
         &  172.49285933765111167_dp,  54.43639475342744305_dp, &
         & -178.00000000000002842_dp,  54.75649468439711143_dp, &
         & -168.49285933765114009_dp,  54.43639475342744305_dp, &
         & -159.25249258416440057_dp,  53.49372597518600259_dp, &
         & -150.49218436749950456_dp,  51.97706503648645082_dp, &
         & -142.34201331309029115_dp,  49.95526128262041254_dp, &
         & -134.84908760812987794_dp,  47.50530446205828383_dp, &
         & -127.99715883033752561_dp,  44.70273256173389598_dp, &
         & -121.73118977168118704_dp,  41.61600262291977259_dp, &
         & -115.97779813807071037_dp,  38.30427835916992052_dp, &
         & -110.65884380836619982_dp,  34.81740352705595143_dp, &
         & -105.69899804029306267_dp,  31.19696754875727152_dp, &
         & -101.02917319698202903_dp,  27.47775433026597725_dp, &
         &  -96.58749981932022877_dp,  23.68920100972959730_dp, &
         &  -92.31902021078286680_dp,  19.85670886149115333_dp, &
         &  -88.17480572169651509_dp,  16.00276430383186366_dp, &
         &  -84.11088800598805904_dp,  12.14788119395578647_dp, &
         &  -80.08720437104132372_dp,   8.31139512800513636_dp, &
         &  -76.06665407661381550_dp,   4.51214364124032485_dp, &
         &  -72.01431282527251199_dp,   0.76906207426874740_dp, &
         &  -67.89683474738467339_dp,  -2.89828246890513030_dp, &
         &  -63.68207179147749031_dp,  -6.46920580966549874_dp, &
         &  -59.33895182482493880_dp,  -9.92146778444056032_dp, &
         &  -54.83767345094592827_dp, -13.23089104518995640_dp, &
         &  -50.15029168417838434_dp, -16.37106576006627279_dp, &
         &  -45.25177543408179304_dp, -19.31318879069118211_dp, &
         &  -40.12160159745184274_dp, -22.02610835172851722_dp, &
         &  -34.74589265732009835_dp, -24.47666503668304117_dp, &
         &  -29.11998552133064422_dp, -26.63042818683534207_dp, &
         &  -23.25113130544624340_dp, -28.45290874783366775_dp, &
         &  -17.16079514785620930_dp, -29.91127029421520689_dp, &
         &  -10.88583393507997776_dp, -30.97645080660140593_dp, &
         &   -4.47781225763253765_dp, -31.62546289221583962_dp, &
         &    1.99999999999999556_dp, -38.87875527701606160_dp, &
         &    9.18708125479774296_dp, -38.63683300066042392_dp, &
         &   16.27414365511956262_dp, -37.91820250638208734_dp, &
         &   23.17259140539264095_dp, -36.74332279213027164_dp, &
         &   29.81377244810832394_dp, -35.14341202945125531_dp, &
         &   36.15298964123235947_dp, -33.15698491696964822_dp, &
         &   42.16912769952225659_dp, -30.82630445836842625_dp, &
         &   47.86123932751760179_dp, -28.19436585459229860_dp, &
         &   53.24376548995357439_dp, -25.30271165018388402_dp, &
         &   58.34173321358173325_dp, -22.19009961204914561_dp, &
         &   63.18670666190918439_dp, -18.89188184637555779_dp, &
         &   67.81377209114522486_dp, -15.43989911427395079_dp, &
         &   72.25952713288313589_dp, -11.86270778471484277_dp, &
         &   76.56090370117536281_dp,  -8.18599910867232694_dp, &
         &   80.75462189677602964_dp,  -4.43311662588922584_dp, &
         &   84.87709425893895343_dp,  -0.62561625366165385_dp, &
         &   88.96463936229967828_dp,   3.21615784383777248_dp, &
         &   93.05390189983984328_dp,   7.07248905242842518_dp, &
         &   97.18240447461120368_dp,  10.92369066480776318_dp, &
         &  101.38917071735671982_dp,  14.74948212031801020_dp, &
         &  105.71535755141637480_dp,  18.52832281285148497_dp, &
         &  110.20481280215611264_dp,  22.23668760419472790_dp, &
         &  114.90442707083992957_dp,  25.84827445710250160_dp, &
         &  119.86406835852177721_dp,  29.33315055785289260_dp, &
         &  125.13576891124590418_dp,  32.65687547770472321_dp, &
         &  130.77168357131759535_dp,  35.77969749489390949_dp, &
         &  136.82020109922683559_dp,  38.65601141858346068_dp, &
         &  143.31958252044233859_dp,  41.23439386179803279_dp, &
         &  150.28885177460347222_dp,  43.45866798082070659_dp, &
         &  157.71667350566602295_dp,  45.27051130755705799_dp, &
         &  165.55074086228117380_dp,  46.61395503653132977_dp, &
         &  173.69217969866488716_dp,  47.44157216781382402_dp, &
         & -178.00000000000002842_dp,  47.72124472298391851_dp, &
         & -169.69217969866491558_dp,  47.44157216781382402_dp, &
         & -161.55074086228117380_dp,  46.61395503653132977_dp, &
         & -153.71667350566602295_dp,  45.27051130755705799_dp, &
         & -146.28885177460344380_dp,  43.45866798082070659_dp, &
         & -139.31958252044236701_dp,  41.23439386179803279_dp, &
         & -132.82020109922686402_dp,  38.65601141858346068_dp, &
         & -126.77168357131760956_dp,  35.77969749489390949_dp, &
         & -121.13576891124588997_dp,  32.65687547770472321_dp, &
         & -115.86406835852179142_dp,  29.33315055785289260_dp, &
         & -110.90442707083994378_dp,  25.84827445710250160_dp, &
         & -106.20481280215612685_dp,  22.23668760419472790_dp, &
         & -101.71535755141638901_dp,  18.52832281285148497_dp, &
         &  -97.38917071735673403_dp,  14.74948212031801020_dp, &
         &  -93.18240447461121789_dp,  10.92369066480776318_dp, &
         &  -89.05390189983984328_dp,   7.07248905242842518_dp, &
         &  -84.96463936229969249_dp,   3.21615784383777248_dp, &
         &  -80.87709425893895343_dp,  -0.62561625366165385_dp, &
         &  -76.75462189677602964_dp,  -4.43311662588922584_dp, &
         &  -72.56090370117536281_dp,  -8.18599910867232694_dp, &
         &  -68.25952713288315010_dp, -11.86270778471484277_dp, &
         &  -63.81377209114523907_dp, -15.43989911427395079_dp, &
         &  -59.18670666190919150_dp, -18.89188184637555779_dp, &
         &  -54.34173321358174746_dp, -22.19009961204914561_dp, &
         &  -49.24376548995358149_dp, -25.30271165018388402_dp, &
         &  -43.86123932751760890_dp, -28.19436585459229860_dp, &
         &  -38.16912769952225659_dp, -30.82630445836842625_dp, &
         &  -32.15298964123236658_dp, -33.15698491696964822_dp, &
         &  -25.81377244810833815_dp, -35.14341202945125531_dp, &
         &  -19.17259140539265516_dp, -36.74332279213027164_dp, &
         &  -12.27414365511956973_dp, -37.91820250638208734_dp, &
         &   -5.18708125479775184_dp, -38.63683300066042392_dp, &
         &    1.99999999999999600_dp, -46.61822072475269607_dp, &
         &   10.68839576675080139_dp, -46.30624543028367412_dp, &
         &   19.18911080317679918_dp, -45.38412606933155757_dp, &
         &   27.34546416576215222_dp, -43.89055765093645078_dp, &
         &   35.05142021090807702_dp, -41.88213387768103502_dp, &
         &   42.25559890256131013_dp, -39.42480136235260346_dp, &
         &   48.95316063861176303_dp, -36.58631299796493153_dp, &
         &   55.17233704527057370_dp, -33.43100825355479344_dp, &
         &   60.96117255247643385_dp, -30.01702215459737744_dp, &
         &   66.37723925505210332_dp, -26.39536140379773599_dp, &
         &   71.48085419487965453_dp, -22.61014977269736548_dp, &
         &   76.33122188826865795_dp, -18.69947873486282575_dp, &
         &   80.98463901984250413_dp, -14.69649678201448850_dp, &
         &   85.49400025392819202_dp, -10.63053585607601548_dp, &
         &   89.90905356028720519_dp,  -6.52818370181667884_dp, &
         &   94.27704477012913742_dp,  -2.41427530523583922_dp, &
         &   98.64352777118510573_dp,   1.68719008387413583_dp, &
         &  103.05319914949195947_dp,   5.75218534812640314_dp, &
         &  107.55065416712271542_dp,   9.75582109859903390_dp, &
         &  112.18096363521173942_dp,  13.67152082594358298_dp, &
         &  116.98994385952536845_dp,  17.47019805768939449_dp, &
         &  122.02393786261990272_dp,  21.11944988981388605_dp, &
         &  127.32885205682140395_dp,  24.58281725765701253_dp, &
         &  132.94811747553873715_dp,  27.81921722445741807_dp, &
         &  138.91921485966395267_dp,  30.78272820361294038_dp, &
         &  145.26850797118672176_dp,  33.42299645292871446_dp, &
         &  152.00450116657361832_dp,  35.68659928106228563_dp, &
         &  159.11038900941949237_dp,  37.51968052984662449_dp, &
         &  166.53782868216146085_dp,  38.87197455633482690_dp, &
         &  174.20476659278793363_dp,  39.70189618399167131_dp, &
         & -178.00000000000002842_dp,  39.98177927524729114_dp, &
         & -170.20476659278793363_dp,  39.70189618399167131_dp, &
         & -162.53782868216148927_dp,  38.87197455633482690_dp, &
         & -155.11038900941949237_dp,  37.51968052984662449_dp, &
         & -148.00450116657361832_dp,  35.68659928106228563_dp, &
         & -141.26850797118672176_dp,  33.42299645292871446_dp, &
         & -134.91921485966395267_dp,  30.78272820361294038_dp, &
         & -128.94811747553873715_dp,  27.81921722445741807_dp, &
         & -123.32885205682140395_dp,  24.58281725765701253_dp, &
         & -118.02393786261990272_dp,  21.11944988981388605_dp, &
         & -112.98994385952538266_dp,  17.47019805768939449_dp, &
         & -108.18096363521175363_dp,  13.67152082594358298_dp, &
         & -103.55065416712271542_dp,   9.75582109859903390_dp, &
         &  -99.05319914949195947_dp,   5.75218534812640314_dp, &
         &  -94.64352777118511995_dp,   1.68719008387413583_dp, &
         &  -90.27704477012913742_dp,  -2.41427530523583922_dp, &
         &  -85.90905356028720519_dp,  -6.52818370181667884_dp, &
         &  -81.49400025392820623_dp, -10.63053585607601548_dp, &
         &  -76.98463901984250413_dp, -14.69649678201448850_dp, &
         &  -72.33122188826867216_dp, -18.69947873486282575_dp, &
         &  -67.48085419487966874_dp, -22.61014977269736548_dp, &
         &  -62.37723925505212463_dp, -26.39536140379773599_dp, &
         &  -56.96117255247644096_dp, -30.01702215459737744_dp, &
         &  -51.17233704527057370_dp, -33.43100825355479344_dp, &
         &  -44.95316063861176303_dp, -36.58631299796493153_dp, &
         &  -38.25559890256131723_dp, -39.42480136235260346_dp, &
         &  -31.05142021090808413_dp, -41.88213387768103502_dp, &
         &  -23.34546416576216643_dp, -43.89055765093645078_dp, &
         &  -15.18911080317680451_dp, -45.38412606933155757_dp, &
         &   -6.68839576675080849_dp, -46.30624543028367412_dp, &
         &    1.99999999999999556_dp, -55.13279625041899834_dp, &
         &   12.21451927262477000_dp, -54.76594013073760436_dp, &
         &   22.09872704828332957_dp, -53.68864395349499574_dp, &
         &   31.39769711559288012_dp, -51.96422430511800883_dp, &
         &   39.96960367385942448_dp, -49.68040408706254141_dp, &
         &   47.77902429867568657_dp, -46.93247902115530223_dp, &
         &   54.86545369174167064_dp, -43.81109166541020983_dp, &
         &   61.30916699148811233_dp, -40.39598469592146301_dp, &
         &   67.20576633421555357_dp, -36.75430974219705860_dp, &
         &   72.65107920217620574_dp, -32.94148403257256064_dp, &
         &   77.73388667252179118_dp, -29.00309226896920123_dp, &
         &   82.53343020155088539_dp, -24.97699141478170048_dp, &
         &   87.11942634360052296_dp, -20.89524495725207132_dp, &
         &   91.55320457280680557_dp, -16.78577161643180204_dp, &
         &   95.88921878897831164_dp, -12.67371220268469578_dp, &
         &  100.17656220612792595_dp,  -8.58256192749418645_dp, &
         &  104.46031614728221371_dp,  -4.53512373056416251_dp, &
         &  108.78265670493264849_dp,  -0.55433148808729282_dp, &
         &  113.18367588372132104_dp,   3.33602075627005812_dp, &
         &  117.70187269530691765_dp,   7.11062322287716331_dp, &
         &  122.37425008640165913_dp,  10.74206713847307348_dp, &
         &  127.23592626204656142_dp,  14.20035582641498806_dp, &
         &  132.31914580979304219_dp,  17.45256126555711873_dp, &
         &  137.65157520973264127_dp,  20.46271167815037728_dp, &
         &  143.25381666270027381_dp,  23.19203115841211726_dp, &
         &  149.13620894054645305_dp,  25.59967735271198208_dp, &
         &  155.29523174265207786_dp,  27.64411687523928052_dp, &
         &  161.71017626763577368_dp,  29.28521267182223298_dp, &
         &  168.34108626834759548_dp,  30.48695101230148552_dp, &
         &  175.12910064316457692_dp,  31.22051723140710777_dp, &
         & -178.00000000000002842_dp,  31.46720374958099598_dp, &
         & -171.12910064316457692_dp,  31.22051723140710777_dp, &
         & -164.34108626834762390_dp,  30.48695101230148552_dp, &
         & -157.71017626763574526_dp,  29.28521267182223298_dp, &
         & -151.29523174265207786_dp,  27.64411687523928052_dp, &
         & -145.13620894054648147_dp,  25.59967735271198208_dp, &
         & -139.25381666270027381_dp,  23.19203115841211726_dp, &
         & -133.65157520973266969_dp,  20.46271167815037728_dp, &
         & -128.31914580979304219_dp,  17.45256126555711873_dp, &
         & -123.23592626204654721_dp,  14.20035582641498806_dp, &
         & -118.37425008640165913_dp,  10.74206713847307348_dp, &
         & -113.70187269530693186_dp,   7.11062322287716331_dp, &
         & -109.18367588372132104_dp,   3.33602075627005812_dp, &
         & -104.78265670493266271_dp,  -0.55433148808729282_dp, &
         & -100.46031614728222792_dp,  -4.53512373056416251_dp, &
         &  -96.17656220612794016_dp,  -8.58256192749418645_dp, &
         &  -91.88921878897831164_dp, -12.67371220268469578_dp, &
         &  -87.55320457280681978_dp, -16.78577161643180204_dp, &
         &  -83.11942634360052296_dp, -20.89524495725207132_dp, &
         &  -78.53343020155088539_dp, -24.97699141478170048_dp, &
         &  -73.73388667252179118_dp, -29.00309226896920123_dp, &
         &  -68.65107920217620574_dp, -32.94148403257256064_dp, &
         &  -63.20576633421556068_dp, -36.75430974219705860_dp, &
         &  -57.30916699148811233_dp, -40.39598469592146301_dp, &
         &  -50.86545369174167774_dp, -43.81109166541020983_dp, &
         &  -43.77902429867569367_dp, -46.93247902115530223_dp, &
         &  -35.96960367385943158_dp, -49.68040408706254141_dp, &
         &  -27.39769711559288723_dp, -51.96422430511800883_dp, &
         &  -18.09872704828334022_dp, -53.68864395349499574_dp, &
         &   -8.21451927262477888_dp, -54.76594013073760436_dp, &
         &    1.99999999999999556_dp, -64.48162218246979194_dp, &
         &   17.98037118830460201_dp, -63.76341508305665684_dp, &
         &   32.62428016143745424_dp, -61.72174914658255318_dp, &
         &   45.26325159838053480_dp, -58.62403790832021144_dp, &
         &   55.90710322947827393_dp, -54.76300160634040992_dp, &
         &   64.89227178252910733_dp, -50.38082342875218700_dp, &
         &   72.61131289029847835_dp, -45.65520975111467550_dp, &
         &   79.40370496549049051_dp, -40.71192873614232610_dp, &
         &   85.53547443418635510_dp, -35.64102404029981841_dp, &
         &   91.20945067766287195_dp, -30.50961194071436822_dp, &
         &   96.58116190590757810_dp, -25.37072818781791383_dp, &
         &  101.77265218881962028_dp, -20.26925377022463337_dp, &
         &  106.88281945262124850_dp, -15.24594064653214254_dp, &
         &  111.99465974304708027_dp, -10.34025377357217934_dp, &
         &  117.18006743498143862_dp,  -5.59247248797413388_dp, &
         &  122.50268451884780063_dp,  -1.04529436283411115_dp, &
         &  128.01906809075350679_dp,   3.25496397729521814_dp, &
         &  133.77826339847268855_dp,   7.25759760165333567_dp, &
         &  139.81978239976487544_dp,  10.90731557455581502_dp, &
         &  146.17005258660478262_dp,  14.14485028302005709_dp, &
         &  152.83768595785250000_dp,  16.90865838596959492_dp, &
         &  159.80845268931921055_dp,  19.13794220572577487_dp, &
         &  167.04151372648448159_dp,  20.77699151155475477_dp, &
         &  174.46891148411387462_dp,  21.78042227826199806_dp, &
         & -178.00000000000002842_dp,  22.11837781753019527_dp, &
         & -170.46891148411387462_dp,  21.78042227826199806_dp, &
         & -163.04151372648448159_dp,  20.77699151155475477_dp, &
         & -155.80845268931921055_dp,  19.13794220572577487_dp, &
         & -148.83768595785252842_dp,  16.90865838596959492_dp, &
         & -142.17005258660481104_dp,  14.14485028302005709_dp, &
         & -135.81978239976487544_dp,  10.90731557455581502_dp, &
         & -129.77826339847271697_dp,   7.25759760165333567_dp, &
         & -124.01906809075352101_dp,   3.25496397729521814_dp, &
         & -118.50268451884778642_dp,  -1.04529436283411115_dp, &
         & -113.18006743498142441_dp,  -5.59247248797413388_dp, &
         & -107.99465974304709448_dp, -10.34025377357217934_dp, &
         & -102.88281945262124850_dp, -15.24594064653214254_dp, &
         &  -97.77265218881962028_dp, -20.26925377022463337_dp, &
         &  -92.58116190590757810_dp, -25.37072818781791383_dp, &
         &  -87.20945067766288616_dp, -30.50961194071436822_dp, &
         &  -81.53547443418635510_dp, -35.64102404029981841_dp, &
         &  -75.40370496549049051_dp, -40.71192873614232610_dp, &
         &  -68.61131289029849256_dp, -45.65520975111467550_dp, &
         &  -60.89227178252910733_dp, -50.38082342875218700_dp, &
         &  -51.90710322947828104_dp, -54.76300160634040992_dp, &
         &  -41.26325159838054901_dp, -58.62403790832021144_dp, &
         &  -28.62428016143746490_dp, -61.72174914658255318_dp, &
         &  -13.98037118830460557_dp, -63.76341508305665684_dp, &
         &    1.99999999999999489_dp, -74.69966643845165777_dp, &
         &   26.73698176730493614_dp, -73.50791820369254026_dp, &
         &   46.45208209886830275_dp, -70.36956689494368788_dp, &
         &   60.80977159628141493_dp, -66.05660901455554779_dp, &
         &   71.45848324441054444_dp, -61.11675773175377913_dp, &
         &   79.80759217874309286_dp, -55.85321872580696834_dp, &
         &   86.74466514239207982_dp, -50.43213273346431436_dp, &
         &   92.80540124701705906_dp, -44.95206516381727369_dp, &
         &   98.32251211109890221_dp, -39.47845092120540045_dp, &
         &  103.51336526710929320_dp, -34.06038011063251503_dp, &
         &  108.52834753231333309_dp, -28.73921107936183361_dp, &
         &  113.47768355265095863_dp, -23.55333544230752452_dp, &
         &  118.44656525084906207_dp, -18.54103902309049090_dp, &
         &  123.50369215326308847_dp, -13.74234202233444968_dp, &
         &  128.70582948829564884_dp,  -9.20020460514958671_dp, &
         &  134.09971622507504208_dp,  -4.96122571165357140_dp, &
         &  139.72202213508867885_dp,  -1.07580930674149267_dp, &
         &  145.59779383610683112_dp,   2.40232548413760538_dp, &
         &  151.73783261271663036_dp,   5.41746050329454931_dp, &
         &  158.13565186637288207_dp,   7.91416414131925894_dp, &
         &  164.76497871932286898_dp,   9.84055665005913660_dp, &
         &  171.57900980622665088_dp,  11.15231427016150256_dp, &
         &  178.51254101195692670_dp,  11.81685015330946520_dp, &
         & -174.51254101195692670_dp,  11.81685015330946520_dp, &
         & -167.57900980622667930_dp,  11.15231427016150256_dp, &
         & -160.76497871932289740_dp,   9.84055665005913660_dp, &
         & -154.13565186637291049_dp,   7.91416414131925894_dp, &
         & -147.73783261271665879_dp,   5.41746050329454931_dp, &
         & -141.59779383610683112_dp,   2.40232548413760538_dp, &
         & -135.72202213508870727_dp,  -1.07580930674149267_dp, &
         & -130.09971622507501365_dp,  -4.96122571165357140_dp, &
         & -124.70582948829567727_dp,  -9.20020460514958671_dp, &
         & -119.50369215326308847_dp, -13.74234202233444968_dp, &
         & -114.44656525084907628_dp, -18.54103902309049090_dp, &
         & -109.47768355265095863_dp, -23.55333544230752452_dp, &
         & -104.52834753231334730_dp, -28.73921107936183361_dp, &
         &  -99.51336526710929320_dp, -34.06038011063251503_dp, &
         &  -94.32251211109890221_dp, -39.47845092120540045_dp, &
         &  -88.80540124701705906_dp, -44.95206516381727369_dp, &
         &  -82.74466514239209403_dp, -50.43213273346431436_dp, &
         &  -75.80759217874310707_dp, -55.85321872580696834_dp, &
         &  -67.45848324441054444_dp, -61.11675773175377913_dp, &
         &  -56.80977159628143625_dp, -66.05660901455554779_dp, &
         &  -42.45208209886832407_dp, -70.36956689494368788_dp, &
         &  -22.73698176730495391_dp, -73.50791820369254026_dp, &
         &    1.99999999999999600_dp, -85.78166687108885924_dp, &
         &   61.87324357773108119_dp, -82.33459525449173100_dp, &
         &   80.27768438369075454_dp, -76.54083121758115738_dp, &
         &   89.42499621356618889_dp, -70.41813086842684299_dp, &
         &   95.82057104813959825_dp, -64.24948773689966686_dp, &
         &  101.11263541171206271_dp, -58.11928872485961506_dp, &
         &  105.90317607822892398_dp, -52.07335345715245722_dp, &
         &  110.47134737780878311_dp, -46.14758359783259323_dp, &
         &  114.97138028465980142_dp, -40.37601690822956613_dp, &
         &  119.50120511177952665_dp, -34.79395188944583595_dp, &
         &  124.13018318901127657_dp, -29.43951176908901957_dp, &
         &  128.91129483912590104_dp, -24.35455549606792047_dp, &
         &  133.88641650799124250_dp, -19.58517424494497305_dp, &
         &  139.08801440266989857_dp, -15.18177122287804615_dp, &
         &  144.53869867413172301_dp, -11.19861017149900739_dp, &
         &  150.24942513902280439_dp,  -7.69266569608215622_dp, &
         &  156.21700460768090579_dp,  -4.72161659803606781_dp, &
         &  162.42170502724644621_dp,  -2.34091526057735644_dp, &
         &  168.82591385569978115_dp,  -0.60006016949341945_dp, &
         &  175.37485237931247184_dp,   0.46152536384328491_dp, &
         & -178.00000000000002842_dp,   0.81833312891115950_dp, &
         & -171.37485237931247184_dp,   0.46152536384328491_dp, &
         & -164.82591385569978115_dp,  -0.60006016949341945_dp, &
         & -158.42170502724641779_dp,  -2.34091526057735644_dp, &
         & -152.21700460768090579_dp,  -4.72161659803606781_dp, &
         & -146.24942513902283281_dp,  -7.69266569608215622_dp, &
         & -140.53869867413175143_dp, -11.19861017149900739_dp, &
         & -135.08801440266989857_dp, -15.18177122287804615_dp, &
         & -129.88641650799127092_dp, -19.58517424494497305_dp, &
         & -124.91129483912591525_dp, -24.35455549606792047_dp, &
         & -120.13018318901130499_dp, -29.43951176908901957_dp, &
         & -115.50120511177955507_dp, -34.79395188944583595_dp, &
         & -110.97138028465980142_dp, -40.37601690822956613_dp, &
         & -106.47134737780881153_dp, -46.14758359783259323_dp, &
         & -101.90317607822893820_dp, -52.07335345715245722_dp, &
         &  -97.11263541171207692_dp, -58.11928872485961506_dp, &
         &  -91.82057104813961246_dp, -64.24948773689966686_dp, &
         &  -85.42499621356618889_dp, -70.41813086842684299_dp, &
         &  -76.27768438369074033_dp, -76.54083121758115738_dp, &
         &  -57.87324357773110250_dp, -82.33459525449173100_dp, &
         & -178.00000000000002842_dp, -82.33591847955618448_dp, &
         &  143.22778135121401988_dp, -79.54230031515010069_dp, &
         &  128.60898756414843547_dp, -73.87349687490876704_dp, &
         &  124.32470998353319658_dp, -67.47696540683871547_dp, &
         &  124.01228809564837263_dp, -60.93070105520797597_dp, &
         &  125.59604777627561134_dp, -54.43751136022503090_dp, &
         &  128.28024682035200499_dp, -48.10755262562803125_dp, &
         &  131.71480673751509016_dp, -42.02394287044850074_dp, &
         &  135.73150447900647464_dp, -36.26259289105208694_dp, &
         &  140.24424010430539056_dp, -30.89942669541638764_dp, &
         &  145.20455296082769792_dp, -26.01294410398721979_dp, &
         &  150.57821873782722832_dp, -21.68429473238734317_dp, &
         &  156.33085313434582986_dp, -17.99542592709287092_dp, &
         &  162.41822389716838870_dp, -15.02545489467462048_dp, &
         &  168.78020742076520833_dp, -12.84550987892848184_dp, &
         &  175.33870321353637678_dp, -11.51266748991093536_dp, &
         & -178.00000000000002842_dp, -11.06408152044378745_dp, &
         & -171.33870321353637678_dp, -11.51266748991093536_dp, &
         & -164.78020742076523675_dp, -12.84550987892848184_dp, &
         & -158.41822389716841712_dp, -15.02545489467462048_dp, &
         & -152.33085313434585828_dp, -17.99542592709287092_dp, &
         & -146.57821873782722832_dp, -21.68429473238734317_dp, &
         & -141.20455296082769792_dp, -26.01294410398721979_dp, &
         & -136.24424010430539056_dp, -30.89942669541638764_dp, &
         & -131.73150447900647464_dp, -36.26259289105208694_dp, &
         & -127.71480673751507595_dp, -42.02394287044850074_dp, &
         & -124.28024682035203341_dp, -48.10755262562803125_dp, &
         & -121.59604777627559713_dp, -54.43751136022503090_dp, &
         & -120.01228809564838684_dp, -60.93070105520797597_dp, &
         & -120.32470998353322500_dp, -67.47696540683871547_dp, &
         & -124.60898756414846389_dp, -73.87349687490876704_dp, &
         & -139.22778135121404830_dp, -79.54230031515010069_dp, &
         & -178.00000000000002842_dp, -69.79343463141964321_dp, &
         &  167.63134400963940607_dp, -68.62304968612301082_dp, &
         &  156.89871695437406629_dp, -65.48334135458465255_dp, &
         &  150.54736374030309776_dp, -61.10651485448561715_dp, &
         &  147.65287319536125210_dp, -56.10790502157546911_dp, &
         &  147.17953110490091717_dp, -50.89570090116846757_dp, &
         &  148.39568884343808008_dp, -45.73876083396746139_dp, &
         &  150.83543074335267420_dp, -40.82969132012996027_dp, &
         &  154.20166627754437627_dp, -36.32066069380964279_dp, &
         &  158.29374271187359113_dp, -32.34078423455542861_dp, &
         &  162.96127389198957758_dp, -29.00296899656860816_dp, &
         &  168.07572003197756771_dp, -26.40464312032804983_dp, &
         &  173.51374580520655400_dp, -24.62495078480371546_dp, &
         &  179.14909640850049755_dp, -23.72034636702055366_dp, &
         & -175.14909640850046912_dp, -23.72034636702055366_dp, &
         & -169.51374580520655400_dp, -24.62495078480371546_dp, &
         & -164.07572003197756771_dp, -26.40464312032806049_dp, &
         & -158.96127389198957758_dp, -29.00296899656861527_dp, &
         & -154.29374271187361956_dp, -32.34078423455542861_dp, &
         & -150.20166627754440469_dp, -36.32066069380964279_dp, &
         & -146.83543074335270262_dp, -40.82969132012996027_dp, &
         & -144.39568884343808008_dp, -45.73876083396746139_dp, &
         & -143.17953110490091717_dp, -50.89570090116849599_dp, &
         & -143.65287319536128052_dp, -56.10790502157547621_dp, &
         & -146.54736374030309776_dp, -61.10651485448561715_dp, &
         & -152.89871695437406629_dp, -65.48334135458465255_dp, &
         & -163.63134400963940607_dp, -68.62304968612301082_dp, &
         & -178.00000000000002842_dp, -56.85258712078380228_dp, &
         &  176.37525674045562596_dp, -56.23764348052387874_dp, &
         &  171.72066876086481102_dp, -54.50623527875517738_dp, &
         &  168.62326642581021474_dp, -51.94637057143930292_dp, &
         &  167.22080918295719698_dp, -48.91487419033276751_dp, &
         &  167.36621335583259906_dp, -45.75617589753742465_dp, &
         &  168.79950790329058918_dp, -42.76713193279059766_dp, &
         &  171.24101930549505823_dp, -40.18968456371464271_dp, &
         &  174.42266827604018431_dp, -38.21219158951615213_dp, &
         &  178.09065200901943626_dp, -36.97055608025468132_dp, &
         & -178.00000000000002842_dp, -36.54741287921620341_dp, &
         & -174.09065200901946469_dp, -36.97055608025468132_dp, &
         & -170.42266827604018431_dp, -38.21219158951615213_dp, &
         & -167.24101930549508666_dp, -40.18968456371464271_dp, &
         & -164.79950790329061761_dp, -42.76713193279059766_dp, &
         & -163.36621335583262749_dp, -45.75617589753742465_dp, &
         & -163.22080918295719698_dp, -48.91487419033276751_dp, &
         & -164.62326642581024316_dp, -51.94637057143930292_dp, &
         & -167.72066876086483944_dp, -54.50623527875517738_dp, &
         & -172.37525674045562596_dp, -56.23764348052387874_dp  ]

  grid = atlas_ReducedGaussianGrid(nx, projection=atlas_RotatedSchmidtProjection(stretch,centre,angle) )

  jglo = 0
  do j = 1, grid%ny()
    do i = 1, grid%nx(j)
      FCTEST_CHECK_CLOSE( grid%lonlat(i,j), ([lonlat(2*jglo+1),lonlat(2*jglo+2)]), 1.e-9_dp );
      jglo = jglo + 1
    enddo
  enddo

  bounding_box = grid%lonlat_bounding_box()
  FCTEST_CHECK_CLOSE( bounding_box%west(),    0._dp, 1.e-10_dp )
  FCTEST_CHECK_CLOSE( bounding_box%east(),  360._dp, 1.e-10_dp )
  FCTEST_CHECK_CLOSE( bounding_box%south(), -90._dp, 1.e-10_dp )
  FCTEST_CHECK_CLOSE( bounding_box%north(),  90._dp, 1.e-10_dp )

  call bounding_box%final()
  call grid%final()
END_TEST

! -----------------------------------------------------------------------------

END_TESTSUITE
