The MDAnalysis *Code of Conduct* sets the rules for the behavior of
every member in the MDAnalysis community so that everyone can
experience a welcoming, supportive, and productive environment that is
free from harassment. As a [NumFOCUS][NF] sponsored
project, MDAnalysis follows the [NumFOCUS Code of Conduct][NF-conduct].

**Table of Contents**

- [MDAnalysis Code of Conduct](#numfocus-code-of-conduct)
- [How to Report](#how-to-report)
- [Who Will Receive Your Report](#who-will-receive-your-report)
- [Diversity, Equity, and Inclusion Statement](#diversity-equity-and-inclusion-statement)
- [Acknowledgment](#acknowledgment)

## MDANALYSIS CODE OF CONDUCT
You can find the whole document here: https://numfocus.org/code-of-conduct.

### THE SHORT VERSION
MDAnalysis and NumFOCUS are dedicated to providing a harassment-free community for everyone,
regardless of gender, sexual orientation, gender identity and expression, disability,
physical appearance, body size, race, or religion. We do not tolerate harassment of
community members in any form.

Be kind to others. Do not insult or put down others. Behave professionally. Remember
that harassment and sexist, racist, or exclusionary jokes are not appropriate for MDAnalysis
or NumFOCUS.

All communication should be appropriate for a professional audience including people of
many different backgrounds. Sexual language and imagery is not appropriate.

Thank you for helping make this a welcoming, friendly community for all.

### THE LONG VERSION
You can find the long version of the Code of Conduct on the NumFOCUS website:
https://numfocus.org/code-of-conduct.

## HOW TO REPORT
If you feel that the Code of Conduct has been violated, feel free to submit a report, by
using the [NumFOCUS Code of Conduct Reporting Form](https://numfocus.typeform.com/to/ynjGdT?typeform-source=numfocus.org).

### REPORTING AT MDANALYSIS EVENTS AND MEETUPS
If you are attending an MDAnalysis event or meetup and wish to make a report that requires
an appropriate immediate response, you may contact the ombudspersons (who will identify
themselves at the event) or other event staff/meetup organizers. If you would prefer not to
do that, please [submit a report](how-to-report) to NumFOCUS, but please note it may not be
possible for the [NumFOCUS Code of Conduct Working Group](#who-will-receive-your-report) to
respond immediately. 

Ombudspeople and event staff/meetup organizers will be happy to help participants contact
venue security or local law enforcement, provide escorts, or otherwise assist those
experiencing harassment to feel safe for the duration of the event/meetup.

## WHO WILL RECEIVE YOUR REPORT
Your report will be received and handled by the NumFOCUS Code of Conduct Working Group; trained,
and experienced contributors with diverse backgrounds. The group is making decisions independently
from the MDAnalysis project, PyData, NumFOCUS or any other organization. 

You can learn more about the current group members, as well as the reporting procedure [HERE][NF-conduct].

### ENFORCEMENT
Based on recommendations for next steps as determined by the NumFOCUS Code of Conduct Working Group,
the MDAnalysis project will remain responsible for making the final decision and implementing any
resulting actions. See the [MDanalysis team](https://www.mdanalysis.org/pages/team/#roles) page on
the MDAnalysis website for a current list of the **MDAnalysis Code of Conduct Committee** members.

Once a resolution has been agreed upon, but before it is enacted, the MDAnalysis Code of Conduct
Committee will contact the original reporter and any other affected parties and explain the proposed
resolution. We will ask if this resolution is acceptable and note feedback for the record. We are,
however, not required to act on this feedback.

## DIVERSITY, EQUITY, AND INCLUSION STATEMENT
MDAnalysis strives to ensure a welcoming, inclusive space for all. As a [NumFOCUS][NF] sponsored project,
we fully support their [*Diversity & Inclusion in Scientific Computing*](https://numfocus.org/programs/diversity-inclusion)
(DISC) mission and abide by their Diversity Statement:

> *"NumFOCUS welcomes and encourages participation in our community by people of all backgrounds and identities.
> We are committed to promoting and sustaining a culture that values mutual respect, tolerance, and learning,
> and we work together as a community to help each other live out these values."*

## ACKNOWLEDGMENT

Original text courtesy of [*NumFOCUS*](https://numfocus.org/code-of-conduct), modified by MDAnalysis.

All content on this page is licensed under a [*Creative Commons Attribution*](http://creativecommons.org/licenses/by/3.0/)
license. 

[NF]: https://numfocus.org/
[NF-conduct]: https://numfocus.org/code-of-conduct

