# W0500 Warning Codes

The W0500 error codes are reserved for warnings related to a major release of the isort project.
Generally, the existence of any of these will trigger one additional warning listing the upgrade guide.

For the most recent upgrade guide, see: [The 5.0.0 Upgrade Guide.](https://pycqa.github.io/isort/docs/upgrade_guides/5.0.0.html).

## W0501: Deprecated CLI flags were included that will be ignored.

This warning will be shown if a CLI flag is passed into the isort command that is no longer supported but can safely be ignored.
Often, this happens because an argument used to be required to turn on a feature that then became the default. An example of this
is `--recursive` which became the default behavior for all folders passed-in starting with 5.0.0.

## W0502: Deprecated CLI flags were included that will safely be remapped.

This warning will be shown if a CLI flag is passed into the isort command that is no longer supported but can safely be remapped to the new version of the flag. If you encounter this warning, you must update the argument to match the new flag
before the next major release.

## W0503: Deprecated config options were ignored.

This warning will be shown if a deprecated config option is defined in the Project's isort config file, but can safely be ignored.
This is similar to `W0500` but dealing with config files rather than CLI flags.
