# fheroes2

**fheroes2** is a recreation of the Heroes of Might and Magic II game engine.

This open source multiplatform project, written from scratch, is designed to reproduce the original game with significant
improvements in gameplay, graphics and logic (including support for high-resolution graphics, improved AI, numerous fixes
and user interface improvements), breathing new life into one of the most addictive turn-based strategy games.

You can find a complete list of all of our changes and enhancements in [**its own wiki page**](https://github.com/ihhub/fheroes2/wiki/Features-and-enhancements-of-the-project).

<!-- markdownlint-disable MD033 -->
<div class="image-showcase">
    <div class="row">
        <img loading="lazy" src="images/screenshots/screenshot_world_map.webp" width="820" class="full-image game-screenshot" alt="Screenshot of the world map">
    </div>
    <div class="row">
        <img loading="lazy" src="images/screenshots/screenshot_battle.webp" class="half-image game-screenshot" alt="Screenshot of the battle screen">
        <img loading="lazy" src="images/screenshots/screenshot_castle.webp" class="half-image game-screenshot" alt="Screenshot of the castle screen">
    </div>
</div>
<!-- markdownlint-enable MD033 -->

## Download and Install

Please follow the [**installation guide**](INSTALL.md) to download and install fheroes2.

<a href="https://github.com/ihhub/fheroes2/releases">
    <img loading="lazy" width="106" height="20" src="https://img.shields.io/github/downloads/ihhub/fheroes2/total.svg" alt="Github Downloads">
</a>

## Copyright

All rights for the original game and its resources belong to former The 3DO Company. These rights were transferred to Ubisoft.
We do not encourage and do not support any form of illegal usage of the original game. We strongly advise to purchase the original
game on [**GOG**](https://www.gog.com) or [**Ubisoft Store**](https://store.ubi.com) platforms. Alternatively, you can download a
free demo version of the game. Please refer to the [**installation guide**](INSTALL.md) for more information.

## License

This project is licensed under the [**GNU General Public License v2.0**](https://github.com/ihhub/fheroes2/blob/master/LICENSE).

Initially, the project was developed on [**sourceforge**](https://sourceforge.net/projects/fheroes2/).

## Contribution and Development

This repository is a place for everyone. If you want to contribute, please read more to learn [**how you can contribute**](https://github.com/ihhub/fheroes2/wiki/F.A.Q.#q-how-can-i-contribute-to-the-project).

### Developing fheroes2 engine

To build the project from source, please follow [**this guide**](DEVELOPMENT.md).

To assist with the graphical asset efforts of the project, please look at our [**graphical artist guide**](GRAPHICAL_ASSETS.md).

If you would like to help translating the project, please read the [**translation guide**](TRANSLATION.md).

### Developing fheroes2 documentation site

To build the [website](https://ihhub.github.io/fheroes2/) from source, please follow
[**this guide**](WEBSITE_LOCAL_DEV.md).

## Donation

We accept donations via [**Patreon**](https://www.patreon.com/fheroes2), [**PayPal**](https://www.paypal.com/paypalme/fheroes2) or [**Boosty**](https://boosty.to/fheroes2).
All donations will be used only for the future project development as we do not consider this project as a source of income by any means.

<a href="https://www.patreon.com/fheroes2">
    <img loading="lazy" width="102" height="20" src="https://img.shields.io/badge/Donate-Patreon-green.svg" alt="Patreon Donate" />
</a>
<a href="https://www.paypal.com/paypalme/fheroes2">
    <img loading="lazy" width="96" height="20" src="https://img.shields.io/badge/Donate-PayPal-green.svg" alt="Paypal Donate" />
</a>
<a href="https://boosty.to/fheroes2">
    <img loading="lazy" width="96" height="20" src="https://img.shields.io/badge/Donate-Boosty-green.svg" alt="Boosty Donate" />
</a>

## Contacts

Follow us on social networks: [**Facebook**](https://www.facebook.com/groups/fheroes2) or [**VK**](https://vk.com/fheroes2).
We also have a [**Discord**](https://discord.gg/xF85vbZ) server to discuss the development of the project.

<a href="https://www.facebook.com/groups/fheroes2">
    <img loading="lazy" width="61" height="20" src="https://img.shields.io/badge/Facebook-blue.svg" alt="Facebook" />
</a>
<a href="https://vk.com/fheroes2">
    <img loading="lazy" width="25" height="20" src="https://img.shields.io/badge/VK-blue.svg" alt="VK" />
</a>
<a href="https://discord.gg/xF85vbZ">
    <img loading="lazy"
        width="93"
        height="20"
        src="https://img.shields.io/discord/733093692860137523.svg?label=&logo=discord&logoColor=ffffff&color=7389D8&labelColor=6A7EC2"
        alt="Discord" />
</a>

## Frequently Asked Questions (FAQ)

You can find answers to the most commonly asked questions on our [**F.A.Q. page**](https://github.com/ihhub/fheroes2/wiki/F.A.Q.).
