; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=2 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

; This test is just to verify that we do not crash/assert due to mismatch in
; argument type between the caller and callee.

define dso_local i16 @foo(i16 %a) {
; TUNIT: Function Attrs: norecurse
; TUNIT-LABEL: define {{[^@]+}}@foo
; TUNIT-SAME: (i16 [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:    [[CALL:%.*]] = call i16 @bar(i16 [[A]], i32 7)
; TUNIT-NEXT:    ret i16 [[CALL]]
;
; CGSCC: Function Attrs: nofree nosync nounwind memory(none)
; CGSCC-LABEL: define {{[^@]+}}@foo
; CGSCC-SAME: (i16 [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:    [[CALL:%.*]] = call i16 @bar(i16 [[A]], i32 7)
; CGSCC-NEXT:    ret i16 [[CALL]]
;
  %call = call i16 @bar(i16 %a, i32 7)
  ret i16 %call
}

define internal i16 @bar(i16 %p1, i16 %p2) {
; TUNIT-LABEL: define {{[^@]+}}@bar
; TUNIT-SAME: (i16 [[P1:%.*]], i16 [[P2:%.*]]) {
; TUNIT-NEXT:    ret i16 [[P2]]
;
; CGSCC: Function Attrs: nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@bar
; CGSCC-SAME: (i16 [[P1:%.*]], i16 returned [[P2:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    ret i16 [[P2]]
;
  ret i16 %p2
}


;.
; TUNIT: attributes #[[ATTR0]] = { norecurse }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree nosync nounwind memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nofree norecurse nosync nounwind willreturn memory(none) }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
