; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck --check-prefixes=AVX2-SLOW %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck --check-prefixes=AVX2-FAST,AVX2-FAST-ALL %s
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck --check-prefixes=AVX2-FAST,AVX2-FAST-PERLANE %s

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @vf2(<2 x i16>* %in.vecptr0, <2 x i16>* %in.vecptr1, <2 x i16>* %in.vecptr2, <2 x i16>* %in.vecptr3, <2 x i16>* %in.vecptr4, <10 x i16>* %out.vec) nounwind {
; AVX2-SLOW-LABEL: vf2:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-SLOW-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13,u,u,2,3,6,7,10,11,u,u,18,19,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,3,0,3,4,7,4,7]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm0 = ymm0[3,3,3,3,4,5,6,7,11,11,11,11,12,13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm2 = <255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,255,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-SLOW-NEXT:    vpblendvb %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vmovd %xmm1, 16(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf2:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-FAST-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; AVX2-FAST-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-FAST-NEXT:    vinserti128 $1, (%r8), %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm1 = ymm0[0,1,4,5,8,9,12,13],zero,zero,ymm0[2,3,6,7,10,11],zero,zero,ymm0[18,19],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1],zero,zero,zero,zero,zero,zero,ymm0[30,31],zero,zero,ymm0[30,31,30,31,16,17,18,19,28,29,30,31]
; AVX2-FAST-NEXT:    vpor %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-FAST-NEXT:    vmovd %xmm1, 16(%r9)
; AVX2-FAST-NEXT:    vmovdqa %xmm0, (%r9)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
  %in.vec0 = load <2 x i16>, <2 x i16>* %in.vecptr0, align 32
  %in.vec1 = load <2 x i16>, <2 x i16>* %in.vecptr1, align 32
  %in.vec2 = load <2 x i16>, <2 x i16>* %in.vecptr2, align 32
  %in.vec3 = load <2 x i16>, <2 x i16>* %in.vecptr3, align 32
  %in.vec4 = load <2 x i16>, <2 x i16>* %in.vecptr4, align 32

  %concat01 = shufflevector <2 x i16> %in.vec0, <2 x i16> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %concat23 = shufflevector <2 x i16> %in.vec2, <2 x i16> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %concat0123 = shufflevector <4 x i16> %concat01, <4 x i16> %concat23, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat4uuu = shufflevector <2 x i16> %in.vec4, <2 x i16> poison, <8 x i32> <i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat01234 = shufflevector <8 x i16> %concat0123, <8 x i16> %concat4uuu, <10 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9>
  %interleaved.vec = shufflevector <10 x i16> %concat01234, <10 x i16> poison, <10 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 1, i32 3, i32 5, i32 7, i32 9>

  store <10 x i16> %interleaved.vec, <10 x i16>* %out.vec, align 32

  ret void
}

define void @vf4(<4 x i16>* %in.vecptr0, <4 x i16>* %in.vecptr1, <4 x i16>* %in.vecptr2, <4 x i16>* %in.vecptr3, <4 x i16>* %in.vecptr4, <20 x i16>* %out.vec) nounwind {
; AVX2-SLOW-LABEL: vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-SLOW-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,3,1,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX2-SLOW-NEXT:    vmovq %xmm0, 32(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm2 = mem[0],zero
; AVX2-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm2
; AVX2-FAST-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-FAST-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm4 = ymm2[0,1,8,9,u,u,u,u,u,u,2,3,10,11,u,u,26,27,u,u,u,u,u,u,20,21,28,29,u,u,u,u]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[2,3,0,1]
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm2 = ymm2[u,u,u,u,0,1,8,9,u,u,u,u,u,u,2,3,u,u,u,u,20,21,28,29,u,u,u,u,u,u,22,23]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5,6],ymm2[7],ymm4[8,9],ymm2[10,11],ymm4[12,13,14],ymm2[15]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX2-FAST-NEXT:    vpsrldq {{.*#+}} xmm0 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,6,7,14,15,u,u,u,u,u,u,u,u,u,u]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX2-FAST-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2],xmm3[3],xmm0[4,5,6,7]
; AVX2-FAST-NEXT:    vmovq %xmm0, 32(%r9)
; AVX2-FAST-NEXT:    vmovdqa %ymm2, (%r9)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
  %in.vec0 = load <4 x i16>, <4 x i16>* %in.vecptr0, align 32
  %in.vec1 = load <4 x i16>, <4 x i16>* %in.vecptr1, align 32
  %in.vec2 = load <4 x i16>, <4 x i16>* %in.vecptr2, align 32
  %in.vec3 = load <4 x i16>, <4 x i16>* %in.vecptr3, align 32
  %in.vec4 = load <4 x i16>, <4 x i16>* %in.vecptr4, align 32

  %concat01 = shufflevector <4 x i16> %in.vec0, <4 x i16> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat23 = shufflevector <4 x i16> %in.vec2, <4 x i16> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %concat0123 = shufflevector <8 x i16> %concat01, <8 x i16> %concat23, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat4uuu = shufflevector <4 x i16> %in.vec4, <4 x i16> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat01234 = shufflevector <16 x i16> %concat0123, <16 x i16> %concat4uuu, <20 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19>
  %interleaved.vec = shufflevector <20 x i16> %concat01234, <20 x i16> poison, <20 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 1, i32 5, i32 9, i32 13, i32 17, i32 2, i32 6, i32 10, i32 14, i32 18, i32 3, i32 7, i32 11, i32 15, i32 19>

  store <20 x i16> %interleaved.vec, <20 x i16>* %out.vec, align 32

  ret void
}

define void @vf8(<8 x i16>* %in.vecptr0, <8 x i16>* %in.vecptr1, <8 x i16>* %in.vecptr2, <8 x i16>* %in.vecptr3, <8 x i16>* %in.vecptr4, <40 x i16>* %out.vec) nounwind {
; AVX2-SLOW-LABEL: vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm3
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm2
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = ymm5[6,7,u,u,u,u,10,11,u,u,8,9,u,u,u,u,22,23,u,u,u,u,26,27,u,u,24,25,u,u,u,u]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,6,7,10,11,u,u,8,9,u,u,8,9,12,13,u,u,22,23,26,27,u,u,24,25,u,u,24,25,28,29]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1,2],ymm6[3],ymm5[4],ymm6[5],ymm5[6,7],ymm6[8],ymm5[9,10],ymm6[11],ymm5[12],ymm6[13],ymm5[14,15]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm4, %ymm2, %ymm6
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm7 = ymm6[8,9,10,11,6,7,u,u,u,u,10,11,12,13,8,9,24,25,26,27,22,23,u,u,u,u,26,27,28,29,24,25]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,0,1]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm6 = ymm6[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3,4],ymm7[5,6,7,8,9,10],ymm6[11,12],ymm7[13,14,15]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vpbroadcastq 8(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm6
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,0]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[0,1,8,9,12,13],zero,zero,zero,zero,ymm6[2,3,18,19,18,19],zero,zero,zero,zero,ymm6[28,29,20,21,28,29],zero,zero
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm8
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,0,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[0,1,8,9],zero,zero,zero,zero,zero,zero,ymm8[2,3,10,11],zero,zero,zero,zero,zero,zero,ymm8[20,21,28,29],zero,zero,zero,zero,zero,zero,ymm8[22,23]
; AVX2-SLOW-NEXT:    vpor %ymm6, %ymm8, %ymm6
; AVX2-SLOW-NEXT:    vpbroadcastq (%r8), %ymm8
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm6, %ymm8, %ymm6
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm3 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; AVX2-SLOW-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm2[4],xmm1[5],xmm2[5],xmm1[6],xmm2[6],xmm1[7],xmm2[7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,5,7,6]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3],xmm1[4,5,6],xmm3[7]
; AVX2-SLOW-NEXT:    vpsrlq $48, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3],xmm0[4],xmm1[5,6,7]
; AVX2-SLOW-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm6, (%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm5, 32(%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: vf8:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdx), %xmm2
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-FAST-ALL-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-FAST-ALL-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm5
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[0,2,2,0]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm5 = zero,zero,zero,zero,ymm5[0,1,8,9,12,13],zero,zero,zero,zero,ymm5[2,3,18,19,18,19],zero,zero,zero,zero,ymm5[28,29,20,21,28,29],zero,zero
; AVX2-FAST-ALL-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm6
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,0,2]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm6 = ymm6[0,1,8,9],zero,zero,zero,zero,zero,zero,ymm6[2,3,10,11],zero,zero,zero,zero,zero,zero,ymm6[20,21,28,29],zero,zero,zero,zero,zero,zero,ymm6[22,23]
; AVX2-FAST-ALL-NEXT:    vpor %ymm5, %ymm6, %ymm5
; AVX2-FAST-ALL-NEXT:    vpbroadcastq (%r8), %ymm6
; AVX2-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-ALL-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm6
; AVX2-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm8 = <1,5,2,u,6,2,u,u>
; AVX2-FAST-ALL-NEXT:    vpermd %ymm6, %ymm8, %ymm6
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[2,3,6,7,6,7],zero,zero,zero,zero,ymm6[8,9,16,17,18,19],zero,zero,zero,zero,ymm6[22,23,18,19,18,19],zero,zero
; AVX2-FAST-ALL-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm8
; AVX2-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm9 = <1,5,2,6,2,6,3,u>
; AVX2-FAST-ALL-NEXT:    vpermd %ymm8, %ymm9, %ymm8
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[2,3,6,7],zero,zero,zero,zero,zero,zero,ymm8[8,9,12,13],zero,zero,zero,zero,zero,zero,ymm8[18,19,22,23],zero,zero,zero,zero,zero,zero,ymm8[24,25]
; AVX2-FAST-ALL-NEXT:    vpor %ymm6, %ymm8, %ymm6
; AVX2-FAST-ALL-NEXT:    vpbroadcastq 8(%rdi), %ymm8
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm6, %ymm8, %ymm6
; AVX2-FAST-ALL-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm4[4],xmm1[4],xmm4[5],xmm1[5],xmm4[6],xmm1[6],xmm4[7],xmm1[7]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[u,u,u,u,8,9,14,15,u,u,u,u,u,u,12,13]
; AVX2-FAST-ALL-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm2[4],xmm3[4],xmm2[5],xmm3[5],xmm2[6],xmm3[6],xmm2[7],xmm3[7]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[8,9,10,11,u,u,u,u,u,u,12,13,14,15,u,u]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3],xmm2[4,5,6],xmm1[7]
; AVX2-FAST-ALL-NEXT:    vpsrlq $48, %xmm0, %xmm0
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3],xmm0[4],xmm1[5,6,7]
; AVX2-FAST-ALL-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm6, 32(%r9)
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-FAST-ALL-NEXT:    vzeroupper
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %xmm4
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = ymm5[6,7,u,u,u,u,10,11,u,u,8,9,u,u,u,u,22,23,u,u,u,u,26,27,u,u,24,25,u,u,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = ymm5[u,u,6,7,10,11,u,u,8,9,u,u,8,9,12,13,u,u,22,23,26,27,u,u,24,25,u,u,24,25,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0],ymm5[1,2],ymm6[3],ymm5[4],ymm6[5],ymm5[6,7],ymm6[8],ymm5[9,10],ymm6[11],ymm5[12],ymm6[13],ymm5[14,15]
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm7 = ymm6[8,9,10,11,6,7,u,u,u,u,10,11,12,13,8,9,24,25,26,27,22,23,u,u,u,u,26,27,28,29,24,25]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,3,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufhw {{.*#+}} ymm6 = ymm6[0,1,2,3,5,5,5,5,8,9,10,11,13,13,13,13]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm6 = ymm7[0,1,2],ymm6[3,4],ymm7[5,6,7,8,9,10],ymm6[11,12],ymm7[13,14,15]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 8(%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm5, %ymm6, %ymm5
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[0,2,2,0]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm6 = zero,zero,zero,zero,ymm6[0,1,8,9,12,13],zero,zero,zero,zero,ymm6[2,3,18,19,18,19],zero,zero,zero,zero,ymm6[28,29,20,21,28,29],zero,zero
; AVX2-FAST-PERLANE-NEXT:    vinserti128 $1, %xmm0, %ymm2, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,0,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm8 = ymm8[0,1,8,9],zero,zero,zero,zero,zero,zero,ymm8[2,3,10,11],zero,zero,zero,zero,zero,zero,ymm8[20,21,28,29],zero,zero,zero,zero,zero,zero,ymm8[22,23]
; AVX2-FAST-PERLANE-NEXT:    vpor %ymm6, %ymm8, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq (%r8), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm6, %ymm8, %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm2 = xmm2[u,u,u,u,8,9,14,15,u,u,u,u,u,u,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpunpckhwd {{.*#+}} xmm1 = xmm1[4],xmm3[4],xmm1[5],xmm3[5],xmm1[6],xmm3[6],xmm1[7],xmm3[7]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[8,9,10,11,u,u,u,u,u,u,12,13,14,15,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5,6],xmm2[7]
; AVX2-FAST-PERLANE-NEXT:    vpsrlq $48, %xmm0, %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0,1,2,3],xmm0[4],xmm1[5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %xmm0, 64(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm6, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm5, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
  %in.vec0 = load <8 x i16>, <8 x i16>* %in.vecptr0, align 32
  %in.vec1 = load <8 x i16>, <8 x i16>* %in.vecptr1, align 32
  %in.vec2 = load <8 x i16>, <8 x i16>* %in.vecptr2, align 32
  %in.vec3 = load <8 x i16>, <8 x i16>* %in.vecptr3, align 32
  %in.vec4 = load <8 x i16>, <8 x i16>* %in.vecptr4, align 32

  %concat01 = shufflevector <8 x i16> %in.vec0, <8 x i16> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat23 = shufflevector <8 x i16> %in.vec2, <8 x i16> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %concat0123 = shufflevector <16 x i16> %concat01, <16 x i16> %concat23, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat4uuu = shufflevector <8 x i16> %in.vec4, <8 x i16> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat01234 = shufflevector <32 x i16> %concat0123, <32 x i16> %concat4uuu, <40 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39>
  %interleaved.vec = shufflevector <40 x i16> %concat01234, <40 x i16> poison, <40 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 1, i32 9, i32 17, i32 25, i32 33, i32 2, i32 10, i32 18, i32 26, i32 34, i32 3, i32 11, i32 19, i32 27, i32 35, i32 4, i32 12, i32 20, i32 28, i32 36, i32 5, i32 13, i32 21, i32 29, i32 37, i32 6, i32 14, i32 22, i32 30, i32 38, i32 7, i32 15, i32 23, i32 31, i32 39>

  store <40 x i16> %interleaved.vec, <40 x i16>* %out.vec, align 32

  ret void
}

define void @vf16(<16 x i16>* %in.vecptr0, <16 x i16>* %in.vecptr1, <16 x i16>* %in.vecptr2, <16 x i16>* %in.vecptr3, <16 x i16>* %in.vecptr4, <80 x i16>* %out.vec) nounwind {
; AVX2-SLOW-LABEL: vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %ymm12
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %ymm11
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-SLOW-NEXT:    vmovdqa (%r8), %ymm2
; AVX2-SLOW-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-SLOW-NEXT:    vmovdqa (%rcx), %xmm6
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm7 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm7 = xmm7[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm7 = ymm7[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa (%rsi), %xmm0
; AVX2-SLOW-NEXT:    vmovdqa (%rdi), %xmm1
; AVX2-SLOW-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1],xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,4,5,6]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm1, %ymm7, %ymm1
; AVX2-SLOW-NEXT:    vpbroadcastq (%r8), %ymm8
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm1, %ymm8, %ymm9
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = xmm5[1,2,2,2]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[6,7,u,u,10,11,u,u,8,9,8,9,u,u,12,13]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3],xmm0[4,5],xmm1[6],xmm0[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} xmm1 = mem[2,1,2,3]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} xmm5 = xmm6[3,3,3,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,5,6,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm5[2],xmm1[3],xmm5[4],xmm1[5,6],xmm5[7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastq 8(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm8
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm2[0,1,0,1,4,5,4,5]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,u,u,24,25,20,21,u,u,24,25]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[0,1,2,1,4,5,6,5]
; AVX2-SLOW-NEXT:    vpshuflw {{.*#+}} ymm5 = ymm11[3,1,2,2,4,5,6,7,11,9,10,10,12,13,14,15]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm5 = ymm5[0,1,2,3,4,4,4,4,8,9,10,11,12,12,12,12]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0,1],ymm1[2],ymm5[3],ymm1[4],ymm5[5,6],ymm1[7],ymm5[8,9],ymm1[10],ymm5[11],ymm1[12],ymm5[13,14],ymm1[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[1,2,2,3,5,6,6,7]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0],ymm1[1],ymm5[2],ymm1[3],ymm5[4,5],ymm1[6],ymm5[7,8],ymm1[9],ymm5[10],ymm1[11],ymm5[12,13],ymm1[14],ymm5[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm5 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-SLOW-NEXT:    vpshufhw {{.*#+}} ymm6 = ymm11[0,1,2,3,5,6,7,7,8,9,10,11,13,14,15,15]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm6 = ymm6[0,2,3,2,4,6,7,6]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm5 = ymm5[0,1],ymm6[2],ymm5[3],ymm6[4],ymm5[5,6],ymm6[7],ymm5[8,9],ymm6[10],ymm5[11],ymm6[12],ymm5[13,14],ymm6[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm1, %ymm5, %ymm1
; AVX2-SLOW-NEXT:    vpsrldq {{.*#+}} ymm5 = ymm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,2]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm1, %ymm5, %ymm1
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u]
; AVX2-SLOW-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm4 = ymm12[1,1,2,2]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-SLOW-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3],ymm2[4],ymm4[5],ymm2[6,7],ymm4[8],ymm2[9,10],ymm4[11],ymm2[12],ymm4[13],ymm2[14,15]
; AVX2-SLOW-NEXT:    vpblendvb %ymm10, %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm3 = ymm11[0,1,0,1,0,1,0,1,14,15,2,3,2,3,14,15,16,17,16,17,16,17,16,17,30,31,18,19,18,19,30,31]
; AVX2-SLOW-NEXT:    vpblendvb %ymm7, %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa %ymm2, 64(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm1, 128(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm0, 96(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm8, 32(%r9)
; AVX2-SLOW-NEXT:    vmovdqa %ymm9, (%r9)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: vf16:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdi), %ymm12
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rsi), %ymm11
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-FAST-ALL-NEXT:    vmovdqa (%r8), %ymm2
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rsi), %xmm5
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-ALL-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-FAST-ALL-NEXT:    vmovdqa (%rcx), %xmm0
; AVX2-FAST-ALL-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm10, %ymm7, %ymm1, %ymm1
; AVX2-FAST-ALL-NEXT:    vpbroadcastq (%r8), %ymm8
; AVX2-FAST-ALL-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm1, %ymm8, %ymm9
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} xmm1 = xmm6[1,2,2,2]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[6,7,u,u,10,11,u,u,8,9,8,9,u,u,12,13]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} xmm1 = xmm5[0],xmm1[1],xmm5[2],xmm1[3],xmm5[4,5],xmm1[6],xmm5[7]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} xmm5 = mem[2,1,2,3]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,6,7,u,u,10,11,u,u,u,u,8,9]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} xmm0 = xmm5[0,1],xmm0[2],xmm5[3],xmm0[4],xmm5[5,6],xmm0[7]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    vpbroadcastq 8(%rdi), %ymm1
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm8
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} ymm0 = ymm2[0,1,0,1,4,5,4,5]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,u,u,24,25,20,21,u,u,24,25]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[0,1,2,1,4,5,6,5]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm5 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0,1],ymm1[2],ymm5[3],ymm1[4],ymm5[5,6],ymm1[7],ymm5[8,9],ymm1[10],ymm5[11],ymm1[12],ymm5[13,14],ymm1[15]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [25769803781,25769803781,25769803781,25769803781]
; AVX2-FAST-ALL-NEXT:    vpermd %ymm3, %ymm1, %ymm1
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0],ymm1[1],ymm5[2],ymm1[3],ymm5[4,5],ymm1[6],ymm5[7,8],ymm1[9],ymm5[10],ymm1[11],ymm5[12,13],ymm1[14],ymm5[15]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm5 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,u,u,30,31,u,u,u,u,28,29]
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} ymm6 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3],ymm5[4],ymm6[5,6],ymm5[7],ymm6[8,9],ymm5[10],ymm6[11],ymm5[12],ymm6[13,14],ymm5[15]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm10, %ymm1, %ymm5, %ymm1
; AVX2-FAST-ALL-NEXT:    vpsrldq {{.*#+}} ymm5 = ymm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,2]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm1, %ymm5, %ymm1
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u]
; AVX2-FAST-ALL-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm4 = ymm12[1,1,2,2]
; AVX2-FAST-ALL-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-FAST-ALL-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3],ymm2[4],ymm4[5],ymm2[6,7],ymm4[8],ymm2[9,10],ymm4[11],ymm2[12],ymm4[13],ymm2[14,15]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm10, %ymm3, %ymm2, %ymm2
; AVX2-FAST-ALL-NEXT:    vpshufb {{.*#+}} ymm3 = ymm11[0,1,0,1,0,1,0,1,14,15,2,3,2,3,14,15,16,17,16,17,16,17,16,17,30,31,18,19,18,19,30,31]
; AVX2-FAST-ALL-NEXT:    vpblendvb %ymm7, %ymm2, %ymm3, %ymm2
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm2, 64(%r9)
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm1, 128(%r9)
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm0, 96(%r9)
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm8, 32(%r9)
; AVX2-FAST-ALL-NEXT:    vmovdqa %ymm9, (%r9)
; AVX2-FAST-ALL-NEXT:    vzeroupper
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%r8), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rsi), %xmm5
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdi), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm6 = xmm6[0,1,2,3,8,9,10,11,4,5,4,5,6,7,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm7 = ymm6[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rdx), %xmm6
; AVX2-FAST-PERLANE-NEXT:    vmovdqa (%rcx), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vpunpcklwd {{.*#+}} xmm1 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm1 = xmm1[4,5,2,3,2,3,0,1,10,11,8,9,4,5,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm10 = <255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255,255,255,0,0,0,0,u,u,255,255>
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm7, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq (%r8), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovdqa {{.*#+}} ymm7 = [255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255,0,0,255,255]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm1, %ymm8, %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm1 = xmm6[1,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm5 = xmm5[6,7,u,u,10,11,u,u,8,9,8,9,u,u,12,13]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm1 = xmm5[0],xmm1[1],xmm5[2],xmm1[3],xmm5[4,5],xmm1[6],xmm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} xmm5 = mem[2,1,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[u,u,u,u,6,7,u,u,10,11,u,u,u,u,8,9]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} xmm0 = xmm5[0,1],xmm0[2],xmm5[3],xmm0[4],xmm5[5,6],xmm0[7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq 8(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm2[0,1,0,1,4,5,4,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm1 = ymm4[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,18,19,u,u,22,23,u,u,24,25,20,21,u,u,24,25]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7,8],ymm0[9],ymm1[10],ymm0[11],ymm1[12,13],ymm0[14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[0,1,2,1,4,5,6,5]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,22,23,18,19,u,u,20,21,u,u,24,25,24,25,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0,1],ymm1[2],ymm5[3],ymm1[4],ymm5[5,6],ymm1[7],ymm5[8,9],ymm1[10],ymm5[11],ymm1[12],ymm5[13,14],ymm1[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm3[1,2,2,3,5,6,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm0, %ymm1, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm1 = ymm12[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm5 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm1 = ymm5[0],ymm1[1],ymm5[2],ymm1[3],ymm5[4,5],ymm1[6],ymm5[7,8],ymm1[9],ymm5[10],ymm1[11],ymm5[12,13],ymm1[14],ymm5[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm5 = ymm11[u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,u,26,27,u,u,30,31,u,u,u,u,28,29]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm6 = ymm3[3,2,3,3,7,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm5 = ymm6[0,1],ymm5[2],ymm6[3],ymm5[4],ymm6[5,6],ymm5[7],ymm6[8,9],ymm5[10],ymm6[11],ymm5[12],ymm6[13,14],ymm5[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,3,2,3]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm1, %ymm5, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpsrldq {{.*#+}} ymm5 = ymm4[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,ymm4[26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm5 = ymm5[2,2,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm1, %ymm5, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm4 = ymm4[u,u,12,13,u,u,0,1,u,u,u,u,14,15,u,u,u,u,28,29,u,u,16,17,u,u,u,u,30,31,u,u]
; AVX2-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[3,0,3,0,7,4,7,4]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[3],ymm3[4,5],ymm4[6],ymm3[7,8],ymm4[9],ymm3[10],ymm4[11],ymm3[12,13],ymm4[14],ymm3[15]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm4 = ymm12[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3],ymm2[4],ymm4[5],ymm2[6,7],ymm4[8],ymm2[9,10],ymm4[11],ymm2[12],ymm4[13],ymm2[14,15]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm10, %ymm3, %ymm2, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpshufb {{.*#+}} ymm3 = ymm11[0,1,0,1,0,1,0,1,14,15,2,3,2,3,14,15,16,17,16,17,16,17,16,17,30,31,18,19,18,19,30,31]
; AVX2-FAST-PERLANE-NEXT:    vpblendvb %ymm7, %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm2, 64(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm1, 128(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm0, 96(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm8, 32(%r9)
; AVX2-FAST-PERLANE-NEXT:    vmovdqa %ymm9, (%r9)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
  %in.vec0 = load <16 x i16>, <16 x i16>* %in.vecptr0, align 32
  %in.vec1 = load <16 x i16>, <16 x i16>* %in.vecptr1, align 32
  %in.vec2 = load <16 x i16>, <16 x i16>* %in.vecptr2, align 32
  %in.vec3 = load <16 x i16>, <16 x i16>* %in.vecptr3, align 32
  %in.vec4 = load <16 x i16>, <16 x i16>* %in.vecptr4, align 32

  %concat01 = shufflevector <16 x i16> %in.vec0, <16 x i16> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat23 = shufflevector <16 x i16> %in.vec2, <16 x i16> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %concat0123 = shufflevector <32 x i16> %concat01, <32 x i16> %concat23, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %concat4uuu = shufflevector <16 x i16> %in.vec4, <16 x i16> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %concat01234 = shufflevector <64 x i16> %concat0123, <64 x i16> %concat4uuu, <80 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79>
  %interleaved.vec = shufflevector <80 x i16> %concat01234, <80 x i16> poison, <80 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 1, i32 17, i32 33, i32 49, i32 65, i32 2, i32 18, i32 34, i32 50, i32 66, i32 3, i32 19, i32 35, i32 51, i32 67, i32 4, i32 20, i32 36, i32 52, i32 68, i32 5, i32 21, i32 37, i32 53, i32 69, i32 6, i32 22, i32 38, i32 54, i32 70, i32 7, i32 23, i32 39, i32 55, i32 71, i32 8, i32 24, i32 40, i32 56, i32 72, i32 9, i32 25, i32 41, i32 57, i32 73, i32 10, i32 26, i32 42, i32 58, i32 74, i32 11, i32 27, i32 43, i32 59, i32 75, i32 12, i32 28, i32 44, i32 60, i32 76, i32 13, i32 29, i32 45, i32 61, i32 77, i32 14, i32 30, i32 46, i32 62, i32 78, i32 15, i32 31, i32 47, i32 63, i32 79>

  store <80 x i16> %interleaved.vec, <80 x i16>* %out.vec, align 32

  ret void
}
