; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O3 -mtriple=x86_64-pc-linux < %s | FileCheck %s --check-prefixes=COMMON,NOFMA
; RUN: llc -O3 -mtriple=x86_64-pc-linux -mattr=+fma < %s | FileCheck %s --check-prefixes=COMMON,FMA
; RUN: llc -O3 -mtriple=x86_64-pc-linux -mattr=+avx512f < %s | FileCheck %s --check-prefixes=COMMON,FMA

; Verify that fma(3.5) isn't simplified when the rounding mode is
; unknown.
define float @f17() #0 {
; NOFMA-LABEL: f17:
; NOFMA:       # %bb.0: # %entry
; NOFMA-NEXT:    pushq %rax
; NOFMA-NEXT:    .cfi_def_cfa_offset 16
; NOFMA-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOFMA-NEXT:    movaps %xmm0, %xmm1
; NOFMA-NEXT:    movaps %xmm0, %xmm2
; NOFMA-NEXT:    callq fmaf
; NOFMA-NEXT:    popq %rax
; NOFMA-NEXT:    .cfi_def_cfa_offset 8
; NOFMA-NEXT:    retq
;
; FMA-LABEL: f17:
; FMA:       # %bb.0: # %entry
; FMA-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; FMA-NEXT:    vfmadd213ss {{.*#+}} xmm0 = (xmm0 * xmm0) + xmm0
; FMA-NEXT:    retq
entry:
  %result = call float @llvm.experimental.constrained.fma.f32(
                                               float 3.5,
                                               float 3.5,
                                               float 3.5,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret float %result
}

; Verify that fma(42.1) isn't simplified when the rounding mode is
; unknown.
define double @f18() #0 {
; NOFMA-LABEL: f18:
; NOFMA:       # %bb.0: # %entry
; NOFMA-NEXT:    pushq %rax
; NOFMA-NEXT:    .cfi_def_cfa_offset 16
; NOFMA-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; NOFMA-NEXT:    movaps %xmm0, %xmm1
; NOFMA-NEXT:    movaps %xmm0, %xmm2
; NOFMA-NEXT:    callq fma
; NOFMA-NEXT:    popq %rax
; NOFMA-NEXT:    .cfi_def_cfa_offset 8
; NOFMA-NEXT:    retq
;
; FMA-LABEL: f18:
; FMA:       # %bb.0: # %entry
; FMA-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; FMA-NEXT:    vfmadd213sd {{.*#+}} xmm0 = (xmm0 * xmm0) + xmm0
; FMA-NEXT:    retq
entry:
  %result = call double @llvm.experimental.constrained.fma.f64(
                                               double 42.1,
                                               double 42.1,
                                               double 42.1,
                                               metadata !"round.dynamic",
                                               metadata !"fpexcept.strict") #0
  ret double %result
}

attributes #0 = { strictfp }

declare float @llvm.experimental.constrained.fma.f32(float, float, float, metadata, metadata)
declare double @llvm.experimental.constrained.fma.f64(double, double, double, metadata, metadata)
