/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: screenshot.c,v 1.2 2000/01/15 16:14:35 rich Exp $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "xracer.h"
#include "xracer-screenshot.h"
#include "xracer-log.h"
#include "xracer-PATH_MAX.h"

/* This is the pattern used to generate screenshots. */
#if defined(HAVE_POPEN) && defined(HAVE_PPMTOGIF) && defined(HAVE_PPMQUANT)
#define EXT ".gif"
#define PIPE_CMD PPMQUANT " 256 | " PPMTOGIF " > %s"
#else
#define EXT ".ppm"
#endif

#ifdef P_tmpdir
#define PREFIX P_tmpdir
#else
#define PREFIX "/tmp"
#endif

#define SCREENSHOT_NAME PREFIX "/xracer-%d" EXT

/* Take a screenshot. */
void
xrScreenshot ()
{
  char pathname[PATH_MAX];
#ifdef PIPE_CMD
  char pipe[PATH_MAX+100];
#endif
  FILE *fp;
  char *pixels;
  int y;
  static int unique = 0;

  /* Generate a suitable random filename. */
  unique++;
  for (;;)
    {
      snprintf (pathname, sizeof pathname, SCREENSHOT_NAME, unique);

#if HAVE_ACCESS
      if (access (pathname, F_OK) == -1)
#endif
	break;

      unique++;
    }

  /* Open the output file. */
#ifdef PIPE_CMD
  snprintf (pipe, sizeof pipe, PIPE_CMD, pathname);
  fp = popen (pipe, "w");
#else
  fp = fopen (pathname, "w");
#endif

  if (fp == NULL)
    {
      xrLogPerror ("open: %s", pathname);
      return;
    }

  /* Write out the header. */
  fprintf (fp, "P6 %d %d 255\n", xrWidth, xrHeight);

  /* Capture the screen into a buffer. */
  pixels = xmalloc (xrWidth * xrHeight * 3);
  glReadPixels (0, 0, xrWidth, xrHeight, GL_RGB, GL_UNSIGNED_BYTE, pixels);

  /* Write the pixels out to a file, but remember that GL saves them
   * upside down. I also have a feeling that this code is sensitive
   * to endianness issues, and so may not work on non-Intel architectures.
   */
  for (y = 0; y < xrHeight; ++y)
    {
      int len = xrWidth * 3;
      int start = len * (xrHeight - y - 1);

      if (fwrite (pixels + start, len, 1, fp) < 1)
	{
	  xrLogPerror ("write: %s", pathname);
	  free (pixels);
#ifdef PIPE_CMD
	  pclose (fp);
#else
	  fclose (fp);
#endif
	  unlink (pathname);
	  return;
	}
    }

  free (pixels);

#ifdef PIPE_CMD
  pclose (fp);
#else
  fclose (fp);
#endif

  xrLog (LOG_INFO, "Saved screenshot to file %s", pathname);
}
