.TH MAILBOX-PREVIEW 1 2022-12-01
.SH NAME
mailbox-preview \- list new email messages in an IMAP mailbox
.SH SYNOPSIS
.na
.B mailbox-preview
.I \fR[[\fPserver\fR][\fP:mailbox\fR]]\fP
[ \fI\-\-option\fP ... ]
.br
.B mailbox-preview
.I mail_spool_file_name
[ \fI\-\-option\fP ... ]
.br
.B mailbox-preview
.I \fR[[\fPserver\fR][\fP:mailbox\fR]]\fP
.B \-\-check
.I oldsize
[ \fI\-\-option\fP ... ]
.br
.B mailbox-preview
.I mail_spool_file_name
.B \-\-check
.I oldsize
[ \fI\-\-option\fP ... ]
.ad
.SH DESCRIPTION
The
.B mailbox-preview
program reads an IMAP mailbox and uses
.BR scan (1)
to display a summary, one line per new message.
It can be used stand-alone on the command line or as the back-end
of a graphical, literate new-mail notification program such as
.BR xlbiff (1).
.PP
The optional first argument is an optional name of an IMAP server
(default \*(lqimap\*(rq), optionally followed by a colon and a mailbox name
(default \*(lqinbox\*(rq).
Unless the default name
.I imap
resolves on your
network to the name of your IMAP server, you will need this argument.
It is likely that the default mailbox name
.I inbox
will work for you.
.PP
Your
.I ~/.netrc
file is consulted for the login and password for the IMAP server.
See the FILES section, below, for the format of this file.
.PP
If the first argument to
.B mailbox-preview
is instead the name of a file under a
top-level directory that exists, it is treated as the name of a
local mail drop, and that file is used instead of doing IMAP.
.PP
With
.BR \-\-check ,
the program conforms to the
.I checkCommand
protocol of
.BR xlbiff (1).
The output is the new mailbox size to pass next time as the argument to
.BR \-\-check .
(The contents of the mailbox are not output.)
The exit value of the program describes how the mailbox size has
changed, as documented under the
.B \-checkCommand
option in
.BR xlbiff (1).
.SH OPTIONS
.TP 8
\fB\-\-check\fP \fIold_size\fP
Check for mailbox change instead of scanning; see
the description above and
.BR xlbiff (1).
.TP 8
\fB\-\-width\fP \fIN\fP
Width in characters to pass to
.IR scan ;
default is $COLUMNS (from the environment).
.TP 8
\fB\-\-max\-messages\fP \fIN\fP
Display only the last \fIN\fP (default 20) new messages; 0 to display all.
.TP 8
\fB\-\-form\fP \fIfile\fP
Format file for
.BR scan ;
see
.BR mh-format (5).
Default is
.I xlbiff.form
.TP 8
\fB\-\-scanproc\fP \fIprogram\fP
Filename of the
program to pipe the messages through; default
.IR /usr/bin/mh/scan .
If set explicitly to an empty string, the messages will be
output raw (which is probably useful only for debugging).
.TP 8
.B \-\-quiet
Do not output the messages.  This option is probably useful only for debugging.
.TP 8
.B \-\-client\-preview
Do not request a short message preview from the IMAP server and
instead create our own short form of the message.
Use this option if you don't like the preview your IMAP server generates.
It has no effect unless the IMAP server advertises a preview capability.
.TP 8
\fB\-\-imap-debug\fP \fIlevel\fP
Set the
.I imaplib
debug level; level 4 displays the IMAP protocol messages,
level 5 also displays IMAP literal strings.
.SH FILES
.TP 8
.I ~/.netrc
Login information for your IMAP server.
If your IMAP server requires a password, supply it on a
.I machine
line matching the IMAP server name, for example
.IP
.RS 12
.ft C
.nf
machine \fIserver_name\fP login \fIaccount_name\fP password \fIyour_pw\fP
.fi
.ft
.RE
.IP
If \*(lqlogin \fIaccount_name\fP\*(rq is omitted,
.I account_name
defaults to your user name.
.SH "BUGS REPORTS"
When reporting interoperability problems with an IMAP server,
include the output of
.PP
.RS 2
.ft C
.nf
mailbox\-preview \fIsrvr\fP \-\-imap\-debug=4 \-\-quiet 2>&1 | grep \-v " LOGIN "
.fi
.ft
.RE
.SH EXAMPLE
Example command lines:
.PP
.RS 4
.ft C
.nf
mailbox\-preview imap.example.com
mailbox\-preview imap.example.com \-\-check 12
.fi
.ft
.RE
.SH AUTHOR
Stephen Gildea, November 2021
.SH "SEE ALSO"
.BR xlbiff (1),
.BR scan (1)
