/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1997
 *  Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces layout of a "MITSUMI KPQ-E99YC"
 * 101 key AT/XT switchable PC-style keyboard.
 * This differs from the keyboard we know as `pc101' in the placement
 * of the "\ and |" key.
 * By Gord Vreugdenhil <gvreugde@plg.uwaterloo.ca>
 *
 * Modified by Poonlap Veeratanabutr <poon-v@fedu.uec.ac.jp>
 * Add Thai Thai characters on the keyboard.
 * 27 May 1997
 */

static struct key_strings pc101_2th_caps [] = {

  /* Row 0 */

  {"Esc", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},
  {"Print", "Screen", 0},
  {"T/E", "Switch" },
  {"Pause", 0},

  /* Row 2 */

  {"%", "-", "`"},
  {"+", "\345", "1"},
  {"\361", "/", "2"},
  {"\362", "_", "3"},
  {"\363", "\300", "4"},
  {"\364", "\266", "5"},
  {"\331", "\330", "6"},
  {"\337", "\326", "7"},
  {"\365", "\244", "8"},
  {"\366", "\265", "9"},
  {"\367", "\250", "0"},
  {"\370", "\242", "-"},
  {"\371", "\252", "="},
  {"\245", "\243", "\\"},
  {"Back", "space", 0},
  {"Insert", 0},
  {"Home", 0},
  {"Page", "Up", 0},
  {"Num", "Lock", 0},
  {"/", 0},
  {"*", 0},
  {"-", 0},

  /* Row 3 */

  {"Tab", 0},
  {"\360", "\346", "Q"},
  {"\"", "\344", "W"},
  {"\256", "\323", "E"},
  {"\261", "\276", "R"},
  {"\270", "\320", "T"},
  {"\355", "\321", "Y"},
  {"\352", "\325", "U"},
  {"\263", "\303", "I"},
  {"\317", "\271", "O"},
  {"\255", "\302", "P"},
  {"\260", "\272", "["},
  {",", "\305", "]"},
  {"Enter", 0},
  {"Delete", 0},
  {"End", 0},
  {"Page", "Down", 0},
  {"7", "Home", 0},
  {"8", "UpArrow", 0},
  {"9", "Pg Up", 0},
  {"+", 0},

  /* Row 4 */

  {"Caps Lock", 0},
  {"\304", "\277", "A"},
  {"\246", "\313", "S"},
  {"\257", "\241", "D"},
  {"\342", "\264", "F"},
  {"\254", "\340", "G"},
  {"\347", "\351", "H"},
  {"\353", "\350", "J"},
  {"\311", "\322", "K"},
  {"\310", "\312", "L"},
  {"\253", "\307", ";"},
  {".", "\247", "'"},
  {"4", "LeftArrow", 0},
  {"5", 0},
  {"6", "RightArrow", 0},

  /* Row 5 */

  {"Shift", 0},
  {"(", "\274", "Z"},
  {")", "\273", "X"},
  {"\251", "\341", "C"},
  {"\316", "\315", "V"},
  {"\332", "\324", "B"},
  {"\354", "\327", "N"},
  {"?", "\267", "M"},
  {"\262", "\301", ","},
  {"\314", "\343", "."},
  {"\306", "\275", "/"},
  {"Shift", 0},
  {"UpArrow", 0},
  {"1", "End", 0},
  {"2", "DownArrow", 0},
  {"3", "Pg Dn", 0},
  {"Enter", 0},

  /* Row 6 */

  {"Ctrl", 0},
  {"Alt", 0},
  {" ", 0},
  {"Alt", 0},
  {"Ctrl", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"0", "Ins", 0},
  {".", "Del", 0}
};
