#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>

extern XVisualInfo *x11_info;
extern int have_shmem;

extern int x11_red_bits;
extern int x11_red_shift;
extern int x11_green_bits;
extern int x11_green_shift;
extern int x11_blue_bits;
extern int x11_blue_shift;

int x11_color_init(Display *dpy);

XImage *x11_create_ximage(Display *dpy, int width, int height, void **shm);
void x11_destroy_ximage(Display *dpy, XImage * ximage, void *shm);
Pixmap x11_create_pixmap(Display *dpy, unsigned char *data,
			 int width, int height);

#define XPUTIMAGE(dpy,dr,gc,xi,a,b,c,d,w,h)                          \
    if (have_shmem)                                                  \
	XShmPutImage(dpy,dr,gc,xi,a,b,c,d,w,h,True);                 \
    else                                                             \
	XPutImage(dpy,dr,gc,xi,a,b,c,d,w,h)
