/* template.h
   Used to create new header files

   Copyright (C) 2000  Mathias Broxvall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SCORESIGN_H
#define SCORESIGN_H

#define SCORESIGN_SCORE 0
#define SCORESIGN_TIME 1

#include "sign.h"

class ScoreSign : public Sign {
 public:
  ScoreSign(int points, Coord3d position);
  ScoreSign(int points, Coord3d position, int type);
  void init(int points, int type);

  void tick(Real);

 private:
  /** If the bonus given is of another type than score */
  int type;
  double pointsLeft, points, pointsPerSecond;
  double lastLife;
};

#endif
