/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


#include "defs.h"
#include "drawit.h"

/*#define DEBUGDRAW */


/* eieiei and again forward decl. */
void drawpage(int, int, int, int, int);

/* ugly switch */
static int tmpnomarks=0;

/* all drawlist drawings refer to ... */
static pagelistelement* thedrawpage;
static int thexpos, theypos;

  
#define DRAWLISTSTEP 500  /* allocate blocks of 500 drawlistelements */

void drawlistinit(pagelistelement* dpage) {
  thedrawpage=dpage;
  freelrumem(&(thedrawpage->drawlist));
  thedrawpage->ndraws=0;
  thedrawpage->maxdraws=0;
}

void drawlistfix(void) {
  thedrawpage->maxdraws=MAX(1,thedrawpage->ndraws);  
  realloclrumem(&(thedrawpage->drawlist),
    thedrawpage->maxdraws*sizeof(drawlistelement));
  unlocklrumem(&(thedrawpage->drawlist)); 
}


drawlistdata* drawlistadd(selfdrawfunction* sdf) {
  drawlistelement* dleptr;
  if(thedrawpage->maxdraws==thedrawpage->ndraws) {
    thedrawpage->maxdraws+=DRAWLISTSTEP;  
    realloclrumem(&(thedrawpage->drawlist),
      thedrawpage->maxdraws*sizeof(drawlistelement));
     locklrumem(&(thedrawpage->drawlist)); 
  }
  dleptr=thedrawpage->drawlist+thedrawpage->ndraws;
  thedrawpage->ndraws++;
  dleptr->drawmyself=sdf;
  return(&(dleptr->data));
}




#define HIDEHIS 50  /* buffer will be reset if drawing in mode 1 */
int hidehis[HIDEHIS][4];
int nexthide=0;

void drawaddupdatelist(int x1, int y1,int x2, int y2) {
  if(directscreen==1) return;
  if(nexthide>=HIDEHIS) { /* this cant happen ? */
    pfprot("(hidehis overflow. grep for HIDEHIS. sorry)");
    for(nexthide=0;nexthide<HIDEHIS-1; nexthide++) {
      hidehis[nexthide][0]= hidehis[nexthide+1][0];
      hidehis[nexthide][1]= hidehis[nexthide+1][1];
      hidehis[nexthide][2]= hidehis[nexthide+1][2];
      hidehis[nexthide][3]= hidehis[nexthide+1][3];
    }    
  }
  hidehis[nexthide][0]=x1;
  hidehis[nexthide][1]=y1;
  hidehis[nexthide][2]=x2;
  hidehis[nexthide][3]=y2;
  nexthide++;
}

void updatelist(void) {
   while(nexthide>=1) { 
     --nexthide;
     (*vgaupdate)(hidehis[nexthide][0],
                  hidehis[nexthide][1],
                  hidehis[nexthide][2],
                  hidehis[nexthide][3]);
   } 
#if ALLSCREEN || CURSORSNOTONSCREEN
   vgascreen(1);   /* turn screen drawing on again */
#else
   vgascreen(0);
#endif
}

void updateall(void) {
#if NOTHINGONSCREEN
   (*vgaupdate)(0,0,vgaxdim-1,vgaydim-1);
   nexthide=0;  
#else
   updatelist();      /* will set vgascreen */
#endif
}

void drawupdatepage(void) {  /* this does a total reset */
#if NOTHINGONSCREEN || SCROLLONSCREEN
   vgascreen(0);
   drawpage(0,0,vgaxdim-1,vgaydim-1,1);
   (*vgaupdate)(0,0,vgaxdim-1,vgaydim-1);
#else
   vgascreen(1);
   drawpage(0,0,vgaxdim-1,vgaydim-1,1);
#endif
   nexthide=0;  
}


void drawhidemark(int x, int y) {
   tmpnomarks=1;
#if CURSORSNOTONSCREEN  /* switch drirect screen off */
   vgascreen(0);
#endif 
   drawpage(x-MARKSIZE,y-MARKSIZE,x+MARKSIZE,y+MARKSIZE,0);
} 

void drawshowmark(int x, int y, int col){
   int ms=MARKSIZE; 
   /* (*vgasetclip)(0,0,vgaxdim-1,vgaydim-1); */
   (*vgadrawrect)(x-ms,y,2*ms+1,1,vgadimm(BLACKCOL,0));
   (*vgadrawrect)(x,y-ms,1,2*ms+1,vgadimm(BLACKCOL,0));
   (*vgadrawrectbg)(x-ms,y-ms,2*ms+1,2*ms+1,col);
   drawaddupdatelist(x-ms,y-ms,x+ms,y+ms);
}

void showmarks(void){ 
  if(markon) 
    drawshowmark(marksxpxl,marksypxl,MARKSCOL); 
  if(hypon) 
    drawshowmark(marksxpxl,marksypxl,MARKHCOL); 
}

void showmarkd(void){    
  if(markon) 
  drawshowmark(MMTOPXL(markdxmm-visfmk->hoffmm)-dvixpos,
               MMTOPXL(markdymm-visfmk->voffmm)-dviypos,MARKDCOL);
}

void showmarkt(void){ 
  if(texton) {   
  (*vgadrawrectbg)(textx1pxl-dvixpos,texty1pxl-dviypos,
                   textx2pxl-textx1pxl+1, texty2pxl-texty1pxl+1,FOUNDCOL);
  (*vgadrawrectbg)(textx3pxl-dvixpos,texty3pxl-dviypos,
                   textx4pxl-textx3pxl+1, texty4pxl-texty3pxl+1,FOUNDCOL);
  drawaddupdatelist(textx1pxl-dvixpos,texty1pxl-dviypos,
                    textx2pxl-dvixpos,texty2pxl-dviypos);
  drawaddupdatelist(textx3pxl-dvixpos,texty3pxl-dviypos,
                    textx4pxl-dvixpos,texty4pxl-dviypos);
  }
} 

void drawshowallmarks(void) {
  showmarkd();
  showmarkt();
  showmarks();
}


void drawshowfixedmarksonly(void){ 
  if(markon) 
    drawshowmark(marksxpxl,marksypxl,MARKSCOL); 
  if(hypon) 
    drawshowmark(marksxpxl,marksypxl,MARKHCOL); 
}


void drawhidefixedmarksonly(void){ 
  if(markon==0 && hypon==0) return;  
  drawhidemark(marksxpxl,marksypxl);
  showmarkd(); /* for the case of intersection */
  showmarkt();
}

void drawhideallmarks(void){  
#if CURSORSNOTONSCREEN  /* switch drirect screen off */
  vgascreen(0);
#endif 
  if(markon!=0) {
    drawhidemark(MMTOPXL(markdxmm-visfmk->hoffmm)-dvixpos,
                 MMTOPXL(markdymm-visfmk->voffmm)-dviypos);
    drawhidemark(marksxpxl,marksypxl);
  }
  if(hypon!=0) {
    drawhidemark(marksxpxl,marksypxl);
  }
  if(texton!=0) {
    tmpnomarks=1; 
    drawpage(textx1pxl-dvixpos,texty1pxl-dviypos,
             textx2pxl-dvixpos,texty2pxl-dviypos,0);
    tmpnomarks=1;
    drawpage(textx3pxl-dvixpos,texty3pxl-dviypos,
             textx4pxl-dvixpos,texty4pxl-dviypos,0);
  }
} 



void drawhiderect(void) {
   int x, y, h, w;
   if(recton==0) return;
#if CURSORSNOTONSCREEN  /* switch drirect screen off */
   vgascreen(0);
#endif 
   x=-dvixpos+MMTOPXL(rectxmm-visfmk->hoffmm);
   y=-dviypos+MMTOPXL(rectymm-visfmk->voffmm);
   w=MMTOPXL(rectxmm-visfmk->hoffmm+rectwmm)-MMTOPXL(rectxmm-visfmk->hoffmm)+1;
   h=MMTOPXL(rectymm-visfmk->voffmm+recthmm)-MMTOPXL(rectymm-visfmk->voffmm)+1;
   recton=0;
   /*drawpage(x,y,x+w-1,y+h-1,0); */
   drawpage(x,y,x+w-1,y,0);
   drawpage(x,y+h-1,x+w-1,y+h-1,0);
   drawpage(x,y,x,y+h-1,0);
   drawpage(x+w-1,y,x+w-1,y+h-1,0);
   recton=1;
} 

void drawshowrect(void){
   int x, y, h, w;
   if(recton==0) return; 
   /*fprintf(prot,"(drawshowrect)");*/
   x=-dvixpos+MMTOPXL(rectxmm-visfmk->hoffmm);
   y=-dviypos+MMTOPXL(rectymm-visfmk->voffmm);
   w=MMTOPXL(rectxmm-visfmk->hoffmm+rectwmm)-MMTOPXL(rectxmm-visfmk->hoffmm)+1;
   h=MMTOPXL(rectymm-visfmk->voffmm+recthmm)-MMTOPXL(rectymm-visfmk->voffmm)+1;
   (*vgadrawrect)(x,y,w,1,RECTCOL);
   (*vgadrawrect)(x,y+h-1,w,1,RECTCOL);
   (*vgadrawrect)(x,y,1,h,RECTCOL);
   (*vgadrawrect)(x+w-1,y,1,h,RECTCOL);
   drawaddupdatelist(x,y,x+w-1,y);
   drawaddupdatelist(x,y+h-1,x+w-1,y+h-1);
   drawaddupdatelist(x,y,x,y+h-1);
   drawaddupdatelist(x+w-1,y,x+w-1,y+h-1);
}


void drawhideallmarksandrect(void){  
  if(!recton){
    drawhideallmarks();
    return;
  }
  drawhiderect();
  recton=0;
  drawhideallmarks();
  recton=1;
}


void drawcharbmp(drawlistdata* arg) { 
  chdesc *thechar;

  /*fprintf(prot,"<High, its me. CharBmp. lets see>\n");*/
 
  thechar=(*arg).chr.chdp;  
  if(thechar->bmp.bits == NULL) pkloadchar(thechar);
  else touchlrumem(&(thechar->bmp.bits));
 (*vgacopybitmapbw)( (*arg).chr.h -thexpos -thechar->hof,
                     (*arg).chr.v -theypos -thechar->vof, 
                     thechar->bmp.w,
                     thechar->bmp.h,
                     thechar->bmp.bits,
                     (*arg).chr.c);
}

void drawcharbmp2bw(drawlistdata* arg) {  
  chdesc *thechar;

  /*fprintf(prot,"<High, its me. CharBmp2BW. lets see>\n");*/

  thechar=(*arg).chr.chdp;  
  if((thechar->bmp2.bits == NULL) || (thechar->shrink != fshrink) 
      || (thechar->bmp2.type != BLACKNWHITE)) {
    if(thechar->bmp.bits == NULL) pkloadchar(thechar);
    pkshrinkcharazbw(thechar);
  } else touchlrumem(&(thechar->bmp2.bits));
  (*vgacopybitmapbw)((*arg).chr.h -thexpos -thechar->hof2,
                     (*arg).chr.v -theypos -thechar->vof2, 
                     thechar->bmp2.w,
                     thechar->bmp2.h,
                     thechar->bmp2.bits,
                     (*arg).chr.c);
}

void drawgscript(drawlistdata* arg){

  gslistelement* gse;

  gse=(*arg).gscript.gse;
  /*printf("<High, its me, Drawgscript (Bmp2BW) lets see>\n");*/
  /*printf("name=%s bits=0x%x  suspect=%d\n",
     gse->gsfile,gse->bmp.bits,gse->suspect); */
  if(   (gse->suspect!=B_OK) 
     || (gse->bmp.w== gse->bmp2.w &&  gse->bmp.bits == NULL) 
     || (gse->bmp.w!= gse->bmp2.w &&  gse->bmp2.bits == NULL)) {
    gsloadbmp(gse); /* wont happen: see speeduplsowstuff() */
  } 
  if(gse->suspect==B_OK && gse->bmp.w== gse->bmp2.w) { 
    touchlrumem(&(gse->bmp.bits));
    (*vgacopybitmapbw)((*arg).gscript.h -thexpos,
                       (*arg).gscript.v -theypos, 
                       gse->bmp.w,
                       gse->bmp.h,
                       gse->bmp.bits,
                       0); /* do not dimm gscript */
  }
  if(gse->suspect==B_OK && gse->bmp.w!= gse->bmp2.w) { 
    touchlrumem(&(gse->bmp2.bits));
    (*vgacopybitmapgs)((*arg).gscript.h -thexpos,
                       (*arg).gscript.v -theypos, 
                       gse->bmp2.w,
                       gse->bmp2.h,
                       gse->bmp2.bits,
                       0); /* do not dimm gscript */
  }
  /*printf("<!!!Drawgscript DONE :-)\n"); */
}


void drawcharbmp2gs(drawlistdata* arg) {  
  chdesc *thechar;

#ifdef DEBUGDRAW        
  pfprot("(CharBmp2GS ");
#endif
 
  thechar=(*arg).chr.chdp;  
  if((thechar->bmp2.bits == NULL) || (thechar->shrink != fshrink) 
      || (thechar->bmp2.type != GREYSCALE)) {
    if(thechar->bmp.bits == NULL) pkloadchar(thechar);
    pkshrinkcharazprecgs(thechar);
  } else touchlrumem(&(thechar->bmp2.bits));
#ifdef DEBUGDRAW        
  pfprot(" call vgacopybitmapgs ");
#endif
  (*vgacopybitmapgs)((*arg).chr.h -thexpos -thechar->hof2,
                     (*arg).chr.v -theypos -thechar->vof2, 
                     thechar->bmp2.w,
                     thechar->bmp2.h,
                     thechar->bmp2.bits,
                     (*arg).chr.c);
#ifdef DEBUGDRAW        
  pfprot(" done)");
#endif
}



void drawruleor(drawlistdata* arg) {
  (*vgadrawrector)( (*arg).rect.x-thexpos, 
                    (*arg).rect.y-theypos, 
                    (*arg).rect.w, 
                    (*arg).rect.h, 
                    (*arg).rect.c);
} 

void drawrulebg(drawlistdata* arg) {
  (*vgadrawrectbg)( (*arg).rect.x-thexpos, 
                    (*arg).rect.y-theypos, 
                    (*arg).rect.w, 
                    (*arg).rect.h, 
                    (*arg).rect.c);
} 


/* 
drawpage() is split up into faststuff, slowstuff, finalstuff.
*/

int drawpagefaststuff(pagelistelement* apage, int x1, int y1, int x2, int y2) {
  drawlistelement *eptr;
  long i, didskipslowstuff;

#ifdef DEBUGDRAW        
  pfprot("(drawpagefaststuff ...");
#endif
  if(apage==NULL) return(0);
  readpage(apage);
  if(apage->drawlist==NULL) return(0);
  thedrawpage=apage;
  thexpos=dvixpos-thedrawpage->xoffset;
  theypos=dviypos-thedrawpage->yoffset;
  locklrumem(&(thedrawpage->drawlist)); 
  eptr=thedrawpage->drawlist;
  for(i=0; i<thedrawpage->ndraws; i++, eptr++) {
    if(eptr->drawmyself!=drawgscript)
      eptr->drawmyself(&(eptr->data));
  }
  didskipslowstuff=0;
  eptr=thedrawpage->drawlist;
  for(i=0; i<thedrawpage->ndraws; i++, eptr++) {
    if(eptr->drawmyself==drawgscript){
      if(eptr->data.gscript.gse->suspect==B_OK)
        eptr->drawmyself(&(eptr->data)); 
      else 
        didskipslowstuff=1;
    }
  }
  unlocklrumem(&(thedrawpage->drawlist)); 
#ifdef DEBUGDRAW        
  pfprot("drawpagefaststuff: done)");
#endif
  return(didskipslowstuff);
}


void drawpagefinalstuff(pagelistelement *apage,int x1,int y1,int x2,int y2){
  HTeX_Anchor *HTeXAp;
  int i;

#ifdef DEBUGDRAW        
  pfprot("(drawpagefinalstuff ...");
#endif
  if(apage==NULL) return;
  thedrawpage=apage;
  thexpos=dvixpos-thedrawpage->xoffset;
  theypos=dviypos-thedrawpage->yoffset;
  /* boarder = paper farme */
  (*vgadrawrect)(-thexpos-MMTOPXL(visfmk->hoffmm)-1,
                 -theypos-MMTOPXL(visfmk->voffmm)-1,
                  MMTOPXL(visfmk->papxmm)+3,1,BORDERCOL);
  (*vgadrawrect)(-thexpos-MMTOPXL(visfmk->hoffmm)-1,
                 -theypos-MMTOPXL(visfmk->voffmm)-1,
                  1,MMTOPXL(visfmk->papymm)+3,BORDERCOL);
  (*vgadrawrect)(-thexpos-MMTOPXL(visfmk->hoffmm)-1,
                 -theypos-MMTOPXL(visfmk->voffmm)+MMTOPXL(visfmk->papymm)+1,
                  MMTOPXL(visfmk->papxmm)+3,1,BORDERCOL);
  (*vgadrawrect)(-thexpos-MMTOPXL(visfmk->hoffmm)+MMTOPXL(visfmk->papxmm)+1,
                 -theypos-MMTOPXL(visfmk->voffmm)-1,
                  1,MMTOPXL(visfmk->papymm)+3,BORDERCOL);
  if(frameon){
    /* draw  frame */
    (*vgadrawrect)(
    -thexpos-MMTOPXL(visfmk->hoffmm)+MMTOPXL(visfmk->lrandmm)-1,
    -theypos-MMTOPXL(visfmk->voffmm)+MMTOPXL(visfmk->orandmm)-1,
    MMTOPXL(visfmk->papxmm-visfmk->rrandmm)-
    MMTOPXL(visfmk->lrandmm)+3,1,FRAMECOL);
    (*vgadrawrect)(
    -thexpos-MMTOPXL(visfmk->hoffmm)+MMTOPXL(visfmk->lrandmm)-1,
    -theypos-MMTOPXL(visfmk->voffmm)+MMTOPXL(visfmk->papymm-visfmk->urandmm)+1,
    MMTOPXL(visfmk->papxmm-visfmk->rrandmm)-
    MMTOPXL(visfmk->lrandmm)+3,1,FRAMECOL);
    (*vgadrawrect)(
    -thexpos-MMTOPXL(visfmk->hoffmm)+MMTOPXL(visfmk->lrandmm)-1,
    -theypos-MMTOPXL(visfmk->voffmm)+MMTOPXL(visfmk->orandmm)-1,
    1,MMTOPXL(visfmk->papymm-visfmk->urandmm)-
    MMTOPXL(visfmk->orandmm)+3,FRAMECOL);
    (*vgadrawrect)(
    -thexpos-MMTOPXL(visfmk->hoffmm)+
    MMTOPXL(visfmk->papxmm-visfmk->rrandmm)+1,
    -theypos-MMTOPXL(visfmk->voffmm)+MMTOPXL(visfmk->orandmm)-1,
    1,MMTOPXL(visfmk->papymm-visfmk->urandmm)-
    MMTOPXL(visfmk->orandmm)+3,FRAMECOL);
  }
  /*if(apage==cpage) */
  drawshowrect();
  /* fprintf(prot,"(read tmp %d)",tmpnomarks); */
  if(hypon) {
    HTeXAp = apage->anchorlist;
    for (i=0; i < apage->nanchors; i++, HTeXAp++) {
      if ((HTeXAp->type&HTeX_A_HREF) == 0) continue; /* Only box hrefs */
        vgadrawrectbg(HTeXAp->x1pxl-thexpos,HTeXAp->y1pxl-theypos, 
      HTeXAp->x2pxl-HTeXAp->x1pxl+1,HTeXAp->y2pxl-HTeXAp->y1pxl+1,HREFCOL);
    }
  }
#ifdef DEBUGDRAW        
  pfprot("drawpagefinalstuff: done)");
#endif
}

int speedx1, speedx2, speedy1, speedy2;

int speedupslowstuff(pagelistelement* apage,int x1, int y1, int x2, int y2) {
  drawlistelement *eptr;
  int didsomeslowstuff;
  long i;

#ifdef DEBUGDRAW        
  pfprot("(speedupslowstuff ...");
#endif
  if(apage==NULL) {
#ifdef DEBUGDRAW        
    pfprot("apege=null)");
#endif
    return(B_SUSPECT);
  }
  readpage(apage);
  if(apage->drawlist==NULL) return(B_SUSPECT);
  thedrawpage=apage;
  thexpos=dvixpos-thedrawpage->xoffset;
  theypos=dviypos-thedrawpage->yoffset;
  locklrumem(&(thedrawpage->drawlist)); 
  didsomeslowstuff=B_SUSPECT;
  eptr=thedrawpage->drawlist;
  for(i=0; i<thedrawpage->ndraws &&  didsomeslowstuff==B_SUSPECT; i++, eptr++) {
    if(eptr->drawmyself==drawgscript){
      if(   eptr->data.gscript.gse->suspect==B_SUSPECT
         || eptr->data.gscript.gse->suspect==B_SKIPONCE){
       gsloadbmp(eptr->data.gscript.gse);
       didsomeslowstuff=eptr->data.gscript.gse->suspect;
       if(eptr->data.gscript.gse->suspect==B_OK) {
          speedx1=eptr->data.gscript.h -thexpos,
          speedy1=eptr->data.gscript.v -theypos,
          speedx2=eptr->data.gscript.h -thexpos +eptr->data.gscript.gse->bmp2.w -1,
          speedy2=eptr->data.gscript.v -theypos +eptr->data.gscript.gse->bmp2.h -1;
        }
      }
    }
  }
  unlocklrumem(&(thedrawpage->drawlist)); 
#ifdef DEBUGDRAW        
  pfprot("speedupslowstuff: done)");
#endif
  return(didsomeslowstuff);
}


void drawpage(int x1, int y1, int x2, int y2, int speedup) {
  int dssscp=0;
  int dssspp=0;

#ifdef DEBUGDRAW        
  pfprot("(drawpage: dest: %d %d %d %d dvipos %d %d ...",
              x1,y1,x2,y2,dvixpos,dviypos);
#endif
  if(visfmk==NULL) return;
  if(x1<0) x1=0; if(y1<0) y1=0;
  if(x2>vgaxdim-1) x2=vgaxdim-1;
  if(y2>vgaydim-1) y2=vgaydim-1;
  if(x2<x1 || y2<y1) return;  
  (*vgasetclip)(x1,y1,x2,y2);
  (*vgadrawrect)(x1,y1,x2-x1+1,y2-y1+1,WHITECOL);
  /*Farbtest  ... */
  /*for(i=0;i<64;i++)
    (*vgadrawrect)(i*10,0,10,10,i);*/  
  dssspp=drawpagefaststuff(ppage,x1,y1,x2,y2);
  dssscp=drawpagefaststuff(cpage,x1,y1,x2,y2);
  if(!speedup || (!dssscp && !dssspp)) {
    drawpagefinalstuff(ppage,x1,y1,x2,y2);
    drawpagefinalstuff(cpage,x1,y1,x2,y2);
    if(tmpnomarks==0) drawshowallmarks();
    drawaddupdatelist(x1,y1,x2,y2);
  } else {
    /* did skip slow stuff and want to catch up */
    drawpagefinalstuff(ppage,x1,y1,x2,y2);
    drawpagefinalstuff(cpage,x1,y1,x2,y2);
    if(tmpnomarks==0) drawshowallmarks();
    drawaddupdatelist(x1,y1,x2,y2);
    updateall(); /* use "all" here. care! */   
    /* try to do the slow stuff: */
    while(speedupslowstuff(cpage,x1,y1,x2,y2)==B_OK) {
      /* some slow stuff is fast now: do the whole page again  */
      (*vgasetclip)(speedx1,speedy1,speedx2,speedy2);
      (*vgadrawrect)(0,0,vgaxdim,vgaydim,WHITECOL);
      drawpagefaststuff(cpage,0,0,vgaxdim-1,vgaydim-1);
      drawpagefinalstuff(cpage,0,0,vgaxdim-1,vgaydim-1);
      if(tmpnomarks==0) drawshowallmarks();
      drawaddupdatelist(speedx1,speedy1,speedx2,speedy2);
      updatelist();   
    }
    while(speedupslowstuff(ppage,x1,y1,x2,y2)==B_OK) {
      /* some slow stuff is fast now: do the whole page again  */
      (*vgasetclip)(speedx1,speedy1,speedx2,speedy2);
      (*vgadrawrect)(0,0,vgaxdim,vgaydim,WHITECOL);
      drawpagefaststuff(ppage,0,0,vgaxdim-1,vgaydim-1);
      drawpagefinalstuff(ppage,0,0,vgaxdim-1,vgaydim-1);
      if(tmpnomarks==0) drawshowallmarks();
      drawaddupdatelist(speedx1,speedy1,speedx2,speedy2);
      updatelist();   
    }
    if(tmpnomarks==0) drawshowallmarks();
  }
  (*vgasetclip)(0,0,vgaxdim-1,vgaydim-1);
  if(statusforce==1) drawstatusline();
  if(statusforce==2) statusforce=1; /* Hack: keep once */
  tmpnomarks=0;
#ifdef DEBUGDRAW        
  pfprot(" ... drawpage done)");
#endif
}


void drawsr(const char* str, int line, int pos, int len) {
  int i,slen;
  slen=strlen(str);
  pos=MAX(0,MIN(vgastatuslen,pos));
  len=MAX(0,MIN(len,vgastatuslen-pos));
  i=pos;
  for(;i < pos+len-slen; i++) vgadrawstatus(' ',line,i);
  for(;i < pos+len; i++) vgadrawstatus(str[slen-(len+pos-i)],line,i);
}

void drawsl(const char* str, int line, int pos, int len) {
  int i,slen,dlen;
  slen=strlen(str);
  pos=MAX(0,MIN(vgastatuslen,pos));
  len=MAX(0,MIN(len,vgastatuslen-pos));
  dlen=MIN(slen,len);
  for(i=0;i<dlen;i++)
    vgadrawstatus(str[i],line,pos+i);
  for(;i < len; i++) vgadrawstatus(' ',line,pos+i);
}

void drawsn(const char* str, int line,int pos) {
  drawsl(str,line,pos,strlen(str));
}


static char counterstr[10*10];
static int pagestrlen=0;
static int markstrlen=0;
static int lastarglen=0;

void setcounterstr(void) {
   int i,j;
   char bustr[20];
   if(cpage==NULL) {counterstr[0]=0; return;}
   for(i=9;i>0 && cpage->count[i] ==0; i--); 
   i=MAX(0,i);
   counterstr[0]=0;
   for(j=0;j<=i;j++) {
     sprintf(bustr,"%ld;",MIN(9999,MAX(-9999,cpage->count[j])));
     strcat(counterstr,bustr);
   }
   counterstr[strlen(counterstr)-1]=0;
 }


void drawstatusline(void); /* forward */
int doupdate=1;


void drawstatusmarks(void) {
  char bustr1[180], bustr2[180];
  char* refstr;
  int ol;

  if(cpage==NULL || visfmk==NULL) return;
  if(statusforce) {
    drawstatusline();
    return;
  }
  switch(statustype) {
  case 0:
    refstr=NULL;
    if(hypon) 
      if(!htex_withinanchor(cpage,dvixpos+marksxpxl, dviypos+marksypxl, &refstr))
        if(ppage!=NULL)
          htex_withinanchor(ppage,marksxpxl+dvixpos-ppage->xoffset, 
                              marksypxl+dviypos-ppage->yoffset, &refstr);
    if(refstr==NULL) {
      sprintf(bustr1,"(%%.%df,%%.%df) [%s]",unitcomma,unitcomma,unitname);
      sprintf(bustr2, bustr1, 
            mmtounit*(PXLTOMM(dvixpos+marksxpxl)+visfmk->hoffmm-markdxmm),
            mmtounit*(PXLTOMM(dviypos+marksypxl)+visfmk->voffmm-markdymm));
      ol=markstrlen;
      markstrlen=strlen(bustr2);
      drawsr(bustr2,0,vgastatuslen-MAX(ol,markstrlen),vgastatuslen);
    } else {
      strncpy(bustr1,refstr,100);
      bustr1[100]=0;
      sprintf(bustr2,"(%s)",bustr1);
      ol=markstrlen;
      markstrlen=strlen(bustr2);
      drawsr(bustr2,0,vgastatuslen-MAX(ol,markstrlen),vgastatuslen);
    }  
    break;
  case 1:
    sprintf(bustr1,"(%%6.%df,%%6.%df)  (%%6.%df,%%6.%df) [%s]",
               unitcomma,unitcomma,unitcomma,unitcomma,unitname);
    sprintf(bustr2, bustr1, 
             mmtounit*markdxmm, 
             mmtounit*markdymm,
             mmtounit*(PXLTOMM(dvixpos+marksxpxl)+visfmk->hoffmm-markdxmm), 
             mmtounit*(PXLTOMM(dviypos+marksypxl)+visfmk->voffmm-markdymm));
    markstrlen=strlen(bustr2);
    drawsr(bustr2,0,vgastatuslen-37,37);
    break;
  default: return;
  }
  if(doupdate) vgaupdatestatus();
}
    

void drawstatuspage(void) {
  char bustr[MAXPATHSTR+10*10];
  int ol;

  if(cpage==NULL || visfmk==NULL) return;
  if(statusforce) {
    drawstatusline();
    return;
  }
  switch(statustype) {
  case 0:
    setcounterstr();
    sprintf(bustr,"%s[%s]",dviname,counterstr);
    ol=pagestrlen;
    pagestrlen=strlen(bustr);
    drawsl(bustr,0,0,MAX(pagestrlen,ol));
    break;
  default: return;
  }
  if(doupdate) vgaupdatestatus();
}


void drawstatusarg(void) {
  char bustr[MAXARGSTR+MAXPATHSTR+10*11];

  if(cpage==NULL || visfmk==NULL) return;
  if(statusforce) {
    drawstatusline();
    return;
  }
  switch(statustype) {
  case 0:
    if(numberargstrlen>0) {
      numberargstr[numberargstrlen]=0;
      sprintf(bustr," <%s> ",numberargstr);
      drawsn(bustr,0,pagestrlen);
      lastarglen=1;
    } else {
      if(lastarglen>0) {
        drawsl(" ",0,pagestrlen,vgastatuslen);
        drawstatusmarks();
      }
      lastarglen=0;
    }
    break;
  default: return;
  }
  if(doupdate) vgaupdatestatus();
}

void drawstatuszoom(void) {
  char bustr[MAXARGSTR+MAXPATHSTR+10];
  if(cpage==NULL || visfmk==NULL) return;
  if(statusforce) {
    drawstatusline();
    return;
  }
  switch(statustype) {
  case 1:
    sprintf(bustr,"%.3f   ",1/fshrink);
    drawsn(bustr,0,5); 
    break;
  default: return;
  }
  if(doupdate) vgaupdatestatus();
}

void drawstatusline(void) {
  int i;
  /* fprintf(prot,"(drawstatusline ..."); fflush(prot); */
  if(vgastatuslines!=1) {
     i=vgastatuslines;
     vgasetstatuslines(1);
     drawpage(0,vgaydim-vgastatushight*(i+1),vgaxdim-1,vgaydim-1,1);
     (*vgaupdate)(0,vgaydim-vgastatushight*(i+1),vgaxdim-1,vgaydim-1);
  }
  if(cpage==NULL || visfmk==NULL) return;
  statusforce=0;
  doupdate=0;
  markstrlen=0; 
  pagestrlen=0;
  lastarglen=0;
  switch(statustype) {
  case 0:  
    drawsl(" ",0,0,vgastatuslen);
    break;
  case 1:  
    if(vgastatuslen>=70) {
      drawsl("ZOOM ",0,0,vgastatuslen);
      drawsn("PAGEMARK/SCREENMARK ",0,vgastatuslen-20-37);
    } else {
      drawsl("PM/SM ",0,0,vgastatuslen);
    }
    break;
  }
  /* fprintf(prot,"details ..."); fflush(prot); */
  drawstatuspage();            /* order is essential !!! */ 
  drawstatusmarks();
  drawstatusarg();
  drawstatuszoom();
  vgaupdatestatus();
  doupdate=1;
  /* fprintf(prot,")"); fflush(prot);*/
}
  

  
  
  






