/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.comm;

import net.tinyos.comm.TOSCommJNI;

public class NativeSerial {
    protected long swigCPtr;
    protected boolean swigCMemOwn;
    private String myPortname = "";

    public NativeSerial(String string) {
        this(TOSCommJNI.new_NativeSerial(string), true);
    }

    private NativeSerial(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public boolean open() {
        if (!this.swigCMemOwn && !this.myPortname.matches("")) {
            this.swigCPtr = TOSCommJNI.new_NativeSerial(this.myPortname);
            this.swigCMemOwn = true;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.swigCPtr != 0L) {
            TOSCommJNI.NativeSerial_close(this.swigCPtr);
        }
    }

    protected NativeSerial() {
        this(0L, false);
    }

    protected void finalize() {
        this.delete();
    }

    public void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            TOSCommJNI.delete_NativeSerial(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(NativeSerial nativeSerial) {
        return nativeSerial == null ? 0L : nativeSerial.swigCPtr;
    }

    public void setSerialPortParams(int n, int n2, int n3, boolean bl) {
        TOSCommJNI.NativeSerial_setSerialPortParams(this.swigCPtr, n, n2, n3, bl);
    }

    public int getBaudRate() {
        return TOSCommJNI.NativeSerial_getBaudRate(this.swigCPtr);
    }

    public int getDataBits() {
        return TOSCommJNI.NativeSerial_getDataBits(this.swigCPtr);
    }

    public int getStopBits() {
        return TOSCommJNI.NativeSerial_getStopBits(this.swigCPtr);
    }

    public boolean getParity() {
        return TOSCommJNI.NativeSerial_getParity(this.swigCPtr);
    }

    public void notifyOn(int n, boolean bl) {
        if (this.swigCPtr != 0L) {
            TOSCommJNI.NativeSerial_notifyOn(this.swigCPtr, n, bl);
        }
    }

    public boolean isNotifyOn(int n) {
        return TOSCommJNI.NativeSerial_isNotifyOn(this.swigCPtr, n);
    }

    public boolean waitForEvent() {
        if (this.swigCPtr != 0L) {
            try {
                return TOSCommJNI.NativeSerial_waitForEvent(this.swigCPtr);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean cancelWait() {
        if (this.swigCPtr != 0L) {
            return TOSCommJNI.NativeSerial_cancelWait(this.swigCPtr);
        }
        return false;
    }

    public boolean didEventOccur(int n) {
        return TOSCommJNI.NativeSerial_didEventOccur(this.swigCPtr, n);
    }

    public void setDTR(boolean bl) {
        TOSCommJNI.NativeSerial_setDTR(this.swigCPtr, bl);
    }

    public void setRTS(boolean bl) {
        TOSCommJNI.NativeSerial_setRTS(this.swigCPtr, bl);
    }

    public boolean isDTR() {
        return TOSCommJNI.NativeSerial_isDTR(this.swigCPtr);
    }

    public boolean isRTS() {
        return TOSCommJNI.NativeSerial_isRTS(this.swigCPtr);
    }

    public boolean isCTS() {
        return TOSCommJNI.NativeSerial_isCTS(this.swigCPtr);
    }

    public boolean isDSR() {
        return TOSCommJNI.NativeSerial_isDSR(this.swigCPtr);
    }

    public boolean isRI() {
        return TOSCommJNI.NativeSerial_isRI(this.swigCPtr);
    }

    public boolean isCD() {
        return TOSCommJNI.NativeSerial_isCD(this.swigCPtr);
    }

    public void sendBreak(int n) {
        TOSCommJNI.NativeSerial_sendBreak(this.swigCPtr, n);
    }

    public int available() {
        try {
            return TOSCommJNI.NativeSerial_available(this.swigCPtr);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int read() {
        return TOSCommJNI.NativeSerial_read__SWIG_0(this.swigCPtr);
    }

    public int read(byte[] byArray, int n, int n2) {
        return TOSCommJNI.NativeSerial_read__SWIG_1(this.swigCPtr, byArray, n, n2);
    }

    public int write(int n) {
        return TOSCommJNI.NativeSerial_write__SWIG_0(this.swigCPtr, n);
    }

    public int write(byte[] byArray, int n, int n2) {
        return TOSCommJNI.NativeSerial_write__SWIG_1(this.swigCPtr, byArray, n, n2);
    }

    public static String getTOSCommMap() {
        return TOSCommJNI.NativeSerial_getTOSCommMap();
    }
}

