  
/******************************************************************************
* MODULE     : x11_colors.h
* DESCRIPTION: RGB colors following x11 naming conventions
* COPYRIGHT  : (C) 2014  François Poulain, Joris van der Hoeven
* NOTES      : Inspired from /usr/share/X11/rgb.txt
*              See also: https://en.wikipedia.org/wiki/X11_color_names
*******************************************************************************
* This software falls under the GNU general public license version 3 or later.
* It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
* in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
******************************************************************************/

#define RGB(r,g,b)  r, g, b 
static rgb_record X11Colors[] = {
  {"Snow"                 , RGB (255, 250, 250)}, 
  {"Ghost white"          , RGB (248, 248, 255)}, 
  {"Ghostwhite"           , RGB (248, 248, 255)}, 
  {"White smoke"          , RGB (245, 245, 245)}, 
  {"Whitesmoke"           , RGB (245, 245, 245)}, 
  {"Gainsboro"            , RGB (220, 220, 220)}, 
  {"Floral white"         , RGB (255, 250, 240)}, 
  {"Floralwhite"          , RGB (255, 250, 240)}, 
  {"Old lace"             , RGB (253, 245, 230)}, 
  {"Oldlace"              , RGB (253, 245, 230)}, 
  {"Linen"                , RGB (250, 240, 230)}, 
  {"Antique white"        , RGB (250, 235, 215)}, 
  {"Antiquewhite"         , RGB (250, 235, 215)}, 
  {"Papaya whip"          , RGB (255, 239, 213)}, 
  {"Papayawhip"           , RGB (255, 239, 213)}, 
  {"Blanched almond"      , RGB (255, 235, 205)}, 
  {"Blanchedalmond"       , RGB (255, 235, 205)}, 
  {"Bisque"               , RGB (255, 228, 196)}, 
  {"Peach puff"           , RGB (255, 218, 185)}, 
  {"Peachpuff"            , RGB (255, 218, 185)}, 
  {"Navajo white"         , RGB (255, 222, 173)}, 
  {"Navajowhite"          , RGB (255, 222, 173)}, 
  {"Moccasin"             , RGB (255, 228, 181)}, 
  {"Cornsilk"             , RGB (255, 248, 220)}, 
  {"Ivory"                , RGB (255, 255, 240)}, 
  {"Lemon chiffon"        , RGB (255, 250, 205)}, 
  {"Lemonchiffon"         , RGB (255, 250, 205)}, 
  {"Seashell"             , RGB (255, 245, 238)}, 
  {"Honeydew"             , RGB (240, 255, 240)}, 
  {"Mint cream"           , RGB (245, 255, 250)}, 
  {"Mintcream"            , RGB (245, 255, 250)}, 
  {"Azure"                , RGB (240, 255, 255)}, 
  {"Alice blue"           , RGB (240, 248, 255)}, 
  {"Aliceblue"            , RGB (240, 248, 255)}, 
  {"Lavender"             , RGB (230, 230, 250)}, 
  {"Lavender blush"       , RGB (255, 240, 245)}, 
  {"Lavenderblush"        , RGB (255, 240, 245)}, 
  {"Misty rose"           , RGB (255, 228, 225)}, 
  {"Mistyrose"            , RGB (255, 228, 225)}, 
  {"White"                , RGB (255, 255, 255)}, 
  {"Black"                , RGB (  0,   0,   0)}, 
  {"Dark slate"           , RGB ( 47,  79,  79)}, 
  {"Darkslategray"        , RGB ( 47,  79,  79)}, 
  {"Dark slate"           , RGB ( 47,  79,  79)}, 
  {"Darkslategrey"        , RGB ( 47,  79,  79)}, 
  {"Dim gray"             , RGB (105, 105, 105)}, 
  {"Dimgray"              , RGB (105, 105, 105)}, 
  {"Dim grey"             , RGB (105, 105, 105)}, 
  {"Dimgrey"              , RGB (105, 105, 105)}, 
  {"Slate gray"           , RGB (112, 128, 144)}, 
  {"Slategray"            , RGB (112, 128, 144)}, 
  {"Slate grey"           , RGB (112, 128, 144)}, 
  {"Slategrey"            , RGB (112, 128, 144)}, 
  {"Light slate"          , RGB (119, 136, 153)}, 
  {"Lightslategray"       , RGB (119, 136, 153)}, 
  {"Light slate"          , RGB (119, 136, 153)}, 
  {"Lightslategrey"       , RGB (119, 136, 153)}, 
  {"Gray"                 , RGB (190, 190, 190)}, 
  {"Grey"                 , RGB (190, 190, 190)}, 
  {"Light grey"           , RGB (211, 211, 211)}, 
  {"Lightgrey"            , RGB (211, 211, 211)}, 
  {"Light gray"           , RGB (211, 211, 211)}, 
  {"Lightgray"            , RGB (211, 211, 211)}, 
  {"Midnight blue"        , RGB ( 25,  25, 112)}, 
  {"Midnightblue"         , RGB ( 25,  25, 112)}, 
  {"Navy"                 , RGB (  0,   0, 128)}, 
  {"Navy blue"            , RGB (  0,   0, 128)}, 
  {"Navyblue"             , RGB (  0,   0, 128)}, 
  {"Cornflower blue"      , RGB (100, 149, 237)}, 
  {"Cornflowerblue"       , RGB (100, 149, 237)}, 
  {"Dark slate"           , RGB ( 72,  61, 139)}, 
  {"Darkslateblue"        , RGB ( 72,  61, 139)}, 
  {"Slate blue"           , RGB (106,  90, 205)}, 
  {"Slateblue"            , RGB (106,  90, 205)}, 
  {"Medium slate"         , RGB (123, 104, 238)}, 
  {"Mediumslateblue"      , RGB (123, 104, 238)}, 
  {"Light slate"          , RGB (132, 112, 255)}, 
  {"Lightslateblue"       , RGB (132, 112, 255)}, 
  {"Medium blue"          , RGB (  0,   0, 205)}, 
  {"Mediumblue"           , RGB (  0,   0, 205)}, 
  {"Royal blue"           , RGB ( 65, 105, 225)}, 
  {"Royalblue"            , RGB ( 65, 105, 225)}, 
  {"Blue"                 , RGB (  0,   0, 255)}, 
  {"Dodger blue"          , RGB ( 30, 144, 255)}, 
  {"Dodgerblue"           , RGB ( 30, 144, 255)}, 
  {"Deep sky"             , RGB (  0, 191, 255)}, 
  {"Deepskyblue"          , RGB (  0, 191, 255)}, 
  {"Sky blue"             , RGB (135, 206, 235)}, 
  {"Skyblue"              , RGB (135, 206, 235)}, 
  {"Light sky"            , RGB (135, 206, 250)}, 
  {"Lightskyblue"         , RGB (135, 206, 250)}, 
  {"Steel blue"           , RGB ( 70, 130, 180)}, 
  {"Steelblue"            , RGB ( 70, 130, 180)}, 
  {"Light steel"          , RGB (176, 196, 222)}, 
  {"Lightsteelblue"       , RGB (176, 196, 222)}, 
  {"Light blue"           , RGB (173, 216, 230)}, 
  {"Lightblue"            , RGB (173, 216, 230)}, 
  {"Powder blue"          , RGB (176, 224, 230)}, 
  {"Powderblue"           , RGB (176, 224, 230)}, 
  {"Pale turquoise"       , RGB (175, 238, 238)}, 
  {"Paleturquoise"        , RGB (175, 238, 238)}, 
  {"Dark turquoise"       , RGB (  0, 206, 209)}, 
  {"Darkturquoise"        , RGB (  0, 206, 209)}, 
  {"Medium turquoise"     , RGB ( 72, 209, 204)}, 
  {"Mediumturquoise"      , RGB ( 72, 209, 204)}, 
  {"Turquoise"            , RGB ( 64, 224, 208)}, 
  {"Cyan"                 , RGB (  0, 255, 255)}, 
  {"Light cyan"           , RGB (224, 255, 255)}, 
  {"Lightcyan"            , RGB (224, 255, 255)}, 
  {"Cadet blue"           , RGB ( 95, 158, 160)}, 
  {"Cadetblue"            , RGB ( 95, 158, 160)}, 
  {"Medium aquamarine"    , RGB (102, 205, 170)}, 
  {"Mediumaquamarine"     , RGB (102, 205, 170)}, 
  {"Aquamarine"           , RGB (127, 255, 212)}, 
  {"Dark green"           , RGB (  0, 100,   0)}, 
  {"Darkgreen"            , RGB (  0, 100,   0)}, 
  {"Dark olive"           , RGB ( 85, 107,  47)}, 
  {"Darkolivegreen"       , RGB ( 85, 107,  47)}, 
  {"Dark sea"             , RGB (143, 188, 143)}, 
  {"Darkseagreen"         , RGB (143, 188, 143)}, 
  {"Sea green"            , RGB ( 46, 139,  87)}, 
  {"Seagreen"             , RGB ( 46, 139,  87)}, 
  {"Medium sea"           , RGB ( 60, 179, 113)}, 
  {"Mediumseagreen"       , RGB ( 60, 179, 113)}, 
  {"Light sea"            , RGB ( 32, 178, 170)}, 
  {"Lightseagreen"        , RGB ( 32, 178, 170)}, 
  {"Pale green"           , RGB (152, 251, 152)}, 
  {"Palegreen"            , RGB (152, 251, 152)}, 
  {"Spring green"         , RGB (  0, 255, 127)}, 
  {"Springgreen"          , RGB (  0, 255, 127)}, 
  {"Lawn green"           , RGB (124, 252,   0)}, 
  {"Lawngreen"            , RGB (124, 252,   0)}, 
  {"Green"                , RGB (  0, 255,   0)}, 
  {"Chartreuse"           , RGB (127, 255,   0)}, 
  {"Medium spring"        , RGB (  0, 250, 154)}, 
  {"Mediumspringgreen"    , RGB (  0, 250, 154)}, 
  {"Green yellow"         , RGB (173, 255,  47)}, 
  {"Greenyellow"          , RGB (173, 255,  47)}, 
  {"Lime green"           , RGB ( 50, 205,  50)}, 
  {"Limegreen"            , RGB ( 50, 205,  50)}, 
  {"Yellow green"         , RGB (154, 205,  50)}, 
  {"Yellowgreen"          , RGB (154, 205,  50)}, 
  {"Forest green"         , RGB ( 34, 139,  34)}, 
  {"Forestgreen"          , RGB ( 34, 139,  34)}, 
  {"Olive drab"           , RGB (107, 142,  35)}, 
  {"Olivedrab"            , RGB (107, 142,  35)}, 
  {"Dark khaki"           , RGB (189, 183, 107)}, 
  {"Darkkhaki"            , RGB (189, 183, 107)}, 
  {"Khaki"                , RGB (240, 230, 140)}, 
  {"Pale goldenrod"       , RGB (238, 232, 170)}, 
  {"Palegoldenrod"        , RGB (238, 232, 170)}, 
  {"Light goldenrod"      , RGB (250, 250, 210)}, 
  {"Lightgoldenrodyellow" , RGB (250, 250, 210)}, 
  {"Light yellow"         , RGB (255, 255, 224)}, 
  {"Lightyellow"          , RGB (255, 255, 224)}, 
  {"Yellow"               , RGB (255, 255,   0)}, 
  {"Gold"                 , RGB (255, 215,   0)}, 
  {"Light goldenrod"      , RGB (238, 221, 130)}, 
  {"Lightgoldenrod"       , RGB (238, 221, 130)}, 
  {"Goldenrod"            , RGB (218, 165,  32)}, 
  {"Dark goldenrod"       , RGB (184, 134,  11)}, 
  {"Darkgoldenrod"        , RGB (184, 134,  11)}, 
  {"Rosy brown"           , RGB (188, 143, 143)}, 
  {"Rosybrown"            , RGB (188, 143, 143)}, 
  {"Indian red"           , RGB (205,  92,  92)}, 
  {"Indianred"            , RGB (205,  92,  92)}, 
  {"Saddle brown"         , RGB (139,  69,  19)}, 
  {"Saddlebrown"          , RGB (139,  69,  19)}, 
  {"Sienna"               , RGB (160,  82,  45)}, 
  {"Peru"                 , RGB (205, 133,  63)}, 
  {"Burlywood"            , RGB (222, 184, 135)}, 
  {"Beige"                , RGB (245, 245, 220)}, 
  {"Wheat"                , RGB (245, 222, 179)}, 
  {"Sandy brown"          , RGB (244, 164,  96)}, 
  {"Sandybrown"           , RGB (244, 164,  96)}, 
  {"Tan"                  , RGB (210, 180, 140)}, 
  {"Chocolate"            , RGB (210, 105,  30)}, 
  {"Firebrick"            , RGB (178,  34,  34)}, 
  {"Brown"                , RGB (165,  42,  42)}, 
  {"Dark salmon"          , RGB (233, 150, 122)}, 
  {"Darksalmon"           , RGB (233, 150, 122)}, 
  {"Salmon"               , RGB (250, 128, 114)}, 
  {"Light salmon"         , RGB (255, 160, 122)}, 
  {"Lightsalmon"          , RGB (255, 160, 122)}, 
  {"Orange"               , RGB (255, 165,   0)}, 
  {"Dark orange"          , RGB (255, 140,   0)}, 
  {"Darkorange"           , RGB (255, 140,   0)}, 
  {"Coral"                , RGB (255, 127,  80)}, 
  {"Light coral"          , RGB (240, 128, 128)}, 
  {"Lightcoral"           , RGB (240, 128, 128)}, 
  {"Tomato"               , RGB (255,  99,  71)}, 
  {"Orange red"           , RGB (255,  69,   0)}, 
  {"Orangered"            , RGB (255,  69,   0)}, 
  {"Red"                  , RGB (255,   0,   0)}, 
  {"Hot pink"             , RGB (255, 105, 180)}, 
  {"Hotpink"              , RGB (255, 105, 180)}, 
  {"Deep pink"            , RGB (255,  20, 147)}, 
  {"Deeppink"             , RGB (255,  20, 147)}, 
  {"Pink"                 , RGB (255, 192, 203)}, 
  {"Light pink"           , RGB (255, 182, 193)}, 
  {"Lightpink"            , RGB (255, 182, 193)}, 
  {"Pale violet"          , RGB (219, 112, 147)}, 
  {"Palevioletred"        , RGB (219, 112, 147)}, 
  {"Maroon"               , RGB (176,  48,  96)}, 
  {"Medium violet"        , RGB (199,  21, 133)}, 
  {"Mediumvioletred"      , RGB (199,  21, 133)}, 
  {"Violet red"           , RGB (208,  32, 144)}, 
  {"Violetred"            , RGB (208,  32, 144)}, 
  {"Magenta"              , RGB (255,   0, 255)}, 
  {"Violet"               , RGB (238, 130, 238)}, 
  {"Plum"                 , RGB (221, 160, 221)}, 
  {"Orchid"               , RGB (218, 112, 214)}, 
  {"Medium orchid"        , RGB (186,  85, 211)}, 
  {"Mediumorchid"         , RGB (186,  85, 211)}, 
  {"Dark orchid"          , RGB (153,  50, 204)}, 
  {"Darkorchid"           , RGB (153,  50, 204)}, 
  {"Dark violet"          , RGB (148,   0, 211)}, 
  {"Darkviolet"           , RGB (148,   0, 211)}, 
  {"Blue violet"          , RGB (138,  43, 226)}, 
  {"Blueviolet"           , RGB (138,  43, 226)}, 
  {"Purple"               , RGB (160,  32, 240)}, 
  {"Medium purple"        , RGB (147, 112, 219)}, 
  {"Mediumpurple"         , RGB (147, 112, 219)}, 
  {"Thistle"              , RGB (216, 191, 216)}, 
  {"Snow1"                , RGB (255, 250, 250)}, 
  {"Snow2"                , RGB (238, 233, 233)}, 
  {"Snow3"                , RGB (205, 201, 201)}, 
  {"Snow4"                , RGB (139, 137, 137)}, 
  {"Seashell1"            , RGB (255, 245, 238)}, 
  {"Seashell2"            , RGB (238, 229, 222)}, 
  {"Seashell3"            , RGB (205, 197, 191)}, 
  {"Seashell4"            , RGB (139, 134, 130)}, 
  {"Antiquewhite1"        , RGB (255, 239, 219)}, 
  {"Antiquewhite2"        , RGB (238, 223, 204)}, 
  {"Antiquewhite3"        , RGB (205, 192, 176)}, 
  {"Antiquewhite4"        , RGB (139, 131, 120)}, 
  {"Bisque1"              , RGB (255, 228, 196)}, 
  {"Bisque2"              , RGB (238, 213, 183)}, 
  {"Bisque3"              , RGB (205, 183, 158)}, 
  {"Bisque4"              , RGB (139, 125, 107)}, 
  {"Peachpuff1"           , RGB (255, 218, 185)}, 
  {"Peachpuff2"           , RGB (238, 203, 173)}, 
  {"Peachpuff3"           , RGB (205, 175, 149)}, 
  {"Peachpuff4"           , RGB (139, 119, 101)}, 
  {"Navajowhite1"         , RGB (255, 222, 173)}, 
  {"Navajowhite2"         , RGB (238, 207, 161)}, 
  {"Navajowhite3"         , RGB (205, 179, 139)}, 
  {"Navajowhite4"         , RGB (139, 121,  94)}, 
  {"Lemonchiffon1"        , RGB (255, 250, 205)}, 
  {"Lemonchiffon2"        , RGB (238, 233, 191)}, 
  {"Lemonchiffon3"        , RGB (205, 201, 165)}, 
  {"Lemonchiffon4"        , RGB (139, 137, 112)}, 
  {"Cornsilk1"            , RGB (255, 248, 220)}, 
  {"Cornsilk2"            , RGB (238, 232, 205)}, 
  {"Cornsilk3"            , RGB (205, 200, 177)}, 
  {"Cornsilk4"            , RGB (139, 136, 120)}, 
  {"Ivory1"               , RGB (255, 255, 240)}, 
  {"Ivory2"               , RGB (238, 238, 224)}, 
  {"Ivory3"               , RGB (205, 205, 193)}, 
  {"Ivory4"               , RGB (139, 139, 131)}, 
  {"Honeydew1"            , RGB (240, 255, 240)}, 
  {"Honeydew2"            , RGB (224, 238, 224)}, 
  {"Honeydew3"            , RGB (193, 205, 193)}, 
  {"Honeydew4"            , RGB (131, 139, 131)}, 
  {"Lavenderblush1"       , RGB (255, 240, 245)}, 
  {"Lavenderblush2"       , RGB (238, 224, 229)}, 
  {"Lavenderblush3"       , RGB (205, 193, 197)}, 
  {"Lavenderblush4"       , RGB (139, 131, 134)}, 
  {"Mistyrose1"           , RGB (255, 228, 225)}, 
  {"Mistyrose2"           , RGB (238, 213, 210)}, 
  {"Mistyrose3"           , RGB (205, 183, 181)}, 
  {"Mistyrose4"           , RGB (139, 125, 123)}, 
  {"Azure1"               , RGB (240, 255, 255)}, 
  {"Azure2"               , RGB (224, 238, 238)}, 
  {"Azure3"               , RGB (193, 205, 205)}, 
  {"Azure4"               , RGB (131, 139, 139)}, 
  {"Slateblue1"           , RGB (131, 111, 255)}, 
  {"Slateblue2"           , RGB (122, 103, 238)}, 
  {"Slateblue3"           , RGB (105,  89, 205)}, 
  {"Slateblue4"           , RGB ( 71,  60, 139)}, 
  {"Royalblue1"           , RGB ( 72, 118, 255)}, 
  {"Royalblue2"           , RGB ( 67, 110, 238)}, 
  {"Royalblue3"           , RGB ( 58,  95, 205)}, 
  {"Royalblue4"           , RGB ( 39,  64, 139)}, 
  {"Blue1"                , RGB (  0,   0, 255)}, 
  {"Blue2"                , RGB (  0,   0, 238)}, 
  {"Blue3"                , RGB (  0,   0, 205)}, 
  {"Blue4"                , RGB (  0,   0, 139)}, 
  {"Dodgerblue1"          , RGB ( 30, 144, 255)}, 
  {"Dodgerblue2"          , RGB ( 28, 134, 238)}, 
  {"Dodgerblue3"          , RGB ( 24, 116, 205)}, 
  {"Dodgerblue4"          , RGB ( 16,  78, 139)}, 
  {"Steelblue1"           , RGB ( 99, 184, 255)}, 
  {"Steelblue2"           , RGB ( 92, 172, 238)}, 
  {"Steelblue3"           , RGB ( 79, 148, 205)}, 
  {"Steelblue4"           , RGB ( 54, 100, 139)}, 
  {"Deepskyblue1"         , RGB (  0, 191, 255)}, 
  {"Deepskyblue2"         , RGB (  0, 178, 238)}, 
  {"Deepskyblue3"         , RGB (  0, 154, 205)}, 
  {"Deepskyblue4"         , RGB (  0, 104, 139)}, 
  {"Skyblue1"             , RGB (135, 206, 255)}, 
  {"Skyblue2"             , RGB (126, 192, 238)}, 
  {"Skyblue3"             , RGB (108, 166, 205)}, 
  {"Skyblue4"             , RGB ( 74, 112, 139)}, 
  {"Lightskyblue1"        , RGB (176, 226, 255)}, 
  {"Lightskyblue2"        , RGB (164, 211, 238)}, 
  {"Lightskyblue3"        , RGB (141, 182, 205)}, 
  {"Lightskyblue4"        , RGB ( 96, 123, 139)}, 
  {"Slategray1"           , RGB (198, 226, 255)}, 
  {"Slategray2"           , RGB (185, 211, 238)}, 
  {"Slategray3"           , RGB (159, 182, 205)}, 
  {"Slategray4"           , RGB (108, 123, 139)}, 
  {"Lightsteelblue1"      , RGB (202, 225, 255)}, 
  {"Lightsteelblue2"      , RGB (188, 210, 238)}, 
  {"Lightsteelblue3"      , RGB (162, 181, 205)}, 
  {"Lightsteelblue4"      , RGB (110, 123, 139)}, 
  {"Lightblue1"           , RGB (191, 239, 255)}, 
  {"Lightblue2"           , RGB (178, 223, 238)}, 
  {"Lightblue3"           , RGB (154, 192, 205)}, 
  {"Lightblue4"           , RGB (104, 131, 139)}, 
  {"Lightcyan1"           , RGB (224, 255, 255)}, 
  {"Lightcyan2"           , RGB (209, 238, 238)}, 
  {"Lightcyan3"           , RGB (180, 205, 205)}, 
  {"Lightcyan4"           , RGB (122, 139, 139)}, 
  {"Paleturquoise1"       , RGB (187, 255, 255)}, 
  {"Paleturquoise2"       , RGB (174, 238, 238)}, 
  {"Paleturquoise3"       , RGB (150, 205, 205)}, 
  {"Paleturquoise4"       , RGB (102, 139, 139)}, 
  {"Cadetblue1"           , RGB (152, 245, 255)}, 
  {"Cadetblue2"           , RGB (142, 229, 238)}, 
  {"Cadetblue3"           , RGB (122, 197, 205)}, 
  {"Cadetblue4"           , RGB ( 83, 134, 139)}, 
  {"Turquoise1"           , RGB (  0, 245, 255)}, 
  {"Turquoise2"           , RGB (  0, 229, 238)}, 
  {"Turquoise3"           , RGB (  0, 197, 205)}, 
  {"Turquoise4"           , RGB (  0, 134, 139)}, 
  {"Cyan1"                , RGB (  0, 255, 255)}, 
  {"Cyan2"                , RGB (  0, 238, 238)}, 
  {"Cyan3"                , RGB (  0, 205, 205)}, 
  {"Cyan4"                , RGB (  0, 139, 139)}, 
  {"Darkslategray1"       , RGB (151, 255, 255)}, 
  {"Darkslategray2"       , RGB (141, 238, 238)}, 
  {"Darkslategray3"       , RGB (121, 205, 205)}, 
  {"Darkslategray4"       , RGB ( 82, 139, 139)}, 
  {"Aquamarine1"          , RGB (127, 255, 212)}, 
  {"Aquamarine2"          , RGB (118, 238, 198)}, 
  {"Aquamarine3"          , RGB (102, 205, 170)}, 
  {"Aquamarine4"          , RGB ( 69, 139, 116)}, 
  {"Darkseagreen1"        , RGB (193, 255, 193)}, 
  {"Darkseagreen2"        , RGB (180, 238, 180)}, 
  {"Darkseagreen3"        , RGB (155, 205, 155)}, 
  {"Darkseagreen4"        , RGB (105, 139, 105)}, 
  {"Seagreen1"            , RGB ( 84, 255, 159)}, 
  {"Seagreen2"            , RGB ( 78, 238, 148)}, 
  {"Seagreen3"            , RGB ( 67, 205, 128)}, 
  {"Seagreen4"            , RGB ( 46, 139,  87)}, 
  {"Palegreen1"           , RGB (154, 255, 154)}, 
  {"Palegreen2"           , RGB (144, 238, 144)}, 
  {"Palegreen3"           , RGB (124, 205, 124)}, 
  {"Palegreen4"           , RGB ( 84, 139,  84)}, 
  {"Springgreen1"         , RGB (  0, 255, 127)}, 
  {"Springgreen2"         , RGB (  0, 238, 118)}, 
  {"Springgreen3"         , RGB (  0, 205, 102)}, 
  {"Springgreen4"         , RGB (  0, 139,  69)}, 
  {"Green1"               , RGB (  0, 255,   0)}, 
  {"Green2"               , RGB (  0, 238,   0)}, 
  {"Green3"               , RGB (  0, 205,   0)}, 
  {"Green4"               , RGB (  0, 139,   0)}, 
  {"Chartreuse1"          , RGB (127, 255,   0)}, 
  {"Chartreuse2"          , RGB (118, 238,   0)}, 
  {"Chartreuse3"          , RGB (102, 205,   0)}, 
  {"Chartreuse4"          , RGB ( 69, 139,   0)}, 
  {"Olivedrab1"           , RGB (192, 255,  62)}, 
  {"Olivedrab2"           , RGB (179, 238,  58)}, 
  {"Olivedrab3"           , RGB (154, 205,  50)}, 
  {"Olivedrab4"           , RGB (105, 139,  34)}, 
  {"Darkolivegreen1"      , RGB (202, 255, 112)}, 
  {"Darkolivegreen2"      , RGB (188, 238, 104)}, 
  {"Darkolivegreen3"      , RGB (162, 205,  90)}, 
  {"Darkolivegreen4"      , RGB (110, 139,  61)}, 
  {"Khaki1"               , RGB (255, 246, 143)}, 
  {"Khaki2"               , RGB (238, 230, 133)}, 
  {"Khaki3"               , RGB (205, 198, 115)}, 
  {"Khaki4"               , RGB (139, 134,  78)}, 
  {"Lightgoldenrod1"      , RGB (255, 236, 139)}, 
  {"Lightgoldenrod2"      , RGB (238, 220, 130)}, 
  {"Lightgoldenrod3"      , RGB (205, 190, 112)}, 
  {"Lightgoldenrod4"      , RGB (139, 129,  76)}, 
  {"Lightyellow1"         , RGB (255, 255, 224)}, 
  {"Lightyellow2"         , RGB (238, 238, 209)}, 
  {"Lightyellow3"         , RGB (205, 205, 180)}, 
  {"Lightyellow4"         , RGB (139, 139, 122)}, 
  {"Yellow1"              , RGB (255, 255,   0)}, 
  {"Yellow2"              , RGB (238, 238,   0)}, 
  {"Yellow3"              , RGB (205, 205,   0)}, 
  {"Yellow4"              , RGB (139, 139,   0)}, 
  {"Gold1"                , RGB (255, 215,   0)}, 
  {"Gold2"                , RGB (238, 201,   0)}, 
  {"Gold3"                , RGB (205, 173,   0)}, 
  {"Gold4"                , RGB (139, 117,   0)}, 
  {"Goldenrod1"           , RGB (255, 193,  37)}, 
  {"Goldenrod2"           , RGB (238, 180,  34)}, 
  {"Goldenrod3"           , RGB (205, 155,  29)}, 
  {"Goldenrod4"           , RGB (139, 105,  20)}, 
  {"Darkgoldenrod1"       , RGB (255, 185,  15)}, 
  {"Darkgoldenrod2"       , RGB (238, 173,  14)}, 
  {"Darkgoldenrod3"       , RGB (205, 149,  12)}, 
  {"Darkgoldenrod4"       , RGB (139, 101,   8)}, 
  {"Rosybrown1"           , RGB (255, 193, 193)}, 
  {"Rosybrown2"           , RGB (238, 180, 180)}, 
  {"Rosybrown3"           , RGB (205, 155, 155)}, 
  {"Rosybrown4"           , RGB (139, 105, 105)}, 
  {"Indianred1"           , RGB (255, 106, 106)}, 
  {"Indianred2"           , RGB (238,  99,  99)}, 
  {"Indianred3"           , RGB (205,  85,  85)}, 
  {"Indianred4"           , RGB (139,  58,  58)}, 
  {"Sienna1"              , RGB (255, 130,  71)}, 
  {"Sienna2"              , RGB (238, 121,  66)}, 
  {"Sienna3"              , RGB (205, 104,  57)}, 
  {"Sienna4"              , RGB (139,  71,  38)}, 
  {"Burlywood1"           , RGB (255, 211, 155)}, 
  {"Burlywood2"           , RGB (238, 197, 145)}, 
  {"Burlywood3"           , RGB (205, 170, 125)}, 
  {"Burlywood4"           , RGB (139, 115,  85)}, 
  {"Wheat1"               , RGB (255, 231, 186)}, 
  {"Wheat2"               , RGB (238, 216, 174)}, 
  {"Wheat3"               , RGB (205, 186, 150)}, 
  {"Wheat4"               , RGB (139, 126, 102)}, 
  {"Tan1"                 , RGB (255, 165,  79)}, 
  {"Tan2"                 , RGB (238, 154,  73)}, 
  {"Tan3"                 , RGB (205, 133,  63)}, 
  {"Tan4"                 , RGB (139,  90,  43)}, 
  {"Chocolate1"           , RGB (255, 127,  36)}, 
  {"Chocolate2"           , RGB (238, 118,  33)}, 
  {"Chocolate3"           , RGB (205, 102,  29)}, 
  {"Chocolate4"           , RGB (139,  69,  19)}, 
  {"Firebrick1"           , RGB (255,  48,  48)}, 
  {"Firebrick2"           , RGB (238,  44,  44)}, 
  {"Firebrick3"           , RGB (205,  38,  38)}, 
  {"Firebrick4"           , RGB (139,  26,  26)}, 
  {"Brown1"               , RGB (255,  64,  64)}, 
  {"Brown2"               , RGB (238,  59,  59)}, 
  {"Brown3"               , RGB (205,  51,  51)}, 
  {"Brown4"               , RGB (139,  35,  35)}, 
  {"Salmon1"              , RGB (255, 140, 105)}, 
  {"Salmon2"              , RGB (238, 130,  98)}, 
  {"Salmon3"              , RGB (205, 112,  84)}, 
  {"Salmon4"              , RGB (139,  76,  57)}, 
  {"Lightsalmon1"         , RGB (255, 160, 122)}, 
  {"Lightsalmon2"         , RGB (238, 149, 114)}, 
  {"Lightsalmon3"         , RGB (205, 129,  98)}, 
  {"Lightsalmon4"         , RGB (139,  87,  66)}, 
  {"Orange1"              , RGB (255, 165,   0)}, 
  {"Orange2"              , RGB (238, 154,   0)}, 
  {"Orange3"              , RGB (205, 133,   0)}, 
  {"Orange4"              , RGB (139,  90,   0)}, 
  {"Darkorange1"          , RGB (255, 127,   0)}, 
  {"Darkorange2"          , RGB (238, 118,   0)}, 
  {"Darkorange3"          , RGB (205, 102,   0)}, 
  {"Darkorange4"          , RGB (139,  69,   0)}, 
  {"Coral1"               , RGB (255, 114,  86)}, 
  {"Coral2"               , RGB (238, 106,  80)}, 
  {"Coral3"               , RGB (205,  91,  69)}, 
  {"Coral4"               , RGB (139,  62,  47)}, 
  {"Tomato1"              , RGB (255,  99,  71)}, 
  {"Tomato2"              , RGB (238,  92,  66)}, 
  {"Tomato3"              , RGB (205,  79,  57)}, 
  {"Tomato4"              , RGB (139,  54,  38)}, 
  {"Orangered1"           , RGB (255,  69,   0)}, 
  {"Orangered2"           , RGB (238,  64,   0)}, 
  {"Orangered3"           , RGB (205,  55,   0)}, 
  {"Orangered4"           , RGB (139,  37,   0)}, 
  {"Red1"                 , RGB (255,   0,   0)}, 
  {"Red2"                 , RGB (238,   0,   0)}, 
  {"Red3"                 , RGB (205,   0,   0)}, 
  {"Red4"                 , RGB (139,   0,   0)}, 
  {"Debianred"            , RGB (215,   7,  81)}, 
  {"Deeppink1"            , RGB (255,  20, 147)}, 
  {"Deeppink2"            , RGB (238,  18, 137)}, 
  {"Deeppink3"            , RGB (205,  16, 118)}, 
  {"Deeppink4"            , RGB (139,  10,  80)}, 
  {"Hotpink1"             , RGB (255, 110, 180)}, 
  {"Hotpink2"             , RGB (238, 106, 167)}, 
  {"Hotpink3"             , RGB (205,  96, 144)}, 
  {"Hotpink4"             , RGB (139,  58,  98)}, 
  {"Pink1"                , RGB (255, 181, 197)}, 
  {"Pink2"                , RGB (238, 169, 184)}, 
  {"Pink3"                , RGB (205, 145, 158)}, 
  {"Pink4"                , RGB (139,  99, 108)}, 
  {"Lightpink1"           , RGB (255, 174, 185)}, 
  {"Lightpink2"           , RGB (238, 162, 173)}, 
  {"Lightpink3"           , RGB (205, 140, 149)}, 
  {"Lightpink4"           , RGB (139,  95, 101)}, 
  {"Palevioletred1"       , RGB (255, 130, 171)}, 
  {"Palevioletred2"       , RGB (238, 121, 159)}, 
  {"Palevioletred3"       , RGB (205, 104, 137)}, 
  {"Palevioletred4"       , RGB (139,  71,  93)}, 
  {"Maroon1"              , RGB (255,  52, 179)}, 
  {"Maroon2"              , RGB (238,  48, 167)}, 
  {"Maroon3"              , RGB (205,  41, 144)}, 
  {"Maroon4"              , RGB (139,  28,  98)}, 
  {"Violetred1"           , RGB (255,  62, 150)}, 
  {"Violetred2"           , RGB (238,  58, 140)}, 
  {"Violetred3"           , RGB (205,  50, 120)}, 
  {"Violetred4"           , RGB (139,  34,  82)}, 
  {"Magenta1"             , RGB (255,   0, 255)}, 
  {"Magenta2"             , RGB (238,   0, 238)}, 
  {"Magenta3"             , RGB (205,   0, 205)}, 
  {"Magenta4"             , RGB (139,   0, 139)}, 
  {"Orchid1"              , RGB (255, 131, 250)}, 
  {"Orchid2"              , RGB (238, 122, 233)}, 
  {"Orchid3"              , RGB (205, 105, 201)}, 
  {"Orchid4"              , RGB (139,  71, 137)}, 
  {"Plum1"                , RGB (255, 187, 255)}, 
  {"Plum2"                , RGB (238, 174, 238)}, 
  {"Plum3"                , RGB (205, 150, 205)}, 
  {"Plum4"                , RGB (139, 102, 139)}, 
  {"Mediumorchid1"        , RGB (224, 102, 255)}, 
  {"Mediumorchid2"        , RGB (209,  95, 238)}, 
  {"Mediumorchid3"        , RGB (180,  82, 205)}, 
  {"Mediumorchid4"        , RGB (122,  55, 139)}, 
  {"Darkorchid1"          , RGB (191,  62, 255)}, 
  {"Darkorchid2"          , RGB (178,  58, 238)}, 
  {"Darkorchid3"          , RGB (154,  50, 205)}, 
  {"Darkorchid4"          , RGB (104,  34, 139)}, 
  {"Purple1"              , RGB (155,  48, 255)}, 
  {"Purple2"              , RGB (145,  44, 238)}, 
  {"Purple3"              , RGB (125,  38, 205)}, 
  {"Purple4"              , RGB ( 85,  26, 139)}, 
  {"Mediumpurple1"        , RGB (171, 130, 255)}, 
  {"Mediumpurple2"        , RGB (159, 121, 238)}, 
  {"Mediumpurple3"        , RGB (137, 104, 205)}, 
  {"Mediumpurple4"        , RGB ( 93,  71, 139)}, 
  {"Thistle1"             , RGB (255, 225, 255)}, 
  {"Thistle2"             , RGB (238, 210, 238)}, 
  {"Thistle3"             , RGB (205, 181, 205)}, 
  {"Thistle4"             , RGB (139, 123, 139)}, 
  {"Gray0"                , RGB (  0,   0,   0)}, 
  {"Grey0"                , RGB (  0,   0,   0)}, 
  {"Gray1"                , RGB (  3,   3,   3)}, 
  {"Grey1"                , RGB (  3,   3,   3)}, 
  {"Gray2"                , RGB (  5,   5,   5)}, 
  {"Grey2"                , RGB (  5,   5,   5)}, 
  {"Gray3"                , RGB (  8,   8,   8)}, 
  {"Grey3"                , RGB (  8,   8,   8)}, 
  {"Gray4"                , RGB ( 10,  10,  10)}, 
  {"Grey4"                , RGB ( 10,  10,  10)}, 
  {"Gray5"                , RGB ( 13,  13,  13)}, 
  {"Grey5"                , RGB ( 13,  13,  13)}, 
  {"Gray6"                , RGB ( 15,  15,  15)}, 
  {"Grey6"                , RGB ( 15,  15,  15)}, 
  {"Gray7"                , RGB ( 18,  18,  18)}, 
  {"Grey7"                , RGB ( 18,  18,  18)}, 
  {"Gray8"                , RGB ( 20,  20,  20)}, 
  {"Grey8"                , RGB ( 20,  20,  20)}, 
  {"Gray9"                , RGB ( 23,  23,  23)}, 
  {"Grey9"                , RGB ( 23,  23,  23)}, 
  {"Gray10"               , RGB ( 26,  26,  26)}, 
  {"Grey10"               , RGB ( 26,  26,  26)}, 
  {"Gray11"               , RGB ( 28,  28,  28)}, 
  {"Grey11"               , RGB ( 28,  28,  28)}, 
  {"Gray12"               , RGB ( 31,  31,  31)}, 
  {"Grey12"               , RGB ( 31,  31,  31)}, 
  {"Gray13"               , RGB ( 33,  33,  33)}, 
  {"Grey13"               , RGB ( 33,  33,  33)}, 
  {"Gray14"               , RGB ( 36,  36,  36)}, 
  {"Grey14"               , RGB ( 36,  36,  36)}, 
  {"Gray15"               , RGB ( 38,  38,  38)}, 
  {"Grey15"               , RGB ( 38,  38,  38)}, 
  {"Gray16"               , RGB ( 41,  41,  41)}, 
  {"Grey16"               , RGB ( 41,  41,  41)}, 
  {"Gray17"               , RGB ( 43,  43,  43)}, 
  {"Grey17"               , RGB ( 43,  43,  43)}, 
  {"Gray18"               , RGB ( 46,  46,  46)}, 
  {"Grey18"               , RGB ( 46,  46,  46)}, 
  {"Gray19"               , RGB ( 48,  48,  48)}, 
  {"Grey19"               , RGB ( 48,  48,  48)}, 
  {"Gray20"               , RGB ( 51,  51,  51)}, 
  {"Grey20"               , RGB ( 51,  51,  51)}, 
  {"Gray21"               , RGB ( 54,  54,  54)}, 
  {"Grey21"               , RGB ( 54,  54,  54)}, 
  {"Gray22"               , RGB ( 56,  56,  56)}, 
  {"Grey22"               , RGB ( 56,  56,  56)}, 
  {"Gray23"               , RGB ( 59,  59,  59)}, 
  {"Grey23"               , RGB ( 59,  59,  59)}, 
  {"Gray24"               , RGB ( 61,  61,  61)}, 
  {"Grey24"               , RGB ( 61,  61,  61)}, 
  {"Gray25"               , RGB ( 64,  64,  64)}, 
  {"Grey25"               , RGB ( 64,  64,  64)}, 
  {"Gray26"               , RGB ( 66,  66,  66)}, 
  {"Grey26"               , RGB ( 66,  66,  66)}, 
  {"Gray27"               , RGB ( 69,  69,  69)}, 
  {"Grey27"               , RGB ( 69,  69,  69)}, 
  {"Gray28"               , RGB ( 71,  71,  71)}, 
  {"Grey28"               , RGB ( 71,  71,  71)}, 
  {"Gray29"               , RGB ( 74,  74,  74)}, 
  {"Grey29"               , RGB ( 74,  74,  74)}, 
  {"Gray30"               , RGB ( 77,  77,  77)}, 
  {"Grey30"               , RGB ( 77,  77,  77)}, 
  {"Gray31"               , RGB ( 79,  79,  79)}, 
  {"Grey31"               , RGB ( 79,  79,  79)}, 
  {"Gray32"               , RGB ( 82,  82,  82)}, 
  {"Grey32"               , RGB ( 82,  82,  82)}, 
  {"Gray33"               , RGB ( 84,  84,  84)}, 
  {"Grey33"               , RGB ( 84,  84,  84)}, 
  {"Gray34"               , RGB ( 87,  87,  87)}, 
  {"Grey34"               , RGB ( 87,  87,  87)}, 
  {"Gray35"               , RGB ( 89,  89,  89)}, 
  {"Grey35"               , RGB ( 89,  89,  89)}, 
  {"Gray36"               , RGB ( 92,  92,  92)}, 
  {"Grey36"               , RGB ( 92,  92,  92)}, 
  {"Gray37"               , RGB ( 94,  94,  94)}, 
  {"Grey37"               , RGB ( 94,  94,  94)}, 
  {"Gray38"               , RGB ( 97,  97,  97)}, 
  {"Grey38"               , RGB ( 97,  97,  97)}, 
  {"Gray39"               , RGB ( 99,  99,  99)}, 
  {"Grey39"               , RGB ( 99,  99,  99)}, 
  {"Gray40"               , RGB (102, 102, 102)}, 
  {"Grey40"               , RGB (102, 102, 102)}, 
  {"Gray41"               , RGB (105, 105, 105)}, 
  {"Grey41"               , RGB (105, 105, 105)}, 
  {"Gray42"               , RGB (107, 107, 107)}, 
  {"Grey42"               , RGB (107, 107, 107)}, 
  {"Gray43"               , RGB (110, 110, 110)}, 
  {"Grey43"               , RGB (110, 110, 110)}, 
  {"Gray44"               , RGB (112, 112, 112)}, 
  {"Grey44"               , RGB (112, 112, 112)}, 
  {"Gray45"               , RGB (115, 115, 115)}, 
  {"Grey45"               , RGB (115, 115, 115)}, 
  {"Gray46"               , RGB (117, 117, 117)}, 
  {"Grey46"               , RGB (117, 117, 117)}, 
  {"Gray47"               , RGB (120, 120, 120)}, 
  {"Grey47"               , RGB (120, 120, 120)}, 
  {"Gray48"               , RGB (122, 122, 122)}, 
  {"Grey48"               , RGB (122, 122, 122)}, 
  {"Gray49"               , RGB (125, 125, 125)}, 
  {"Grey49"               , RGB (125, 125, 125)}, 
  {"Gray50"               , RGB (127, 127, 127)}, 
  {"Grey50"               , RGB (127, 127, 127)}, 
  {"Gray51"               , RGB (130, 130, 130)}, 
  {"Grey51"               , RGB (130, 130, 130)}, 
  {"Gray52"               , RGB (133, 133, 133)}, 
  {"Grey52"               , RGB (133, 133, 133)}, 
  {"Gray53"               , RGB (135, 135, 135)}, 
  {"Grey53"               , RGB (135, 135, 135)}, 
  {"Gray54"               , RGB (138, 138, 138)}, 
  {"Grey54"               , RGB (138, 138, 138)}, 
  {"Gray55"               , RGB (140, 140, 140)}, 
  {"Grey55"               , RGB (140, 140, 140)}, 
  {"Gray56"               , RGB (143, 143, 143)}, 
  {"Grey56"               , RGB (143, 143, 143)}, 
  {"Gray57"               , RGB (145, 145, 145)}, 
  {"Grey57"               , RGB (145, 145, 145)}, 
  {"Gray58"               , RGB (148, 148, 148)}, 
  {"Grey58"               , RGB (148, 148, 148)}, 
  {"Gray59"               , RGB (150, 150, 150)}, 
  {"Grey59"               , RGB (150, 150, 150)}, 
  {"Gray60"               , RGB (153, 153, 153)}, 
  {"Grey60"               , RGB (153, 153, 153)}, 
  {"Gray61"               , RGB (156, 156, 156)}, 
  {"Grey61"               , RGB (156, 156, 156)}, 
  {"Gray62"               , RGB (158, 158, 158)}, 
  {"Grey62"               , RGB (158, 158, 158)}, 
  {"Gray63"               , RGB (161, 161, 161)}, 
  {"Grey63"               , RGB (161, 161, 161)}, 
  {"Gray64"               , RGB (163, 163, 163)}, 
  {"Grey64"               , RGB (163, 163, 163)}, 
  {"Gray65"               , RGB (166, 166, 166)}, 
  {"Grey65"               , RGB (166, 166, 166)}, 
  {"Gray66"               , RGB (168, 168, 168)}, 
  {"Grey66"               , RGB (168, 168, 168)}, 
  {"Gray67"               , RGB (171, 171, 171)}, 
  {"Grey67"               , RGB (171, 171, 171)}, 
  {"Gray68"               , RGB (173, 173, 173)}, 
  {"Grey68"               , RGB (173, 173, 173)}, 
  {"Gray69"               , RGB (176, 176, 176)}, 
  {"Grey69"               , RGB (176, 176, 176)}, 
  {"Gray70"               , RGB (179, 179, 179)}, 
  {"Grey70"               , RGB (179, 179, 179)}, 
  {"Gray71"               , RGB (181, 181, 181)}, 
  {"Grey71"               , RGB (181, 181, 181)}, 
  {"Gray72"               , RGB (184, 184, 184)}, 
  {"Grey72"               , RGB (184, 184, 184)}, 
  {"Gray73"               , RGB (186, 186, 186)}, 
  {"Grey73"               , RGB (186, 186, 186)}, 
  {"Gray74"               , RGB (189, 189, 189)}, 
  {"Grey74"               , RGB (189, 189, 189)}, 
  {"Gray75"               , RGB (191, 191, 191)}, 
  {"Grey75"               , RGB (191, 191, 191)}, 
  {"Gray76"               , RGB (194, 194, 194)}, 
  {"Grey76"               , RGB (194, 194, 194)}, 
  {"Gray77"               , RGB (196, 196, 196)}, 
  {"Grey77"               , RGB (196, 196, 196)}, 
  {"Gray78"               , RGB (199, 199, 199)}, 
  {"Grey78"               , RGB (199, 199, 199)}, 
  {"Gray79"               , RGB (201, 201, 201)}, 
  {"Grey79"               , RGB (201, 201, 201)}, 
  {"Gray80"               , RGB (204, 204, 204)}, 
  {"Grey80"               , RGB (204, 204, 204)}, 
  {"Gray81"               , RGB (207, 207, 207)}, 
  {"Grey81"               , RGB (207, 207, 207)}, 
  {"Gray82"               , RGB (209, 209, 209)}, 
  {"Grey82"               , RGB (209, 209, 209)}, 
  {"Gray83"               , RGB (212, 212, 212)}, 
  {"Grey83"               , RGB (212, 212, 212)}, 
  {"Gray84"               , RGB (214, 214, 214)}, 
  {"Grey84"               , RGB (214, 214, 214)}, 
  {"Gray85"               , RGB (217, 217, 217)}, 
  {"Grey85"               , RGB (217, 217, 217)}, 
  {"Gray86"               , RGB (219, 219, 219)}, 
  {"Grey86"               , RGB (219, 219, 219)}, 
  {"Gray87"               , RGB (222, 222, 222)}, 
  {"Grey87"               , RGB (222, 222, 222)}, 
  {"Gray88"               , RGB (224, 224, 224)}, 
  {"Grey88"               , RGB (224, 224, 224)}, 
  {"Gray89"               , RGB (227, 227, 227)}, 
  {"Grey89"               , RGB (227, 227, 227)}, 
  {"Gray90"               , RGB (229, 229, 229)}, 
  {"Grey90"               , RGB (229, 229, 229)}, 
  {"Gray91"               , RGB (232, 232, 232)}, 
  {"Grey91"               , RGB (232, 232, 232)}, 
  {"Gray92"               , RGB (235, 235, 235)}, 
  {"Grey92"               , RGB (235, 235, 235)}, 
  {"Gray93"               , RGB (237, 237, 237)}, 
  {"Grey93"               , RGB (237, 237, 237)}, 
  {"Gray94"               , RGB (240, 240, 240)}, 
  {"Grey94"               , RGB (240, 240, 240)}, 
  {"Gray95"               , RGB (242, 242, 242)}, 
  {"Grey95"               , RGB (242, 242, 242)}, 
  {"Gray96"               , RGB (245, 245, 245)}, 
  {"Grey96"               , RGB (245, 245, 245)}, 
  {"Gray97"               , RGB (247, 247, 247)}, 
  {"Grey97"               , RGB (247, 247, 247)}, 
  {"Gray98"               , RGB (250, 250, 250)}, 
  {"Grey98"               , RGB (250, 250, 250)}, 
  {"Gray99"               , RGB (252, 252, 252)}, 
  {"Grey99"               , RGB (252, 252, 252)}, 
  {"Gray100"              , RGB (255, 255, 255)}, 
  {"Grey100"              , RGB (255, 255, 255)}, 
  {"Dark grey"            , RGB (169, 169, 169)}, 
  {"Darkgrey"             , RGB (169, 169, 169)}, 
  {"Dark gray"            , RGB (169, 169, 169)}, 
  {"Darkgray"             , RGB (169, 169, 169)}, 
  {"Dark blue"            , RGB (  0,   0, 139)}, 
  {"Darkblue"             , RGB (  0,   0, 139)}, 
  {"Dark cyan"            , RGB (  0, 139, 139)}, 
  {"Darkcyan"             , RGB (  0, 139, 139)}, 
  {"Dark magenta"         , RGB (139,   0, 139)}, 
  {"Darkmagenta"          , RGB (139,   0, 139)}, 
  {"Dark red"             , RGB (139,   0,   0)}, 
  {"Darkred"              , RGB (139,   0,   0)}, 
  {"Light green"          , RGB (144, 238, 144)}, 
  {"Lightgreen"           , RGB (144, 238, 144)}, 
  {"", 0, 0, 0}
};

