/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.PRoot;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.util.PPickPath;

public class PInputManager
extends PBasicInputEventHandler
implements PRoot.InputSource {
    private final Point2D lastCanvasPosition = new Point2D.Double();
    private final Point2D currentCanvasPosition = new Point2D.Double();
    private InputEvent nextInput;
    private int nextType;
    private PCamera nextInputSource;
    private PPickPath mouseFocus;
    private PPickPath previousMouseFocus;
    private PPickPath mouseOver;
    private PPickPath previousMouseOver;
    private PInputEventListener keyboardFocus;
    private int buttonsPressed;

    public PInputEventListener getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public void setKeyboardFocus(PInputEventListener eventHandler) {
        PInputEvent focusEvent = new PInputEvent(this, null);
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(focusEvent, 1005, this.keyboardFocus);
        }
        this.keyboardFocus = eventHandler;
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(focusEvent, 1004, this.keyboardFocus);
        }
    }

    public PPickPath getMouseFocus() {
        return this.mouseFocus;
    }

    public void setMouseFocus(PPickPath path) {
        this.previousMouseFocus = this.mouseFocus;
        this.mouseFocus = path;
    }

    public PPickPath getMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(PPickPath path) {
        this.mouseOver = path;
    }

    public Point2D getLastCanvasPosition() {
        return this.lastCanvasPosition;
    }

    public Point2D getCurrentCanvasPosition() {
        return this.currentCanvasPosition;
    }

    public void keyPressed(PInputEvent event) {
        this.dispatchEventToListener(event, 401, this.keyboardFocus);
    }

    public void keyReleased(PInputEvent event) {
        this.dispatchEventToListener(event, 402, this.keyboardFocus);
    }

    public void keyTyped(PInputEvent event) {
        this.dispatchEventToListener(event, 400, this.keyboardFocus);
    }

    public void mouseClicked(PInputEvent event) {
        this.dispatchEventToListener(event, 500, this.previousMouseFocus);
    }

    public void mouseWheelRotated(PInputEvent event) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(event, 0, this.mouseOver);
    }

    public void mouseWheelRotatedByBlock(PInputEvent event) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(event, 1, this.mouseOver);
    }

    public void mouseDragged(PInputEvent event) {
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 506, this.mouseFocus);
    }

    public void mouseEntered(PInputEvent event) {
        this.dispatchEventToListener(event, 504, this.mouseOver);
    }

    public void mouseExited(PInputEvent event) {
        this.dispatchEventToListener(event, 505, this.previousMouseOver);
    }

    public void mouseMoved(PInputEvent event) {
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 503, this.mouseOver);
    }

    public void mousePressed(PInputEvent event) {
        if (this.buttonsPressed == 0) {
            this.setMouseFocus(this.getMouseOver());
        }
        ++this.buttonsPressed;
        this.dispatchEventToListener(event, 501, this.mouseFocus);
        if (this.buttonsPressed < 1 || this.buttonsPressed > 3) {
            System.err.println("invalid pressedCount on mouse pressed: " + this.buttonsPressed);
        }
    }

    public void mouseReleased(PInputEvent event) {
        --this.buttonsPressed;
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 502, this.mouseFocus);
        if (this.buttonsPressed == 0) {
            this.setMouseFocus(null);
        }
        if (this.buttonsPressed < 0 || this.buttonsPressed > 2) {
            System.err.println("invalid pressedCount on mouse released: " + this.buttonsPressed);
        }
    }

    protected void checkForMouseEnteredAndExited(PInputEvent event) {
        PNode previousNode;
        PNode currentNode = this.getPickedNode(this.mouseOver);
        if (currentNode != (previousNode = this.getPickedNode(this.previousMouseOver))) {
            this.dispatchEventToListener(event, 505, this.previousMouseOver);
            this.dispatchEventToListener(event, 504, this.mouseOver);
            this.previousMouseOver = this.mouseOver;
        }
    }

    private PNode getPickedNode(PPickPath pickPath) {
        if (pickPath == null) {
            return null;
        }
        return pickPath.getPickedNode();
    }

    public void processInput() {
        if (this.nextInput == null) {
            return;
        }
        PInputEvent e = new PInputEvent(this, this.nextInput);
        Point2D newCurrentCanvasPosition = null;
        Point2D newLastCanvasPosition = null;
        if (e.isMouseEvent()) {
            if (e.isMouseEnteredOrMouseExited()) {
                PPickPath aPickPath = this.nextInputSource.pick(((MouseEvent)this.nextInput).getX(), ((MouseEvent)this.nextInput).getY(), 1.0);
                this.setMouseOver(aPickPath);
                this.previousMouseOver = aPickPath;
                newCurrentCanvasPosition = (Point2D)this.currentCanvasPosition.clone();
                newLastCanvasPosition = (Point2D)this.lastCanvasPosition.clone();
            } else {
                this.lastCanvasPosition.setLocation(this.currentCanvasPosition);
                this.currentCanvasPosition.setLocation(((MouseEvent)this.nextInput).getX(), ((MouseEvent)this.nextInput).getY());
                PPickPath aPickPath = this.nextInputSource.pick(this.currentCanvasPosition.getX(), this.currentCanvasPosition.getY(), 1.0);
                this.setMouseOver(aPickPath);
            }
        }
        this.nextInput = null;
        this.nextInputSource = null;
        this.processEvent(e, this.nextType);
        if (newCurrentCanvasPosition != null && newLastCanvasPosition != null) {
            this.currentCanvasPosition.setLocation(newCurrentCanvasPosition);
            this.lastCanvasPosition.setLocation(newLastCanvasPosition);
        }
    }

    public void processEventFromCamera(InputEvent event, int type, PCamera camera) {
        this.nextInput = event;
        this.nextType = type;
        this.nextInputSource = camera;
        camera.getRoot().processInputs();
    }

    private void dispatchEventToListener(PInputEvent event, int type, PInputEventListener listener) {
        if (listener != null) {
            event.setHandled(false);
            listener.processEvent(event, type);
        }
    }
}

