C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                           *****************
                            SUBROUTINE LECSOL
C                           *****************
C
C     ------------------------------------------------------------
     *( NDIM,NDIELE,NPOINS,NELEMS,
     *  TMPSA,TMPS,TMPSC1,TMPSC2,TMPSC3,TMPMAX,TMPMIN)
C    -------------------------------------------------------------
C
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C
C     LECTURE DES RESULTATS SUR LE SOLIDE POUR UNE SUITE DE CALCUL
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C ! NDIM      !  E ! D  ! DIMENSION DU PROBLEME                        !
C ! NDIELE    !  E ! D  ! DIMENSION DES ELEMENTS                       !
C ! NELEMS    !  E ! D  ! NOMBRE D'ELTS VOL SOLIDE                     !
C !  NPOINS   !  E !  D ! NOMBRE DE NOEUDS DU MAILLAGE                 !
C !  TMPSA    ! TR !  D ! TEMPERATURE PAS DE TEMPS N                   !
C !  TMPS     ! TR !  D ! TEMPERATURE PAS DE TEMPS N+1                 !
C !  TMPSC1   ! TR !  D ! TEMPERATURE COMPOSANTE 1, CAS DU MODELE COQUE!
C !  TMPSC2   ! TR !  D ! TEMPERATURE COMPOSANTE 2, CAS DU MODELE COQUE!
C !  TMPSC3   ! TR !  D ! TEMPERATURE COMPOSANTE 3, CAS DU MODELE COQUE!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     : INISOL
C
C     SOUS PROGRAMME(S) APPELE(S) : LECG2E,LECG2R
C
C***********************************************************************
*
      IMPLICIT NONE        
*
C***********************************************************************
C     DONNEES EN COMMON  (VOIR LA SIGNIFICATION COMPLETE DANS LECDON)
C **********************************************************************
C
#include "optct.h"
#include "nlofct.h"
#include "divct.h"
#include "nlofes.h"
#include "fichct.h"
#ifdef MED
#include "med.hf"
#endif
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NPOINS,NDIM,NDIELE,NELEMS
      DOUBLE PRECISION TMPSC1(NPOINS),TMPSC2(NPOINS),TMPSC3(NPOINS)
      DOUBLE PRECISION TMPSA(NPOINS), TMPS(NPOINS)
      DOUBLE PRECISION TMPMAX(NPOINS),TMPMIN(NPOINS)
C
C.. Variables internes
      INTEGER NBSCAL,I,NVAL,NCHA,TYPCHA,IRET,NCOMP,IDIM,NGAUSS,NORDRE
      CHARACTER*32 NOM,NOMCHA,MAA
      CHARACTER*8 COMP,UNIT,CHUNIT
C
C***********************************************************************
C    
      IF (TYPSU.NE.'MED') THEN
C
         CALL LECG2E (NFGSCT,NDIM,NDIELE,NPOINS,NELEMS,NBSCAL) 
C
         CALL LECG2R (TMPS,NPOINS,'TEMP_SOLIDE ' ,NFGSCT)
C
         IF (LTMAX) THEN
            IF (NBSCAL.EQ.3) THEN
               CALL LECG2R (TMPMIN,NPOINS,'TEMP_MIN    ' ,NFGSCT)
               CALL LECG2R (TMPMAX,NPOINS,'TEMP_MAX    ' ,NFGSCT)
            ELSE
               WRITE(NFECRA,1000)
               DO I=1,NPOINS
                  TMPMAX(I)=TMPS(I)
                  TMPMIN(I)=TMPS(I)
               ENDDO
            ENDIF
         ENDIF  
      ELSE
#ifdef MED
        NOM='Resultat Syrthes'
        call efmaai(NFGSCT,1,NOM,IDIM,IRET)
        CALL EFNCHA(NFGSCT,0,NCHA,IRET)
        IF (NCHA.EQ.0) THEN
          WRITE(NFECRA,1005) 
          STOP
        ENDIF
        DO I=1,NCHA
          CALL EFCHAI(NFGSCT,I,NOMCHA,TYPCHA,COMP,UNIT,NCOMP,IRET)
          IF (NOMCHA(1:4).EQ.'TMPS') THEN
             CALL EFNVAL(NFGSCT,NOM,NOMCHA,MED_NOEUD,0,NVAL,IRET)
             IF (NVAL.NE.NPOINS) THEN
               WRITE(6,1010) NVAL,NPOINS
               STOP  
             ENDIF
CMED20             CALL EFCHAL(NFGSCT,NOM,NOMCHA,TMPS,NPOINS,MED_NOEUD,0,IRET)
             CALL EFCHAL(NFGSCT,NOM,NOMCHA,TMPS,MED_NO_INTERLACE,
     *                   MED_ALL,MED_NOPFL,MED_NOEUD,0,
     *                   MED_NOPDT,MED_NONOR,IRET)
CMED20             READ(NOMCHA(8:),'(E16.6)') TEMPSS
CMED20             READ(NOMCHA(25:),'(I8)') NTSYR
             CALL EFPDTI(NFGSCT,NOMCHA,MED_NOEUD,0,1,MAA,NGAUSS,
     *                   NTSYR,CHUNIT,TEMPSS,NORDRE,IRET)
          ELSEIF (NOMCHA(1:7).EQ.'MINTMPS'.AND.LTMAX) THEN
             CALL EFNVAL(NFGSCT,NOM,NOMCHA,MED_NOEUD,0,NVAL,IRET)
             IF (NVAL.NE.NPOINS) THEN
               WRITE(6,1010) NVAL,NPOINS
               STOP
             ENDIF
CMED20             CALL EFCHAL(NFGSCT,NOM,NOMCHA,TMPMAX,NPOINS,MED_NOEUD,0,
CMED20     *                                                            IRET)
             CALL EFCHAL(NFGSCT,NOM,NOMCHA,TMPMAX,MED_NO_INTERLACE,
     *                   MED_ALL,MED_NOPFL,MED_NOEUD,0,
     *                   MED_NOPDT,MED_NONOR,IRET)
          ELSEIF (NOMCHA(1:7).EQ.'MAXTMPS'.AND.LTMAX) THEN
             CALL EFNVAL(NFGSCT,NOM,NOMCHA,MED_NOEUD,0,NVAL,IRET)
             IF (NVAL.NE.NPOINS) THEN
               WRITE(6,1010) NVAL,NPOINS
               STOP
             ENDIF
CMED20             CALL EFCHAL(NFGSCT,NOM,NOMCHA,TMPMIN,NPOINS,MED_NOEUD,0,
CMED20     *                                                             IRET)
             CALL EFCHAL(NFGSCT,NOM,NOMCHA,TMPMIN,MED_NO_INTERLACE,
     *                   MED_ALL,MED_NOPFL,MED_NOEUD,0,
     *                   MED_NOPDT,MED_NONOR,IRET)
          ENDIF
        ENDDO
        IF (NCHA.EQ.1 .AND. LTMAX) THEN
           WRITE(NFECRA,1000)
           DO I=1,NPOINS
              TMPMAX(I)=TMPS(I)
              TMPMIN(I)=TMPS(I)
           ENDDO
        ENDIF
#endif
      ENDIF
C     
C     
C--------
C FORMATS
C--------
 1000 FORMAT(/,' $$ ATTENTION LECSOL : le fichier suite ne contient',
     * ' pas le tableau des temperatures min et max',/,
     *         '                       elles seront cependant',
     * ' calculees sur le present calcul.')
 1005 FORMAT(/' $$ ERREUR LECSOL : le fichier suite ne contient',
     *        ' aucun champ !')
 1010 FORMAT(/' $$ ERREUR LECSOL : le champ du fichier',
     *     ' suite contient ',i8,' valeurs',/,
     *     '                    Pour le present calcul, on en attend ',
     *      i8)
C
C
C----
C FIN
C----
C
      END
