/***************************************************************

   The Subread software package is free software package:
   you can redistribute it and/or modify it under the terms
   of the GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   Subread is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   See the GNU General Public License for more details.

   Authors: Drs Yang Liao and Wei Shi

  ***************************************************************/

#ifndef __LRMCHRO_EVENT_H_
#define __LRMCHRO_EVENT_H_

#include "LRMconfig.h"

int LRMevents_load_annot(LRMcontext_t * context);
int LRMevents_filtering(LRMcontext_t * context);
int LRMevents_reorder(LRMcontext_t * context);
int LRMevents_build_entries(LRMcontext_t * context);
int LRMevents_lookup(LRMcontext_t * context, unsigned int abs_pos, int event_type_masks, int search_large_side, LRMevent_t ** res);

int LRMchro_event_new(LRMcontext_t * context, LRMthread_context_t * thread_context, LRMread_iteration_context_t * iteration_context, LRMevent_t * new_event);

int LRMdonor_score(LRMcontext_t * context, LRMthread_context_t * thread_context, LRMread_iteration_context_t * iteration_context, LRMsegment_mapping_candidate_t * mapping_result, int seg_id, unsigned int secondary_mapping_location, unsigned int secondary_coverage_start , unsigned int secondary_coverage_end, int indel_in_anchor, int indel_in_secondary, int * final_split_point, int *is_GT_AG_strand, int * left_offset_indels);


// high_penalty_for_creating_gap is for creating less CIGAR options (<65535)
int LRMindel_dynamic_search(LRMcontext_t* context, LRMthread_context_t* thread_context, int expected_indels, unsigned int last_correct_base_on_chro, char * corrected_read, int last_correct_base, int first_correct_base, unsigned int * total_mismatched, int high_penalty_for_creating_gap, char * read_name);
int LRMrealign_one_segment(LRMcontext_t * context, LRMthread_context_t * thread_context, LRMread_iteration_context_t * iteration_context, LRMrealign_context_t * realign_context);
void LRMreverse_read_and_qual(LRMcontext_t * context, LRMthread_context_t * thread_context, LRMread_iteration_context_t * iteration_context);
int LRMindel_dynamic_search_unknownregion(LRMcontext_t* context, LRMthread_context_t* thread_context, int search_to_3end, unsigned int last_correct_base_on_chro, char * corrected_read, int last_correct_base, int first_correct_base,unsigned int * total_mismatched_bases, int high_penalty_create_gap, char * read_name);
#endif
