use ui;
use layout;
use core:geometry;

class MenuWindow extends Frame {
	init() {
		MenuBar root;
		PopupMenu help;

		init("Menu test", Size(300, 100)) {
			root = root;
			help = help;
			button = Button("Test button");
		}

		help << Menu:Check("Enable help", &this.enableHelp);
		help << Menu:Text("Help", &this.showHelp) << Menu:Separator() << Menu:Text("About...", &this.showAbout());
		help[1].enabled = false;

		root << Menu:Text("Test") << Menu:Submenu("Help", help);
		menu = root;

		add(button);
		button.pos(Rect(0, 0, 300, 100).shrink(Size(8)));

		create();
	}

	MenuBar root;
	PopupMenu help;
	Button button;

	Bool onClick(Bool pressed, Point at, MouseButton button) : override {
		if (pressed) {
			if (button == MouseButton:left) {
				if (menu)
					menu = null;
				else
					menu = root;
			} else if (button == MouseButton:middle) {
				fullscreen = !fullscreen;
			} else if (button == MouseButton:right) {
				popupMenu(help);
			}
		}

		true;
	}

	void showAbout() {
		AboutWindow win;
		Int r = win.show(this);
		print("Result: ${r}");
	}

	void enableHelp(Bool enabled) {
		help[1].enabled = enabled;
	}

	void showHelp() {
		root << Menu:Text("Bonus");
	}
}

dialog AboutWindow {
	layout Grid {
		expandCol: 0;
		expandRow: 0;

		Edit e() { row: 0; col: 0; colspan: 3; }
		Button close("Close") { row: 1; col: 1; }
		Button ok("OK") { row:1; col: 2; }
	}

	init() {
		init("About", Size(200, 100)) {}

		var me = this;
		close.onClick = () => me.close(1);
		defaultChoice = ok;
		ok.onClick = () => me.close(100);
	}
}

void menu() {
	MenuWindow w;
	w.waitForClose;
	print("Done!");
}
