/*  
 *   Copyright 2007 Simone Della Longa <simonedll@yahoo.it>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef TASKS_H_
#define TASKS_H_


#include "main.h"
#include "xstuff.h"


class taskInfo
{
public:
  // This is to avoid exceptions and their overhead
  bool Init(WnckWindow* w);
  void setName (char *processName);
  bool compareWith (simImage * img);
  wxString name;
  unsigned int pid;
  wxString title;

};

class taskManager
{
public:
	taskManager(ImagesArray * ImagesList,simSettings* settings);
	static Window getFromName (const char *name, int nameLength);
    static int getProcessName (unsigned int pid, char *target_name, int size_targetname);
	void fillList ();
	static void raise (WnckWindow* win);
	static void close (WnckWindow* win);
	void register_signals();
	/* Adds a new image to the images list given a window and task informations */
	void addNewImage(WnckWindow *window, const taskInfo& ti);
	ImagesArray* getImagesArray() { return ImagesList; }
	simSettings* getSettings() {return settings; }
private:
	ImagesArray * ImagesList;
	simSettings* settings;
};

/* Window changed status callback 
void tasks_window_status (WnckScreen *screen, WnckWindow *window,WnckWindowState changed_mask, WnckWindowState new_state, taskManager* tm );

*/

#endif
