/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.sikuli.guide.Annotation;

public class AnnotationToolTip
extends Annotation {
    final int spacing = 10;
    final float hp = 0.2f;
    final int thickness = 20;
    String _text;
    Point _target;

    public AnnotationToolTip(String string, Point point) {
        this._text = string;
        this._target = point;
    }

    void paintContainer(Graphics2D graphics2D, Rectangle rectangle) {
        BasicStroke basicStroke = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(new Color(255, 250, 205));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(new Color(238, 221, 130));
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintAnnotation(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._text == null || this._target == null) {
            return;
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = new Font("sansserif", 0, 12);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = fontMetrics.stringWidth(this._text);
        int n2 = fontMetrics.getHeight();
        Rectangle rectangle = new Rectangle(this._target.x, this._target.y, n, n2);
        this.paintContainer(graphics2D, rectangle);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(this._text, this._target.x, this._target.y + n2 - 2);
    }
}

