#version 330
layout (location=0) in vec4  L0;
layout (location=1) in vec4  L1;
layout (location=2) in vec4  L2;
layout (location=3) in vec4  L3;
layout (location=4) in vec4  L4;
layout (location=5) in vec4  L5;

/*#version 440
//5 components                              01234567
layout (location=0, component = 0) in vec3  Center;
layout (location=0, component = 3) in float AN_f;
layout (location=1, component = 0) in vec3  Corner;
layout (location=1, component = 3) in float CI_f;
layout (location=2)                in vec4  ADPRQ;
layout (location=3, component = 0) in vec3  ADP_eigen_values;
layout (location=3, component = 3) in float Style_f;
layout (location=4, component = 0) in float PH;
layout (location=4, component = 1) in float SG_f;
layout (location=4, component = 2) in float part_f;
layout (location=4, component = 3) in float MI_f;
*/
out vec3 center;
out vec3 vert;
out float an;
out float ci;
out vec4 rotarr;
out vec3 eigenvalues;
out float style;
out float peakheight;
out float sg;
out float part;
out float mi;
out float idx;
out float auidx;
out float resinr;

uniform vec3 origin = vec3(0);
/*
// 440
void main(void){
    center = Center;
    an = int(AN_f);
    vert = Corner;
    gl_Position = vec4(Corner, 1.0);
    ci = CI_f;
    rotarr = ADPRQ;
    eigenvalues = ADP_eigen_values;
    style = Style_f;
    peakheight = PH;
    sg = SG_f;
    part = part_f;
    mi = MI_f;
}
*/
// 410
void main(void){
    center       = L0.xyz - origin;
    an           = L0.w;
    vert         = L1.xyz;
    gl_Position  = vec4(vert, 1.0);
    ci           = L1.w;
    rotarr       = L2;
    eigenvalues  = L3.xyz;
    style        = L3.w;
    peakheight   = L4.x;
    sg           = L4.y;
    part         = L4.z;
    mi           = L4.w;
    idx          = L5.x;
    auidx        = L5.y;
    resinr       = L5.z;
    //= L5.w;
}
