/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * files.c -- various file handling procedures
 *
 * Authors: Uli Pralle (Uli.Pralle@cs.tu-berlin.de)
 *          Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: files.c[4.0] Thu Jun 24 17:43:14 1993 andy@cs.tu-berlin.de frozen $
 */

#include "config.h"
#include "sttk.h"

/*===========================
 * register temporary files
 *===========================*/

static char *tmpNames[ST_MAX_TMPFILES];

EXPORT void stRmRegisteredFiles ()
{
  register int i;

  for (i=0; i < ST_MAX_TMPFILES; i++)
    if (tmpNames[i])
      unlink (tmpNames[i]);
}

EXPORT void stRegisterFile (fileName)
     char *fileName;
{
  register int i;

  if (!fileName) return;

  for (i=0; i < ST_MAX_TMPFILES; i++)
    if (!tmpNames[i]) {
      tmpNames[i] = stStrEnter (fileName);
      break;
    }
  if (i == ST_MAX_TMPFILES) /* list is full */
    /* WARNING: tmpfile list is full -- couldn't register */
    ;
}

static int tmpCount=0;

EXPORT char *stTmpFile (path)
     char *path;
{
  static char tmpName[PATH_MAX+1];

  if (!path || !*path)
    path = "/tmp";

  sprintf (tmpName, "%s/sttk%d%d", path, getpid(), tmpCount++);
  unlink (tmpName);
  stRegisterFile (tmpName);
  return (tmpName);
}


EXPORT void stUnRegisterFile (fileName) /* remove tmp file entry */
     char *fileName;
{
  register int i;
  char *nameSym = stStrEnter (fileName);

  for (i=0; i < ST_MAX_TMPFILES; i++)
    if (tmpNames[i] == nameSym) {
      tmpNames[i] = (char *)0;
      break;
    }
  if (i == ST_MAX_TMPFILES) /* fileName not found */
    ; /* WARNING: name of tmpfile has not been registered before */
}

/*===============
 * find Program
 *===============*/

EXPORT char *stFindProgram (programName)
     char *programName;
     /* returns the full pathname of "programName", if program
      * is found and executable. Otherwise NULL.
      */
{
  static char this[PATH_MAX+1];
  char *path;
  char *dir, *dirPtr;

  /* if program has already a '/' in it, assume existence */
  if (strchr (programName, '/')) {
    if (access (programName, X_OK) == 0)
      return (programName);
    else
      return (NULL);
  }

  /* get path from enivronment */
  if (!(path = getenv ("PATH")))
    path = ST_DEFAULT_PATH;

  while (1) {
    if ((dir = path) == NULL)
      return (NULL);

    /* find end of dir in string */
    if ((dirPtr = strchr (path, ':'))) {
      *dirPtr = '\0';		/* make "dir" null terminated */
      path = dirPtr + 1;		/* path points to next dir */
    }
    else
      path = (NULL);		/* end of path reached */

    /* file found ? */
    sprintf (this, "%s/%s", dir, programName);	/* construct new filename */
    if ((access (this, F_OK)) == 0)
      return (this);		/* found */
  }
}
