.\" $Id: scanbd.man 190 2013-09-02 06:19:37Z wimalopaan $
.TH scanbd 8 "02 Jan 2013" "@PACKAGENAME@ @PACKAGEVERSION@" "Scanner button daemon"
.IX scanbd
.SH NAME
scanbd\- Scanner button monitoring daemon
.SH SYNOPSIS
.I Polling mode:
.PP
.B scanbd
.B [\-c 
.I configfile
.B ] [\-f]
.BI  [\-d [debuglevel]
.B ]
.PP
.I Manager-mode
.PP
The manager mode of 
.B scanbd 
that can be triggered by the 
.B \-m
option is not documented in this man-page but in 
.BR scanbm (8)
.
.SH DESCRIPTION
.B scanbd
is a scanner button monitoring daemon that can trigger execution of scripts when
a button on a scanner is pressed.
scanbd (the scanner button daemon) opens and polls the scanner 
and therefore locks the device. So no other application can access the device 
directly (open the /dev/..., or via libusb, etc).
.PP
To enable scanning from applications, we use scanbm as a "proxy" for 
saned to access the scanner from an application. scanbm 
listens for requests on the saned network port for scanning requests.
If a scan request arrives, scanbm 
requests the scanbd daemon to release the scanner. 
Then it starts the real saned which scans and sends the data back
to the requesting application. When the scanning is done and saned exits, the 
scanbm daemon tells scanbd to resume polling the scanner.
.PP   
scanbd can be configured at compile time to either use sane to poll the scannner
or use the scanbuttond backends to do so.
.PP
scanbd polls the scanner regularly (the interval can be set in 
.B scanbd.conf
) and monitors for any scanner button to be pressed. If it detects a button press
it triggers execution of the appropriate script as defined in 
.B scanbd.conf
.
.SH OPTIONS
.TP
.BI \-c " configfile" " \-\-config" =configfile
Use 
.I configfile
instead of the default @SCANBDCFGDIR@/scanbd.conf configuration file.
.TP
.BI \-d [debuglevel] " \-\-debug" [=debuglevel]
turn debug mode on. If specified, set the debug level to 
.I debuglevel
.br
1 = error 
.br
2 = warn
.br
3 = info
.br
4 - 7 = debug)
.TP
.B \-f \-\-foreground
Run scanbd in the foreground
.SH SIGNALS
.TP
.B SIGUSR1
Stop polling and relase the scanner (used by 
.B scanbm
)
.TP
.B SIGUSR1
Resume polling (used by 
.B scanbm
)
.TP
.B SIGHUP 
Rescan for available devices (useful when no automatic detection is available (HAL, UDEV) )
.SH MAIN SCANBD CONFIGURATION
scanbd and scanbm are configured trough scanbd.conf (@SCANBDCFGDIR@/scanbd.conf).
The distributed scanbd.conf
contains a detailed explantion of the configuration options.
.PP 
The 
.B \-c
option can be used to override the default configuration file.
.PP
scanbd shall normally be started from init using your operating
system's start method. See the integration directory in the scanbd 
sources to see what is available for your OS and
distribution. 
.SH "SEE ALSO"
.BR scanbm (8),
.BR sane (7),
.BR saned (8),
.BR sane\-dll (5),
.BR sane\-net (5)
.BR @SCANBDCFGDIR@/scanbd.conf
.br
.I http://scanbd.sourceforge.net
.SH AUTHOR
Louis Lagendijk
