/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_PolyLine.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/05
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __LIST_POLYLINE_H__
#define __LIST_POLYLINE_H__

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_POLYLINE_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL POLYLINE_LIST *p_polyline_list;
	GLOBAL POLYLINE_LIST_INFO polyline_list_info;

	GLOBAL POLYLINE_LIST *PolyLineStartData GLOBAL_VAL(0);


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _LIST_POLYLINE_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int init_polyline(POLYLINE *polyline);
/*  */
POLYLINE_LIST *r_polyline_list_add_first(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data をリストの最初に追加 */
POLYLINE_LIST *polyline_list_add_first(POLYLINE *add_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data をリストの最初に追加して、 Undo Baffer に書込む */
POLYLINE_LIST *polyline_list_add_first_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);

/* POLYLINE Data をリストの最後に追加 */
POLYLINE_LIST *polyline_list_add_last(POLYLINE *add_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data をリストの最後に追加、 Undo Baffer に書込む */
POLYLINE_LIST *polyline_list_add_last_with_undo(POLYLINE *add_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);

/* POLYLINE Data の削除機能 (メモリの削除ではない) */
int polyline_list_delete(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す) */
int polyline_list_delete_Undo(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info);

/* POLYLINE Data を変更する */
POLYLINE_LIST *polyline_list_edit(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data を変更する、 Undo Baffer に書込む */
POLYLINE_LIST *polyline_list_edit_with_undo(POLYLINE_LIST *point, POLYLINE *change_polyline, POLYLINE_LIST_INFO *p_polyline_list_info);

/* リストの総数を調べる */
long polyline_list_num(POLYLINE_LIST_INFO *p_polyline_list_info);
/* n 番目のデータの検索 */
POLYLINE_LIST *polyline_search_num(long search_number, POLYLINE_LIST_INFO *p_polyline_list_info);
/* データの検索(POLYLINE *p_PolyLine から POLYLINE_LIST を求める) */
POLYLINE_LIST *polyline_search_polyline(POLYLINE *p_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* データの検索(POLYLINE *p_PolyLine から Data No. の long 値を求める) */
long polyline_search_polyline_to_num(POLYLINE *p_PolyLine, POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE Data をリストから削除 */
int polyline_list_free(POLYLINE_LIST *del_List, POLYLINE_LIST_INFO *p_polyline_list_info);
/* 全リストを削除 */
void polyline_list_all_free(POLYLINE_LIST_INFO *p_polyline_list_info);
/* POLYLINE_LIST のデータ log */
void polyline_list_log(POLYLINE_LIST_INFO *p_polyline_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_POLYLINE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_PolyLine.h
 * ====================================================================
 */
