#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-11-03 14:17:28 
# _test-network.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYDNS="$1"
MYDOMAIN="$2"
MYDC="$3"
MYSERVER="$4"
MYHOSTALLOW="$5"
MYWINS="$6"

### I N C L U D E

. ./_include.sh

### S T A R T

function gethn()
{
	python -c "import socket;hn=socket.gethostname();print hn" 2> /dev/null
	return $?
}

function gethbn()
{
	python -c "import socket;hn,al,ips=socket.gethostbyname_ex(\"$1\");print hn" 2> /dev/null
	return $?
}

function getaliases()
{
	python -c "import socket;hn,al,ips=socket.gethostbyname_ex(\"$1\");print al" 2> /dev/null
	return $?
}

function getips()
{
	python -c "import socket;hn,al,ips=socket.gethostbyname_ex(\"$1\");print ips" 2> /dev/null
	return $?
}

function getfqdn()
{
	python -c "import socket;print socket.getfqdn(\"$1\")" 2> /dev/null
	return $?
}

function resolve()
{
	python -c "import socket;print socket.gethostbyname(\"$1\")" 2> /dev/null
	return $?
}

function resolveDns()
{
	output=`host "$1" 2> /dev/null | grep -v '^;;' | grep -v 'not found'`
	if [ "${output}" != "" ];then
		echo ${output}
		return 0
	fi
	return 1
}

echo "--------------------------------------------------------------------------------"
echo "NETWORK TEST"
echo "--------------------------------------------------------------------------------"
result=0

echo "+HOSTNAME"
echo "+hostname"
hn=`hostname`
echo ${hn}
echo "+shortname"
sn=`hostname -s`
echo ${sn}
echo "+fqdn"
fqdn=`hostname -f`
echo ${fqdn}
echo "+gethostname (socket)"
hn2=`gethn ${hn}`
echo ${hn2}
echo "+gethostbyname(gethostname) (socket)"
hn3=`gethbn ${hn2}`
echo ${hn3}
echo "+fqdn (socket)"
fqdn2=`getfqdn`
echo ${fqdn2}
echo "+aliases (socket)"
al=`getaliases ${hn} | sed "s/[']//g"`
echo ${al}
echo "+ips (socket)"
al=`getips ${hn} | sed "s/[']//g"`
echo ${al}
echo "+dn"
dn=${fqdn##${sn}.}
echo ${dn}
echo "+target fqdn"
if [ "${dn}" != "${MYDNS}" ]; then
	echo "hostname ${fqdn} not in domain ${MYDNS}" >&2
else
	echo "hostname ${fqdn} in target domain ${MYDNS}"
fi
if [ -e /etc/hostname ];then
echo "+/etc/hostname"
cat /etc/hostname
fi
if [ -e /etc/sysconfig/network ];then
echo "+/etc/sysconfig/network"
grep HOSTNAME /etc/sysconfig/network
fi
echo "+entry in /etc/hosts"
cat /etc/hosts | grep ${sn}

echo "+CHECK HOSTNAME IS RESOLVABLE"
echo "+resolve ${sn}"
resolve ${sn}
if [ "$?" != "0" ]; then
	echo "ip: unresolved host ${sn}" >&2
	result=110
fi
echo "+resolve ${fqdn}"
resolve ${fqdn}
if [ "$?" != "0" ]; then
	echo "ip: unresolved host ${fqdn}" >&2
	result=111
fi

echo "+CHECK HOSTNAME IS REACHABLE (PING)"
echo "+ping ${sn}"
ping -q -c 1 ${sn} > /dev/null
if [ "$?" != "0" ]; then
	echo "ping: unreachable host ${sn} (firewall may drop pings)" >&2
	result=130
else
	echo "ok"
fi
echo "+ping ${fqdn}"
ping -q -c 1 ${fqdn} > /dev/null
if [ "$?" != "0" ]; then
	echo "ping: unreachable host ${fqdn} (firewall may drop pings)" >&2
	result=131
else
	echo "ok"
fi

echo "+CHECK DOMAIN CONTROLLER IS RESOLVABLE"
echo "+resolve ${MYDC}"
resolve ${MYDC}
if [ "$?" != "0" ]; then
	echo "ip: unresolved host ${MYDC}" >&2
	result=10
fi
echo "+resolve ${MYDC}.${MYDNS}"
resolve ${MYDC}.${MYDNS}
if [ "$?" != "0" ]; then
	echo "ip: unresolved host ${MYDC}.${MYDNS}" >&2
	result=11
fi

echo "+CHECK DOMAIN CONTROLLER IS DNS-RESOLVABLE"
echo "+resolve ${MYDC}"
resolveDns ${MYDC}
if [ "$?" != "0" ]; then
	echo "dns: unresolved host ${MYDC}" >&2
	result=20
fi
echo "+resolve ${MYDC}.${MYDNS}"
resolveDns ${MYDC}.${MYDNS}
if [ "$?" != "0" ]; then
	echo "dns: unresolved host ${MYDC}.${MYDNS}" >&2
	result=21
fi

echo "+CHECK DOMAIN CONTROLLER IS REACHABLE (PING)"
echo "+ping ${MYDC}"
ping -q -c 1 ${MYDC} > /dev/null
if [ "$?" != "0" ]; then
	echo "ping: unreachable host ${MYDC} (firewall may drop pings)" >&2
	result=30
else
	echo "ok"
fi
echo "+ping ${MYDC}.${MYDNS}"
ping -q -c 1 ${MYDC}.${MYDNS} > /dev/null
if [ "$?" != "0" ]; then
	echo "ping: unreachable host ${MYDC}.${MYDNS} (firewall may drop pings)" >&2
	result=31
else
	echo "ok"
fi
exit ${result}
