#!/bin/bash
# bbou@ac-toulouse.fr
# 2005-07-10 12:06:03   
# _restart.sh

### P A R A M S

MYEXCEPTNSCD=
if [ "$1" == "-nonscd" ];then
	export MYEXCEPTNSCD="True"
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

function stripansiesc()
{
     sed 's/\(\x1B\[[0-9]*[ABCDG]\)\|\(\x1B\[[0-9]*,[0-9]*[HfR]\)\|\(\x1B\[2J\)\|\(\x1B\[[0-9]*m\)\|\(\x1B\[[0-9]*\([;]\)\?[0-9]*\([;]\)\?[0-9]*[mH]\)//g' | sed 's/\(\x1B\[=[01]\?[h1]\?\)\|\(\x1B\[=[0-7],7[h1]\)\|\(\x1B\[?[7]\?[h1]\{,2\}\)\|\(\x1B\[[suK:]\)\|\(\x1B=\)//g'
}

# samba

echo "--------------------------------------------------------------------------------"
echo "RESTART SAMBA DAEMONS"
echo "--------------------------------------------------------------------------------"
${SERVICE} ${WINBINDSERVICE} restart | stripansiesc
${SERVICE} ${SAMBASERVICE} restart | stripansiesc

# nscd

if [ -z "${MYEXCEPTNSCD}" ];then

echo "--------------------------------------------------------------------------------"
echo "RESTART NSCD DAEMON"
echo "--------------------------------------------------------------------------------"
${SERVICE} ${NSCDSERVICE} restart | stripansiesc

fi
