;;! target = "x86_64"
;;! compile = true
;;! settings = ["sse42", "opt_level=speed", "has_avx"]

(module
  (func (export "f32.pmin") (param f32 f32) (result f32)
    (select
      (local.get 1) (local.get 0)
      (f32.lt (local.get 1) (local.get 0))))
  (func (export "f32.pmax") (param f32 f32) (result f32)
    (select
      (local.get 1) (local.get 0)
      (f32.lt (local.get 0) (local.get 1))))

  (func (export "f64.pmin") (param f64 f64) (result f64)
    (select
      (local.get 1) (local.get 0)
      (f64.lt (local.get 1) (local.get 0))))
  (func (export "f64.pmax") (param f64 f64) (result f64)
    (select
      (local.get 1) (local.get 0)
      (f64.lt (local.get 0) (local.get 1))))

  (func (export "f32x4.pmin") (param v128 v128) (result v128)
    (f32x4.pmin (local.get 0) (local.get 1)))
  (func (export "f32x4.pmax") (param v128 v128) (result v128)
    (f32x4.pmax (local.get 0) (local.get 1)))

  (func (export "f64x2.pmin") (param v128 v128) (result v128)
    (f64x2.pmin (local.get 0) (local.get 1)))
  (func (export "f64x2.pmax") (param v128 v128) (result v128)
    (f64x2.pmax (local.get 0) (local.get 1)))
)
;; function u0:0:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vminss  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:1:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vmaxss  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:2:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vminsd  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:3:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vmaxsd  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:4:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vminps  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:5:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vmaxps  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:6:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vminpd  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
;;
;; function u0:7:
;;   pushq   %rbp
;;   unwind PushFrameRegs { offset_upward_to_caller_sp: 16 }
;;   movq    %rsp, %rbp
;;   unwind DefineNewFrame { offset_upward_to_caller_sp: 16, offset_downward_to_clobbers: 0 }
;; block0:
;;   jmp     label1
;; block1:
;;   vmaxpd  %xmm1, %xmm0, %xmm0
;;   movq    %rbp, %rsp
;;   popq    %rbp
;;   ret
