# Синтезатор речи ru_tts

Альтернативная реализация синтезатора русской речи "Фонемафон-5"
международной лаборатории интеллектуальных систем "БелСИнт"
(Лаборатория распознавания и синтеза речи Института технической
кибернетики Академии наук Белорусской ССР). Исходный код
оригинальной реализации был утерян. Эта реализация является
результатом обратной разработки резидентного речевого драйвера SDRV
для MS-DOS, и она официально одобрена для публикации под свободной
лицензией Борисом Лобановым, который является руководителем
лаборатории и автором конструктивных решений, лёгших в основу данного
синтезатора речи, а также Александром Ивановым, который является
инженером лаборатории и разработчиком оригинальной программной
реализации данного синтезатора речи.


## Сборка приложения

Чтобы скомпилировать приложение, помимо C-компилятора и утилиты
[Make](https://www.gnu.org/software/make/), вам понадобятся еще GNU
[Autoconf](https://www.gnu.org/software/autoconf/),
[Automake](https://www.gnu.org/software/automake/) и
[Libtool](https://www.gnu.org/software/libtool/). В Debian-подобной
операционной системе все необходимое можно установить командой:

```bash
$ sudo apt install autoconf-archive automake libtool make
```

Собственно же процесс сборки складывается из трех стадий:

```bash
$ autoreconf -ifs
$ ./configure
$ make
```

Процессом сборки можно управлять посредством ключей, передаваемых в
командной строке скрипту `configure`, создаваемому на первой
стадии. Чтобы получить представление об этих ключах, вызовите его так:

```bash
$ ./configure --help
```


## Кооперация со словарем произношений RuLex

Речь синтезатора может быть улучшена использованием словаря
произношений из проекта [RuLex](https://github.com/poretsky/rulex). По
умолчанию, библиотека `rulex`, предоставляющая средства доступа к
словарю, не связывается с результирующим исполняемым файлом в качестве
необходимого компонента, а подгружается динамически по мере надобности
во время исполнения при наличии ее в системе.

Чтобы связать библиотеку `rulex` с приложением на этапе сборки, при
вызове скрипта `configure` используйте ключ
`--with-dictionary`. Напротив, если взаимодействие со словарем
произношений по каким-либо причинам является в принципе нежелательным,
вызывайте скрипт `configure` с ключом `--without-dictionary`.


## Установка

Скомпилированное приложение можно установить командой:

```bash
# make install
```

Кроме того, для некоторых версий *Ubuntu* существуют готовые пакеты,
которые можно непосредственно установить следующим образом:

```bash
$ sudo add-apt-repository ppa:poretsky/a11y
$ sudo apt update
$ sudo apt install ru-tts
```


## Использование

Подробности касательно использования смотрите в [README файле](README.ru).


## Благодарности

Благодарим следующие организации и людей за их вклад в проект:

* Международную лабораторию интеллектуальных систем "БелСИнт" за
  разработку оригинального резидентного речевого драйвера SDRV;
* Дмитрия Падучих за помощь в первичном дизассемблировании
  резидентного речевого драйвера SDRV;
* Бориса Лобанова за создание синтезатора речи "Фонемафон-5" и
  одобрение публикации результатов обратной разработки резидентного
  речевого драйвера SDRV под свободной лицензией.
* Александра Иванова за разработку оригинальной программной
  реализации синтезатора речи "Фонемафон-5" и одобрение публикации
  результатов обратной разработки резидентного речевого драйвера
  SDRV под свободной лицензией.


## Научные публикации

В любых статьях или публикациях, в которых используются или
упоминаются конструктивные решения синтезатора речи "Фонемафон-5",
просьба цитировать следующую статью:

* Иванов А.Н., Лобанов Б.М. - Синтезатор речи ФОНЕМАФОН для САПР на
  базе IBM PC // Тез. докл. конф. “Теория и методы создания
  интеллектуальных САПР”. - Минск, 1992. - С. 29-30.

Вышеупомянутая статья представляет собой базовую публикацию об
оригинальной реализации синтезатора речи "Фонемафон-5" для MS-DOS.

Микроволновой метод синтеза речи, разработанный Борисом Лобановым и
использованный в "Фонемафоне-5", также описан в следующих научных
публикациях:

* [Лобанов Б.М. - Микроволновой синтез речи по тексту // Анализ и
  синтез речи. - Минск: Инст. техн. кибернетики АНБ, 1991. -
  С. 57-73.](publications/Lobanov_B.M._-_Microwave_Speech_Synthesis_from_Text_(in_Russian).pdf)
* Лобанов Б.М. - Программная модель микроволнового синтеза речи по
  тексту // Автоматическое распознавание слуховых образов (АРСО-14). -
  М., 1991. - С. 82-84.
* Лобанов Б.М. - Микроволновой синтез речи // Автоматическое
  распознавание слуховых образов (АРСО-16). - М., 1991. - С. 27-31.
* Lobanov B. - Microwave Speech Synthesis from Text // Proc. of the 24
  Fachkolloquim Informationstechnik. - Dresden, 1991. - pp. 118-120.


## Связанные проекты

Существует несколько проектов, связанных с синтезатором речи ru_tts:

* [RuLex](https://github.com/poretsky/rulex) -
  русский словарь произношений для ru_tts
* [ru_tts for NVDA](https://github.com/kvark128/ru_tts-for-nvda) -
  дополнение для программы экранного доступа NVDA с речевым драйвером для ru_tts.
* [RU_TTS_EX](https://electrik-spb.ru/ru_tts/ru_tts_ex/) -
  расширение для облегчения работы с языками высокого уровня
  и реализации дополнительных возможностей синтезатора
  (устарело после ru_tts package release 6.0.4 и не поддерживается)
