///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// interface : provides data structures for interfaces and free surfaces
//
// author:
//      JEtienne@ujf-grenoble.fr
//
// date:
//	30/01/09
//
#include "space.h"
using namespace rheolef;
using namespace std;

size_t
    
interface::get_first_node (const geo& g) const 
 { 
  check_macro(order_set, "Order not set on interface");
  return g.begin()[_first_K][_first_iloc];
 } 
size_t
interface::get_last_node (const geo& g, const std::string& dom) const 
 { 
  check_macro(order_set, "Order not set on interface");
  return g[dom].begin()[_last_K][_last_iloc]; 
 }

size_t
interface::first_Hermite_dof (const class space& Nh) const
 { 
    check_macro(order_set, "Order not set on interface");
    check_macro(Nh.n_component()==1||Nh.get_approx()=="H3", 
    	"Only scalar H3 spaces can be subject to dof-blocking");
    tiny_vector<point::size_type> dofs;
    Nh.set_dof((Nh.get_geo().begin())[_first_K],dofs);
    return (dofs[_first_iloc+2]);
 }

size_t
interface::last_Hermite_dof (const class space& Nh) const
 { 
    check_macro(order_set, "Order not set on interface");
    check_macro(Nh.n_component()==1||Nh.get_approx()=="H3", 
    	"Only scalar H3 spaces can be subject to dof-blocking");
    tiny_vector<point::size_type> dofs;
    Nh.set_dof((Nh.get_geo().begin())[_last_K],dofs);
    return (dofs[_last_iloc+2]);
 }

void
interface::block_first_dof (const class space& Nh) const
 { 
    check_macro(order_set, "Order not set on interface");
    check_macro(Nh.get_approx()=="P1"||Nh.get_approx()=="P2"||Nh.get_approx()=="H3", 
    	"Only P1 and P2 spaces can be subject to dof-blocking");
    tiny_vector<point::size_type> dofs;
    for (point::size_type id=0; id<Nh.n_component(); id++)
     {
    	Nh.set_dof((Nh.get_geo().begin())[_first_K],dofs,id);
	Nh.block_dof(dofs[_first_iloc]);
	if (Nh.get_approx()=="H3") Nh.block_dof(dofs[_first_iloc+2]);
     }
 }

void
interface::block_last_dof (const class space& Nh) const
 { 
    check_macro(order_set, "Order not set on interface");
//    if (Nh.get_approx()=="H3") warning_macro( 
//    	"H3 spaces dof-blocking : only value, not derivative");
    check_macro(Nh.get_approx()=="P1"||Nh.get_approx()=="P2"||Nh.get_approx()=="H3", 
    	"Only P1 and P2 spaces can be subject to dof-blocking");
    tiny_vector<point::size_type> dofs;
    for (point::size_type id=0; id<Nh.n_component(); id++)
     {
    	Nh.set_dof((Nh.get_geo().begin())[_last_K],dofs,id);
	Nh.block_dof(dofs[_last_iloc]);
	if (Nh.get_approx()=="H3") Nh.block_dof(dofs[_last_iloc+2]);
	//Nh.block_dof(dofs[0]);
	//Nh.block_dof(dofs[1]);
     }
 }

void
interface::unblock_last_dof (const class space& Nh) const
 { 
    check_macro(order_set, "Order not set on interface");
    check_macro(Nh.get_approx()=="bubble",
    	"Only bubble spaces can presently be subject to dof-unblocking");
    tiny_vector<point::size_type> dofs;
    for (point::size_type id=0; id<Nh.n_component(); id++)
     {
    	Nh.set_dof((Nh.get_geo().begin())[_last_K],dofs,id);
	Nh.unblock_dof(dofs[_last_iloc]);
	if (Nh.get_approx()=="H3") Nh.block_dof(dofs[_last_iloc+2]);
     }
 }


