# ifndef _SKIT_CSR_ALGO_CAT_H
# define _SKIT_CSR_ALGO_CAT_H
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
namespace rheolef { 
//
// matrix concatenation
//
template<
    class InputIterator1,
    class InputIterator2,
    class InputIterator3,
    class InputIterator4,
    class InputIterator5,
    class InputIterator6,
    class OutputIterator1,
    class OutputIterator2,
    class OutputIterator3,
    class Size>
OutputIterator1
vcat (
    InputIterator1	iter_ia1,
    InputIterator1	last_ia1,
    InputIterator2	iter_ja1,
    InputIterator2	last_ja1,
    InputIterator3	iter_a1,
    InputIterator3	last_a1,
    InputIterator4	iter_ia2,
    InputIterator4	last_ia2,
    InputIterator5	iter_ja2,
    InputIterator5	last_ja2,
    InputIterator6	iter_a2,
    InputIterator6	last_a2,
    OutputIterator1	iter_ia,
    OutputIterator2	iter_ja,
    OutputIterator3	iter_a,
    Size	        nnz1)
{
    OutputIterator1 middle_ia = copy (iter_ia1, last_ia1-1, iter_ia);
    OutputIterator1 last_ia   = copy (iter_ia2, last_ia2,   middle_ia);

    OutputIterator2 middle_ja = copy (iter_ja1, last_ja1, iter_ja);
    copy (iter_ja2, last_ja2, middle_ja);

    OutputIterator3 middle_a = copy (iter_a1 , last_a1 , iter_a);
    copy (iter_a2, last_a2, middle_a);

    while (middle_ia < last_ia) (*middle_ia++) += nnz1;
    return middle_ia;
}
template<
    class InputIterator1,
    class InputIterator2,
    class InputIterator3,
    class InputIterator4,
    class InputIterator5,
    class InputIterator6,
    class OutputIterator1,
    class OutputIterator2,
    class OutputIterator3,
    class Size>
OutputIterator1
hcat (
    InputIterator1	iter_ia1,
    InputIterator2	iter_ja1,
    InputIterator3	iter_a1,
    InputIterator4	iter_ia2,
    InputIterator5	iter_ja2,
    InputIterator6	iter_a2,
    OutputIterator1	iter_ia,
    OutputIterator1	last_ia,
    OutputIterator2	iter_ja,
    OutputIterator3	iter_a,
    Size	        ncol1)
{
    Size p = 0;
    iter_ia1++;
    iter_ia2++;
    InputIterator2  first_ja1 = iter_ja1;
    InputIterator5  first_ja2 = iter_ja2;
    *iter_ia++ = p;
    while (iter_ia != last_ia) {

        InputIterator2  last_ja1  = first_ja1 + (*iter_ia1++);
        while (iter_ja1 != last_ja1) {
            (*iter_ja++) = (*iter_ja1++);
            (*iter_a++)  = (*iter_a1++);
            p++;
        }
        InputIterator5  last_ja2  = first_ja2 + (*iter_ia2++);
        while (iter_ja2 != last_ja2) {
            (*iter_ja++) = (*iter_ja2++) + ncol1;
            (*iter_a++)  = (*iter_a2++);
            p++;
        }
        (*iter_ia++) = p;
    }
    return last_ia;
}
//@!\vfill
}// namespace rheolef
# endif // _SKIT_CSR_ALGO_CAT_H
