/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2010-2014 - Hans-Kristian Arntzen
 *  Copyright (C) 2011-2016 - Daniel De Matteis
 *  Copyright (C) 2016 - Brad Parker
 *
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __MSG_HASH_H
#define __MSG_HASH_H

#include <stdint.h>
#include <stddef.h>

#include <retro_common_api.h>

#include "input/input_defines.h"

#define MSG_HASH(Id, str) case Id: return str;

RETRO_BEGIN_DECLS

enum msg_file_type
{
   FILE_TYPE_NONE = 0,
   FILE_TYPE_PLAIN,
   FILE_TYPE_DIRECTORY,
   FILE_TYPE_PARENT_DIRECTORY,
   FILE_TYPE_PATH,
   FILE_TYPE_DEVICE,
   FILE_TYPE_CORE,
   FILE_TYPE_PLAYLIST_ENTRY,
   FILE_TYPE_CONTENTLIST_ENTRY,
   FILE_TYPE_SHADER_PRESET,
   FILE_TYPE_SHADER,
   FILE_TYPE_VIDEOFILTER,
   FILE_TYPE_AUDIOFILTER,
   FILE_TYPE_CHEAT,
   FILE_TYPE_OVERLAY,
   FILE_TYPE_FONT,
   FILE_TYPE_CONFIG,
   FILE_TYPE_USE_DIRECTORY,
   FILE_TYPE_SCAN_DIRECTORY,
   FILE_TYPE_CARCHIVE,
   FILE_TYPE_IN_CARCHIVE,
   FILE_TYPE_IMAGE,
   FILE_TYPE_IMAGEVIEWER,
   FILE_TYPE_REMAP,
   FILE_TYPE_DOWNLOAD_CORE,
   FILE_TYPE_DOWNLOAD_URL,
   FILE_TYPE_DOWNLOAD_CORE_CONTENT,
   FILE_TYPE_DOWNLOAD_CORE_INFO,
   FILE_TYPE_DOWNLOAD_THUMBNAIL_CONTENT,
   FILE_TYPE_DOWNLOAD_LAKKA,
   FILE_TYPE_RDB,
   FILE_TYPE_RDB_ENTRY,
   FILE_TYPE_RPL_ENTRY,
   FILE_TYPE_CURSOR,
   FILE_TYPE_BOOL_ON,
   FILE_TYPE_BOOL_OFF,
   FILE_TYPE_RECORD_CONFIG,
   FILE_TYPE_PLAYLIST_COLLECTION,
   FILE_TYPE_PLAYLIST_ASSOCIATION,
   FILE_TYPE_MOVIE,
   FILE_TYPE_MUSIC,
   FILE_TYPE_SHADER_SLANG,
   FILE_TYPE_SHADER_GLSL,
   FILE_TYPE_SHADER_HLSL,
   FILE_TYPE_SHADER_CG,
   FILE_TYPE_SHADER_PRESET_GLSLP,
   FILE_TYPE_SHADER_PRESET_HLSLP,
   FILE_TYPE_SHADER_PRESET_CGP,
   FILE_TYPE_SHADER_PRESET_SLANGP,
   FILE_TYPE_DOWNLOAD_THUMBNAIL,
   FILE_TYPE_MORE,
   FILE_TYPE_COMPRESSED,
   FILE_TYPE_SHA1,
   FILE_TYPE_MD5,
   FILE_TYPE_CRC,

   FILE_TYPE_WEBM,
   FILE_TYPE_F4F,
   FILE_TYPE_F4V,
   FILE_TYPE_OGM,
   FILE_TYPE_MKV,
   FILE_TYPE_AVI,
   FILE_TYPE_M4A,
   FILE_TYPE_3GP,
   FILE_TYPE_3G2,
   FILE_TYPE_MP4,
   FILE_TYPE_MP3,
   FILE_TYPE_FLAC,
   FILE_TYPE_OGG,
   FILE_TYPE_FLV,
   FILE_TYPE_WAV,
   FILE_TYPE_MOV,
   FILE_TYPE_WMA,
   FILE_TYPE_WMV,
   FILE_TYPE_MPG,
   FILE_TYPE_MPEG,
   FILE_TYPE_VOB,
   FILE_TYPE_ASF,
   FILE_TYPE_DIVX,
   FILE_TYPE_M2P,
   FILE_TYPE_M2TS,
   FILE_TYPE_PS,
   FILE_TYPE_TS,
   FILE_TYPE_MXF,

   FILE_TYPE_JPEG,
   FILE_TYPE_PNG,
   FILE_TYPE_TGA,
   FILE_TYPE_BMP,

   FILE_TYPE_CUE,
   FILE_TYPE_ISO,
   FILE_TYPE_LUTRO,

   FILE_TYPE_DIRECT_LOAD,

   FILE_TYPE_LAST
};

#define MENU_LABEL(STR) \
   MENU_ENUM_LABEL_##STR, \
   MENU_ENUM_SUBLABEL_##STR, \
   MENU_ENUM_LABEL_VALUE_##STR

enum msg_hash_enums
{
   MSG_UNKNOWN = 0,
   MSG_SETTING_DISK_IN_TRAY,
   MSG_FAILED_TO_SET_DISK,
   MSG_NETPLAY_FAILED,
   MSG_NETPLAY_USERS_HAS_FLIPPED,
   MSG_UNKNOWN_NETPLAY_COMMAND_RECEIVED,
   MSG_CONNECTING_TO_NETPLAY_HOST,
   MSG_NETPLAY_LAN_SCAN_COMPLETE,
   MSG_NETPLAY_LAN_SCANNING,
   MSG_WAITING_FOR_CLIENT,
   MSG_NETPLAY_YOU_HAVE_LEFT_THE_GAME,
   MSG_NETPLAY_YOU_HAVE_JOINED_AS_PLAYER_N,
   MSG_NETPLAY_IMPLEMENTATIONS_DIFFER,
   MSG_NETPLAY_ENDIAN_DEPENDENT,
   MSG_NETPLAY_PLATFORM_DEPENDENT,
   MSG_NETPLAY_ENTER_PASSWORD,
   MSG_NETPLAY_INCORRECT_PASSWORD,
   MSG_NETPLAY_SERVER_NAMED_HANGUP,
   MSG_NETPLAY_SERVER_HANGUP,
   MSG_NETPLAY_CLIENT_HANGUP,
   MSG_NETPLAY_CANNOT_PLAY_UNPRIVILEGED,
   MSG_NETPLAY_CANNOT_PLAY_NO_SLOTS,
   MSG_NETPLAY_CANNOT_PLAY,
   MSG_NETPLAY_PEER_PAUSED,
   MSG_NETPLAY_CHANGED_NICK,
   MSG_AUTODETECT,
   MSG_AUDIO_VOLUME,
   MSG_LIBRETRO_FRONTEND,
   MSG_CAPABILITIES,
   MSG_DEVICE_CONFIGURED_IN_PORT,
   MSG_DEVICE_NOT_CONFIGURED,
   MSG_DEVICE_DISCONNECTED_FROM_PORT,
   MSG_NO_ARGUMENTS_SUPPLIED_AND_NO_MENU_BUILTIN,
   MSG_COMPILER,
   MSG_UNKNOWN_COMPILER,
   MSG_FAILED,
   MSG_SUCCEEDED,
   MSG_LOADING,
   MSG_FIRMWARE,
   MSG_CONNECTING_TO_PORT,
   MSG_CONNECTED_TO,
   MSG_FAILED_TO_LOAD,
   MSG_USING_CORE_NAME_FOR_NEW_CONFIG,
   MSG_SAVED_NEW_CONFIG_TO,
   MSG_FAILED_SAVING_CONFIG_TO,
   MSG_INFLATED_CHECKSUM_DID_NOT_MATCH_CRC32,
   MSG_FAILED_TO_EXTRACT_CONTENT_FROM_COMPRESSED_FILE,
   MSG_FILE_NOT_FOUND,
   MSG_VALUE_SHUTTING_DOWN,
   MSG_VALUE_REBOOTING,
   MSG_FAILED_TO_START_AUDIO_DRIVER,
   MSG_FOUND_LAST_STATE_SLOT,
   MSG_RESTORED_OLD_SAVE_STATE,
   MSG_NO_STATE_HAS_BEEN_LOADED_YET,
   MSG_GOT_CONNECTION_FROM,
   MSG_GOT_CONNECTION_FROM_NAME,
   MSG_CONNECTION_SLOT,
   MSG_PUBLIC_ADDRESS,
   MSG_NO_SAVE_STATE_HAS_BEEN_OVERWRITTEN_YET,
   MSG_CANNOT_INFER_NEW_CONFIG_PATH,
   MSG_UNDID_LOAD_STATE,
   MSG_UNDID_SAVE_STATE,
   MSG_CONNECT_DEVICE_FROM_A_VALID_PORT,
   MSG_VALUE_CONNECT_DEVICE_FROM_A_VALID_PORT,
   MSG_DISCONNECT_DEVICE_FROM_A_VALID_PORT,
   MSG_DISCONNECTING_DEVICE_FROM_PORT,
   MSG_VALUE_DISCONNECTING_DEVICE_FROM_PORT,
   MSG_BRINGING_UP_COMMAND_INTERFACE_ON_PORT,
   MSG_FAILED_TO_ACCEPT_INCOMING_SPECTATOR,
   MSG_FAILED_TO_GET_NICKNAME_FROM_CLIENT,
   MSG_FAILED_TO_SEND_NICKNAME_TO_CLIENT,
   MSG_FAILED_TO_SEND_NICKNAME_TO_HOST,
   MSG_FAILED_TO_RECEIVE_NICKNAME_SIZE_FROM_HOST,
   MSG_FAILED_TO_RECEIVE_NICKNAME,
   MSG_FAILED_TO_RECEIVE_NICKNAME_FROM_HOST,
   MSG_FAILED_TO_RECEIVE_HEADER_FROM_CLIENT,
   MSG_FAILED_TO_RECEIVE_SRAM_DATA_FROM_HOST,
   MSG_FAILED_TO_SEND_NICKNAME_SIZE,
   MSG_FAILED_TO_SEND_NICKNAME,
   MSG_FAILED_TO_SEND_SRAM_DATA_TO_CLIENT,
   MSG_GAME_SPECIFIC_CORE_OPTIONS_FOUND_AT,
   MSG_INVALID_NICKNAME_SIZE,
   MSG_VERSION_OF_LIBRETRO_API,
   MSG_COMPILED_AGAINST_API,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_SPECIAL_CONTENT,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_CONTENT,
   MSG_SEVERAL_PATCHES_ARE_EXPLICITLY_DEFINED,
   MSG_DID_NOT_FIND_A_VALID_CONTENT_PATCH,
   MSG_FAILED_TO_ALLOCATE_MEMORY_FOR_PATCHED_CONTENT,
   MSG_CONTENT_LOADING_SKIPPED_IMPLEMENTATION_WILL_DO_IT,
   MSG_PROGRAM,
   MSG_ERROR,
   MSG_FOUND_DISK_LABEL,
   MSG_READING_FIRST_DATA_TRACK,
   MSG_COULD_NOT_FIND_COMPATIBLE_SYSTEM,
   MSG_COMPARING_WITH_KNOWN_MAGIC_NUMBERS,
   MSG_COULD_NOT_FIND_VALID_DATA_TRACK,
   MSG_COULD_NOT_OPEN_DATA_TRACK,
   MSG_FOUND_FIRST_DATA_TRACK_ON_FILE,
   MSG_FRAMES,
   MSG_FOUND_SHADER,
   MSG_LOADING_HISTORY_FILE,
   MSG_COULD_NOT_READ_STATE_FROM_MOVIE,
   MSG_MOVIE_FILE_IS_NOT_A_VALID_BSV1_FILE,
   MSG_OVERRIDES_SAVED_SUCCESSFULLY,
   MSG_AUTOCONFIG_FILE_SAVED_SUCCESSFULLY,
   MSG_AUTOCONFIG_FILE_ERROR_SAVING,
   MSG_OVERRIDES_ERROR_SAVING,
   MSG_FILE_ALREADY_EXISTS_SAVING_TO_BACKUP_BUFFER,
   MSG_AUTOLOADING_SAVESTATE_FROM,
   MSG_FOUND_AUTO_SAVESTATE_IN,
   MSG_SRAM_WILL_NOT_BE_SAVED,
   MSG_FAILED_TO_BIND_SOCKET,
   MSG_AUTO_SAVE_STATE_TO,
   MSG_RESTORING_DEFAULT_SHADER_PRESET_TO,
   MSG_SORRY_UNIMPLEMENTED_CORES_DONT_DEMAND_CONTENT_NETPLAY,
   MSG_RECEIVED,
   MSG_LOADING_CONTENT_FILE,
   MSG_FATAL_ERROR_RECEIVED_IN,
   MSG_FAILED_TO_PATCH,
   MSG_COULD_NOT_READ_MOVIE_HEADER,
   MSG_CRC32_CHECKSUM_MISMATCH,
   MSG_USING_LIBRETRO_DUMMY_CORE_RECORDING_SKIPPED,
   MSG_FAILED_TO_OPEN_LIBRETRO_CORE,
   MSG_COULD_NOT_FIND_ANY_NEXT_DRIVER,
   MSG_MOVIE_FORMAT_DIFFERENT_SERIALIZER_VERSION,
   MSG_CONTENT_CRC32S_DIFFER,
   MSG_RECORDING_TERMINATED_DUE_TO_RESIZE,
   MSG_FAILED_TO_START_RECORDING,
   MSG_REVERTING_SAVEFILE_DIRECTORY_TO,
   MSG_ERROR_PARSING_ARGUMENTS,
   MSG_REVERTING_SAVESTATE_DIRECTORY_TO,
   MSG_DOWNLOAD_FAILED,
   MSG_APPLYING_CHEAT,
   MSG_INPUT_CHEAT,
   MSG_INPUT_PRESET_FILENAME,
   MSG_INPUT_CHEAT_FILENAME,
   MSG_REMAP_FILE_SAVED_SUCCESSFULLY,
   MSG_SHADER_PRESET_SAVED_SUCCESSFULLY,
   MSG_ERROR_SAVING_REMAP_FILE,
   MSG_ERROR_SAVING_SHADER_PRESET,
   MSG_FAILED_TO_CREATE_THE_DIRECTORY,
   MSG_ERROR_SAVING_CORE_OPTIONS_FILE,
   MSG_CORE_OPTIONS_FILE_CREATED_SUCCESSFULLY,
   MSG_DECOMPRESSION_ALREADY_IN_PROGRESS,
   MSG_DECOMPRESSION_FAILED,
   MSG_DISK_EJECTED,
   MSG_DISK_CLOSED,
   MSG_REWIND_INIT,
   MSG_REWIND_INIT_FAILED,
   MSG_REWIND_INIT_FAILED_THREADED_AUDIO,
   MSG_LIBRETRO_ABI_BREAK,
   MSG_DETECTED_VIEWPORT_OF,
   MSG_RECORDING_TO,
   MSG_HW_RENDERED_MUST_USE_POSTSHADED_RECORDING,
   MSG_VIEWPORT_SIZE_CALCULATION_FAILED,
   MSG_AUTOSAVE_FAILED,
   MSG_MOVIE_RECORD_STOPPED,
   MSG_MOVIE_PLAYBACK_ENDED,
   MSG_TAKING_SCREENSHOT,
   MSG_WIFI_SCAN_COMPLETE,
   MSG_SCANNING_WIRELESS_NETWORKS,
   MSG_FAILED_TO_TAKE_SCREENSHOT,
   MSG_CUSTOM_TIMING_GIVEN,
   MSG_SAVING_STATE,
   MSG_UNDOING_SAVE_STATE,
   MSG_LOADING_STATE,
   MSG_FAILED_TO_SAVE_STATE_TO,
   MSG_FAILED_TO_SAVE_SRAM,
   MSG_STATE_SIZE,
   MSG_FAILED_TO_LOAD_CONTENT,
   MSG_COULD_NOT_READ_CONTENT_FILE,
   MSG_SAVED_SUCCESSFULLY_TO,
   MSG_BYTES,
   MSG_BLOCKING_SRAM_OVERWRITE,
   MSG_UNRECOGNIZED_COMMAND,
   MSG_SENDING_COMMAND,
   MSG_RESTARTING_RECORDING_DUE_TO_DRIVER_REINIT,
   MSG_REWINDING,
   MSG_SLOW_MOTION_REWIND,
   MSG_SLOW_MOTION,
   MSG_REWIND_REACHED_END,
   MSG_FAILED_TO_START_MOVIE_RECORD,
   MSG_CHEEVOS_HARDCORE_MODE_ENABLE,
   MSG_STATE_SLOT,
   MSG_STARTING_MOVIE_RECORD_TO,
   MSG_FAILED_TO_APPLY_SHADER,
   MSG_APPLYING_SHADER,
   MSG_SHADER,
   MSG_REDIRECTING_SAVESTATE_TO,
   MSG_REDIRECTING_SAVEFILE_TO,
   MSG_REDIRECTING_CHEATFILE_TO,
   MSG_SCANNING,
   MSG_SCANNING_OF_DIRECTORY_FINISHED,
   MSG_LOADED_STATE_FROM_SLOT,
   MSG_LOADED_STATE_FROM_SLOT_AUTO,
   MSG_REMOVING_TEMPORARY_CONTENT_FILE,
   MSG_FAILED_TO_REMOVE_TEMPORARY_FILE,
   MSG_STARTING_MOVIE_PLAYBACK,
   MSG_APPENDED_DISK,
   MSG_SKIPPING_SRAM_LOAD,
   MSG_CONFIG_DIRECTORY_NOT_SET,
   MSG_SAVED_STATE_TO_SLOT,
   MSG_SAVED_STATE_TO_SLOT_AUTO,
   MSG_CORE_DOES_NOT_SUPPORT_SAVESTATES,
   MSG_FAILED_TO_LOAD_STATE,
   MSG_FAILED_TO_UNDO_LOAD_STATE,
   MSG_FAILED_TO_UNDO_SAVE_STATE,
   MSG_RESET,
   MSG_AUDIO_MUTED,
   MSG_AUDIO_UNMUTED,
   MSG_FAILED_TO_UNMUTE_AUDIO,
   MSG_FAILED_TO_LOAD_OVERLAY,
   MSG_PAUSED,
   MSG_UNPAUSED,
   MSG_CORE_DOES_NOT_SUPPORT_DISK_OPTIONS,
   MSG_GRAB_MOUSE_STATE,
   MSG_GAME_FOCUS_ON,
   MSG_GAME_FOCUS_OFF,
   MSG_FAILED_TO_LOAD_MOVIE_FILE,
   MSG_FAILED_TO,
   MSG_SAVING_RAM_TYPE,
   MSG_TO,
   MSG_VIRTUAL_DISK_TRAY,
   MSG_REMOVED_DISK_FROM_TRAY,
   MSG_FAILED_TO_REMOVE_DISK_FROM_TRAY,
   MSG_GOT_INVALID_DISK_INDEX,
   MSG_DOWNLOADING,
   MSG_EXTRACTING,
   MSG_EXTRACTING_FILE,
   MSG_NO_CONTENT_STARTING_DUMMY_CORE,

   MENU_ENUM_LABEL_MENU_TOGGLE,

   MENU_LABEL(NO_HISTORY_AVAILABLE),

   MENU_ENUM_LABEL_VALUE_REMAP_FILE,
   MENU_ENUM_LABEL_VALUE_CHEAT_FILE,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_BEGIN,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_END   = MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_BEGIN + RARCH_BIND_LIST_END,

   MENU_LABEL(MENU_WALLPAPER_OPACITY),

   MENU_ENUM_LABEL_VALUE_CONFIG,
   MENU_ENUM_LABEL_VALUE_OVERLAY,
   MENU_ENUM_LABEL_VALUE_AUTO,

   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_MONOCHROME,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_FLATUI,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_RETROACTIVE,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_PIXEL,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_NEOACTIVE,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_SYSTEMATIC,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_DOTART,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_CUSTOM,

   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_LEGACY_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_DARK_PURPLE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_MIDNIGHT_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_GOLDEN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_ELECTRIC_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_APPLE_GREEN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_UNDERSEA,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_VOLCANIC_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_DARK,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_PLAIN,

   MENU_LABEL(SHADER_PIPELINE_RIBBON_SIMPLIFIED),
   MENU_LABEL(SHADER_PIPELINE_RIBBON),
   MENU_LABEL(SHADER_PIPELINE_SIMPLE_SNOW),
   MENU_LABEL(SHADER_PIPELINE_SNOW),
   MENU_LABEL(SHADER_PIPELINE_BOKEH),

   MENU_LABEL(MATERIALUI_MENU_HEADER_OPACITY),
   MENU_LABEL(MATERIALUI_MENU_FOOTER_OPACITY),
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_BLUE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_BLUE_GREY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_RED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_GREEN,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_YELLOW,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_NVIDIA_SHIELD,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_DARK_BLUE,

   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_LATE,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_NORMAL,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_EARLY,
   MENU_ENUM_LABEL_PLAYLIST_COLLECTION_ENTRY,

   MENU_LABEL(CHEEVOS_UNLOCKED_ENTRY),
   MENU_LABEL(CHEEVOS_LOCKED_ENTRY),

   MENU_ENUM_LABEL_SHADER_PARAMETERS_ENTRY,
   MENU_ENUM_LABEL_RDB_ENTRY,
   MENU_ENUM_LABEL_URL_ENTRY,
   MENU_ENUM_LABEL_CORE_OPTION_ENTRY,
   MENU_ENUM_LABEL_NETWORK_INFO_ENTRY,
   MENU_ENUM_LABEL_SYSTEM_INFO_ENTRY,
   MENU_ENUM_LABEL_CORE_INFO_ENTRY,
   MENU_ENUM_LABEL_PLAYLIST_ENTRY,

   MENU_LABEL(START_VIDEO_PROCESSOR),
   MENU_LABEL(START_NET_RETROPAD),

   MENU_ENUM_LABEL_VALUE_INTERNAL_STORAGE_STATUS,

   /* System information */
   MENU_LABEL(CPU_CORES),
   MENU_LABEL(CPU_ARCHITECTURE),

   /* Input  */

   MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE,
   MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE_LAST = MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE,
   MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE_LAST = MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE + MAX_USERS,
   MENU_ENUM_LABEL_INPUT_SETTINGS_BEGIN,

   MENU_LABEL(INPUT_HOTKEY_BINDS),

   MENU_ENUM_LABEL_INPUT_HOTKEY_BINDS_BEGIN,

   MENU_LABEL(INPUT_TURBO_PERIOD),

   MENU_ENUM_LABEL_INPUT_PLAYER1_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER2_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER3_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER4_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER5_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_BIND_DEVICE_TYPE,
   MENU_ENUM_LABEL_INPUT_DRIVER_LINUXRAW,
   MENU_ENUM_LABEL_INPUT_DRIVER_UDEV,
   MENU_ENUM_LABEL_INPUT_USER_1_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_2_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_3_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_4_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_5_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_6_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_7_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_8_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_9_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_10_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_11_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_12_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_13_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_14_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_15_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_16_BINDS,
   MENU_ENUM_LABEL_INPUT_HOTKEY_SETTINGS,

   MENU_LABEL(INPUT_REMAPPING_DIRECTORY),

   MENU_ENUM_LABEL_INPUT_BIND_MODE,
   MENU_ENUM_LABEL_INPUT_OVERLAY,
   MENU_ENUM_LABEL_INPUT_OSK_OVERLAY,

   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_B,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_Y,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_SELECT,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_START,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_DOWN,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_LEFT,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_RIGHT,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_A,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_X,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L2,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R2,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_L3,
   MENU_ENUM_LABEL_VALUE_INPUT_JOYPAD_R3,
   MENU_ENUM_LABEL_VALUE_INPUT_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_X_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_LEFT_Y_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_X_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_ANALOG_RIGHT_Y_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_TURBO_ENABLE,

   MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FAST_FORWARD_HOLD_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_LOAD_STATE_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SAVE_STATE_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FULLSCREEN_TOGGLE_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_QUIT_KEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_STATE_SLOT_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_MOVIE_RECORD_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_PAUSE_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_FRAMEADVANCE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_RESET,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_NEXT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SHADER_PREV,
   MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_PLUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_INDEX_MINUS,
   MENU_ENUM_LABEL_VALUE_INPUT_META_CHEAT_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SCREENSHOT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_MUTE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_OSK,
   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_FLIP,
   MENU_ENUM_LABEL_VALUE_INPUT_META_NETPLAY_GAME_WATCH,
   MENU_ENUM_LABEL_VALUE_INPUT_META_SLOWMOTION,
   MENU_ENUM_LABEL_VALUE_INPUT_META_ENABLE_HOTKEY,
   MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_UP,
   MENU_ENUM_LABEL_VALUE_INPUT_META_VOLUME_DOWN,
   MENU_ENUM_LABEL_VALUE_INPUT_META_OVERLAY_NEXT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_EJECT_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_NEXT,
   MENU_ENUM_LABEL_VALUE_INPUT_META_DISK_PREV,
   MENU_ENUM_LABEL_VALUE_INPUT_META_GRAB_MOUSE_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_GAME_FOCUS_TOGGLE,
   MENU_ENUM_LABEL_VALUE_INPUT_META_MENU_TOGGLE,

   MENU_ENUM_LABEL_VALUE_INPUT_DEVICE_INDEX,
   MENU_ENUM_LABEL_VALUE_INPUT_DEVICE_TYPE,
   MENU_ENUM_LABEL_VALUE_INPUT_ADC_TYPE,
   MENU_ENUM_LABEL_VALUE_INPUT_BIND_ALL,
   MENU_ENUM_LABEL_VALUE_INPUT_BIND_DEFAULT_ALL,
   MENU_ENUM_LABEL_VALUE_INPUT_SAVE_AUTOCONFIG,

   MENU_LABEL(INPUT_MAX_USERS),
   MENU_LABEL(INPUT_USER_BINDS),
   MENU_LABEL(INPUT_DUTY_CYCLE),
   MENU_LABEL(INPUT_AUTODETECT_ENABLE),
   MENU_LABEL(INPUT_DESCRIPTOR_LABEL_SHOW),
   MENU_LABEL(INPUT_DESCRIPTOR_HIDE_UNBOUND),
   MENU_LABEL(INPUT_AXIS_THRESHOLD),
   MENU_LABEL(INPUT_BIND_TIMEOUT),
   MENU_LABEL(INPUT_REMAP_BINDS_ENABLE),
   MENU_LABEL(MENU_INPUT_SWAP_OK_CANCEL),
   MENU_LABEL(INPUT_OVERLAY_ENABLE),
   MENU_LABEL(INPUT_OSK_OVERLAY_ENABLE),
   MENU_LABEL(INPUT_MENU_ENUM_TOGGLE_GAMEPAD_COMBO),
   MENU_LABEL(INPUT_OVERLAY_HIDE_IN_MENU),
   MENU_LABEL(INPUT_KEYBOARD_GAMEPAD_MAPPING_TYPE),
   MENU_LABEL(INPUT_SMALL_KEYBOARD_ENABLE),
   MENU_LABEL(INPUT_TOUCH_ENABLE),
   MENU_LABEL(INPUT_PREFER_FRONT_TOUCH),
   MENU_LABEL(INPUT_ICADE_ENABLE),
   MENU_LABEL(INPUT_ALL_USERS_CONTROL_MENU),
   MENU_LABEL(INPUT_POLL_TYPE_BEHAVIOR),
   MENU_LABEL(INPUT_UNIFIED_MENU_CONTROLS),

   /* Video */
   MENU_LABEL(VIDEO_FONT_ENABLE),
   MENU_LABEL(VIDEO_FONT_PATH),
   MENU_LABEL(VIDEO_FONT_SIZE),
   MENU_LABEL(VIDEO_MESSAGE_POS_X),
   MENU_LABEL(VIDEO_MESSAGE_POS_Y),
   MENU_LABEL(VIDEO_FILTER_FLICKER),
   MENU_LABEL(VIDEO_SOFT_FILTER),
   MENU_LABEL(VIDEO_MAX_SWAPCHAIN_IMAGES),
   MENU_LABEL(VIDEO_GPU_SCREENSHOT),
   MENU_LABEL(VIDEO_BLACK_FRAME_INSERTION),
   MENU_LABEL(VIDEO_FRAME_DELAY),
   MENU_LABEL(VIDEO_VSYNC),
   MENU_LABEL(VIDEO_HARD_SYNC),
   MENU_LABEL(VIDEO_HARD_SYNC_FRAMES),
   MENU_LABEL(VIDEO_WINDOWED_FULLSCREEN),
   MENU_LABEL(VIDEO_WINDOW_WIDTH),
   MENU_LABEL(VIDEO_WINDOW_HEIGHT),
   MENU_LABEL(VIDEO_FORCE_SRGB_DISABLE),
   MENU_LABEL(VIDEO_ROTATION),
   MENU_LABEL(VIDEO_SCALE),
   MENU_LABEL(VIDEO_SMOOTH),

   MENU_LABEL(VIDEO_CROP_OVERSCAN),

   MENU_LABEL(VIDEO_SCALE_INTEGER),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_X),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_Y),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_WIDTH),
   MENU_LABEL(VIDEO_VIEWPORT_CUSTOM_HEIGHT),
   MENU_LABEL(VIDEO_GAMMA),
   MENU_LABEL(VIDEO_ALLOW_ROTATE),
   MENU_LABEL(VIDEO_SHARED_CONTEXT),
   MENU_LABEL(VIDEO_THREADED),


   MENU_LABEL(VIDEO_SWAP_INTERVAL),
   MENU_LABEL(VIDEO_FULLSCREEN),
   MENU_LABEL(VIDEO_MONITOR_INDEX),
   MENU_LABEL(VIDEO_WINDOW_SCALE),
   MENU_LABEL(VIDEO_REFRESH_RATE),
   MENU_LABEL(VIDEO_REFRESH_RATE_AUTO),

   MENU_ENUM_LABEL_VALUE_DOWNLOAD_CORE,

   MENU_LABEL(PARENT_DIRECTORY),

   MENU_ENUM_LABEL_CONTENT_ACTIONS,


   /* Menu settings */
   MENU_LABEL(RUN),
   MENU_LABEL(MENU_WALLPAPER),
   MENU_LABEL(DYNAMIC_WALLPAPER),
   MENU_LABEL(PAUSE_NONACTIVE),
   MENU_LABEL(MOUSE_ENABLE),
   MENU_LABEL(POINTER_ENABLE),
   MENU_LABEL(MENU_LINEAR_FILTER),
   MENU_LABEL(NAVIGATION_WRAPAROUND),
   MENU_LABEL(SHOW_ADVANCED_SETTINGS),
   MENU_LABEL(THREADED_DATA_RUNLOOP_ENABLE),
   MENU_LABEL(ENTRY_NORMAL_COLOR),
   MENU_LABEL(ENTRY_HOVER_COLOR),
   MENU_LABEL(XMB_ALPHA_FACTOR),
   MENU_LABEL(XMB_SCALE_FACTOR),
   MENU_LABEL(XMB_FONT),
   MENU_LABEL(XMB_THEME),
   MENU_LABEL(XMB_MENU_COLOR_THEME),
   MENU_LABEL(XMB_SHADOWS_ENABLE),
   MENU_LABEL(XMB_SHOW_SETTINGS),
   MENU_LABEL(XMB_SHOW_IMAGES),
   MENU_LABEL(XMB_SHOW_MUSIC),
   MENU_LABEL(XMB_SHOW_VIDEO),
   MENU_LABEL(XMB_SHOW_HISTORY),
   MENU_LABEL(XMB_SHOW_ADD),
   MENU_LABEL(XMB_RIBBON_ENABLE),
   MENU_LABEL(THUMBNAILS),
   MENU_LABEL(TIMEDATE_ENABLE),
   MENU_LABEL(BATTERY_LEVEL_ENABLE),
   MENU_LABEL(MATERIALUI_MENU_COLOR_THEME),

   /* UI settings */
   MENU_LABEL(VIDEO_DISABLE_COMPOSITION),
   MENU_LABEL(UI_COMPANION_ENABLE),
   MENU_LABEL(UI_COMPANION_START_ON_BOOT),
   MENU_LABEL(UI_MENUBAR_ENABLE),

   MENU_ENUM_LABEL_FILE_CONFIG,
   MENU_ENUM_LABEL_FILE_BROWSER_COMPRESSED_ARCHIVE,
   MENU_ENUM_LABEL_FILE_BROWSER_CONFIG,
   MENU_ENUM_LABEL_FILE_BROWSER_RECORD_CONFIG,
   MENU_ENUM_LABEL_FILE_BROWSER_CURSOR,
   MENU_ENUM_LABEL_FILE_BROWSER_DIRECTORY,
   MENU_ENUM_LABEL_FILE_BROWSER_PLAIN_FILE,
   MENU_ENUM_LABEL_FILE_BROWSER_SHADER_PRESET,
   MENU_ENUM_LABEL_FILE_BROWSER_SHADER,
   MENU_ENUM_LABEL_FILE_BROWSER_REMAP,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE,
   MENU_ENUM_LABEL_FILE_BROWSER_OVERLAY,
   MENU_ENUM_LABEL_FILE_BROWSER_CHEAT,
   MENU_ENUM_LABEL_FILE_BROWSER_FONT,
   MENU_ENUM_LABEL_FILE_BROWSER_RDB,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE_SELECT_FROM_COLLECTION,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE_SELECT_FROM_COLLECTION_CURRENT_CORE,
   MENU_ENUM_LABEL_FILE_BROWSER_CORE_DETECTED,
   MENU_ENUM_LABEL_FILE_BROWSER_IMAGE,
   MENU_ENUM_LABEL_FILE_BROWSER_IMAGE_OPEN_WITH_VIEWER,
   MENU_ENUM_LABEL_FILE_BROWSER_MOVIE_OPEN,
   MENU_ENUM_LABEL_FILE_BROWSER_MUSIC_OPEN,

   /* Menu file browser */
   MENU_LABEL(NAVIGATION_BROWSER_FILTER_SUPPORTED_EXTENSIONS_ENABLE),

   /* Playlists */
   MENU_LABEL(HISTORY_LIST_ENABLE),
   MENU_LABEL(CONTENT_HISTORY_SIZE),
   MENU_LABEL(PLAYLIST_ENTRY_REMOVE),
   MENU_LABEL(MENU_THROTTLE_FRAMERATE),
   MENU_LABEL(NO_ACHIEVEMENTS_TO_DISPLAY),
   MENU_LABEL(NO_ENTRIES_TO_DISPLAY),

   /* Help */

   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_SCROLL_UP,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_SCROLL_DOWN,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_CONFIRM,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_BACK,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_START,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_INFO,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_TOGGLE_MENU,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_QUIT,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_TOGGLE_KEYBOARD,

   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_SCROLL_UP,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_CONFIRM,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_START,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_INFO,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_TOGGLE_MENU,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_QUIT,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_TOGGLE_KEYBOARD,

   MENU_LABEL(MENU_SETTINGS),
   MENU_LABEL(THUMBNAILS_UPDATER_LIST),
   MENU_LABEL(USER_INTERFACE_SETTINGS),
   MENU_LABEL(RETRO_ACHIEVEMENTS_SETTINGS),
   MENU_LABEL(MENU_FILE_BROWSER_SETTINGS),
   MENU_LABEL(UPDATER_SETTINGS),
   MENU_LABEL(WIFI_SETTINGS),
   MENU_LABEL(USER_SETTINGS),
   MENU_LABEL(DIRECTORY_SETTINGS),
   MENU_LABEL(PRIVACY_SETTINGS),
   MENU_LABEL(NETWORK_SETTINGS),
   MENU_LABEL(NETPLAY_LAN_SCAN_SETTINGS),

   MENU_ENUM_LABEL_CONNECT_WIFI,
   MENU_ENUM_LABEL_CONNECT_NETPLAY_ROOM,
   MENU_ENUM_LABEL_CONNECT_NETPLAY_LAN,

   MENU_LABEL(MENU_ENUM_LINEAR_FILTER),
   MENU_LABEL(MENU_ENUM_THROTTLE_FRAMERATE),
   MENU_LABEL(STATE_SLOT),

   MENU_ENUM_LABEL_PLAYLIST_SETTINGS_BEGIN,


   MENU_ENUM_LABEL_VALUE_CHEEVOS_SETTINGS,

   MENU_LABEL(CHEEVOS_USERNAME),
   MENU_LABEL(CHEEVOS_PASSWORD),

   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_SETTINGS,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_PASSWORD,

   MENU_LABEL(ACCOUNTS_CHEEVOS_USERNAME),
   MENU_LABEL(CHEEVOS_HARDCORE_MODE_ENABLE),
   MENU_LABEL(CHEEVOS_TEST_UNOFFICIAL),
   MENU_LABEL(CHEEVOS_ENABLE),
   MENU_LABEL(CHEEVOS_DESCRIPTION),
   MENU_LABEL(CHEEVOS_UNLOCKED_ACHIEVEMENTS),
   MENU_LABEL(CHEEVOS_LOCKED_ACHIEVEMENTS),
   MENU_LABEL(ACCOUNTS_RETRO_ACHIEVEMENTS),

   MENU_LABEL(ACCOUNTS_LIST),

   MENU_ENUM_LABEL_VALUE_ACCOUNTS_LIST_END,

   MENU_ENUM_LABEL_VALUE_MENU_ENUM_CONTROLS_PROLOG,

   MENU_LABEL(HELP_WHAT_IS_A_CORE),
   MENU_LABEL(HELP_LOADING_CONTENT),
   MENU_LABEL(HELP_LIST),
   MENU_LABEL(HELP_CONTROLS),

   MENU_ENUM_LABEL_VALUE_EXTRACTING_PLEASE_WAIT,

   MENU_ENUM_LABEL_WELCOME_TO_RETROARCH,

   MENU_LABEL(BROWSE_URL),
   MENU_LABEL(BROWSE_START),
   /* Deferred */
   MENU_ENUM_LABEL_DEFERRED_BROWSE_URL_START,
   MENU_ENUM_LABEL_DEFERRED_BROWSE_URL_LIST,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_ACTION_DETECT_CORE,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_ACTION,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_OPEN_DETECT_CORE,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_OPEN,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_DIRS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_DIRS_SUBDIR_LIST,
   MENU_ENUM_LABEL_DEFERRED_LAKKA_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_HOTKEY_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DATABASE_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_FILTER,
   MENU_ENUM_LABEL_DEFERRED_CORE_LIST_SET,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_DEVELOPER,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PUBLISHER,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ORIGIN,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FRANCHISE,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_ISSUE,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FAMITSU_MAGAZINE_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ENHANCEMENT_HW,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEMONTH,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEYEAR,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ESRB_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ELSPA_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PEGI_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_CERO_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_BBFC_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_MAX_USERS,
   MENU_ENUM_LABEL_DEFERRED_RDB_ENTRY_DETAIL,
   MENU_ENUM_LABEL_DEFERRED_RPL_ENTRY_ACTIONS,
   MENU_ENUM_LABEL_DEFERRED_CORE_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_DEFERRED_THUMBNAILS_UPDATER_LIST,
   MENU_ENUM_LABEL_DEFERRED_RECORDING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_PLAYLIST_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DRIVER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CONFIGURATION_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_SAVING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_FRAME_THROTTLE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_REWIND_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_DISPLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_OVERLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_NOTIFICATIONS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MENU_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_INTERFACE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MENU_FILE_BROWSER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_RETRO_ACHIEVEMENTS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_UPDATER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_WIFI_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETWORK_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETPLAY_LAN_SCAN_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_LAKKA_SERVICES_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DIRECTORY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_PRIVACY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_LOGGING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_AUDIO_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_CHEEVOS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_LIST,

   MENU_LABEL(FILE_DETECT_CORE_LIST_PUSH_DIR),
   MENU_LABEL(DOWNLOADED_FILE_DETECT_CORE_LIST),

   MENU_ENUM_LABEL_VALUE_SEARCH,

   MENU_LABEL(DOWNLOAD_CORE_CONTENT),
   MENU_LABEL(DOWNLOAD_CORE_CONTENT_DIRS),
   MENU_LABEL(SCAN_THIS_DIRECTORY),
   MENU_LABEL(SCAN_DIRECTORY),
   MENU_LABEL(SCAN_FILE),
   MENU_LABEL(NETPLAY_REFRESH_ROOMS),
   MENU_LABEL(NETPLAY_ROOM_NICKNAME),
   MENU_LABEL(ADD_CONTENT_LIST),
   MENU_LABEL(CONFIGURATIONS_LIST),

   MENU_ENUM_LABEL_VALUE_DONT_CARE,
   MENU_ENUM_LABEL_VALUE_LINEAR,
   MENU_ENUM_LABEL_VALUE_NEAREST,
   MENU_ENUM_LABEL_VALUE_UNKNOWN,
   MENU_ENUM_LABEL_VALUE_USER,
   MENU_ENUM_LABEL_VALUE_CHEAT,
   MENU_ENUM_LABEL_VALUE_SHADER,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_CONTENT,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_NONE,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_DEFAULT,
   MENU_ENUM_LABEL_VALUE_NOT_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_ASK_ARCHIVE,

   /* Online Updater */

   MENU_LABEL(UPDATE_ASSETS),
   MENU_LABEL(UPDATE_LAKKA),
   MENU_LABEL(UPDATE_CHEATS),
   MENU_LABEL(UPDATE_AUTOCONFIG_PROFILES),
   MENU_LABEL(UPDATE_DATABASES),
   MENU_LABEL(UPDATE_CG_SHADERS),
   MENU_LABEL(UPDATE_OVERLAYS),
   MENU_LABEL(UPDATE_GLSL_SHADERS),
   MENU_LABEL(UPDATE_SLANG_SHADERS),
   MENU_LABEL(UPDATE_CORE_INFO_FILES),

   MENU_LABEL(INFORMATION),
   MENU_LABEL(INFORMATION_LIST),
   MENU_LABEL(USE_BUILTIN_PLAYER),
   MENU_LABEL(CONTENT_SETTINGS),
   MENU_LABEL(LOAD_CONTENT_LIST),
   MENU_LABEL(NO_SETTINGS_FOUND),
   MENU_LABEL(NO_NETWORKS_FOUND),
   MENU_LABEL(NO_PERFORMANCE_COUNTERS),
   MENU_LABEL(FRAME_THROTTLE_SETTINGS),
   MENU_LABEL(FRAME_THROTTLE_ENABLE),
   MENU_LABEL(CORE_ENABLE),

   /* Netplay */
   MENU_LABEL(NETPLAY_ENABLE_HOST),
   MENU_LABEL(NETPLAY_ENABLE_CLIENT),
   MENU_LABEL(NETPLAY_DISCONNECT),
   MENU_LABEL(NETPLAY_SETTINGS),
   MENU_LABEL(NETPLAY_CONNECT_TO),
   MENU_LABEL(NO_NETPLAY_HOSTS_FOUND),

   MENU_ENUM_LABEL_RESET,
   MENU_ENUM_LABEL_SLOWMOTION,
   MENU_ENUM_LABEL_HOLD_FAST_FORWARD,
   MENU_ENUM_LABEL_CHEAT_TOGGLE,
   MENU_ENUM_LABEL_PAUSE_TOGGLE,

   MENU_LABEL(PAUSE_LIBRETRO),
   MENU_LABEL(DIRECTORY_NOT_FOUND),
   MENU_LABEL(NO_ITEMS),
   MENU_LABEL(NO_PLAYLISTS),

   MSG_INTERFACE,
   MSG_MEMORY,
   MSG_IN_BYTES,
   MSG_IN_MEGABYTES,
   MSG_IN_GIGABYTES,
   MSG_INTERNAL_STORAGE,
   MSG_REMOVABLE_STORAGE,
   MSG_APPLICATION_DIR,
   MSG_EXTERNAL_APPLICATION_DIR,

   MENU_LABEL(ARCHIVE_MODE),
   MENU_LABEL(SHADER_OPTIONS),
   MENU_LABEL(USE_THIS_DIRECTORY),
   MENU_LABEL(CORE_OPTIONS),
   MENU_LABEL(NO_SHADER_PARAMETERS),
   MENU_LABEL(NO_CORE_INFORMATION_AVAILABLE),
   MENU_LABEL(NO_CORES_AVAILABLE),

   /* Audio */
   MENU_LABEL(AUDIO_ENABLE),
   MENU_LABEL(AUDIO_MAX_TIMING_SKEW),
   MENU_LABEL(AUDIO_OUTPUT_RATE),
   MENU_LABEL(AUDIO_DEVICE),
   MENU_LABEL(AUDIO_BLOCK_FRAMES),
   MENU_LABEL(AUDIO_DSP_PLUGIN),
   MENU_LABEL(AUDIO_MUTE),
   MENU_LABEL(AUDIO_SYNC),
   MENU_LABEL(AUDIO_VOLUME),
   MENU_LABEL(AUDIO_RATE_CONTROL_DELTA),
   MENU_LABEL(AUDIO_LATENCY),
   MENU_LABEL(SAVE_STATE),
   MENU_LABEL(LOAD_STATE),
   MENU_LABEL(UNDO_LOAD_STATE),
   MENU_LABEL(UNDO_SAVE_STATE),

   MENU_LABEL(NETPLAY_FLIP_PLAYERS),
   MENU_LABEL(NETPLAY_GAME_WATCH),
   MENU_LABEL(CHEAT_INDEX_MINUS),
   MENU_LABEL(CHEAT_INDEX_PLUS),
   MENU_LABEL(SHADER_NEXT),
   MENU_LABEL(SHADER_PREV),
   MENU_LABEL(FRAME_ADVANCE),
   MENU_LABEL(FPS_SHOW),
   MENU_LABEL(MOVIE_RECORD_TOGGLE),
   MENU_ENUM_LABEL_L_X_PLUS,
   MENU_ENUM_LABEL_L_X_MINUS,
   MENU_ENUM_LABEL_L_Y_PLUS,
   MENU_ENUM_LABEL_L_Y_MINUS,
   MENU_ENUM_LABEL_R_X_PLUS,
   MENU_ENUM_LABEL_R_X_MINUS,
   MENU_ENUM_LABEL_R_Y_MINUS,
   MENU_ENUM_LABEL_R_Y_PLUS,

   MENU_LABEL(BLOCK_SRAM_OVERWRITE),
   MENU_LABEL(GAME_SPECIFIC_OPTIONS),
   MENU_LABEL(GAME_SPECIFIC_OPTIONS_CREATE),
   MENU_LABEL(GAME_SPECIFIC_OPTIONS_IN_USE),
   MENU_LABEL(AUTO_OVERRIDES_ENABLE),
   MENU_LABEL(AUTO_REMAPS_ENABLE),
   MENU_LABEL(AUTO_SHADERS_ENABLE),
   MENU_LABEL(RGUI_SHOW_START_SCREEN),
   MENU_LABEL(SCREENSHOT),
   MENU_LABEL(REWIND),
   MENU_LABEL(REWIND_GRANULARITY),
   MENU_LABEL(INPUT_META_REWIND),

   MENU_LABEL(SCREEN_RESOLUTION),
   MENU_LABEL(TITLE_COLOR),
   MENU_LABEL(SAVESTATE_AUTO_INDEX),
   MENU_LABEL(SAVESTATE_AUTO_SAVE),
   MENU_LABEL(SAVESTATE_AUTO_LOAD),
   MENU_LABEL(SAVESTATE_THUMBNAIL_ENABLE),

   MENU_LABEL(SUSPEND_SCREENSAVER_ENABLE),
   MENU_LABEL(DPI_OVERRIDE_ENABLE),
   MENU_LABEL(DPI_OVERRIDE_VALUE),
   MENU_ENUM_LABEL_VOLUME_UP,
   MENU_ENUM_LABEL_VOLUME_DOWN,

   MENU_LABEL(LOG_VERBOSITY),

   MENU_ENUM_LABEL_OVERLAY_NEXT,

   MENU_LABEL(NETPLAY_ENABLE),
   MENU_LABEL(SSH_ENABLE),
   MENU_LABEL(SAMBA_ENABLE),
   MENU_LABEL(BLUETOOTH_ENABLE),
   MENU_LABEL(NETPLAY_CLIENT_SWAP_INPUT),
   MENU_LABEL(NETPLAY_DELAY_FRAMES),
   MENU_LABEL(NETPLAY_STATELESS_MODE),
   MENU_LABEL(NETPLAY_CHECK_FRAMES),
   MENU_LABEL(NETPLAY_INPUT_LATENCY_FRAMES_MIN),
   MENU_LABEL(NETPLAY_INPUT_LATENCY_FRAMES_RANGE),
   MENU_LABEL(NETPLAY_SPECTATOR_MODE_ENABLE),
   MENU_LABEL(NETPLAY_TCP_UDP_PORT),
   MENU_LABEL(NETPLAY_NAT_TRAVERSAL),
   MENU_LABEL(SORT_SAVEFILES_ENABLE),
   MENU_LABEL(SORT_SAVESTATES_ENABLE),
   MENU_LABEL(NETPLAY_IP_ADDRESS),
   MENU_LABEL(NETPLAY_PASSWORD),
   MENU_LABEL(NETPLAY_SPECTATE_PASSWORD),
   MENU_LABEL(NETPLAY_MODE),
   MENU_LABEL(PERFCNT_ENABLE),
   MENU_LABEL(OVERLAY_SCALE),
   MENU_LABEL(OVERLAY_PRESET),
   MENU_LABEL(OVERLAY_OPACITY),

   MENU_LABEL(FASTFORWARD_RATIO),
   MENU_LABEL(REWIND_ENABLE),

   MENU_ENUM_LABEL_ENABLE_HOTKEY,
   MENU_ENUM_LABEL_DISK_EJECT_TOGGLE,
   MENU_ENUM_LABEL_DISK_NEXT,
   MENU_ENUM_LABEL_GRAB_MOUSE_TOGGLE,
   MENU_ENUM_LABEL_GAME_FOCUS_TOGGLE,
   MENU_LABEL(STATE_SLOT_DECREASE),
   MENU_LABEL(STATE_SLOT_INCREASE),

   MENU_LABEL(LIBRETRO_LOG_LEVEL),
   MENU_LABEL(AUTOSAVE_INTERVAL),
   MENU_LABEL(CONFIG_SAVE_ON_EXIT),
   MENU_LABEL(CONFIGURATION_LIST),
   MENU_LABEL(CONFIRM_ON_EXIT),
   MENU_LABEL(SHOW_HIDDEN_FILES),

   /* Driver settings */

   MENU_LABEL(AUDIO_DRIVER),
   MENU_LABEL(JOYPAD_DRIVER),
   MENU_LABEL(MENU_DRIVER),
   MENU_LABEL(LOCATION_DRIVER),
   MENU_LABEL(CAMERA_DRIVER),
   MENU_LABEL(WIFI_DRIVER),
   MENU_LABEL(AUDIO_RESAMPLER_DRIVER),
   MENU_LABEL(RECORD_DRIVER),
   MENU_LABEL(VIDEO_DRIVER),
   MENU_LABEL(INPUT_DRIVER),

   MENU_ENUM_LABEL_VIDEO_DRIVER_GL,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL2,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL1,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D,
   MENU_ENUM_LABEL_VIDEO_DRIVER_EXYNOS,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SUNXI,
   MENU_ENUM_LABEL_VIDEO_DRIVER_DRM,

   MENU_LABEL(MENU_ENUM_DRIVER),

   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_SINC,
   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_CC,

   MENU_LABEL(SAVEFILE_DIRECTORY),
   MENU_LABEL(SAVESTATE_DIRECTORY),
   MENU_LABEL(DYNAMIC_WALLPAPERS_DIRECTORY),
   MENU_LABEL(THUMBNAILS_DIRECTORY),

   MENU_LABEL(SLOWMOTION_RATIO),
   MENU_LABEL(TURBO),

   /* Privacy settings */

   MENU_LABEL(CAMERA_ALLOW),
   MENU_LABEL(LOCATION_ALLOW),

   /* RDB Settings */

   MENU_LABEL(RDB_ENTRY_ANALOG),
   MENU_LABEL(RDB_ENTRY_SERIAL),
   MENU_LABEL(RDB_ENTRY_RUMBLE),
   MENU_LABEL(RDB_ENTRY_COOP),
   MENU_LABEL(RDB_ENTRY_START_CONTENT),
   MENU_LABEL(RDB_ENTRY_DESCRIPTION),
   MENU_LABEL(RDB_ENTRY_GENRE),
   MENU_LABEL(RDB_ENTRY_ENHANCEMENT_HW),
   MENU_LABEL(RDB_ENTRY_FRANCHISE),
   MENU_LABEL(RDB_ENTRY_ORIGIN),
   MENU_LABEL(RDB_ENTRY_DEVELOPER),
   MENU_LABEL(RDB_ENTRY_NAME),
   MENU_LABEL(RDB_ENTRY_PUBLISHER),
   MENU_LABEL(RDB_ENTRY_ESRB_RATING),
   MENU_LABEL(RDB_ENTRY_BBFC_RATING),
   MENU_LABEL(RDB_ENTRY_ELSPA_RATING),
   MENU_LABEL(RDB_ENTRY_PEGI_RATING),
   MENU_LABEL(RDB_ENTRY_CERO_RATING),
   MENU_LABEL(RDB_ENTRY_EDGE_MAGAZINE_RATING),
   MENU_LABEL(RDB_ENTRY_EDGE_MAGAZINE_ISSUE),
   MENU_LABEL(RDB_ENTRY_EDGE_MAGAZINE_REVIEW),
   MENU_LABEL(RDB_ENTRY_FAMITSU_MAGAZINE_RATING),
   MENU_LABEL(RDB_ENTRY_TGDB_RATING),
   MENU_LABEL(RDB_ENTRY_RELEASE_MONTH),
   MENU_LABEL(RDB_ENTRY_RELEASE_YEAR),
   MENU_LABEL(RDB_ENTRY_MAX_USERS),
   MENU_LABEL(RDB_ENTRY_SHA1),
   MENU_LABEL(RDB_ENTRY_MD5),
   MENU_LABEL(RDB_ENTRY_CRC32),

   MENU_LABEL(NO_PLAYLIST_ENTRIES_AVAILABLE),

   MENU_ENUM_LABEL_VIDEO_SHADER_DEFAULT_FILTER,
   MENU_ENUM_LABEL_VIDEO_SHADER_FILTER_PASS,
   MENU_ENUM_LABEL_VIDEO_SHADER_SCALE_PASS,

   MENU_LABEL(VIDEO_SHADER_NUM_PASSES),
   MENU_LABEL(CHEAT_NUM_PASSES),

   MENU_LABEL(NO_DISK),

   MENU_ENUM_LABEL_VALUE_MD5,
   MENU_ENUM_LABEL_VALUE_SHA1,
   MENU_ENUM_LABEL_VALUE_CRC,
   MENU_ENUM_LABEL_VALUE_MORE,

   MENU_LABEL(VIDEO_TAB),
   MENU_LABEL(MUSIC_TAB),
   MENU_LABEL(IMAGES_TAB),
   MENU_LABEL(HORIZONTAL_MENU),
   MENU_LABEL(SETTINGS_TAB),
   MENU_LABEL(HISTORY_TAB),
   MENU_LABEL(ADD_TAB),
   MENU_LABEL(NETPLAY_TAB),
   MENU_LABEL(PLAYLISTS_TAB),
   MENU_LABEL(MAIN_MENU),
   MENU_LABEL(INPUT_SETTINGS),

   MENU_LABEL(ON),
   MENU_LABEL(OFF),
   MENU_LABEL(DISABLED),
   MENU_LABEL(ENABLED),
   MENU_ENUM_LABEL_VALUE_TRUE,
   MENU_ENUM_LABEL_VALUE_FALSE,
   MENU_ENUM_LABEL_VALUE_COMP,
   MENU_ENUM_LABEL_VALUE_MUSIC,
   MENU_ENUM_LABEL_VALUE_IMAGE,
   MENU_ENUM_LABEL_VALUE_MOVIE,
   MENU_ENUM_LABEL_VALUE_CORE,
   MENU_ENUM_LABEL_VALUE_CURSOR,
   MENU_ENUM_LABEL_VALUE_FILE,
   MENU_ENUM_LABEL_VALUE_MISSING,
   MENU_ENUM_LABEL_VALUE_PRESENT,
   MENU_ENUM_LABEL_VALUE_OPTIONAL,
   MENU_ENUM_LABEL_VALUE_REQUIRED,
   MENU_ENUM_LABEL_VALUE_RDB,
   MENU_ENUM_LABEL_VALUE_DIR,
   MENU_ENUM_LABEL_VALUE_NO_CORE,
   MENU_ENUM_LABEL_VALUE_DETECT,
   MENU_ENUM_LABEL_VALUE_GLSLP,
   MENU_ENUM_LABEL_VALUE_CGP,
   MENU_ENUM_LABEL_VALUE_GLSL,
   MENU_ENUM_LABEL_VALUE_CG,
   MENU_ENUM_LABEL_VALUE_SLANG,
   MENU_ENUM_LABEL_VALUE_SLANGP,

   MENU_ENUM_LABEL_VALUE_RETROPAD,
   MENU_ENUM_LABEL_VALUE_RETROPAD_WITH_ANALOG,
   MENU_ENUM_LABEL_VALUE_RETROKEYBOARD,

   MENU_LABEL(SYSTEM_BGM_ENABLE),

   MENU_LABEL(NETWORK_CMD_ENABLE),
   MENU_LABEL(NETWORK_CMD_PORT),
   MENU_LABEL(STDIN_CMD_ENABLE),
   MENU_LABEL(NETWORK_REMOTE_ENABLE),
   MENU_LABEL(NETWORK_REMOTE_PORT),

   MENU_ENUM_LABEL_NETWORK_REMOTE_USER_1_ENABLE,

   MENU_ENUM_LABEL_NETWORK_REMOTE_USER_LAST_ENABLE = MENU_ENUM_LABEL_NETWORK_REMOTE_USER_1_ENABLE + MAX_USERS,

   MENU_LABEL(NETWORK_USER_REMOTE_ENABLE),

   MENU_LABEL(DUMMY_ON_CORE_SHUTDOWN),
   MENU_LABEL(CHECK_FOR_MISSING_FIRMWARE),

   MENU_LABEL(DETECT_CORE_LIST_OK_CURRENT_CORE),
   MENU_LABEL(DETECT_CORE_LIST_OK),
   MENU_LABEL(FAVORITES),
   MENU_LABEL(START_CORE),
   MENU_LABEL(CORE_UPDATER_LIST),
   MENU_LABEL(CORE_UPDATER_AUTO_EXTRACT_ARCHIVE),
   MENU_LABEL(CORE_UPDATER_BUILDBOT_URL),
   MENU_LABEL(BUILDBOT_ASSETS_URL),
   MENU_LABEL(CORE_SET_SUPPORTS_NO_CONTENT_ENABLE),
   MENU_LABEL(CLOSE_CONTENT),
   MENU_LABEL(QUIT_RETROARCH),
   MENU_LABEL(SHUTDOWN),
   MENU_LABEL(REBOOT),
   MENU_LABEL(DISK_IMAGE_APPEND),
   MENU_LABEL(CORE_LIST),
   MENU_LABEL(MANAGEMENT),
   MENU_LABEL(ONLINE),
   MENU_LABEL(ONLINE_UPDATER),
   MENU_LABEL(NETPLAY),
   MENU_LABEL(SETTINGS),
   MENU_LABEL(FRONTEND_COUNTERS),
   MENU_LABEL(CORE_COUNTERS),
   MENU_LABEL(LOAD_CONTENT_HISTORY),
   MENU_LABEL(NETWORK_INFORMATION),
   MENU_LABEL(SYSTEM_INFORMATION),
   MENU_LABEL(ACHIEVEMENT_LIST),
   MENU_LABEL(ACHIEVEMENT_LIST_HARDCORE),
   MENU_LABEL(CORE_INFORMATION),

   MENU_LABEL(VIDEO_SHADER_PARAMETERS),
   MENU_LABEL(VIDEO_SHADER_PRESET_PARAMETERS),
   MENU_LABEL(DISK_OPTIONS),
   MENU_LABEL(DISK_CYCLE_TRAY_STATUS),
   MENU_LABEL(NO_CORE_OPTIONS_AVAILABLE),
   MENU_LABEL(DISK_INDEX),
   MENU_LABEL(CORE_CHEAT_OPTIONS),
   MENU_LABEL(CORE_INPUT_REMAPPING_OPTIONS),
   MENU_LABEL(DATABASE_MANAGER),
   MENU_LABEL(CURSOR_MANAGER),

   MENU_ENUM_LABEL_DATABASE_MANAGER_LIST,
   MENU_ENUM_LABEL_CURSOR_MANAGER_LIST,
   MENU_ENUM_LABEL_VALUE_SUPPORTED_CORES,
   MENU_ENUM_LABEL_VIDEO_SHADER_PASS,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_TWO,

   MENU_LABEL(VIDEO_SHADER_PRESET),
   MENU_LABEL(CHEAT_FILE_LOAD),
   MENU_LABEL(REMAP_FILE_LOAD),

   MENU_ENUM_LABEL_MESSAGE,
   MENU_ENUM_LABEL_INFO_SCREEN,

   MENU_LABEL(CUSTOM_RATIO),
   MENU_LABEL(HELP),
   MENU_LABEL(CHEAT_DATABASE_PATH),
   MENU_LABEL(CURSOR_DIRECTORY),
   MENU_LABEL(OSK_OVERLAY_DIRECTORY),
   MENU_LABEL(RECORDING_OUTPUT_DIRECTORY),
   MENU_LABEL(RECORDING_CONFIG_DIRECTORY),
   MENU_LABEL(VIDEO_FILTER),
   MENU_LABEL(PAL60_ENABLE),

   MENU_LABEL(CONTENT_HISTORY_PATH),

   MENU_LABEL(RGUI_BROWSER_DIRECTORY),
   MENU_LABEL(CONTENT_DATABASE_DIRECTORY),
   MENU_LABEL(PLAYLIST_DIRECTORY),
   MENU_LABEL(CORE_ASSETS_DIRECTORY),
   MENU_LABEL(SCREENSHOT_DIRECTORY),
   MENU_LABEL(CONTENT_DIRECTORY),
   MENU_LABEL(VIDEO_SHADER_DIR),
   MENU_LABEL(VIDEO_FILTER_DIR),
   MENU_LABEL(AUDIO_FILTER_DIR),

   MENU_LABEL(TURBO_DEADZONE_LIST),
   MENU_LABEL(LIBRETRO_DIR_PATH),
   MENU_LABEL(LIBRETRO_INFO_PATH),
   MENU_LABEL(RGUI_CONFIG_DIRECTORY),
   MENU_LABEL(OVERLAY_DIRECTORY),
   MENU_LABEL(SYSTEM_DIRECTORY),
   MENU_LABEL(ASSETS_DIRECTORY),
   MENU_LABEL(CACHE_DIRECTORY),
   MENU_LABEL(JOYPAD_AUTOCONFIG_DIR),
   MENU_LABEL(DRIVER_SETTINGS),
   MENU_LABEL(VIDEO_SETTINGS),
   MENU_LABEL(AUDIO_SETTINGS),
   MENU_LABEL(CORE_SETTINGS),
   MENU_LABEL(CONFIGURATION_SETTINGS),
   MENU_LABEL(LOGGING_SETTINGS),
   MENU_LABEL(SAVING_SETTINGS),
   MENU_LABEL(RECORDING_SETTINGS),
   MENU_LABEL(OVERLAY_SETTINGS),
   MENU_LABEL(REWIND_SETTINGS),

   MENU_ENUM_LABEL_ONSCREEN_KEYBOARD_OVERLAY_SETTINGS,

   MENU_LABEL(MULTIMEDIA_SETTINGS),
   MENU_LABEL(PLAYLIST_SETTINGS),
   MENU_LABEL(CORE_UPDATER_SETTINGS),
   MENU_LABEL(LAKKA_SERVICES),
   MENU_LABEL(SHADER_APPLY_CHANGES),
   MENU_LABEL(SAVE_NEW_CONFIG),
   MENU_LABEL(ONSCREEN_DISPLAY_SETTINGS),
   MENU_LABEL(ONSCREEN_OVERLAY_SETTINGS),
   MENU_LABEL(ONSCREEN_NOTIFICATIONS_SETTINGS),
   MENU_LABEL(CHEAT_APPLY_CHANGES),

   MENU_ENUM_LABEL_COLLECTION,
   MENU_LABEL(CONFIGURATIONS),
   MENU_LABEL(CONTENT_COLLECTION_LIST),
   MENU_LABEL(BROWSE_URL_LIST),

   MENU_ENUM_LABEL_CUSTOM_BIND,

   MENU_ENUM_LABEL_CUSTOM_BIND_ALL,

   MENU_ENUM_LABEL_CUSTOM_BIND_DEFAULTS,
   MENU_ENUM_LABEL_EXIT_EMULATOR,
   MENU_ENUM_LABEL_OSK_ENABLE,

   MENU_LABEL(REMAP_FILE_SAVE_CORE),
   MENU_LABEL(REMAP_FILE_SAVE_GAME),
   MENU_LABEL(RESTART_CONTENT),
   MENU_LABEL(RESUME),
   MENU_LABEL(RESUME_CONTENT),

   MENU_LABEL(CHEAT_FILE_SAVE_AS),
   MENU_LABEL(DELETE_ENTRY),
   MENU_LABEL(RESTART_RETROARCH),

   MENU_LABEL(TAKE_SCREENSHOT),

   MENU_ENUM_LABEL_VALUE_UNABLE_TO_READ_COMPRESSED_FILE,

   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_AS),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_CORE),
   MENU_LABEL(VIDEO_SHADER_PRESET_SAVE_GAME),
   MENU_LABEL(USER_LANGUAGE),
   MENU_LABEL(NETPLAY_NICKNAME),
   MENU_LABEL(VIDEO_VI_WIDTH),
   MENU_LABEL(VIDEO_FORCE_ASPECT),
   MENU_LABEL(VIDEO_ASPECT_RATIO_AUTO),
   MENU_LABEL(VIDEO_ASPECT_RATIO_INDEX),
   MENU_LABEL(VIDEO_VFILTER),
   MENU_LABEL(VIDEO_GPU_RECORD),
   MENU_LABEL(RECORD_USE_OUTPUT_DIRECTORY),
   MENU_LABEL(RECORD_CONFIG),
   MENU_LABEL(RECORD_PATH),
   MENU_LABEL(VIDEO_POST_FILTER_RECORD),
   MENU_LABEL(RECORD_ENABLE),

   MENU_LABEL(SECONDS),
   MENU_LABEL(STATUS),

   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_NAME,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_LABEL,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SYSTEM_NAME,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SYSTEM_MANUFACTURER,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CATEGORIES,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_AUTHORS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_PERMISSIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_LICENSES,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SUPPORTED_EXTENSIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_FIRMWARE,

   /* System information */

   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DYNAMIC_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_BUILD_DATE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GIT_VERSION,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CPU_FEATURES,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_IDENTIFIER,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_NAME,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_OS,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RETRORATING_LEVEL,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_NO_SOURCE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_CHARGING,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_CHARGED,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_DISCHARGING,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_VIDEO_CONTEXT_DRIVER,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_MM_WIDTH,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_MM_HEIGHT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_DPI,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBRETRODB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OVERLAY_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COMMAND_IFACE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETWORK_COMMAND_IFACE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETWORK_REMOTE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COCOA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RTGA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RBMP_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RJPEG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RPNG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_VULKAN_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENGL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENGLES_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_THREADING_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_KMS_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_UDEV_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENVG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_EGL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_X11_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_WAYLAND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_XVIDEO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ALSA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OSS_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENAL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RSOUND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ROARAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_JACK_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_PULSEAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DSOUND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_XAUDIO2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ZLIB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_7ZIP_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DYLIB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GLSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SLANG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_HLSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBXML2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL_IMAGE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FBO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FFMPEG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CORETEXT_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FREETYPE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETPLAY_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_PYTHON_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_V4L2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBUSB_SUPPORT,

   MENU_ENUM_LABEL_VALUE_CORE_ASSETS_DIR,

   MENU_LABEL(CONTENT_DIR),
   MENU_LABEL(DATABASE_SELECTION),
   MENU_LABEL(DATABASE_CURSOR_LIST),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_DEVELOPER),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_PUBLISHER),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_ORIGIN),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_FRANCHISE),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_ESRB_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_ELSPA_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_PEGI_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_CERO_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_BBFC_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_MAX_USERS),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_EDGE_MAGAZINE_ISSUE),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_EDGE_MAGAZINE_RATING),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_RELEASEDATE_BY_MONTH),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_RELEASEDATE_BY_YEAR),
   MENU_LABEL(DATABASE_CURSOR_LIST_ENTRY_DATABASE_INFO),

   MENU_ENUM_LABEL_VALUE_NO,
   MENU_ENUM_LABEL_VALUE_YES,

   MENU_ENUM_LABEL_VALUE_PORT,

   MENU_ENUM_LABEL_VALUE_LEFT_ANALOG,
   MENU_ENUM_LABEL_VALUE_RIGHT_ANALOG,

   MENU_ENUM_LABEL_VALUE_LANG_ENGLISH,
   MENU_ENUM_LABEL_VALUE_LANG_JAPANESE,
   MENU_ENUM_LABEL_VALUE_LANG_FRENCH,
   MENU_ENUM_LABEL_VALUE_LANG_SPANISH,
   MENU_ENUM_LABEL_VALUE_LANG_GERMAN,
   MENU_ENUM_LABEL_VALUE_LANG_ITALIAN,
   MENU_ENUM_LABEL_VALUE_LANG_DUTCH,
   MENU_ENUM_LABEL_VALUE_LANG_PORTUGUESE,
   MENU_ENUM_LABEL_VALUE_LANG_RUSSIAN,
   MENU_ENUM_LABEL_VALUE_LANG_KOREAN,
   MENU_ENUM_LABEL_VALUE_LANG_CHINESE_TRADITIONAL,
   MENU_ENUM_LABEL_VALUE_LANG_CHINESE_SIMPLIFIED,
   MENU_ENUM_LABEL_VALUE_LANG_ESPERANTO,
   MENU_ENUM_LABEL_VALUE_LANG_POLISH,
   MENU_ENUM_LABEL_VALUE_LANG_VIETNAMESE,

   MENU_ENUM_LABEL_VALUE_NONE,
   MENU_ENUM_LABEL_VALUE_NO_INFORMATION_AVAILABLE,

   MENU_LABEL(USE_BUILTIN_IMAGE_VIEWER),
   MENU_LABEL(OVERLAY_AUTOLOAD_PREFERRED),
   MENU_LABEL(LOAD_ARCHIVE),
   MENU_LABEL(OPEN_ARCHIVE),
   MENU_ENUM_LABEL_LOAD_ARCHIVE_DETECT_CORE,
   MENU_ENUM_LABEL_OPEN_ARCHIVE_DETECT_CORE,

   MENU_ENUM_LABEL_VALUE_WHAT_IS_A_CORE_DESC,

   MENU_LABEL(HELP_CHANGE_VIRTUAL_GAMEPAD),
   MENU_LABEL(HELP_CHANGE_VIRTUAL_GAMEPAD_DESC),

   MENU_LABEL(HELP_AUDIO_VIDEO_TROUBLESHOOTING),

   MENU_ENUM_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING_DESC,

   MENU_LABEL(HELP_SCANNING_CONTENT),

   MENU_ENUM_LABEL_VALUE_HELP_SCANNING_CONTENT_DESC,

   MENU_LABEL(SAVE_CURRENT_CONFIG),
   MENU_LABEL(SAVE_CURRENT_CONFIG_OVERRIDE_CORE),
   MENU_LABEL(SAVE_CURRENT_CONFIG_OVERRIDE_GAME),

   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_BOXARTS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_SCREENSHOTS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_TITLE_SCREENS,

   /* Callback strings */
   MENU_ENUM_LABEL_CB_CORE_CONTENT_DIRS_LIST,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_LIST,
   MENU_ENUM_LABEL_CB_CORE_THUMBNAILS_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_UPDATER_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_CB_DOWNLOAD_URL,
   MENU_ENUM_LABEL_CB_LAKKA_DOWNLOAD,
   MENU_ENUM_LABEL_CB_LAKKA_LIST,
   MENU_ENUM_LABEL_CB_MENU_THUMBNAIL,
   MENU_ENUM_LABEL_CB_MENU_SAVESTATE_THUMBNAIL,
   MENU_ENUM_LABEL_CB_MENU_WALLPAPER,
   MENU_ENUM_LABEL_CB_THUMBNAILS_UPDATER_DOWNLOAD,
   MENU_ENUM_LABEL_CB_THUMBNAILS_UPDATER_LIST,
   MENU_ENUM_LABEL_CB_UPDATE_ASSETS,
   MENU_ENUM_LABEL_CB_UPDATE_AUTOCONFIG_PROFILES,
   MENU_ENUM_LABEL_CB_UPDATE_CHEATS,
   MENU_ENUM_LABEL_CB_UPDATE_CORE_INFO_FILES,
   MENU_ENUM_LABEL_CB_UPDATE_DATABASES,
   MENU_ENUM_LABEL_CB_UPDATE_OVERLAYS,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_CG,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_GLSL,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_SLANG,

   /* Sublabels */
   MENU_ENUM_SUBLABEL_INFORMATION_LIST_LIST,
   MENU_ENUM_SUBLABEL_SERVICES_SETTINGS,

   MENU_LABEL(SELECT_FILE),
   MENU_LABEL(SELECT_FROM_COLLECTION),

   MENU_ENUM_LABEL_VALUE_FILTER,
   MENU_ENUM_LABEL_VALUE_SCALE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_START_WHEN_LOADED,
   MENU_ENUM_LABEL_VALUE_NETPLAY_LOAD_CONTENT_MANUALLY,
   MENU_ENUM_LABEL_VALUE_NETPLAY_COMPAT_CONTENT_FOUND,

   MSG_LAST
};


/* Callback strings */

#define CB_CORE_UPDATER_DOWNLOAD                                               0x7412da7dU
#define CB_UPDATE_ASSETS                                                       0xbf85795eU

/* Deferred */

#define MENU_LABEL_DEFERRED_BROWSE_URL_LIST                                    0x6358c2c4U
#define MENU_LABEL_DEFERRED_THUMBNAILS_UPDATER_LIST                            0x364dfa2bU
#define MENU_LABEL_DEFERRED_VIDEO_FILTER                                       0x966ad201U
#define MENU_LABEL_DEFERRED_CORE_LIST_SET                                      0xa6d5fdb4U
#define MENU_LABEL_DEFERRED_DATABASE_MANAGER_LIST                              0x7c0b704fU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST                                0x45446638U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_DEVELOPER            0xcbd89be5U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PUBLISHER            0x125e594dU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ORIGIN               0x4ebaa767U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FRANCHISE            0x77f9eff2U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_RATING 0x1c7f8a43U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_ISSUE  0xaaeebde7U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FAMITSU_MAGAZINE_RATING 0xbf7ff5e7U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ENHANCEMENT_HW       0x9866bda3U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEMONTH         0x2b36ce66U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEYEAR          0x9c7c6e91U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ESRB_RATING          0x68eba20fU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ELSPA_RATING         0x8bf6ab18U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PEGI_RATING          0x5fc77328U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_CERO_RATING          0x24f6172cU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_BBFC_RATING          0x0a8e67f0U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_MAX_USERS            0xbfcba816U
#define MENU_LABEL_DEFERRED_RDB_ENTRY_DETAIL                                   0xc35416c0U
#define MENU_LABEL_DEFERRED_RPL_ENTRY_ACTIONS                                  0x358a7494U
#define MENU_LABEL_DEFERRED_CORE_LIST                                          0xf157d289U
#define MENU_LABEL_DEFERRED_CORE_UPDATER_LIST                                  0xc315f682U
#define MENU_LABEL_DEFERRED_DRIVER_SETTINGS_LIST                               0xaa5efefcU
#define MENU_LABEL_DEFERRED_VIDEO_SETTINGS_LIST                                0x83c65827U
#define MENU_LABEL_DEFERRED_AUDIO_SETTINGS_LIST                                0x5bba25e2U
#define MENU_LABEL_DEFERRED_RECORDING_SETTINGS_LIST                            0x05548d52U
#define MENU_LABEL_DEFERRED_PLAYLIST_SETTINGS_LIST                             0x9518e0c7U
#define MENU_LABEL_DEFERRED_INPUT_SETTINGS_LIST                                0x050bec60U
#define MENU_LABEL_DEFERRED_USER_BINDS_LIST                                    0x28c5750eU
#define MENU_LABEL_DEFERRED_ACCOUNTS_CHEEVOS_LIST                              0x1322324cU
#define MENU_LABEL_DEFERRED_ACCOUNTS_LIST                                      0x3d2b8860U
#define MENU_LABEL_DEFERRED_ARCHIVE_ACTION_DETECT_CORE                         0xdc9c0064U
#define MENU_LABEL_DEFERRED_ARCHIVE_ACTION                                     0x7faf0284U
#define MENU_LABEL_DEFERRED_ARCHIVE_OPEN_DETECT_CORE                           0xd9452498U
#define MENU_LABEL_DEFERRED_ARCHIVE_OPEN                                       0xfa0938b8U
#define MENU_LABEL_DEFERRED_CORE_CONTENT_LIST                                  0x76150c63U
#define MENU_LABEL_DEFERRED_LAKKA_LIST                                         0x3db437c4U
#define MENU_LABEL_DEFERRED_INPUT_HOTKEY_BINDS_LIST                            0x10b41d97U
#define MENU_LABEL_DEFERRED_CONFIGURATIONS_LIST                                0x679a1b0bU
#define MENU_LABEL_DEFERRED_BROWSE_URL_START                                   0xcef58296U

/* Cheevos settings */

#define MENU_LABEL_CHEEVOS_DESCRIPTION                                         0x7e00e0f5U

/* Playlist settings */

#define MENU_LABEL_PLAYLIST_SETTINGS_BEGIN                                     0x80a8d2cbU

/* Accounts settings */

#define MENU_LABEL_ACCOUNTS_RETRO_ACHIEVEMENTS                                 0xe6b7c16cU
#define MENU_LABEL_ACCOUNTS_LIST                                               0x774c15a0U

#define MENU_LABEL_VALUE_ACCOUNTS_LIST_END                                     0x3d559522U


#define MENU_LABEL_DOWNLOADED_FILE_DETECT_CORE_LIST                            0xb4f82700U

/* Scan values */
#define MENU_LABEL_SCAN_THIS_DIRECTORY                                         0x6921b775U
#define MENU_LABEL_SCAN_DIRECTORY                                              0x57de303eU
#define MENU_LABEL_SCAN_FILE                                                   0xd5d1eee9U

/* Online updater settings */

#define MENU_LABEL_UPDATE_LAKKA                                                0x19b51eebU

/* Information settings */

#define MENU_LABEL_INFORMATION_LIST                                            0x225e7606U
#define MENU_LABEL_SYSTEM_INFORMATION                                          0x206ebf0fU
#define MENU_LABEL_NETWORK_INFORMATION                                         0x73ae3cb4U

#define MENU_LABEL_CONTENT_SETTINGS                                            0xe789f7f6U

#define MENU_LABEL_SCREEN_RESOLUTION                                           0x5c9b3a58U

/* Menu settings */
#define MENU_LABEL_XMB_FONT                                                    0x0ECA56CA2

#define MENU_LABEL_PERFCNT_ENABLE                                              0x6823dbddU

/* Video settings */
#define MENU_LABEL_VIDEO_FONT_PATH                                             0xd0de729eU
#define MENU_LABEL_VIDEO_VI_WIDTH                                              0x6e4a6d3aU
#define MENU_LABEL_VIDEO_VFILTER                                               0x664f8397U
#define MENU_LABEL_VIDEO_GAMMA                                                 0x08a951beU

#define MENU_LABEL_VIDEO_SHADER_PRESET_SAVE_AS                                 0x3d6e5ce5U
#define MENU_LABEL_VIDEO_SHADER_DEFAULT_FILTER                                 0x4468cb1bU
#define MENU_LABEL_VIDEO_SHADER_NUM_PASSES                                     0x79b2992fU
#define MENU_LABEL_VIDEO_SHADER_PARAMETERS                                     0x9895c3e5U
#define MENU_LABEL_VIDEO_SHADER_PRESET_PARAMETERS                              0xd18158d7U
#define MENU_LABEL_VIDEO_SHADER_PASS                                           0x4fa31028U
#define MENU_LABEL_VIDEO_SHADER_PRESET                                         0xc5d3bae4U

/* Input settings */
#define MENU_LABEL_INPUT_OVERLAY                                               0x24e24796U
#define MENU_LABEL_INPUT_OSK_OVERLAY                                           0x11f1c582U

/* Record settings */

#define MENU_LABEL_RECORD_CONFIG                                               0x11c3daf9U

/* Cheat options */

#define MENU_LABEL_CHEAT_DATABASE_PATH                                         0x01388b8aU
#define MENU_LABEL_CHEAT_FILE_LOAD                                             0x57336148U
#define MENU_LABEL_CHEAT_FILE_SAVE_AS                                          0x1f58dccaU
#define MENU_LABEL_CHEAT_APPLY_CHANGES                                         0xde88aa27U

/* Disk settings */

#define MENU_LABEL_DISK_OPTIONS                                                0xc61ab5fbU
#define MENU_LABEL_DISK_IMAGE_APPEND                                           0x5af7d709U

/* Menu settings */

#define MENU_LABEL_MENU_WALLPAPER                                              0x3b84de01U
#define MENU_LABEL_MENU_SETTINGS                                               0x61e4544bU

/* Directory settings */

#define MENU_LABEL_CURSOR_DIRECTORY                                            0xdee8d377U
#define MENU_LABEL_OSK_OVERLAY_DIRECTORY                                       0xcce86287U
#define MENU_LABEL_JOYPAD_AUTOCONFIG_DIR                                       0x2f4822d8U
#define MENU_LABEL_RECORDING_OUTPUT_DIRECTORY                                  0x30bece06U
#define MENU_LABEL_RECORDING_CONFIG_DIRECTORY                                  0x3c3f274bU
#define MENU_LABEL_LIBRETRO_DIR_PATH                                           0x1af1eb72U
#define MENU_LABEL_AUDIO_FILTER_DIR                                            0x4bd96ebaU
#define MENU_LABEL_VIDEO_SHADER_DIR                                            0x30f53b10U
#define MENU_LABEL_VIDEO_FILTER_DIR                                            0x67603f1fU
#define MENU_LABEL_SCREENSHOT_DIRECTORY                                        0x552612d7U
#define MENU_LABEL_SYSTEM_DIRECTORY                                            0x35a6fb9eU
#define MENU_LABEL_INPUT_REMAPPING_DIRECTORY                                   0x5233c20bU
#define MENU_LABEL_OVERLAY_DIRECTORY                                           0xc4ed3d1bU
#define MENU_LABEL_SAVEFILE_DIRECTORY                                          0x92773488U
#define MENU_LABEL_SAVESTATE_DIRECTORY                                         0x90551289U
#define MENU_LABEL_DYNAMIC_WALLPAPERS_DIRECTORY                                0x62f975b8U
#define MENU_LABEL_THUMBNAILS_DIRECTORY                                        0xdea77410U
#define MENU_LABEL_RGUI_BROWSER_DIRECTORY                                      0xa86cba73U
#define MENU_LABEL_CONTENT_DATABASE_DIRECTORY                                  0x6b443f80U
#define MENU_LABEL_PLAYLIST_DIRECTORY                                          0x6361820bU
#define MENU_LABEL_CORE_ASSETS_DIRECTORY                                       0x8ba5ee54U
#define MENU_LABEL_CONTENT_DIRECTORY                                           0x7738dc14U
#define MENU_LABEL_RGUI_CONFIG_DIRECTORY                                       0x0cb3e005U
#define MENU_LABEL_ASSETS_DIRECTORY                                            0xde1ae8ecU
#define MENU_LABEL_CACHE_DIRECTORY                                             0x851dfb8dU

/* RDB settings */

#define MENU_LABEL_NO_PLAYLIST_ENTRIES_AVAILABLE                               0x8888c5acU
#define MENU_LABEL_RDB_ENTRY_START_CONTENT                                     0x95025a55U
#define MENU_LABEL_RDB_ENTRY_PUBLISHER                                         0x4d7bcdfbU
#define MENU_LABEL_RDB_ENTRY_DEVELOPER                                         0x06f61093U
#define MENU_LABEL_RDB_ENTRY_ORIGIN                                            0xb176aad5U
#define MENU_LABEL_RDB_ENTRY_FRANCHISE                                         0xb31764a0U
#define MENU_LABEL_RDB_ENTRY_ENHANCEMENT_HW                                    0x79ee4f11U
#define MENU_LABEL_RDB_ENTRY_ESRB_RATING                                       0xe138fa3dU
#define MENU_LABEL_RDB_ENTRY_BBFC_RATING                                       0x82dbc01eU
#define MENU_LABEL_RDB_ENTRY_ELSPA_RATING                                      0x0def0906U
#define MENU_LABEL_RDB_ENTRY_PEGI_RATING                                       0xd814cb56U
#define MENU_LABEL_RDB_ENTRY_CERO_RATING                                       0x9d436f5aU
#define MENU_LABEL_RDB_ENTRY_EDGE_MAGAZINE_RATING                              0x9735f631U
#define MENU_LABEL_RDB_ENTRY_EDGE_MAGAZINE_ISSUE                               0xd5706415U
#define MENU_LABEL_RDB_ENTRY_FAMITSU_MAGAZINE_RATING                           0x01a50315U
#define MENU_LABEL_RDB_ENTRY_RELEASE_MONTH                                     0xad2f2c54U
#define MENU_LABEL_RDB_ENTRY_RELEASE_YEAR                                      0x14c9c6bfU
#define MENU_LABEL_RDB_ENTRY_MAX_USERS                                         0xfae91cc4U

#define MENU_LABEL_FAVORITES                                                   0x67325138U
#define MENU_LABEL_DETECT_CORE_LIST                                            0xaa07c341U
#define MENU_LABEL_DETECT_CORE_LIST_OK                                         0xabba2a7aU
#define MENU_LABEL_CORE_LIST                                                   0xa22bb14dU
#define MENU_LABEL_MANAGEMENT                                                  0x2516c88aU
#define MENU_LABEL_FRONTEND_COUNTERS                                           0xe5696877U
#define MENU_LABEL_CORE_COUNTERS                                               0x64cc83e0U
#define MENU_LABEL_ACHIEVEMENT_LIST                                            0x7b90fc49U
#define MENU_LABEL_ACHIEVEMENT_LIST_HARDCORE                                   0x7c632930U
#define MENU_LABEL_CORE_INFORMATION                                            0xb638e0d3U
#define MENU_LABEL_CORE_OPTIONS                                                0xf65e60f9U
#define MENU_LABEL_SHADER_OPTIONS                                              0x1f7d2fc7U
#define MENU_LABEL_CORE_CHEAT_OPTIONS                                          0x9293171dU
#define MENU_LABEL_CORE_INPUT_REMAPPING_OPTIONS                                0x7836a8caU
#define MENU_LABEL_DATABASE_MANAGER_LIST                                       0x7f853d8fU
#define MENU_LABEL_CURSOR_MANAGER_LIST                                         0xa969e378U
#define MENU_LABEL_REMAP_FILE_LOAD                                             0x9c2799b8U
#define MENU_LABEL_INFO_SCREEN                                                 0xd97853d0U
#define MENU_LABEL_CUSTOM_RATIO                                                0xf038731eU
#define MENU_LABEL_PAL60_ENABLE                                                0x62bc416eU
#define MENU_LABEL_CONTENT_HISTORY_PATH                                        0x6f22fb9dU
#define MENU_LABEL_ONSCREEN_KEYBOARD_OVERLAY_SETTINGS                          0xa6de9ba6U
#define MENU_LABEL_SHADER_APPLY_CHANGES                                        0x4f7306b9U
#define MENU_LABEL_CUSTOM_BIND                                                 0x1e84b3fcU
#define MENU_LABEL_CUSTOM_BIND_ALL                                             0x79ac14f4U
#define MENU_LABEL_CUSTOM_BIND_DEFAULTS                                        0xe88f7b13U
#define MENU_LABEL_CONFIGURATIONS                                              0x3e930a50U
#define MENU_LABEL_REMAP_FILE_SAVE_CORE                                        0x7c9d4c8fU
#define MENU_LABEL_REMAP_FILE_SAVE_GAME                                        0x7c9f41e0U
#define MENU_LABEL_CONTENT_COLLECTION_LIST                                     0x32d1df83U
#define MENU_LABEL_COLLECTION                                                  0x5fea5991U

#define MENU_LABEL_OPEN_ARCHIVE                                                0x78c0ca58U
#define MENU_LABEL_OPEN_ARCHIVE_DETECT_CORE                                    0x92442638U
#define MENU_LABEL_LOAD_ARCHIVE_DETECT_CORE                                    0x681f2f46U
#define MENU_LABEL_LOAD_ARCHIVE                                                0xc3834e66U

/* Help */
#define MENU_LABEL_LIBRETRO_INFO_PATH                                          0xe552b25fU

#define MENU_LABEL_INPUT_DRIVER_LINUXRAW                                       0xc33c6b9fU
#define MENU_LABEL_INPUT_DRIVER_UDEV                                           0x7c9eeeb9U

#define MENU_LABEL_AUDIO_DSP_PLUGIN                                            0x4a69572bU

#define MENU_LABEL_AUDIO_RESAMPLER_DRIVER_SINC                                 0x7c9dec52U
#define MENU_LABEL_AUDIO_RESAMPLER_DRIVER_CC                                   0x0059732bU

#define MENU_LABEL_VIDEO_FILTER                                                0x1c0eb741U
#define MENU_LABEL_HELP_CONTROLS                                               0x04859221U
#define MENU_LABEL_HELP_LIST                                                   0x006af669U
#define MENU_LABEL_HELP_WHAT_IS_A_CORE                                         0x83fcbc44U
#define MENU_LABEL_HELP_LOADING_CONTENT                                        0x231d8245U
#define MENU_LABEL_HELP_SCANNING_CONTENT                                       0x1dec52b8U
#define MENU_LABEL_HELP_CHANGE_VIRTUAL_GAMEPAD                                 0x6e66ef07U
#define MENU_LABEL_HELP_AUDIO_VIDEO_TROUBLESHOOTING                            0xd44d395cU

/* Main menu */
#define MENU_LABEL_LOAD_CONTENT_LIST                                           0x5745de1fU
#define MENU_LABEL_LOAD_CONTENT_HISTORY                                        0xfe1d79e5U
#define MENU_LABEL_ADD_CONTENT_LIST                                            0x046f4668U
#define MENU_LABEL_ONLINE_UPDATER                                              0xcac0025eU
#define MENU_LABEL_NETPLAY                                                     0x0b511d22U
#define MENU_LABEL_SETTINGS                                                    0x1304dc16U
#define MENU_LABEL_HELP                                                        0x7c97d2eeU
#define MENU_VALUE_HORIZONTAL_MENU                                             0x35761704U
#define MENU_LABEL_QUIT_RETROARCH                                              0x84b0bc71U

#define MENU_LABEL_BROWSE_URL_LIST                                             0xa7d1a004U

const char *msg_hash_to_str(enum msg_hash_enums msg);

const char *msg_hash_to_str_fr(enum msg_hash_enums msg);
int menu_hash_get_help_fr_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_ru(enum msg_hash_enums msg);

const char *msg_hash_to_str_de(enum msg_hash_enums msg);
int menu_hash_get_help_de_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_es(enum msg_hash_enums msg);
int menu_hash_get_help_es_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_eo(enum msg_hash_enums msg);
int menu_hash_get_help_eo_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_it(enum msg_hash_enums msg);
int menu_hash_get_help_it_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_jp(enum msg_hash_enums msg);
int menu_hash_get_help_jp_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_pt(enum msg_hash_enums msg);
int menu_hash_get_help_pt_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_pl(enum msg_hash_enums msg);
int menu_hash_get_help_pl_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_nl(enum msg_hash_enums msg);
int menu_hash_get_help_nl_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_vn(enum msg_hash_enums msg);
int menu_hash_get_help_vn_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_chs(enum msg_hash_enums msg);
int menu_hash_get_help_chs_enum(enum msg_hash_enums msg, char *s, size_t len);

const char *msg_hash_to_str_us(enum msg_hash_enums msg);
int menu_hash_get_help_us_enum(enum msg_hash_enums msg, char *s, size_t len);

int menu_hash_get_help_enum(enum msg_hash_enums msg, char *s, size_t len);

enum msg_file_type msg_hash_to_file_type(uint32_t hash);

uint32_t msg_hash_calculate(const char *s);

RETRO_END_DECLS

#endif
