/*******************************************************************************
 * Copyright (c) 2015 Eclipse RDF4J contributors, Aduna, and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Distribution License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *******************************************************************************/
package org.eclipse.rdf4j.query.resultio;

/**
 * A TupleQueryResultParserFactory returns {@link TupleQueryResultParser}s for a specific tuple query result format.
 *
 * @author Arjohn Kampman
 */
public interface TupleQueryResultParserFactory {

	/**
	 * Returns the tuple query result format for this factory.
	 */
	TupleQueryResultFormat getTupleQueryResultFormat();

	/**
	 * Returns a TupleQueryResultParser instance.
	 */
	TupleQueryResultParser getParser();
}
