.PU
.TH RASMOL 1 "July 2009"
.SH NAME
rasmol \- Molecular Graphics Visualisation Tool v2.7.5

.SH SYNOPSIS
.B rasmol
.RB "[\|" \-nodiplay "\|]"
.RB "[\|\&[\|" "\-"\c
.I "format"\c
.RB "\|]"
.I filename\c
\&\|]
.RB "[\|" "\-script "\c
.I scriptfile\c
\&\|]

.SH FORMATS
.PD 0
.TP 12
.B \-pdb
Protein Data Bank
.TP
.B \-mdl
MDL's MOL File Format
.TP
.B \-mol2
Tripos' Sybyl MOL2 Format
.TP
.B \-xyz
MSC's XYZ (XMol) Format
.TP
.B \-mopac
MOPAC Input or Output File Format
.TP
.B \-alchemy
Alchemy File Format
.TP
.B \-charmm
CHARMm File Format
.TP
.B \-cif
IUCr CIF or CIF File Format
.PD
.SH NOTICES

This software has been created from several sources.  Much of the code is
from RasMol 2.6, as created by Roger Sayle.
The torsion angle code, new POVRAY3 code and other features are derived from
the RasMol2.6x1 revisions by Arne Mueller.
The Ramachandran printer plot code was derived from fisipl created by Frances C.
Bernstein.  See the Protein Data Bank program tape.

The code to display multiple molecules and to allow bond rotation is derived
in large part from the UCB mods by Gary Grossman and Marco Molinaro,
included with
permission of Eileen Lewis of the ModularCHEM Consortium.

The CIF modifications make use of a library based in part on CBFlib by
Paul J. Ellis and Herbert J. Bernstein.
Parts of CBFlib is loosely based on the CIFPARSE software package from the NDB
at Rutgers university.
Please type the RasMol commands
.B help copying,
.B help general,
.B help IUCR,
.B help CBFlib,
 and
.B help CIFPARSE
for applicable notices.  Please type
.B help copyright
for copyright notices.  If you use RasMol V2.6
or an earlier version, type the RasMol command
.B help oldnotice.

.SH COPYING

This version is based directly on RasMol version 2.7.4.2,
on RasMol verion 2.7.4.2, on RasMol version 2.7.4,
on RasMol version 2.7.3.1, on RasMol version 2.7.3,
on RasMol version 2.7.2.1.1, Rasmol version 2.7.2, RasMol
version 2.7.1.1 and RasTop version 1.3 and indirectly on
the RasMol 2.5-ucb and 2.6-ucb versions and version
2.6_CIF.2, RasMol 2.6x1 and RasMol_2.6.4.

RasMol 2.7.5 may be distributed under the terms of the GNU
General Public License (the GPL), see

          http://www.gnu.org/licenses/gpl.txt

or the file GPL or type the command
.B help GPL

or RasMol 2.7.5 may be distributed under the RASMOL license.
See the file NOTICE
or type the command
.B help RASLIC

.TP
.B GPL
                    GNU GENERAL PUBLIC LICENSE
                       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

                            Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

                    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

                            NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

                     END OF TERMS AND CONDITIONS

            How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.

.TP
.B RASLIC
If you do not use the GPL, the following license terms apply:

RasMol License

Even though the authors of the various documents and software found here
have made a good faith effort to ensure that the documents are correct and
that the software performs according to its documentation, and we would
greatly appreciate hearing of any problems you may encounter, the programs
and documents any files created by the programs are provided **AS IS**
without any warranty as to correctness, merchantability or fitness for any
particular or general use.

THE RESPONSIBILITY FOR ANY ADVERSE CONSEQUENCES FROM THE USE OF PROGRAMS OR
DOCUMENTS OR ANY FILE OR FILES CREATED BY USE OF THE PROGRAMS OR DOCUMENTS
LIES SOLELY WITH THE USERS OF THE PROGRAMS OR DOCUMENTS OR FILE OR FILES AND
NOT WITH AUTHORS OF THE PROGRAMS OR DOCUMENTS.

Subject to your acceptance of the conditions stated above, and your respect
for the terms and conditions stated in the notices below, if you are not
going to make any modifications or create derived works, you are given
permission to freely copy and distribute this package, provided you do the
following:

  1.  Either include the complete documentation, especially the file
NOTICE, with what you distribute or provide a clear indication where
people can get a copy of the documentation; and

  2.  Please give credit where credit is due citing the version and
original authors properly; and

  3.  Please do not give anyone the impression that the original
authors are providing a warranty of any kind.

If you would like to use major pieces of RasMol in some other program,
make modifications to RasMol, or in some other way make what a lawyer
would call a "derived work", you are not only permitted to do so, you
are encouraged to do so. In addition to the things we discussed above,
please do the following:

  4.  Please explain in your documentation how what you did differs
from this version of RasMol; and

  5.  Please make your modified source code available.

This version of RasMol is _not_ in the public domain, but it is given
freely to the community in the hopes of advancing science.  If you make
changes, please make them in a responsible manner, and please offer us
the opportunity to include those changes in future versions of RasMol.

.TP
.B General Notice
The following notice applies to this work as a whole and to the works
included within it:

* Creative endeavors depend on the lively exchange of ideas. There are laws
and customs which establish rights and responsibilities for authors and the
users of what authors create. This notice is not intended to prevent you
from using the software and documents in this package, but to ensure that
there are no misunderstandings about terms and conditions of such use.

* Please read the following notice carefully. If you do not understand any
portion of this notice, please seek appropriate professional legal advice
before making use of the software and documents included in this software
package. In addition to whatever other steps you may be obliged to take
to respect the intellectual property rights of the various parties
involved, if you do make use of the software and documents in this package,
please give credit where credit is due by citing this package, its authors
and the URL or other source from which you obtained it, or equivalent
primary references in the literature with the same authors.

* Some of the software and documents included within this software package
are the intellectual property of various parties, and placement in this
package does not in any way imply that any such rights have in any way been
waived or diminished.

* With respect to any software or documents for which a copyright exists,
ALL RIGHTS ARE RESERVED TO THE OWNERS OF SUCH COPYRIGHT.

* Even though the authors of the various documents and software found here
have made a good faith effort to ensure that the documents are correct and
that the software performs according to its documentation, and we would
greatly appreciate hearing of any problems you may encounter, the programs
and documents and any files created by the programs are provided **AS IS**
without any warranty as to correctness, merchantability or fitness for any
particular or general use.

* THE RESPONSIBILITY FOR ANY ADVERSE CONSEQUENCES FROM THE USE OF PROGRAMS
OR DOCUMENTS OR ANY FILE OR FILES CREATED BY USE OF THE PROGRAMS OR
DOCUMENTS LIES SOLELY WITH THE USERS OF THE PROGRAMS OR DOCUMENTS OR FILE
OR FILES AND NOT WITH AUTHORS OF THE PROGRAMS OR DOCUMENTS.

See the files GPL and RASLIC for two alternate ways to license this
package.

.TP
.B RasMol V2.6 Notice
The following notice applies to RasMol V 2.6 and older RasMol versions.

Information in this document is subject to change without notice and
does not represent a commitment on the part of the supplier. This package
is sold/distributed subject to the condition that it shall not, by way
of trade or otherwise, be lent, re-sold, hired out or otherwise
circulated without the supplier's prior consent, in any form of
packaging or cover other than that in which it was produced. No
part of this manual or accompanying software may be reproduced,
stored in a retrieval system on optical or magnetic disk, tape or
any other medium, or transmitted in any form or by any means,
electronic, mechanical, photocopying, recording or otherwise for
any purpose other than the purchaser's personal use.

This product is not to be used in the planning, construction,
maintenance, operation or use of any nuclear facility nor the
flight, navigation or communication of aircraft or ground support
equipment. The author shall not be liable, in whole or in part, for
any claims or damages arising from such use, including death,
bankruptcy or outbreak of war.

.TP
.B IUCR Policy
.B The IUCr Policy for the Protection and the Promotion of the STAR File and
.B CIF Standards for Exchanging and Archiving Electronic Data.

.B Overview

The Crystallographic Information File (CIF)[1] is a standard for information
interchange promulgated by the International Union of Crystallography
(IUCr). CIF (Hall, Allen & Brown, 1991) is the recommended method for
submitting publications to Acta Crystallographica Section C and reports of
crystal structure determinations to other sections of Acta Crystallographica
and many other journals. The syntax of a CIF is a subset of the more general
STAR File[2] format. The CIF and STAR File approaches are used increasingly
in the structural sciences for data exchange and archiving, and are having a
significant influence on these activities in other fields.

.B Statement of intent

The IUCr's interest in the STAR File is as a general data interchange
standard for science, and its interest in the CIF, a conformant derivative
of the STAR File, is as a concise data exchange and archival standard for
crystallography and structural science.

.B Protection of the standards

To protect the STAR File and the CIF as standards for interchanging and
archiving electronic data, the IUCr, on behalf of the scientific community,

   * holds the copyrights on the standards themselves,

   * owns the associated trademarks and service marks, and

   * holds a patent on the STAR File.

These intellectual property rights relate solely to the interchange formats,
not to the data contained therein, nor to the software used in the
generation, access or manipulation of the data.

.B Promotion of the standards

The sole requirement that the IUCr, in its protective role, imposes on
software purporting to process STAR File or CIF data is that the following
conditions be met prior to sale or distribution.

   * Software claiming to read files written to either the STAR File or the
CIF standard must be able to extract the pertinent data from a file
conformant to the STAR File syntax, or the CIF syntax, respectively.

   * Software claiming to write files in either the STAR File, or the CIF,
standard must produce files that are conformant to the STAR File
syntax, or the CIF syntax, respectively.

   * Software claiming to read definitions from a specific data dictionary
approved by the IUCr must be able to extract any pertinent definition
which is conformant to the dictionary definition language (DDL)[3]
associated with that dictionary.

The IUCr, through its Committee on CIF Standards, will assist any developer
to verify that software meets these conformance conditions.

.B Glossary of terms

[1] CIF:

is a data file conformant to the file syntax defined at
http://www.iucr.org/iucr-top/cif/spec/index.html

[2] STAR File:

is a data file conformant to the file syntax defined at
http://www.iucr.org/iucr-top/cif/spec/star/index.html

[3] DDL:

is a language used in a data dictionary to define data items in terms
of "attributes". Dictionaries currently approved by the IUCr, and the
DDL versions used to construct these dictionaries, are listed at
http://www.iucr.org/iucr-top/cif/spec/ddl/index.html

Last modified: 30 September 2000

IUCr Policy Copyright (C) 2000 International Union of Crystallography

.TP
.B CBFLIB
The following Disclaimer Notice applies to CBFlib V0.1, from which this code
in part is derived.

* The items furnished herewith were developed under the sponsorship of the
U.S. Government. Neither the U.S., nor the U.S. D.O.E., nor the Leland
Stanford Junior University, nor their employees, makes any warranty,
express or implied, or assumes any liability or responsibility for
accuracy, completeness or usefulness of any information, apparatus, product
or process disclosed, or represents that its use will not infringe
privately-owned rights. Mention of any product, its manufacturer, or
suppliers shall not, nor is it intended to, imply approval, disapproval,
or fitness for any particular use. The U.S. and the University at all times
retain the right to use and disseminate the furnished items for any purpose
whatsoever.

Notice 91 02 01

.TP
.B CIFPARSE
Portions of this software are loosely based on the CIFPARSE software package
from the NDB at Rutgers University.  See

   http://ndbserver.rutgers.edu/NDB/mmcif/software

CIFPARSE is part of the NDBQUERY application, a program component of the
Nucleic Acid Database Project [ H. M. Berman, W. K. Olson, D. L. Beveridge,
J. K. Westbrook, A. Gelbin, T. Demeny, S. H. Shieh, A. R. Srinivasan, and B.
Schneider. (1992). The Nucleic Acid Database: A Comprehensive Relational
Database of Three-Dimensional Structures of Nucleic Acids. Biophys J., 63,
751-759.], whose cooperation is gratefully acknowledged, especially in the
form of design concepts created by J. Westbrook.

Please be aware of the following notice in the CIFPARSE API:

This software is provided WITHOUT WARRANTY OF MERCHANTABILITY OR FITNESS
FOR A PARTICULAR PURPOSE OR ANY OTHER WARRANTY, EXPRESS OR IMPLIED. RUTGERS
MAKE NO REPRESENTATION OR WARRANTY THAT THE SOFTWARE WILL NOT INFRINGE ANY
PATENT, COPYRIGHT OR OTHER PROPRIETARY RIGHT.

.SH DESCRIPTION
RasMol is a molecular graphics program intended for the visualisation of
proteins, nucleic acids and small molecules.
The program is aimed at display, teaching and generation of
publication quality images.   RasMol runs on wide range of architectures
and operating systems including Microsoft Windows, Apple
Macintosh, UNIX and VMS systems. UNIX and VMS versions require an 8, 24 or
32 bit colour X Windows display (X11R4 or later).  The X Windows version of
RasMol provides optional support for a hardware dials box and accelerated
shared memory communication (via the XInput and MIT-SHM extensions)
if available on the current X Server.

The program reads in a
molecule coordinate file and interactively displays the molecule on the
screen in a variety of colour schemes and molecule representations. Currently
available representations include depth-cued wireframes, 'Dreiding' sticks,
spacefilling (CPK) spheres, ball and stick, solid and strand biomolecular
ribbons, atom labels and dot surfaces.

Up to 5 molecules may be loaded and displayed at once.  Any one or all of
 the molecules may be rotated and translated.

The RasMol help facility can be accessed by typing "help <topic>" or "help
<topic> <subtopic>" from the command line. A complete list of RasMol commands
may be displayed by typing "help commands". A single question mark may also
be used to abbreviate the keyword "help".  Please type "help notices" for
important notices.

.SH COMMANDS
RasMol allows the execution of interactive commands typed at the
.B RasMol>
prompt in the terminal window. Each command must be given on
a separate line. Keywords are case insensitive and may be entered in
either upper or lower case letters. All whitespace characters are
ignored except to separate keywords and their arguments.

All commands may be prefixed by a parenthesized
.B atom expression
to temporarily select certain atoms just for the execution
of that one command.  After execution of the command, the
previous selection is restored except for the commands
.B select
,
.B restrict
and
.B script.

The commands/keywords currently recognised by RasMol are given below.

.TP
.B Backbone
The RasMol
.B backbone
command permits the representation of a polypeptide
backbone as a series of bonds connecting the adjacent alpha carbons of
each amino acid in a chain. The display of these backbone 'bonds' is
turned on and off by the command parameter in the same way as with the
.B wireframe
command. The command
.B backbone off
turns off the selected 'bonds', and
.B backbone on
or with a number turns them on. The number can be used
to specify the cylinder radius of the representation in either Angstrom
or RasMol units. A parameter value of 500 (2.0 Angstroms) or above
results in a "Parameter value too large" error. Backbone objects may be
coloured using the RasMol
.B colour backbone
command.

The reserved word backbone is also used as a predefined set ("help sets")
and as a parameter to the
.B set hbond
and
.B set ssbond
commands. The
RasMol command
.B trace
renders a smoothed backbone, in contrast to
.B backbone
which connects alpha carbons with straight lines.

The backbone may be displayed with dashed lines by use of the
.B backbone dash
command.

.TP
.B Background
The RasMol
.B background
command is used to set the colour of the "canvas" background. The
colour may be given as either a colour name or a comma separated
triple of Red, Green and Blue (RGB) components enclosed in square
brackets. Typing the command
.B help colours
will give a list of the predefined colour names recognised by RasMol.
When running under X Windows, RasMol also recognises colours in the
X server's colour name database.

The
.B background
command is synonymous with the RasMol
.B set background
command.

.TP
.B Bond
The RasMol command
.B bond <number> <number> +
adds the designated bond to the drawing, increasing the bond order
if the bond already exists.  The command
.B bond <number> <number> pick
selects the two atoms specified by the atom serial numbers
as the two ends of a bond around which the
.B rotate bond <angle>
command will be applied.  If no bond exists, it is created.

Rotation around a previously picked bond may be specified by the
.B rotate bond <angle>
command, or may also be controlled with the mouse, using the
.B bond rotate on/off
or the equivalent
.B rotate bond on/off
commands.

.TP
.B Bulgarian
The RasMol
.B Bulgarian
command sets the menus and messages to the Bulgarian versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B Cartoon
The RasMol
.B cartoon
command does a display of a molecule
.B ribbons
as Richardson (MolScript) style protein
.B cartoons,
implemented as thick (deep) ribbons. The
easiest way to obtain a cartoon representation of a protein is
to use the
.B Cartoons
option on the
.B Display
menu. The
.B cartoon
command represents the currently selected residues
as a deep ribbon with width specified by the command's argument.
Using the command without a parameter results in the ribbon's
width being taken from the protein's secondary structure,
as described in the
.B ribbons
command. By default, the C-termini of beta-sheets are displayed
as arrow heads. This may be enabled and disabled using the
.B set cartoons
command.
The depth of the cartoon may be adjusted using the
.B set cartoons <number>
command. The
.B set cartoons
command without any parameters returns these two options
to their default values.

.TP
.B Centre
The RasMol
.B centre
command defines the point about which the
.B rotate
command and the scroll bars rotate the current molecule. Without a
parameter the centre command resets the centre of rotation to be the
centre of gravity of the molecule. If an atom expression is specified,
RasMol rotates the molecule about the centre of gravity of the set of
atoms specified by the expression. Hence, if a single atom is specified
by the expression, that atom will remain 'stationary' during rotations.

Type
.B help expression
for more information on RasMol atom expressions.

Alternatively the centring may be given as a comma separated triple of
[CenX, CenY, CenZ] offsets in RasMol units (1/250 of an Angstrom) from
the centre of gravity.  The triple must be enclosed in square brackets.

The optional forms
.B centre ... translate
and
.B centre ... center
may be used to specify use of a translated centre of rotation (not
necessarily in the centre of the canvas) or a centre of rotation
which is placed at the centre of the canvas.  Starting with
RasMol 2.7.2, the default is
to center the new axis on the canvas.

.TP
.B Chinese
The RasMol
.B Chinese
command sets the menus and messages to the Chinese versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B Clipboard
The RasMol
.B clipboard
command places a copy of the currently displayed image on the local
graphics 'clipboard'. Note: this command is not yet supported on
UNIX or VMS machines. It is intended to make transfering images
between applications easier under Microsoft Windows or on an Apple
Macintosh.

When using RasMol on a UNIX or VMS system this functionality may be
achieved by generating a raster image in a format that can be read
by the receiving program using the RasMol
.B write
command.

.TP
.B Colour
Colour the atoms (or other objects) of the selected region. The colour may
be given as either a colour name or a comma separated triple of Red, Green
and Blue (RGB) components enclosed in square brackets. Typing the command
.B help colours
will give a list of all the predefined colour names recognised
by RasMol.

Allowed objects are
.B atoms,
.B bonds,
.B backbone,
.B ribbons,
.B labels,
.B dots,
.B hbonds,
.B map,
and
.B ssbonds.
If no object is specified, the default keyword
.B atom
is assumed.
Some colour schemes are defined for certain object types. The colour scheme
.B none
can be applied to all objects except atoms and dots, stating that the selected
objects have no colour of their own, but use the colour of their associated
atoms (i.e. the atoms they connect).
.B Atom
objects can also be coloured by
.B alt,
.B amino,
.B chain,
.B charge,
.B cpk,
.B group,
.B model,
.B shapely,
.B structure,
.B temperature
or
.B user.
Hydrogen bonds can also be coloured by
.B type
and dot surfaces can also be coloured by
.B electrostatic potential.
For more information type
.B help colour <colour>.
Map objects may be coloured by specific color of by nearest atom.

.TP
.B ColourMode
ColourMode allows the user to switch between using the new
.B colour
method. At present, the new coloring technique is the same as
the old one, but to preserve compatibility for older scripts
it may be wise to add a "colormode on" near the top of your
script somewhere, if the script was designed for version 2.7.3
of RasMol or earlier. The new color method, when completed,
aims to fix a few bugs in the coloring routines.

.TP
.B Connect
The RasMol
.B connect
command is used to force RasMol to (re)calculate the connectivity
of the current molecule.
If the original input file contained connectivity information, this
is discarded. The command
.B connect false
uses a fast heuristic
algorithm that is suitable for determining bonding in large
bio-molecules such as proteins and nucleic acids. The command
.B connect true
uses a slower more accurate algorithm based upon
covalent radii that is more suitable to small molecules containing
inorganic elements or strained rings. If no parameters are given,
RasMol determines which algorithm to use based on the number of atoms
in the input file. Greater than 255 atoms causes RasMol to use the
faster implementation. This is the method used to determine bonding,
if necessary, when a molecule is first read in using the
.B load
command.

.TP
.B Defer
The RasMol
.B defer
command adds the command given to the macro with given name,
if no name is given, the command is added to the macro with a
blank name. The command
.B zap
is a special case. In that case the macro is erased. If no name is
given the command must begin with a selection, e.g.
.B defer (selection).spacefill

The deferred commands accumulated under the given name can be executed
using the
.B execute
command

.TP
.B Define
The RasMol
.B define
command allows the user to associate an arbitrary set of atoms with a
unique identifier. This allows the definition of user-defined sets. These
sets are declared statically, i.e. once defined the contents of the set
do not change, even if the expression defining them depends on the
current transformation and representation of the molecule.

.TP
.B Depth
The RasMol
.B depth
command enables, disables or positions the back-clipping plane of the
molecule. The program only draws those portions of the
molecule that are closer to the viewer than the clipping plane.
Integer values range from zero at the very back of the molecule to
100 which is completely in front of the molecule. Intermediate values
determine the percentage of the molecule to be drawn.

This command interacts with the
.B slab <value>
command, which clips to the front of a given z-clipping plane.

.TP
.B Dots
The RasMol
.B dots
command is used to generate a van der Waals' dot surface around the
currently selected atoms. Dot surfaces display regularly spaced points
on a sphere of van der Waals' radius about each selected atom. Dots that
would are 'buried' within the van der Waals' radius of any other atom
(selected or not) are not displayed.
The command
.B dots on
deletes any existing dot surface and generates a dots surface around
the currently selected atom set with a default dot density of 100. The
command
.B dots off
deletes any existing dot surface. The dot density may be
specified by providing a numeric parameter between 1 and 1000. This
value approximately corresponds to the number of dots on the surface
of a medium sized atom.

By default, the colour of each point on a dot surface is the colour
of its closest atom at the time the surface is generated. The colour
of the whole dot surface may be changed using the
.B colour dots
command.

.TP
.B Echo
The RasMol
.B echo
command is used to display a message in the RasMol command/terminal
window. The string parameter may optionally be delimited in double
quote characters. If no parameter is specified, the
.B echo
command displays a blank line. This command is particularly useful
for displaying text from within a RasMol
.B script
file.

.TP
.B English
The RasMol
.B English
command sets the menus and messages to the English versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B Execute
The RasMol
.B execute
command:

1.  saves the old poise of the molecule (translation,
rotation and zoom)

2. executes the specified macro suppressing both screen
updates and recording

3. animates motion of the newly rendered molecule linearly
from the old poise to the new poise

The macro must have been previously defined by calls to the
.B defer
command.

The animation of the motion depends on the prior settings of the
.B record
command.

.TP
.B French
The RasMol
.B French
command sets the menus and messages to the French versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B HBonds
The RasMol
.B hbond
command is used to represent the hydrogen bonding of the protein
molecule's backbone. This information is useful in assessing the
protein's secondary structure. Hydrogen bonds are represented as
either dotted lines or cylinders between the donor and acceptor
residues. The first time the
.B hbond
command is used, the program searches the structure of the
molecule to find hydrogen bonded residues and reports the number of bonds
to the user. The command
.B hbonds on
displays the selected 'bonds' as dotted lines, and the
.B hbonds off
turns off their display. The colour of hbond objects may be changed
by the
.B colour hbond
command. Initially, each hydrogen bond has the colours of its connected
atoms.

By default the dotted lines are drawn between the accepting oxygen and
the donating nitrogen. By using the
.B set hbonds
command the alpha carbon positions of the appropriate residues may be
used instead. This is especially useful when examining proteins in
backbone representation.

.TP
.B Help
The RasMol
.B help
command provides on-line help on the given topic.

.TP
.B Italian
The RasMol
.B Italian
command sets the menus and messages to the Italian versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B Japanese
The RasMol
.B Japanese
command sets the menus and messages to the Japanese versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B Label
The RasMol
.B label
command allows an arbitrary formatted text string to be
associated with each currently selected atom.  This string may contain
embedded 'expansion specifiers' which display properties of the atom
being labelled. An expansion specifier consists of a '%' character
followed by a single alphabetic character specifying the property to be
displayed.
An actual '%' character may be displayed by using the expansion
specifier '%%'.

Atom labelling for the currently selected atoms may be turned off with
the command
.B label off.
By default, if no string is given as a parameter, RasMol uses labels
appropriate for the current molecule.

The colour of each label may be changed using the
.B colour label
command. By default, each label is drawn in the same colour as the atom
to which it is attached. The size and spacing of the displayed text
may be changed using the
.B set fontsize
command.  The width of the strokes in the displayed text may be changed
 using the
.B set fontstroke
 command.

.TP
.B Load
Load a molecule coordinate file into RasMol. Valid molecule file
formats are
.B pdb
(Protein Data Bank format),
.B mdl
(Molecular Design Limited's MOL file format),
.B alchemy
(Tripos' Alchemy file format),
.B mol2
(Tripos' Sybyl Mol2 file format),
.B charmm
(CHARMm file format),
.B xyz
(MSC's XMol XYZ file format),
.B mopac
(J. P. Stewart's MOPAC file format) or
.B cif
(IUCr CIF or mmCIF file format). If no file format is specified,
.B PDB,
.B CIF,
or
.B mmCIF
is assumed by default. Up to 20 molecules may be loaded at a time.
If CHEM_COMP ligand models are included in an mmCIF file, they will be loaded
as NMR models, first giving the all the NMR models for model
coordinates if specified and then giving all the NMR models for
ideal model coordinates.

To delete a molecule prior to loading another use the RasMol
.B zap
command.  To select a molecule for manipulation use the RasMol
.B molecule <n>
command.

The
.B load
command selects all the atoms in the molecule, centres it on the
screen and renders it as a CPK coloured wireframe model. If the molecule
contains no bonds (i.e. contains only alpha carbons), it is drawn as
an alpha carbon backbone. If the file specifies fewer bonds than atoms,
RasMol determines connectivity using the
.B connect
command.

The
.B load inline
command also allows the storing of atom coordinates in scripts
to allow better integration with WWW browsers. A load command
executed inside a script file may specify the keyword
.B inline
instead of a conventional filename. This option specifies that
the coordinates of the molecule to load are stored in the same
file as the currently executing commands.

.TP
.B Map
The RasMol
.B map
commands manipulate electron density maps in coordination
with the display of molecules.  These commands are very
memory intensive and may not work on machines with
limited memory.  Each molecule may have as many maps
as available memory permits.  Maps may be read from
files or generated from Gaussian density distributions
around atoms.

.B map colour,
to colour a map according to a given colour scheme,
.B map generate,
to generate a map from selected atoms based on pseudo-Gaussians,
.B map level,
to set the contouring level for selected maps,
.B map load,
to load a map from a file,
.B map mask
to designate a mask for the selected maps,
.B map resolution,
to set the resolution for contouring selected maps,
.B map restrict,
to select one or more maps and to disable all others,
.B map save,
to save map information to a file,
.B map scale,
.B control the scaling of pseudo-Gaussians when generating maps,
.B map select,
to select one or more maps,
.B map show,
to display information about one or more maps or about the
parameters to be used in generating or loading the next map,
.B map spacing,
to set the spacing betwen contour lines of selected maps,
.B map spread,
to set the variance of the Gaussians for map generation as a fraction
of the atomic radius, and
.B map zap
to delete previously generated or loaded maps.

The effect of
.B map generate
and
.B map load
commands is modified by the
.B map mask
command which limits the portion of the display space
that can be considered for display of maps.

.TP
.B Map colour
The RasMol
.B map colour
command colours the selected maps according to the specified
colour scheme.  The colour scheme may be a colour name or
and RBG triple in brackets, or the keyword
.B atom
to cause the map points to be coloured by the color of the
nearest atom.

.TP
.B Map generate
The RasMol
.B map generate
command generates a map from whatever atoms are currently selected,
by summing electron densities approximated by Gaussian distributions.
The height of each Gaussian is determined by the setting of the
.B  map scale
command.
In the default of map scale true, each Gaussian has a height proportional
element type of the atom.
If the optional 'LRSurf' parameter is given or if map scale false
has been executed, each Gaussian is scaled so that
the Gaussian contour level 1 is at the van der Waals radius.
In either case a standard deviation determined by the
most recently specified spread or resolution is used.  If a non-zero spread has been
given the radius of the atom is multiplied by the spread to find the
standard deviation.  The default is 2/3rds.  If a resolution
has been given, the spread is inferred as 2/3rds of the resolution.

For example, if the resolution is given as 1., and the atom in question
is a Carbon with a van der Waals radius of 468 RasMol units (1.87 Angstroms),
the inferred spead is .6667, and the standard deviation of the Gaussian
is taken as 1.25 Angstroms.

If the spread has been set to zero, the spread for each atom is determined
from the van der Waals radius and the probe atom radius to simulate the
effect of a Lee-Richards surface.

If no specific map was given by the map selector, the new map is
given the next available map number.

If a specific map was given by the map selector, the new map replaces
that map.  If more than one map was given by the map selector, the
new map replaces the lowest numbered of the selected maps.  In any
case the new map becomes the currently selected map.

The map is displayed as dots, mesh or a surface, depending on the last
map rendering mode selected or the mode selected on the command itself.

.TP
.B Map level
The RasMol
.B map level
command sets the contour level to be used in creating subsequent
representations of generated or loaded maps.  If the keyword MEAN
in used the level is relative to the mean of the map data.  Otherwise
the level is absolute.

In general, a lower level results in a map containing more of the
displayed volume, while a higher level results in a map containing
less of the displayed volume.

.TP
.B Map load
The RasMol
.B map load
command loads a map file into RasMol.  The valid formats are
CCP4 map format and imgCIF format.

If no specific map was given by the map selector, the new map is
given the next available map number.

If a specific map was given by the map selector, the new map replaces
that map.  If more than one map was given by the map selector, the
new map replaces the lowest numbered of the selected maps.  In any
case the new map becomes the currently selected map.

The map is displayed as dots, mesh or a surface depending on the
last map rendering mode selected.

.TP
.B Map mask
The RasMol
.B map mask
command specifies a mask to be used to limit the display space
to be used for making representations of other maps or removes
an earlier mask specification.

The 'selected' option indicates that the mask is to be created
from the currently selected atoms.  The '<number>' option indicates
that the mask is to be copied from the map of the number specified.
The 'none' option removes the previously specified mask, if any.

The map selector specifies the map or maps to which the specified mask
will the applied.  For example, 'map next mask selected' specifies
that the currently selected atoms are to be used to generate a
mask to be applied to any maps created by subsequent 'map load'
or 'map generate' commands.

Any map may be used as a mask.  The portions of the mask map greater than
than or equal to the average value of the mask map allow the values of the
map being masked to be used as given.  The portions of the mask
map lower than the average value of the mask map cause the values of
the map being masked to be treated as if they were equal to the
lowest data value of the map being masked.

.TP
.B Map resolution
The RasMol
.B map resolution
command specifies the resolution in RasMol units or,
if a number containing a decimal point is given, the
resolution in Angstroms to be used in generating and
in representing maps.

The resolution is used at the map spacing for
representations of maps, indicating the separation
between contour levels (see the
.B map spacing
command) and to infer the map spread to be used in
generated maps from selected atoms (see the
.B map spread
command).  The map spread is set to two thirds of
the specified resolution.

.TP
.B Map restrict
The RasMol
.B map restrict
command selects particular maps to make them active for
subsequent map commands.  This is similar to the
.B map select
command, but does disables the display of the
maps that were not selected.

.TP
.B Map save
The RasMol
.B map save
command saves an imgCIF map file.

If no specific map was given by the map selector, the currently
selected maps and their masks are written to the file, one
map and mask pair per data block.

.TP
.B Map scale
The RasMol
.B map scale
command selects the scaling of pseudo-Gaussians in the
.B map generate
commands.
In the default of map scale true, each Gaussian has a height proportional
element type of the atom.
If map scale false has been executed, each Gaussian is scaled so that
the Gaussian contour level 1 is at the van der Waals radius.
In either case a standard deviation determined by the
most recently specified spread or resolution is used.

.TP
.B Map select
The RasMol
.B map select
command selects particular maps to make them active for
subsequent map commands.  This is similar to the
.B map restrict
command, but does not disable the display of the
maps that were not selected.

If the optional
.B atom
parameter is given, the command selects the atoms with centres closest to the
map points.  The radius of the search may be specified by the parameter
.B search_radius.
The default is to look for atoms within 4 Angstroms plus the probe radius.
If the optional
.B within
parameter is given, the new selection is taken from within the currently
selected atoms.  If the options
.B add
parameter is given, the new selection is added to the currently selected atoms.
The default is to search within all atoms.

.TP
.B Map show
The RasMol
.B map show
command causes information about the maps specified by
the map selector to be written to the command window.

.TP
.B Map spacing
The RasMol
.B map spacing
command specifies the spacing to be used between contour lines
in creating representations of maps.  The spacing is typically
 given in Angstroms with a decimal point, but may also be
specified in RasMol units (250ths of an Angstom) as an
integer.  For maps loaded in grid coordinates that spacing
is parallel to the cell edges.  The default spacing is
one half Angstrom.

.TP
.B Map spread
The RasMol
.B map spread
command specifies the reciprocal of the number of
standard deviations per radius to be used in
generating maps as sums of Gaussians centered
on atomic positions.  The default spread is one
two thirds (i.e. each radius covers 1.5 standard deviations).

If the spread has been set to zero, the spread for each atom is determined
from the van der Waals radius and the probe atom radius to simulate the
effect of a Lee-Richards surface.

.TP
.B Map zap
The RasMol
.B map zap
command removes the data and representations of the
maps specified by the map selector.  The map numbers
of maps that have not been removed are not changed.

.TP
.B Molecule
The RasMol
.B molecule
command selects one of up to 5 previously loaded molecules
for active manipulation.  While all the molcules are displayed
and may be rotated collectively (see the
.B rotate all
command), only one molecule at a time
time is active for manipulation by the commands which
control the details of rendering.

.TP
.B Monitor
The RasMol
.B monitor
command allows the display of distance monitors. A distance
monitor is a dashed (dotted) line between an arbitrary pair
of atoms, optionally labelled by the distance between them.
The RasMol command
.B monitor <number> <number>
adds such a distance monitor between the two atoms specified by the atom
serial numbers given as parameters

Distance monitors are turned off with the command
.B monitors off.
By default, monitors display the
distance between its two end points as a label at the centre of
the monitor. These distance labels may be turned off with the
command
.B set monitors off,
and re-enabled with the command
.B set monitors on.
Like most other representations,
the colour of a monitor is taken from the colour of its end points unless
specified by the
.B colour monitors
command.

Distance monitors may also be added to a molecule interactively with
the mouse, using the
.B set picking monitor
command. Clicking on an atom results
in its being identified on the rasmol command line. In addition
every atom picked increments a modulo counter such that, in monitor
mode, every second atom displays the distance between this atom and
the previous one. The shift key may be used to form distance monitors
between a fixed atom and several consecutive positions. A distance
monitor may also be removed (toggled) by selecting the appropriate
pair of atom end points a second time.

.TP
.B Notoggle
The RasMol
.B NoToggle
command enables or disables the use of the toggle ability
that is used by some of the other RasMol commands.
When no boolean value is specified, NoToggle mode is ENABLED.
When NoToggle mode is ENABLED, all toggle functionality is
DISABLED. To turn it off, one must explicitly set
.B notoggle off.

Some commands which use the toggle feature are:
.B ColourMode.
More functions that utilize this capability may be added
at a later date.

.TP
.B Pause
The RasMol
.B pause
command is used in script files to stop the script file for local
manipulation by a mouse, until any key is pushed to restart the
script file.
.B Wait
is synonymous with
.B pause.
This command may be executed in RasMol script files to suspend
the sequential execution of commands and allow the user to examine
the current image.   When RasMol executes a
.B pause
command in a script file, it suspends  execution of the rest
of the file, refreshes the image on the screen and allows the
manipulation of the image using the mouse and scroll  bars, or
resizing of the graphics window.  Once a key is pressed, control
returns to the script file at the line following the
.B pause
command.  While a script is suspended the molecule may be rotated,
translated, scaled, slabbed and picked as usual, but all menu
commands are disabled.

.TP
.B Play
The RasMol
.B play
command specifies the recording medium from which to play back a movie.
The playback frame start time is given in seconds to millisecond precision.
Since we are working on computers, the medium is specified as a set of files,
each marked with the playback frame start time in milliseconds as part of the
name. The place in the name at which to look for the playback frame start
time in milliseconds is marked by the characters "ssssss" with an
appropriate number of digits.  RasMol accepts either upper or lower case
s's or decimal digits to mark the place for the time.  The play off and play
eject commands effectively remove the specified medium from use. If no medium
is specified, play off suspends playing and play on resumes playing.
Normally play starts immediately and runs to the end of the medium. However,
if play off and/or or some combination of play from and play until is entered
before
.B play type medium,
those settings will be used.

As of release 2.7.5, RasMol support play from scripts and data files.

.TP
.B Print
The RasMol
.B print
command sends the currently displayed image to the local default printer
using the operating system's native printer driver. Note: this command
is not yet supported under UNIX or VMS. It is intended to take advantage
of Microsoft Windows and Apple Macintosh printer drivers. For example,
this allows images to be printed directly on a dot matrix printer.

When using RasMol on a UNIX or VMS system this functionality may be
achieved by either generating a PostScript file using the RasMol
.B write ps
or
.B write vectps
commands and printing that or generating a raster image file and using a
utility to dump that to the local printer.

.TP
.B Quit
Exit from the RasMol program. The RasMol commands
.B exit
and
.B quit
are synonymous, except within nested scripts.  In that case,
.B exit
terminates only the current level, while
.B quit
terminates all nested levels of scripts.

.TP
.B Record
The RasMol
.B record
command specifies the recording medium to hold the movie. Since we are
working on computers, the medium is specified as a template for a set of
files, each marked with the playback frame start time in milliseconds
(rather than as seconds to avoid embedding a decimal point) as part of
the name. The place in the name to be replaced with the playback frame
start time in milliseconds is marked by the characters "ssssss" with
an appropriate number of digits. RasMol accepts either upper or lower case
s's or decimal digits to mark the place for the time.  The record off
commands remove the specified medium from use. If no medium is specified,
record off suspends recording and record on resumes recording with the
next available time on the same medium. The screen is the default medium
and is, by default, on. Writing to disk must be explicitly specified so
that the disk does not get filled up unintentionally. The type of a
recording medium may be an image type such as gif, pict or png to record
the actual screen images or script to record the RasMol commands used to
generate the frames.

Normally recording starts at playback frame start time 0 seconds.
A non-zero starting time in seconds can be specified with the
.B record from
command as in
.B record from 25
or
.B record from 37.25
to help in organizing scenes of movies to be assembled later in an
appropriate order.
The
.B record until
command allows an upper limit to be set on recording time in seconds.
The default is to have no limit. Issuing the commands

.B record from 600

.B record until 1800

would result in a 20 minute movie segment intended to start 10
minutes into a longer movie.
These commands allow control over rewriting selected time segments.

.TP
.B Refresh
The RasMol
.B refresh
command redraws the current image.  This is useful in scripts
to ensure application of a complex list of parameter changes.

.TP
.B Renumber
The RasMol
.B renumber
command sequentially numbers the residues in a macromolecular chain.
The optional parameter specifies the value of the first residue in the
sequence. By default, this value is one. For proteins,
each amino acid is numbered consecutively from the N terminus to the C
terminus. For nucleic acids, each base is numbered from the 5' terminus
to the 3' terminus. All chains in the current database are renumbered and gaps
in the original sequence are ignored. The starting value for numbering may
be negative.

.TP
.B Reset
The RasMol
.B reset
command restores the original viewing transformation
and centre of rotation. The scale is set to its default value,
.B zoom 100,
the centre of rotation is set to the geometric centre of the currently
loaded molecule,
.B centre all,
this centre is translated to the middle of the screen and
the viewpoint set to the default orientation.

This command should not be mistaken for the RasMol
.B zap
command which deletes the currently stored molecule, returning the
program to its initial state.

.TP
.B Restrict
The RasMol
.B restrict
command both defines the currently selected region of the
molecule and disables the representation of (most of) those parts of the
molecule no longer selected.  All subsequent RasMol commands that modify
a molecule's colour or representation affect only the currently selected
region. The parameter of a
.B restrict
command is a RasMol atom expression that is evaluated for every atom
of the current molecule. This command is very similar to the RasMol
.B select
command, except
.B restrict
disables the
.B wireframe,
.B spacefill
and
.B backbone
representations in the non-selected region.

Type "help expression" for more information on RasMol atom expressions or
see section
.B Atom Expressions.

.TP
.B Ribbons
The RasMol
.B ribbons
command displays the currently loaded protein or nucleic acid as a
smooth solid "ribbon" surface passing along the backbone of the protein.
The ribbon is drawn between each amino acid whose alpha carbon is
currently selected. The colour of the ribbon is changed by the RasMol
.B colour ribbon
command. If the current ribbon colour is
.B none
(the default), the colour is taken from the alpha carbon at each
position along its length.

The width of the ribbon at each position is determined by the optional
parameter in the usual RasMol units. By default the width of the ribbon
is taken from the secondary structure of the protein or a constant value
of 720 (2.88 Angstroms) for nucleic acids.
The default width of protein alpha helices and beta sheets is 380 (1.52
Angstroms) and 100 (0.4 Angstroms) for turns and random coil. The
secondary structure assignment is either from the PDB file or calculated
using the DSSP algorithm as used by the
.B structure
command. This command is similar to the RasMol command
.B strands
which renders the biomolecular ribbon as parallel depth-cued curves.

.TP
.B Rotate
Rotate the molecule about the specified axis.
Permitted values for the axis parameter are
"x", "y", "z" and "bond".
The integer parameter states the angle in degrees for the structure to
be rotated. For the X and Y axes, positive values move the closest point
up and right, and negative values move it down and left, respectively. For
the Z axis, a positive rotation acts clockwise and a negative angle
anti-clockwise.

Alternatively, this command may be used to specify which rotations
the mouse or dials will control.  If
.B rotate bond true
is selected, the horizontal scroll bar will control rotation around
the axis selected by the
.B bond src dst pick
command.  If
.B rotate all true
is selected, and multiple molecules have been loaded, then all molecules
will rotate together.  In all other cases, the mouseand dials control the
the rotation of the molecule selected by the
.B molecule n
command.

.TP
.B Russian
The RasMol
.B Russian
command sets the menus and messages to the Russian versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B Save
Save the currently selected set of atoms in a Protein
Data Bank (PDB), MDL, Alchemy(tm) or XYZ format file.
The distinction between this command and the RasMol
.B write
command has been dropped. The only difference is that without a format
specifier the
.B save
command generates a
.B PDB
file and the
.B write
command generates a
.B GIF
image.

.TP
.B Script
The RasMol
.B script
command reads a set of RasMol commands sequentially from a
text file and executes them. This allows sequences of commonly used
commands to be stored and performed by single command. A RasMol script
file may contain a further script command up to a maximum "depth" of 10,
allowing complicated sequences of actions to be executed. RasMol
ignores all characters after the first '#' character on each line
allowing the scripts to be annotated. Script files are often also
annotated using the RasMol
.B echo
command.

The most common way to generate a RasMol script file is to use the
.B write script
or
.B write rasmol
commands to output the sequence of commands that are needed to
regenerate the current view, representation and colouring of the
currently displayed molecule.

The RasMol command
.B source
is synonymous with the
.B script
command.

.TP
.B Select
Define the currently selected region of the molecule. All subsequent RasMol
commands that manipulate a molecule or modify its colour or representation
only affect the currently selected region. The parameter of a
.B select
command is a RasMol expression that is evaluated for every atom of the
current molecule. The currently selected (active) region of the molecule
are those atoms that cause the expression to evaluate true. To select
the whole molecule use the RasMol command
.B select all.
The behaviour of the
.B select
command without any parameters is determined by the RasMol
.B hetero
and
.B hydrogen
parameters.

Type "help expression" for more information on RasMol atom expressions or
see section
.B Atom Expressions.

.TP
.B Set
The RasMol
.B set
command allows the user to alter various internal program parameters
such as those controlling rendering options. Each parameter has its
own set or permissible parameter options. Typically, omitting the
paramter option resets that parameter to its default value. A list of
valid parameter names is given below.

.TP
.B Show
The RasMol
.B show
command display details of the status of the currently
loaded molecule. The command
.B show information
lists the molecule's name,
classification, PDB code and the number of atoms, chains, groups it contains.
If hydrogen bonding, disulphide bridges or secondary structure have been
determined, the number of hbonds, ssbonds, helices, ladders and turns
are also displayed, respectively. The command
.B show centre
shows any non-zero centering values selected by the
.B centre [CenX, CenY, CenZ]
command. The command
.B show phipsi
shows the phi and psi angles of the currently selected residues and
the omega angles of cis peptide bonds. The command
.B show RamPrint
(or 'show RPP' or 'show RamachandranPrinterPlot') shows a simple
Ramachandran printer plot in the style of Frances Bernstein's fisipl
program.  The command
.B show rotation
(or 'show rot' or 'show 'rotate') shows the currently selected values
of z, y, x and bond rotations, if any.
The command
.B show selected
(or 'show selected group' or 'show selected chain' or  'show selected atom' )
shows the groups (default), chains or atoms of the current selection.
The command
.B show sequence
lists the residues that comprise each chain of the molecule.  The command
.B show symmetry
shows the space group and unit cell of the molecule. The command
.B show translation
shows any non-zero translation values selected by the
.B translate <axis> <value>
command. The command
.B show zoom
shows any non-zero zoom value selected by the
.B zoom <value>
command.

.TP
.B Slab
The RasMol
.B slab
command enables, disables or positions the z-clipping plane of the
molecule. The program only draws those portions of the
molecule that are further from the viewer than the slabbing plane.
Integer values range from zero at the very back of the molecule to
100 which is completely in front of the molecule. Intermediate values
determine the percentage of the molecule to be drawn.

This command interacts with the
.B depth <value>
command, which clips to the rear of a given z-clipping plane.

.TP
.B Spacefill
The RasMol
.B spacefill
command is used to represent all of the currently selected atoms as solid
spheres. This command is used to produce both union-of-spheres and
ball-and-stick models of a molecule. The command,
.B spacefill true,
the default, represents each atom as a sphere of van der Waals radius.
The command
.B spacefill off
turns off the representation of the selected atom as spheres. A sphere
radius may be specified as an integer in RasMol units (1/250th Angstrom)
or a value containing a decimal point. A value of 500 (2.0
Angstroms) or greater results in a "Parameter value too large" error.

The
.B temperature
option sets the radius of each sphere to the value stored in its temperature
field. Zero or negative values have no effect and values greater than
2.0 are truncated to 2.0.  The
.B user
option allows the radius of each sphere to be specified by additional lines
in the molecule's PDB file using Raster 3D's COLOUR record extension.

The RasMol command
.B cpk
is synonymous with the
.B spacefill
command.

The RasMol command
.B cpknew
is synonymous with the
.B spacefill
command, except that a slightly different set of colours is used.

.TP
.B Spanish
The RasMol
.B Spanish
command sets the menus and messages to the Spanish versions.

This command may not work correctly unless appropriate fonts
have been installed.  The commands
.B Bulgarian,
.B Chinese,
.B English,
.B French,
.B Italian,
.B Russian
and
.B Spanish
may be used to select Bulgarian, Chinese, English, French,
Italian, Japanese, Russian and Spanish menus and messages if the
appropriate fonts have been installed.

.TP
.B SSBonds
The RasMol
.B ssbonds
command is used to represent the disulphide bridges of the protein
molecule as either dotted lines or cylinders between the connected
cysteines. The first time that the
.B ssbonds
command is used, the program searches the structure of the protein to
find half-cysteine pairs (cysteines whose sulphurs are within 3 Angstroms
of each other) and reports the number of bridges to the user. The command
.B ssbonds on
displays the selected "bonds" as dotted lines, and the command
.B ssbonds off
disables the display of ssbonds in the currently selected area. Selection
of disulphide bridges is identical to normal bonds, and may be adjusted
using the RasMol
.B set bondmode
command. The colour of disulphide bonds may be changed using the
.B colour ssbonds
command. By default, each disulphide bond has the colours of its connected
atoms.

By default disulphide bonds are drawn between the sulphur atoms within
the cysteine groups. By using the
.B set ssbonds
command the position of the cysteine's alpha carbons may be used instead.

.TP
.B Star
The RasMol
.B star
command is used to represent all of the currently selected atoms as
stars (six strokes, one each in the x, -x, y, -y, z and -z directions).
The commands
.B select not bonded
followed by
.B star 75
are useful to mark unbonded atoms in a
.B wireframe
display with less overhead than provided by
.B spacefill 75.
This can be done automatically for all subsequent wireframe
displays with the command
.B set bondmode not bonded.

The command
.B star true,
the default, represents each atom as a star with strokes
length equal to van der Waals radius.
The command
.B star off
turns off the representation of the selected atom as stars. A star
stroke length may be specified as an integer in RasMol units
(1/250th Angstrom)
or a value containing a decimal point. A value of 500 (2.0
Angstroms) or greater results in a "Parameter value too large" error.

The
.B temperature
option sets the stroke length of each star to the value stored
in its temperature
field. Zero or negative values have no effect and values greater than
2.0 are truncated to 2.0.  The
.B user
option allows the stroke length of each star to be specified by
additional lines
in the molecule's PDB file using Raster 3D's COLOUR record extension.

The RasMol
.B spacefill
command can be used for more artistic rendering of atoms as spheres.

.TP
.B Stereo
The RasMol
.B stereo
command provides side-by-side stereo display of images. Stereo
viewing of a molecule may be turned on (and off) either by
selecting
.B Stereo
from the
.B Options
menu, or by
typing the commands
.B stereo on
or
.B stereo off.

Starting with RasMol version 2.7.2.1, the
.B Stereo
menu selection and the command
.B stereo
without arguments cycle from the initial state of
.B stereo off
to
.B stereo on
in cross-eyed mode to
.B stereo on
in wall-eyed mode and then back to
.B stereo off.

The separation angle between
the two views may be adjusted with the
.B set stereo [-] <number>
command, where positive values result in crossed eye
viewing and negative values in relaxed (wall-eyed) viewing.
The inclusion of
.B [-] <number>
in the
.B stereo
command, as for example in
.B stereo 3
or
.B stereo -5,
also controls angle and direction.

The stereo command is only partially
implemented. When stereo is turned on, the image is not properly
recentred. (This can be done with a
.B translate x -<number>
 command.)
It is not supported in vector PostScript output files, is not
saved by the
.B write script
command, and in
general is not yet properly interfaced with several other
features of the program.

.TP
.B Strands
The RasMol
.B strands
command displays the currently loaded protein or nucleic acid as a
smooth "ribbon" of depth-cued curves passing along the backbone of the
protein. The ribbon is composed of a number of strands that run parallel
to one another along the peptide plane of each residue. The ribbon is
drawn between each amino acid whose alpha carbon is currently selected.
The colour of the ribbon is changed by the RasMol
.B colour ribbon
command. If the current ribbon colour is
.B none
(the default), the colour is taken from the alpha carbon at each
position along its length. The central and outermost
strands may be coloured independently using the
.B colour ribbon1
and
.B colour ribbon2
commands, respectively. The number of strands in the ribbon may be
altered using the RasMol
.B set strands
command.

The width of the ribbon at each position is determined by the optional
parameter in the usual RasMol units. By default the width of the ribbon
is taken from the secondary structure of the protein or a constant value
of 720 for nucleic acids (which produces a ribbon 2.88 Angstroms wide).
The default width of protein alpha helices and beta sheets is 380 (1.52
Angstroms) and 100 (0.4 Angstroms) for turns and random coil. The
secondary structure assignment is either from the PDB file or calculated
using the DSSP algorithm as used by the
.B structure
command. This command is similar to the RasMol command
.B ribbons
which renders the biomolecular ribbon as a smooth shaded surface.

.TP
.B Structure
The RasMol
.B structure
command calculates secondary structure assignments
for the currently loaded protein. If the original PDB file contained
structural assignment records (HELIX, SHEET and TURN) these are discarded.
Initially, the hydrogen bonds of the current molecule are found, if this
hasn't been done already. The secondary structure is then determined using
Kabsch and Sander's DSSP algorithm. Once finished the program reports the
number of helices, strands and turns found.

.TP
.B Surface
The RasMol
.B surface
command renders a Lee-Richards molecular surface resulting
from rolling a probe atom on the selected atoms.
The value given specifies the radius of the probe.
If given in the first form, the evolute of the surface
of the probe is shown (the solvent excluded surface).
If given in the second form, the envelope of the
positions of the center of the probe is shown
(the solvent accessible surface).

.TP
.B Trace
The RasMol
.B trace
command displays a smooth spline between  consecutive alpha
carbon positions.  This spline does not pass exactly through
the alpha carbon position of each residue, but  follows the
same path as
.B ribbons,
.B strands
and
.B cartoons.
Note that residues may be displayed as
.B ribbons,
.B strands,
.B cartoons
or as a
.B trace.
Enabling one of these
representations disables the others. However, a residue
may be displayed simultaneously as backbone and as one of
the above representations.  This may change in future
versions of RasMol.  Prior to version 2.6,
.B trace
was synonymous with
.B backbone.

.B Trace temperature
displays the backbone as a wider cylinder
at high temperature factors and thinner at lower.  This
representation is useful to X-ray crystallographers and NMR spectroscopists.

.TP
.B Translate
The RasMol
.B translate
command moves the position of the centre of the molecule on the
screen. The axis parameter specifies along which axis the molecule
is to be moved and the integer parameter specifies the absolute
position of the molecule centre from the middle of the screen.
Permitted values for the axis parameter are
"x", "y" and "z".
Displacement values must be between -100 and 100 which correspond to
moving the current molecule just off the screen. A positive
"x"
displacement moves the molecule to the right, and a positive
"y"
displacement moves the molecule down the screen. The pair of commands
.B translate x 0
and
.B translate y 0
centres the molecule on the screen.

.TP
.B UnBond
The RasMol command
.B unbond <number> <number>
removes the designated bond from the drawing.

The command
.B unbond
without arguments removes a bond previously picked by the
.B bond <number> <number> pick
command.

.TP
.B Wireframe
The RasMol
.B wireframe
command represents each bond within the selected region of the molecule
as a cylinder, a line or a depth-cued vector. The display of bonds
as depth-cued vectors (drawn darker the further away from the viewer)
is turned on by the command
.B wireframe
or
.B wireframe on.
The selected bonds are displayed as cylinders by specifying a radius
either as an integer in RasMol units or containing a decimal point as
a value in Angstroms.  A parameter value of 500 (2.0 Angstroms) or
above results in an "Parameter value too large" error. Bonds may be
coloured using the
.B colour bonds
command.

If the selected bonds involved atoms of alternate conformers then
the bonds are narrowed in the middle to a radius of .8 of the specified
radius (or to the radius specifed as the optional second parameter).

Non-bonded atoms, which could become invisible in an
ordinary
.B wireframe
display can be marked by a preceding
.B set bondmode not bonded
command.  If nearly co-linear bonds to atoms cause them to be
difficult to see in a wireframe display, the
.B set bondmode all
command will add markers for
.B all
atoms in subsequent
.B wireframe
command executions.

.TP
.B Write
Write the current image to a file in a standard format. Currently
supported image file formats include
.B bmp
(Microsoft bitmap) and
.B gif
(Compuserve GIF),
.B iris
(IRIS RGB),
.B ppm
(Portable Pixmap),
.B ras
(Sun rasterfile),
.B ps
and
.B epsf
(Encapsulated PostScript),
.B monops
(Monochrome Encapsulated PostScript),
.B pict
(Apple PICT),
.B vectps
(Vector Postscript).  The
.B write
command may also be used to generate command scripts for other graphics
programs. The format
.B script
writes out a file containing the RasMol
.B script
commands to reproduce the current image. The format
.B molscript
writes out the commands required to render the current view of the
molecule as ribbons in Per Kraulis' Molscript program and the format
.B kinemage
the commands for David Richardson's program Mage.  The following
formats are useful for further processing:
.B povray
(POVRay 2),
.B povray3
(POVRay 3 -- under development),
.B vrml
(VRML file).
Finally, several
formats are provided to provide phi-psi data for listing or for
.B phipsi
(phi-psi data as an annotated list with cis omegas),
.B ramachan
and
.B RDF
and
.B RamachandranDataFile
(phi-psi data as columns of numbers for gnuplot),
.B RPP
and
.B RamachandranPrinterPlot
(phi-psi data as a printer plot).

The distinction between this command and the RasMol
.B save
command has been dropped. The only difference is that without a format
specifier the
.B save
command generates a
.B PDB
file and the
.B write
command generates a
.B GIF
image.

.TP
.B Zap
Deletes the contents of the current database and resets parameter
variables to their initial default state.

.TP
.B Zoom
Change the magnification of the currently displayed image. Boolean
parameters either magnify or reset the scale of current molecule. An
integer parameter specifies the desired magnification as a percentage
of the default scale. The minimum parameter value is 10; the maximum
parameter value is dependent upon the size of the molecule being
displayed. For medium sized proteins this is about 500.

.SH SET PARAMETERS
RasMol has a number of internal parameters that may be modified using the
.B set
command. These parameters control a number of program options such as
rendering options and mouse button mappings.

    picking         play.fps        radius          record.aps

.TP
.B Set Ambient
The RasMol
.B ambient
parameter is used to control the amount of ambient (or surrounding)
light in the scene. The
.B ambient
value must be between 0 and 100. It controls the percentage intensity
of the darkest shade of an object. For a solid object, this is the
intensity of surfaces facing away from the light source or in shadow.
For depth-cued objects this is the intensity of objects furthest from
the viewer.

This parameter is commonly used to correct for monitors with different
"gamma values" (brightness), to change how light or dark a hardcopy
image appears when printed or to alter the feeling of depth for
wireframe or ribbon representations.

.TP
.B Set Axes
The RasMol
.B axes
parameter controls the display of orthogonal coordinate axes on
the current display. The coordinate axes are those used in the
molecule data file, and the origin is the centre of the molecule's
bounding box. The
.B set axes
command is similar to the commands
.B set boundbox
and
.B set unitcell
that display the bounding box and the crystallographic unit cell,
respectively.

.TP
.B Set Backfade
The RasMol
.B backfade
parameter is used to control backfade to the specified background
colour, rather than black.  This is controlled by the commands
.B set backfade on
and
.B set backfade off.
For example, this may be used to generate depth-cued images that
fade to white, rather than black.

.TP
.B Set Background
The RasMol
.B background
parameter is used to set the colour of the "canvas" background. The
colour may be given as either a colour name or a comma separated
triple of Red, Green, Blue (RGB) components enclosed in square
brackets. Typing the command
.B help colours
will give a list of the predefined colour names recognised by RasMol.
When running under X Windows, RasMol also recognises colours in the
X server's colour name database.

The command
.B set background
is synonymous with the RasMol command
.B background.

.TP
.B Set BondMode
The RasMol
.B set bondmode
command controls the mechanism used to select individual bonds
and modifies the display of bonded and non-bonded atoms by subsequent
.B wireframe
commands.

When using the
.B select
and
.B restrict
commands, a given bond will be selected if i) the bondmode is
.B or
and either of the connected atoms is selected, or ii) the bondmode is
.B and
and both atoms connected by the bond are selected. Hence an individual
bond may be uniquely identified by using the command
.B set bondmode and
and then uniquely selecting the atoms at both ends.

The
.B bondmode [all | none | not bonded]
commands add
.B star 75
or
.B spacefill 75
markers for the designated atoms to
.B wireframe
displays.  Stars are used when the specified wireframe radius is zero.

.TP
.B Set Bonds
The RasMol
.B bonds
parameter is used to control display of double and triple bonds as
multiple  lines or cylinders.  Currently bond orders are only read
from  MDL Mol files, Sybyl Mol2 format files, Tripos Alchemy format
files, CIF and mmCIF,  and suitable PDB files.  Double (and triple)  bonds
are specified in some  PDB files by specifying a given bond twice  (and
three times) in CONECT records.  The  command
.B set bonds on
enables the display of bond orders, and  the command
.B set bonds off
disables them.

.TP
.B Set BoundBox
The RasMol
.B boundbox
parameter controls the display of the current molecule's bounding box
on the display. The bounding box is orthogonal to the data file's
original coordinate axes. The
.B set boundbox
command is similar to the commands
.B set axes
and
.B set unitcell
that display orthogonal coordinate axes and the bounding box,
respectively.

.TP
.B Set Cartoon
The RasMol
.B cartoon
parameter is used to control display of the cartoon version of the
.B ribbons
display.  By default, the C-termini of beta-sheets are displayed as
arrow heads. This may be enabled and disabled using the
.B set cartoons <boolean>
command. The depth of the cartoon may be adjusted using the
.B cartoons <number>
command. The
.B set cartoons
command without any parameters returns these two options to
 their default values.

.TP
.B Set CisAngle
The RasMol
.B cisangle
parameter controls the cutoff angle for identifying cis peptide
 bonds.  If no value is given, the cutoff is set to 90 degrees.

.TP
.B Set Display
This command controls the display mode within RasMol. By default,
.B set display normal,
RasMol displays the molecule in the representation specified by the
user. The command
.B set display selected
changes the display mode such that the molecule is temporarily drawn
so as to indicate currently selected portion of the molecule. The
user specified colour scheme and representation remains unchanged.
In this representation all selected atoms are shown in yellow and
all non selected atoms are shown in blue. The colour of the background
is also changed to a dark grey to indicate the change of display mode.
This command is typically only used by external Graphical User
Interfaces (GUIs).

.TP
.B Set FontSize
The RasMol
.B set fontsize
command is used to control the size of the characters that
form atom labels. This value corresponds to the height of
the displayed character in pixels. The maximum value of
.B fontsize
is 48 pixels, and the default value is 8 pixels high.
Fixed or proportional spacing may be selected by appending the
"FS" or "PS" modifiers, respectively.  The default is "FS".
To display atom labels on the screen use the RasMol
.B label
command and to change the colour of displayed labels, use
the
.B colour labels
command.

.TP
.B Set FontStroke
The RasMol
.B set fontstroke
command is used to control the size of the stroke width of the
characters that form atom labels.  This value is the radius in
pixels of cylinders used to form the strokes.  The special value
of "0" is the default used for the normal single pixel stroke width,
which allows for rapid drawing and rotation of the image.
Non-zero values are provided to allow for more artistic atom
labels for publication at the expense of extra time in rendering
the image.

When wider strokes are used, a larger font size is recommend, e.g.
by using the RasMol
.B set fontsize 24 PS
command, followed by
.B set fontstroke 2

To display atom labels on the screen use the RasMol
.B label
command, and to change the colour of displayed labels use
the
.B colour labels
command.

.TP
.B Set HBonds
The RasMol
.B hbonds
parameter determines whether hydrogen bonds are drawn between
the donor and acceptor atoms of the hydrogen bond,
.B set hbonds sidechain
or between the alpha carbon atoms of the protein backbone and between
the phosphorous atoms of the nucleic acid backbone,
.B set hbonds backbone.
The actual display of hydrogen bonds is controlled by the
.B hbonds
command. Drawing hydrogen bonds between protein alpha carbons or
nucleic acid phosphorous atoms is useful when the rest of the molecule
is shown in only a schematic representation such as
.B backbone,
.B ribbons
or
.B strands.
This parameter is similar to the RasMol
.B ssbonds
parameter.

.TP
.B Set Hetero
The RasMol
.B hetero
parameter is used to modify the 'default' behaviour of the RasMol
.B select
command, i.e. the behaviour of
.B select
without any parameters. When this value is
.B false,
the default
.B select
region does not include any heterogeneous atoms (refer to the
predefined set
.B hetero
). When this value is
.B true,
the default
.B select
region may contain hetero atoms. This parameter is similar to
the RasMol
.B hydrogen
parameter which determines whether hydrogen atoms should be
included in the default set. If both
.B hetero
and
.B hydrogen
are
.B true,
.B select
without any parameters is equivalent to
.B select all.

.TP
.B Set HourGlass
The RasMol
.B hourglass
parameter allows the user to enable and disable the use of the 'hour
glass' cursor used by RasMol to indicate that the program is currently
busy drawing the next frame. The command
.B set hourglass on
enables the indicator, whilst
.B set hourglass off
prevents RasMol from changing the cursor. This is useful when spinning
the molecule, running a sequence of commands from a script file or
using interprocess communication to execute complex sequences of
commands. In these cases a 'flashing' cursor may be distracting.

.TP
.B Set Hydrogen
The RasMol
.B hydrogen
parameter is used to modify the "default" behaviour of the RasMol
.B select
command, i.e. the behaviour of
.B select
without any parameters. When this value is
.B false,
the default
.B select
region does not include any hydrogen, deuterium or tritium atoms (refer
to the predefined set
.B hydrogen
). When this value is
.B true,
the default
.B select
region may contain hydrogen atoms. This parameter is similar to
the RasMol
.B hetero
parameter which determines whether heterogeneous atoms should be
included in the default set. If both
.B hydrogen
and
.B hetero
are
.B true,
.B select
without any parameters is equivalent to
.B select all.

.TP
.B Set Kinemage
The RasMol
.B set kinemage
command controls the amount of detail stored in a Kinemage output
file generated by the RasMol
.B write kinemage
command. The output kinemage files are intended to be displayed by
David Richardson's Mage program.
.B set kinemage false,
the default, only stores the currently displayed representation in
the generated output file. The command
.B set kinemage true,
generates a more complex Kinemage that contains both the wireframe
and backbone representations as well as the coordinate axes,
bounding box and crystal unit cell.

.TP
.B Set Menus
The RasMol
.B set menus
command enables the canvas window's menu buttons or menu bar. This
command is typically only used by graphical user interfaces or to
create as large an image as possible when using Microsoft Windows.

.TP
.B Set Monitor
The RasMol
.B set monitor
command enables
.B monitors.
The distance monitor labels may be turned off with the command
.B set monitor off,
and re-enabled with the command
.B set monitor on.


.TP
.B Set Mouse
The RasMol
.B set mouse
command sets the rotation, translation, scaling and zooming mouse
bindings. The default value is
.B rasmol
which is suitable for two button mice (for three button mice the
second and third buttons are synonymous); X-Y rotation is controlled
by the first button, and X-Y translation by the second. Additional
functions are controlled by holding a modifier key on the keyboard.
[Shift] and the first button performs scaling, [shift] and the second
button performs Z-rotation, and [control] and the first mouse button
controls the clipping plane. The
.B insight
and
.B quanta
options provide the same mouse bindings as other packages for experienced
users.

.TP
.B Set Picking
The RasMol
.B set picking
series of commands affects how a user may interact with a
molecule displayed on the screen in RasMol.

.B Enabling/Disabling Atom Identification Picking:
Clicking on an atom with the mouse results in identification and
the display of its residue name, residue number, atom name, atom serial
number and chain in the command window. This behavior may be disabled
with the command
.B set picking none
and restored with the command
.B set picking ident.
The command
.B set picking coord
adds the atomic coordinates of the atom to the display.

Disabling picking, by using
.B set picking off
is useful when executing the
.B pause
command in RasMol scripts as it prevents the display of
spurious message on the command line while the script is suspended.

.B Measuring Distances, Angles and Torsions:
Interactive measurement of distances, angles and torsions
is achieved using the commands:
.B set picking distance,
.B set picking monitor,
.B set picking angle
and
.B set picking torsion,
respectively. In these modes, clicking on an atom results in it
being identified on the rasmol command line. In addition every
atom picked increments a modulo counter such that in distance
mode, every second atom displays the distance (or distance monitor)
between this atom and the previous one. In angle mode, every
third atom displays the angle between the previous three atoms
and in torsion mode every fourth atom displays the torsion between
the last four atoms. By holding down the shift key while picking an
atom, this modulo counter is not incremented and allows, for
example, the distances of consecutive atoms from a fixed atom to
be displayed. See the
.B monitor
command for how to control the display of distance monitor lines and labels.

.B Labelling Atoms with the Mouse:
The mouse may also be used to toggle the display of an atom label
on a given atom. The RasMol command
.B set picking label
removes a label from a picked atom if it already has one or
displays a concise label at that atom position otherwise.

.B Centring Rotation with the Mouse:
A molecule may be centred on a specified atom position using the
RasMol commands
.B set picking centre
or
.B set picking center.
In this mode, picking an atom causes all futher rotations to be
about that point.

.B Picking a Bond as a Rotation Axis:
Any bond may be picked as an axis of rotation for the portion of
the molecule beyond the second atom selected.  This feature should
be used with caution, since, naturally, it changes the conformation
of the molecule.  After executing
.B set picking bond
or using the equivalent "Pick Bond" in the "Settings" menu,
a bond to be rotated is picked with the same sort of mouse clicks
as are used for picking atoms for a distance measurement.  Normally
this should be done where a bond exists, but if no bond exists, it
will be added.  The bond cannot be used for rotation if it is part
of a ring of any size.  All bonds selected for rotation are remembered
so that they can be properly reported when writing a script, but
only the most recently selected bond may be actively rotated.

.B Enabling Atom/Group/Chain Selection Picking:
Atoms, groups and chains may be selected (as if with the
.B select
command), with the
.B set picking atom,
.B set picking group,
.B set picking chain
commands.  For each of these commands, the shift key may be used to
have a new selection added to the old, and the control key may be
used to have a new selection deleted from the old. When the
.B set picking atom
command is given, the mouse can be used to pick or to drag a box around
the atoms for which selection is desired.  When the
.B set picking group
command is given, picking any an atom will cause selection
of all atoms which agree in residue number with the picked atom,
even if in different chains.
When the
.B set picking chain
command is given, picking any atom will cause selection
of all atoms which agree in chain identifier with the picked atom.

.TP
.B Set Play
The RasMol
.B set play.fps
command gives the number of frames per second for playback by the
.B play
command (default 24 frames per second).

In the current release of RasMol, the play timing is not controlled
by this parameter.

.TP
.B Set Radius
The RasMol
.B set radius
command is used to alter the behaviour of the RasMol
.B dots
command depending upon the value of the
.B solvent
parameter.
When
.B solvent
is
.B true,
the
.B radius
parameter controls whether a true van der Waals' surface
is generated by the
.B dots
command. If the value of
.B radius
is anything other than zero, that value is used as the
radius of each atom instead of its true vdW value. When
the value of
.B solvent
is
.B true,
this parameter determines the 'probe sphere' (solvent) radius.
The parameter may be given as an integer in rasmol units or
containing a decimal point in Angstroms. The default value of
this parameter is determined by the value of
.B solvent
and changing
.B solvent
resets
.B radius
to its new default value.

.TP
.B Set Record
The RasMol
.B set record.aps
gives the maximum on-screen velocity in Angstroms per second in animating
translations, rotations and zooms (default 10 A/second).

The RasMol
.B set record.aps
command gives number of frames per second for recording by the
.B record
command (default 24 frames per second).

The RasMol
.B set record.dwell
command sets the time in seconds to dwell on a change in appearance
(default .5 sec).

.TP
.B Set ShadePower
The
.B shadepower
parameter (adopted from RasTop) determines the shade repartition (the contrast)
used in rendering solid objects. This value between 0 and 100 adjusts
shading on an object surface oriented along the direction to the
light source.  Changing the shadepower parameter does not change the
maximum or the minimum values of this shading, as does changing the
.B ambient
parameter.  A value of 100 concentrates the light on the top of spheres,
giving a highly specular, glassy rendering (see the
.B specpower
parameter).
A value of 0 distributes the light on the entire object.

This implementation of shadepower differs from the one in RasTop
only in the choice of range (0 to 100 versus -20 to 20 in RasTop).

.TP
.B Set Shadow
The RasMol
.B set shadow
command enables and disables ray-tracing of the currently rendered image.
Currently only the spacefilling representation is shadowed or can cast
shadows. Enabling shadowing will automatically disable the Z-clipping
(slabbing) plane using the command
.B slab off.
Ray-tracing typically takes about several seconds for a moderately sized protein.
It is recommended that shadowing be normally disabled whilst the
molecule is being transformed or manipulated, and only enabled once
an appropiate viewpoint is selected, to provide a greater impression
of depth.

.TP
.B Set SlabMode
The RasMol
.B slabmode
parameter controls the rendering method of objects cut by the
slabbing (z-clipping) plane. Valid slabmode parameters are
"reject", "half", "hollow", "solid" and "section".

.TP
.B Set Solvent
The RasMol
.B set solvent
command is used to control the behaviour of the RasMol
.B dots
command. Depending upon the value of the
.B solvent
parameter, the
.B dots
command either generates a van der Waals' or a solvent
accessible surface around the currently selected set of
atoms. Changing this parameter automatically resets the
value of the RasMol
.B radius
parameter.
The command
.B set solvent false,
the default value, indicates that a van der Waals' surface
should be generated and resets the value of
.B radius
to zero. The command
.B set solvent true
indicates that a 'Connolly' or 'Richards' solvent
accessible surface should be drawn and sets the
.B radius
parameter, the solvent radius, to 1.2 Angstroms (or 300
RasMol units).

.TP
.B Set Specular
The RasMol
.B set specular
command enables and disables the display of specular highlights on
solid objects drawn by RasMol. Specular highlights appear as white
reflections of the light source on the surface of the object. The
current RasMol implementation uses an approximation function to
generate this highlight.

The specular highlights on the surfaces of solid objects may be
altered by using the specular reflection coefficient, which is
altered using the RasMol
.B set specpower
command.

.TP
.B Set SpecPower
The
.B specpower
parameter determines the shininess of solid objects rendered by
RasMol. This value between 0 and 100 adjusts the reflection
coefficient used in specular highlight calculations. The specular
highlights are enabled and disabled by the RasMol
.B set specular
command. Values around 20 or 30 produce plastic looking surfaces.
High values represent more shiny surfaces such as metals, while
lower values produce more diffuse/dull surfaces.

.TP
.B Set SSBonds
The RasMol
.B ssbonds
parameter determines whether disulphide bridges are drawn between
the sulphur atoms in the sidechain (the default) or between the alpha
carbon atoms in the backbone of the cysteines residues. The actual
display of disulphide bridges is controlled by the
.B ssbonds
command. Drawing disulphide bridges between alpha carbons is useful
when the rest of the protein is shown in only a schematic
representation such as
.B backbone,
.B ribbons
or
.B strands.
This parameter is similar to the RasMol
.B hbonds
parameter.

.TP
.B Set Stereo
The RasMol
.B set stereo
parameter controls the separation between the left and
right images. Turning stereo on and off doesn't reposition
the centre of the molecule.

Stereo viewing of a molecule may be turned on (and off) either
by selecting
.B Stereo
from the
.B Options
menu, or by typing the commands
.B stereo on
or
.B stereo off.

The separation angle between the two views may be adjusted with the
.B set stereo [-] <number>
command, where positive values result in crossed eye viewing and
negative values in relaxed (wall-eyed) viewing. Currently, stereo viewing
is not supported in
.B vector PostScript
output files.

.TP
.B Set Strands
The RasMol
.B strands
parameter controls the number of parallel strands that are displayed
in the ribbon representations of proteins. The permissible values for
this parameter are 1, 2, 3, 4, 5 and 9. The default value is 5. The
number of strands is constant for all ribbons being displayed.
However, the ribbon width (the separation between strands) may be
controlled on a residue by residue basis using the RasMol
.B ribbons
command.

.TP
.B Set Transparent
The RasMol
.B transparent
parameter controls the writing of transparent GIFs by the
.B write gif <filename>
command.  This may be controlled by the
.B set transparent on
and
.B set transparent off
commands.

.TP
.B Set UnitCell
The RasMol
.B unitcell
parameter controls the display of the crystallographic unit cell on
the current display. The crystal cell is only enabled if the appropriate
crystal symmetry information is contained in the PDB, CIF or mmCIF data
file. The
RasMol command
.B show symmetry
display details of the crystal's space group and unit cell axes. The
.B set unitcell
command is similar to the commands
.B set axes
and
.B set boundbox
that display orthogonal coordinate axes and the bounding box,
respectively.

.TP
.B Set VectPS
The RasMol
.B vectps
parameter is use to control the way in which the RasMol
.B write
command generates vector PostScript output files. The command
.B set vectps on
enables the use of black outlines around spheres and cylinder bonds
producing "cartoon-like" high resolution output. However, the current
implementation of RasMol incorrectly cartoons spheres that are intersected
by more than one other sphere. Hence "ball and stick" models are rendered
correctly but not large spacefilling spheres models. Cartoon outlines
can be disabled, the default, by the command
.B set vectps off.

.TP
.B Set Write
The RasMol
.B write
parameter controls the use of the
.B save
and
.B write
commands within scripts, but it may only be executed from the
command line.  By default, this value is
.B false,
prohibiting the generation of files in any scripts executed at
start-up (such as those launched from a WWW browser). However,
animators may start up RasMol interactively: type
.B set write on
and then execute a script to generate each frame using the
source command.

.SH ATOM EXPRESSIONS
RasMol atom expressions uniquely identify an arbitrary group of atoms
within a molecule. Atom expressions are composed of either primitive
expressions,
predefined sets,
comparison operators,
.B within
expressions,
or logical (boolean) combinations of the above expression types.

The logical operators allow complex queries to be constructed out of
simpler ones using the standard boolean connectives
.B and,
.B or
and
.B not.
These may be abbreviated by the symbols
"&", "|" and "!",
respectively. Parentheses (brackets) may be used to alter the
precedence of the operators. For convenience, a comma may also
be used for boolean disjunction.

The atom expression is evaluated for each atom, hence
.B protein and backbone
selects protein backbone atoms, not the protein and [nucleic] acid
backbone atoms!

.TP
.B Primitive Expressions
RasMol primitive expressions are the fundamental building blocks
of atom expressions. There are two types of primitive expression.
The first type is used to identify a given residue number or range
of residue numbers. A single residue is identified by its number
(position in the sequence), and a range is specified by lower and
upper bounds separated by a hyphen character. For example
.B select 5,6,7,8
is also
.B select 5-8.
Note that this selects the given residue numbers in all macromolecule
chains.

The second type of primitive expression specifies a sequence of fields
that must match for a given atom. The first part specifies a residue
(or group of residues) and an optional second part specifies the atoms
within those residues. The first part consists of a residue name,
optionally followed by a residue number and/or chain identifier.

The second part consists of a period character followed by an atom
name.  An atom name may be up to four alphabetic or numeric characters.
An optional semicolon followed by an alternate conformation
identifier may be appended.  An optional slash followed by a
model number may also be appended.

An asterisk may be used as a wild card for a whole field and a
question mark as a single character wildcard.

.TP
.B Comparison Operators
Parts of a molecule may also be distinguished using equality,
inequality and ordering operators on their properties. The format
of such comparison expression is a property name, followed by a
comparison operator and then an integer value.

The atom properties that may be used in RasMol are
.B atomno
for the atom serial number,
.B elemno
for the atom's atomic number (element),
.B resno
for the residue number,
.B radius
for the spacefill radius in RasMol units (or zero if not represented
as a sphere) and
.B temperature
for the PDB isotropic temperature value.

The equality operator is denoted either
"=" or "==".
The inequality operator as either
"<>", "!=" or "/=".
The ordering operators are
"<"
for less than,
"<="
for less than or equal to,
">"
for greater than, and
">"
for greater than or equal to.

.TP
.B Within Expressions
A RasMol
.B within
expression allows atoms to be selected on their proximity to
another set of atoms. A
.B within
expression takes two parameters separated by a comma and surrounded
by parentheses. The first argument is an integer value called the
"cut-off" distance of the within expression and the second argument
is any  valid atom expression. The cut-off distance is expressed in
either integer RasMol units or Angstroms containing a decimal point.
An atom is selected if it is within the cut-off distance of any of
the atoms defined by the second argument. This allows complex
expressions to be constructed containing nested
.B within
expressions.

For example, the command
.B select within(3.2,backbone)
selects any atom within a 3.2 Angstrom radius of any atom in a
protein or nucleic acid backbone.
.B Within
expressions are particularly useful for selecting the atoms
around an active site.

.TP
.B Predefined Sets
RasMol atom expressions may contain predefined sets. These sets
are single keywords that represent portions of a molecule of interest.
Predefined sets are often abbreviations of primitive atom expressions.
In some cases the use of predefined sets allows selection of areas of
a molecule that could not otherwise be distinguished.
A list of the currently predefined sets
is given below.
In addition to the sets listed here, RasMol also treats element names
(and their plurals) as predefined sets containing all atoms of that
element type, i.e. the command
.B select oxygen
is equivalent to the command
.B select elemno=8.

.SH Predefined Sets
.TP
.B AT Set
This set contains the atoms in the complementary nucleotides
adenosine and thymidine (A and T, respectively). All nucleotides
are classified as either the set
.B at
or the set
.B cg
This set is equivalent to the RasMol atom expressions
.B a,t,
and
.B nucleic and not cg.

.TP
.B Acidic Set
The set of acidic amino acids.
These are the residue types Asp and Glu.
All amino acids are classified as either
.B acidic,
.B basic
.B or
.B neutral.
This set is equivalent to the RasMol atom expressions
.B asp, glu
and
.B amino and not (basic or neutral).

.TP
.B Acyclic Set
The set of atoms in amino acids not containing a cycle or
ring. All amino acids are classified as either
.B cyclic
or
.B acyclic.
This set is equivalent to the RasMol atom expression
.B amino and not cyclic.

.TP
.B Aliphatic Set
This set contains the aliphatic amino acids.
These are the amino acids Ala, Gly, Ile, Leu and Val.
This set is equivalent to the RasMol atom expression
.B ala, gly, ile, leu, val.

.TP
.B Alpha Set
The set of alpha carbons in the protein molecule. This set is
approximately equivalent to the RasMol atom expression
.B *.CA.
This command should not be confused with the predefined set
.B helix
which contains the atoms in the amino acids of the protein's
alpha helices.

.TP
.B Amino Set
This set contains all the atoms contained in amino acid residues.
This is useful for distinguishing the protein from the nucleic
acid and heterogeneous atoms in the current molecule database.

.TP
.B Aromatic Set
The set of atoms in amino acids containing aromatic rings.
These are the amino acids His, Phe, Trp and Tyr.
Because they contain aromatic rings all members of this
set are member of the predefined set
.B cyclic.
This set is equivalent to the RasMol atom expressions
.B his, phe, trp, tyr
and
.B cyclic and not pro.

.TP
.B Backbone Set
This set contains the four atoms of each amino acid that form the
polypeptide N-C-C-O backbone of proteins, and the atoms of the sugar
phosphate backbone of nucleic acids.
Use the RasMol predefined sets
.B protein
and
.B nucleic
to distinguish between the two forms of backbone.
Atoms in nucleic acids and proteins are either
.B backbone
or
.B sidechain.
This set is equivalent to the RasMol expression
.B (protein or nucleic) and not sidechain.

The predefined set
.B mainchain
is synonymous with the set
.B backbone.

.TP
.B Basic Set
The set of basic amino acids.
These are the residue types Arg, His and Lys.
All amino acids are classified as either
.B acidic,
.B basic
or
.B neutral.
This set is equivalent to the RasMol atom expressions
.B arg, his, lys
and
.B amino and not (acidic or neutral).

.TP
.B Bonded Set
This set contain all the atoms in the current molecule database that
are bonded to at least one other atom.

.TP
.B Buried Set
This set contains the atoms in those amino acids that tend
(prefer) to be buried inside protein, away from contact with
solvent molecules. This set refers to the amino acids
preference and not the actual solvent accessibility for
the current protein.
All amino acids are classified as either
.B surface
or
.B buried.
This set is equivalent to the RasMol atom expression
.B amino and not surface.

.TP
.B CG Set
This set contains the atoms in the complementary nucleotides
cytidine and guanosine (C and G, respectively). All nucleotides
are classified as either the set
.B at
or the set
.B cg
This set is equivalent to the RasMol atom expressions
.B c,g
and
.B nucleic and not at.

.TP
.B Charged Set
This set contains the charged amino acids. These are the amino
acids that are either
.B acidic
or
.B basic.
Amino acids are classified as being either
.B charged
or
.B neutral.
This set is equivalent to the RasMol atom expressions
.B acidic or basic
and
.B amino and not neutral.

.TP
.B Cyclic Set
The set of atoms in amino acids containing a cycle or rings.
All amino acids are classified as either
.B cyclic
or
.B acyclic.
This set consists of the amino acids His, Phe, Pro, Trp and Tyr.
The members of the predefined set
.B aromatic
are members of this set.
The only cyclic but non-aromatic amino acid is proline.
This set is equivalent to the RasMol atom expressions
.B his, phe, pro, trp, tyr
and
.B aromatic or pro
and
.B amino and not acyclic.

.TP
.B Cystine Set
This set contains the atoms of cysteine residues that form part
of a disulphide bridge, i.e. half cystines. RasMol automatically
determines disulphide bridges, if neither the predefined set
.B cystine
nor the RasMol
.B ssbonds
command have been used since the molecule was loaded. The set of
free cysteines may be determined using the RasMol atom expression
.B cys and not cystine.

.TP
.B Helix Set
This set contains all atoms that form part of a protein alpha
helix as determined by either the PDB file author or Kabsch and
Sander's DSSP algorithm. By default, RasMol uses the secondary
structure determination given in the PDB file if it exists.
Otherwise, it uses the DSSP algorithm as used by the RasMol
.B structure
command.

This predefined set should not be confused with the predefined set
.B alpha
which contains the alpha carbon atoms of a protein.

.TP
.B Hetero Set
This set contains all the heterogeneous atoms in the molecule. These
are the atoms described by HETATM entries in the PDB file. These
typically contain water, cofactors and other solvents and ligands. All
.B hetero
atoms are classified as either
.B ligand
or
.B solvent
atoms. These heterogeneous
.B solvent
atoms are further classified as either
.B water
or
.B ions.

.TP
.B Hydrogen Set
This predefined set contains all the hydrogen, deuterium and tritium atoms
of the current molecule. This predefined set is equivalent to the
RasMol atom expression
.B elemno=1.

.TP
.B Hydrophobic Set
This set contains all the hydrophobic amino acids.
These are the amino acids Ala, Leu, Val, Ile, Pro, Phe, Met and Trp.
All amino acids are classified as either
.B hydrophobic
or
.B polar.
This set is equivalent to the RasMol atom expressions
.B ala, leu, val, ile, pro, phe, met, trp
and
.B amino and not polar.

.TP
.B Ions Set
This set contains all the heterogeneous phosphate and sulphate ions in
the current molecule data file. A large number of these ions are
sometimes associated with protein and nucleic acid structures determined
by X-ray crystallography. These atoms tend to clutter an image. All
.B hetero
atoms are classified as either
.B ligand
or
.B solvent
atoms. All
.B solvent
atoms are classified as either
.B water
or
.B ions.

.TP
.B Large Set
All amino acids are classified as either
.B small,
.B medium
or
.B large.
This set is equivalent to the RasMol atom expression
.B amino and not (small or medium).

.TP
.B Ligand Set
This set contains all the heterogeneous cofactor and ligand moieties that
are contained in the current molecule data file.  This set is defined
to be all
.B hetero
atoms that are not
.B solvent
atoms. Hence this set is equivalent to the RasMol atom expression
.B hetero and not solvent.

.TP
.B Medium Set
All amino acids are classified as either
.B small,
.B medium
or
.B large.
This set is equivalent to the RasMol atom expression
.B amino and not (large or small).

.TP
.B Neutral Set
The set of neutral amino acids.
All amino acids are classified as either
.B acidic,
.B basic
or
.B neutral.
This set is equivalent to the RasMol atom expression
.B amino and not (acidic or basic).

.TP
.B Nucleic Set
The set of all atoms in nucleic acids, which consists of the four
nucleotide bases adenosine, cytidine, guanosine and thymidine (A,
C, G and T, respectively). All neucleotides are classified as either
.B purine
or
.B pyrimidine.
This set is equivalent to the RasMol atom expressions
.B a,c,g,t
and
.B purine or pyrimidine.
The symbols for RNA nucleotides (U, +U, I, 1MA, 5MC, OMC,
1MG, 2MG, M2G, 7MG, OMG, YG, H2U, 5MU, and PSU) are also
recognized as members of this set.

.TP
.B Polar Set
This set contains the polar amino acids.
All amino acids are classified as either
.B hydrophobic
or
.B polar.
This set is equivalent to the RasMol atom expression
.B amino and not hydrophobic.

.TP
.B Protein Set
The set of all atoms in proteins. This consists of the RasMol
predefined set
.B amino
and common post-translation modifications.

.TP
.B Purine Set
The set of purine nucleotides.
These are the bases adenosine and guanosine (A and G, respectively).
All nucleotides are either
.B purines
or
.B pyrimidines.
This set is equivalent to the RasMol atom expressions
.B a,g
and
.B nucleic and not pyrimidine.

.TP
.B Pyrimidine Set
The set of pyrimidine nucleotides.
These are the bases cytidine and thymidine (C and T, respectively).
All nucleotides are either
.B purines
or
.B pyrimidines.
This set is equivalent to the RasMol atom expressions
.B c,t
and
.B nucleic and not purine.

.TP
.B Selected Set
This set contains the set of atoms in the currently selected
region. The currently selected region is defined by the preceding
.B select
or
.B restrict
command and not the atom expression containing the
.B selected
keyword.

.TP
.B Sheet Set
This set contains all atoms that form part of a protein beta
sheet as determined by either the PDB file author or Kabsch and
Sander's DSSP algorithm. By default, RasMol uses the secondary
structure determination given in the PDB file if it exists.
Otherwise, it uses the DSSP algorithm as used by the RasMol
.B structure
command.

.TP
.B Sidechain Set
This set contains the functional sidechains of any amino acids
and the base of each nucleotide. These are the atoms not part of
the polypeptide N-C-C-O backbone of proteins or the sugar
phosphate backbone of nucleic acids.
Use the RasMol predefined sets
.B protein
and
.B nucleic
to distinguish between the two forms of sidechain.
Atoms in nucleic acids and proteins are either
.B backbone
or
.B sidechain.
This set is equivalent to the RasMol expression
.B (protein or nucleic) and not backbone.

.TP
.B Small Set
All amino acids are classified as either
.B small,
.B medium
or
.B large.
This set is equivalent to the RasMol atom expression
.B amino and not (medium or large).

.TP
.B Solvent Set
This set contains the solvent atoms in the molecule coordinate file.
These are the heterogeneous water molecules, phosphate and sulphate
ions. All
.B hetero
atoms are classified as either
.B ligand
or
.B solvent
atoms. All
.B solvent
atoms are classified as either
.B water
or
.B ions.
This set is equivalent to the RasMol atom expressions
.B hetero and not ligand
and
.B water or ions.

.TP
.B Surface Set
This set contains the atoms in those amino acids that tend
(prefer) to be on the surface of proteins, in contact with
solvent molecules. This set refers to the amino acids
preference and not the actual solvent accessibility for
the current protein.
All amino acids are classified as either
.B surface
or
.B buried.
This set is equivalent to the RasMol atom expression
.B amino and not buried.

.TP
.B Turn Set
This set contains all atoms that form part of a protein turns
as determined by either the PDB file author or Kabsch and
Sander's DSSP algorithm. By default, RasMol uses the secondary
structure determination given in the PDB file if it exists.
Otherwise, it uses the DSSP algorithm as used by the RasMol
.B structure
command.

.TP
.B Water Set
This set contains all the heterogeneous water molecules in the current
database. A large number of water molecules are sometimes associated
with protein and nucleic acid structures determined by X-ray
crystallography. These atoms tend to clutter an image.
All
.B hetero
atoms are classified as either
.B ligand
or
.B solvent
atoms. The
.B solvent
atoms are further classified as either
.B water
or
.B ions.

.TP
.B Set Summary
The table below summarises RasMol's classification of the common amino acids.

.SH COLOUR SCHEMES
The RasMol
.B colour
command allows different objects (such as atoms, bonds and ribbon segments)
to be given a specified colour. Typically this colour is either a RasMol
predefined colour name or an RGB triple. Additionally RasMol also supports
.B alt,
.B amino,
.B chain,
.B charge,
.B cpk,
.B group,
.B model,
.B shapely,
.B structure,
.B temperature
or
.B user
colour schemes for atoms, and
.B hbond type
colour scheme for hydrogen bonds and
.B electrostatic potential
colour scheme for dot surfaces.
The 24 currently predefined colour
names are
Black, Blue, BlueTint, Brown, Cyan, Gold, Grey, Green,
GreenBlue, GreenTint, HotPink, Magenta, Orange, Pink,
PinkTint, Purple, Red, RedOrange, SeaGreen, SkyBlue,
Violet, White, Yellow and YellowTint

If you frequently wish to use a colour not predefined, you can write
a one-line script. For example, if you make the file
.B grey.col
containing the line,
.B colour [180,180,180] #grey,
then the command
.B script grey.col
colours the currently selected atom set grey.

.TP
.B Alt Colours
The RasMol
.B alt
(Alternate Conformer)
colour scheme codes the base
structure with one colour and applies a limited number of colours to each
alternate conformer.  In a RasMol built for 8-bit colour systems, 4 colours
are allowed for alternate conformers. Otherwise, 8 colours are available.

.TP
.B Amino Colours
The RasMol
.B amino
colour scheme colours amino acids according to traditional amino acid
properties. The purpose of colouring is to identify amino acids in an
unusual or surprising environment. The outer parts of a protein that are
polar are visible (bright) colours and non-polar residues darker. Most
colours are hallowed by tradition. This colour scheme is similar to the
.B shapely
scheme.

.TP
.B Chain Colours
The RasMol
.B chain
colour scheme assigns each macromolecular chain a unique colour. This
colour scheme is particularly useful for distinguishing the parts of
multimeric structure or the individual 'strands' of a DNA chain.
.B Chain
can be selected from the RasMol
.B Colours
menu.

.TP
.B Charge Colours
The RasMol
.B charge
colour scheme colour codes each atom according to the charge value
stored in the input file (or beta factor field of PDB files). High
values are coloured in blue (positive) and lower values coloured in
red (negative). Rather than use a fixed scale this scheme determines
the maximum and minimum values of the charge/temperature field and
interpolates from red to blue appropriately. Hence, green cannot be
assumed to be 'no net charge' charge.

The difference between the
.B charge
and
.B temperature
colour schemes is that increasing temperature values proceed from blue
to red, whereas increasing charge values go from red to blue.

If the charge/temperature field stores reasonable values it is possible
to use the RasMol
.B colour dots potential
command to colour code a dot surface (generated by the
.B dots
command) by electrostatic potential.

.TP
.B CPK Colours
The RasMol
.B cpk
colour scheme is based upon the colours of the popular plastic
spacefilling models which were developed by Corey, Pauling and later
improved by Kultun. This colour scheme colours 'atom' objects by the
atom (element) type. This is the scheme conventionally used by chemists.
The assignment of the most commonly used element types to colours is
given below.

.TP
.B Group Colours
The RasMol
.B group
colour scheme colour codes residues by their position in a macromolecular
chain. Each chain is drawn as a smooth spectrum from blue through green,
yellow and orange to red. Hence the N terminus of proteins and 5' terminus
of nucleic acids are coloured red and the C terminus of proteins and 3'
terminus of nucleic acids are drawn in blue. If a chain has a large number
of heterogeneous molecules associated with it, the macromolecule may not be
drawn in the full 'range' of the spectrum.
.B Group
can be selected from the RasMol
.B Colours
menu.

If a chain has a large number of heterogeneous molecules associated with it,
the macromolecule may not be drawn in the full range of the spectrum. When
RasMol performs group colouring it decides the range of colours it uses from
the residue numbering given in the PDB file. Hence the lowest residue
number is displayed in blue and the highest residue number is displayed as
red. Unfortunately, if a PDB file contains a large number of heteroatoms,
such as water molecules, that occupy the high residue numbers, the protein
is displayed in the blue-green end of the spectrum and the waters in the
yellow-red end of the spectrum. This is aggravated by there typically being
many more water molecules than amino acid residues. The solution to this
problem is to use the command
.B set hetero off
before applying the group
colour scheme. This can also be achieved by toggling
.B Hetero Atoms
on the
.B Options
menu before selecting
.B Group
on the
.B Colour
menu. This command
instructs RasMol to only use non-hetero residues in the group colour scaling.

.TP
.B NMR Model Colours
The RasMol
.B model
colour scheme codes each NMR model with a distinct
colour.  The NMR model number is taken as a numeric value.  High values
are coloured in blue and lower values coloured in red. Rather than use a
fixed scale this scheme determines the maximum value of the
NMR model number and interpolates from red to blue appropriately.

.TP
.B Shapely Colours
The RasMol
.B shapely
colour scheme colour codes residues by amino acid property. This scheme
is based upon Bob Fletterick's "Shapely Models". Each amino acid and
nucleic acid residue is given a unique colour. The
.B shapely
colour scheme is used by David Bacon's Raster3D program. This colour
scheme is similar to the
.B amino
colour scheme.

.TP
.B Structure Colours
The RasMol
.B structure
colour scheme colours the molecule by protein secondary structure.
Alpha helices are coloured magenta, [240,0,128], beta sheets are
coloured yellow, [255,255,0], turns are coloured pale blue, [96,128,255]
and all other residues are coloured white. The secondary structure
is either read from the PDB file (HELIX, SHEET and TURN records), if available,
or determined using Kabsch and Sander's DSSP algorithm. The RasMol
.B structure
command may be used to force DSSP's structure assignment to be used.

.TP
.B Temperature Colours
The RasMol
.B temperature
colour scheme colour codes each atom according to the anisotropic
temperature (beta) value stored in the PDB file. Typically this gives
a measure of the mobility/uncertainty of a given atom's position. High
values are coloured in warmer (red) colours and lower values in colder
(blue) colours. This feature is often used to associate a "scale" value
[such as amino acid variability in viral mutants] with each atom in a
PDB file, and colour the molecule appropriately.

The difference between the
.B temperature
and
.B charge
colour schemes is that increasing temperature values proceed from blue
to red, whereas increasing charge values go from red to blue.

.TP
.B User Colours
The RasMol
.B user
colour scheme allows RasMol to use the colour scheme stored in the
PDB file. The colours for each atom are stored in COLO records placed
in the PDB data file. This convention was introduced by David Bacon's
Raster3D program.

.TP
.B HBond Type Colours
The RasMol
.B type
colour scheme applies only to hydrogen bonds, hence is used in the command
.B colour hbonds type.
This scheme colour codes each hydrogen bond according to the
distance along a protein chain between hydrogen bond donor and acceptor.
This schematic representation was introduced by Belhadj-Mostefa and
Milner-White. This representation gives a good insight into protein
secondary structure (hbonds forming alpha helices appear red, those
forming sheets appear yellow and those forming turns appear magenta).

.TP
.B Potential Colours
The RasMol
.B potential
colour scheme applies only to dot surfaces, hence is used in the command
.B colour dots potential.
This scheme colours each currently displayed dot by the electrostatic
potential at that point in space. This potential is calculated using
Coulomb's law taking the temperature/charge field of the input file to
be the charge assocated with that atom. This is the same interpretation
used by the
.B colour charge
command. Like the
.B charge
colour scheme low values are blue/white and high values are red.

.TP
.B Amino Acid Codes
The following table lists the names, single letter and three letter
codes of each of the amino acids.

.TP
.B Booleans
A boolean parameter is a truth value. Valid boolean values are 'true' and
'false', and their synonyms 'on' and 'off'. Boolean parameters are commonly
used by RasMol to either enable or disable a representation or option.

.SH FILE FORMATS

.B Protein Data Bank Files

If you do not have the PDB documentation, you may find the
following summary of the PDB file format useful. The Protein Data Bank
is a computer-based archival database for macromolecular structures.
The database was established in 1971 by Brookhaven National
Laboratory, Upton, New York, as a public domain repository for resolved
crystallographic structures. The Bank uses a uniform format to store
atomic coordinates and partial bond connectivities as derived from
crystallographic studies.  In 1999 the Protein Data Bank moved
to the Research Collaboratory for Structural Biology.

PDB file entries consist of records of 80 characters each. Using the
punched card analogy, columns 1 to 6 contain a record-type identifier,
the columns 7 to 70 contain data. In older entries, columns 71 to 80
are normally blank,
but may contain sequence information added by library management
programs.  In new entries conforming to the 1996 PDB format, there
is other information in those columns. The first four characters of
the record identifier are
sufficient to identify the type of record uniquely, and the syntax of
each record is independent of the order of records within any entry for
a particular macromolecule.

The only record types that are of major interest to the RasMol program
are the ATOM and HETATM records which describe the position of each
atom. ATOM/HETATM records contain standard atom names and residue
abbreviations, along with sequence identifiers, coordinates in
Angstrom units, occupancies and thermal motion factors. The exact
details are given below as a FORTRAN format statement.  The "fmt"
column indicates use of the field in all PDB formats,
in the 1992 and earlier formats or in the 1996 and later formats.

Residues occur in order starting from the N-terminal residue
for proteins and
5'-terminus for nucleic acids. If the residue sequence is known,
certain atom serial numbers may be omitted to allow for future insertion
of any missing atoms. Within each residue, atoms are ordered in a
standard manner, starting with the backbone (N-C-C-O for proteins) and
proceeding in increasing remoteness from the alpha carbon, along the
side chain.

HETATM records are used to define post-translational modifications and
cofactors associated with the main molecule. TER records are
interpreted as breaks in the main molecule's backbone.

If present, RasMol also inspects HEADER, COMPND, HELIX, SHEET, TURN,
CONECT, CRYST1, SCALE, MODEL, ENDMDL, EXPDTA and END records. Information such as the
name, database code, revision date and classification of the molecule
are extracted from HEADER and COMPND records, initial secondary
structure assignments are taken from HELIX, SHEET and TURN records, and
the end of the file may be indicated by an END record.

.TP
.B RasMol Interpretation of PDB fields
Atoms located at 9999.000, 9999.000, 9999.000 are assumed to be Insight
pseudo atoms and are ignored by RasMol. Atom names beginning ' Q' are
also assumed to be pseudo atoms or position markers.

When a data file contains an NMR structure, multiple conformations may
be placed in a single PDB file delimited by pairs of MODEL and ENDMDL
records. RasMol displays all the NMR models contained in the file.

Residue names "CSH", "CYH" and "CSM" are considered pseudonyms for
cysteine "CYS". Residue names "WAT", "H20", "SOL" and "TIP" are
considered pseudonyms for water "HOH". The residue name "D20" is
consider heavy water "DOD". The residue name "SUL" is considered a
sulphate ion "SO4". The residue name "CPR" is considered to be
cis-proline and is translated as "PRO". The residue name "TRY" is
considered a pseudonym for tryptophan "TRP".

RasMol uses the HETATM fields to define the sets hetero, water, solvent
and ligand. Any group with the name "HOH", "DOD", "SO4" or "PO4" (or
aliased to one of these names by the preceding rules) is considered a
solvent and is considered to be defined by a HETATM field.

RasMol only respects CONECT connectivity records in PDB files containing
fewer than 256 atoms. This is explained in more detail in the section on
determining molecule connectivity. CONECT records that define a bond
more than once are interpreted as specifying the bond order of that
bond, i.e. a bond specified twice is a double bond and a bond specified
three (or more) times is a triple bond.  This is not a standard PDB feature.

.TP
.B PDB Colour Scheme Specification
RasMol also accepts the supplementary COLO record type in the PDB
files. This record format was introduced by David Bacon's Raster3D
program for specifying the colour scheme to be used when rendering the
molecule. This extension is not currently supported by the PDB. The
COLO record has the same basic record type as the ATOM and HETATM
records described above.

Colours are assigned to atoms using a matching process. The Mask field
is used in the matching process as follows. First RasMol reads in and
remembers all the ATOM, HETATM and COLO records in input order. When the
user-defined ('User') colour scheme is selected, RasMol goes through
each remembered ATOM/HETATM record in turn, and searches for a COLO
record that matches in all of columns 7 through 30. The first such COLO
record to be found determines the colour and radius of the atom.

Note that the Red, Green and Blue components are in the same positions
as the X, Y, and Z components of an ATOM or HETA record, and the van
der Waals radius goes in the place of the Occupancy. The Red, Green and
Blue components must all be in the range 0 to 1.

In order that one COLO record can provide colour and radius
specifications for more than one atom (e.g. based on residue, atom
type, or any other criterion for which labels can be given somewhere in
columns 7 through 30), a 'don't-care' character, the hash mark "#"
(number or sharp sign) is used. This character, when found in a COLO
record, matches any character in the corresponding column in a
ATOM/HETATM record. All other characters must match identically to count
as a match. As an extension to the specification, any atom that fails
to match a COLO record is displayed in white.

.TP
.B Multiple NMR Models
RasMol loads all of the NMR models from a PDB file no matter which
command is used:
.B load pdb <filename>
or
.B load nmrpdb <filename>

Once multiple NMR conformations have been loaded they may be
manipulated with the atom expression extensions described in
.B Primitive Expressions.
In particular, the command
.B restrict */1
will restrict the display to the first model only.

.TP
.B CIF and mmCIF Format Files
CIF is the IUCr standard for presentation of small molecules and mmCIF
is intended as the replacement for the fixed-field PDB format for
presentation of macromolecular structures. RasMol can accept data sets
in either format.

There are many useful sites on the World Wide Web where information
tools and software related to CIF, mmCIF and the PDB can be found. The
following are good starting points for exploration:

The International Union of Crystallography (IUCr) provides access to
software, dictionaries, policy statements and documentation relating to
CIF and mmCIF at: IUCr, Chester, England (www.iucr.org/iucr-top/cif/)
with many mirror sites.

The Nucleic Acid Database Project provides access to its entries,
software and documentation, with an mmCIF page giving access to the
dictionary and mmCIF software tools at Rutgers University, New Jersey,
USA (http://ndbserver.rutgers.edu/NDB/mmcif) with many mirror sites.

This version of RasMol restricts CIF or mmCIF tag values to essentially
the same conventions as are used for the fixed-field PDB format. Thus
chain identifiers and alternate conformation identifiers are limited to
a single character, atom names are limited to 4 characters, etc. RasMol
interprets the following CIF and mmCIF tags:
A search is made through multiple data blocks for the desired tags, so
a single dataset may be composed from multiple data blocks, but
multiple data sets may not be stacked in the same file.

.SH MACHINE-SPECIFIC SUPPORT

In the following sections, support for
.B Monochrome X-Windows,
.B Tcl/Tk IPC,
.B UNIX sockets based IPC,
.B Compiling RasWin with Borland and MetroWerks
are described.

.TP
.B Monochrome X-Windows Support
RasMol supports the many
monochrome UNIX workstations typically found in academia, such as low-end
SUN workstations and NCD X-terminals. The X11 version of RasMol (when
compiled in 8 bit mode) now detects black and white X-Windows displays and
enables dithering automatically. The use of run-time error diffusion dithering
means that all display modes of RasMol are available when in monochrome
mode. For best results, users should experiment with the set ambient
command to ensure the maximum contrast in resulting images.

.TP
.B Tcl/Tk IPC support
Version 4 of Tk
graphics library changed the protocol used to communicate between Tk
applications. RasMol version 2.6 was modified such that it could
communicate with both this new protocol and the previous version 3 protocol
supported by RasMol v2.5. Although Tcl/Tk 3.x applications may only
communicate with other 3.x applications and Tcl/Tk 4.x applications with other
4.x applications, these changes allow RasMol to communicate between
processes with both protocols (potentially concurrently).

.TP
.B UNIX sockets based IPC
The UNIX implementation of RasMol
supports BSD-style socket communication. An identical socket mechanism is
also being developed for VMS, Apple Macintosh and Microsoft Windows
systems. This should allow RasMol to interactively display results of a
computation on a remote host. The current protocol acts as a TCP/IP server on
port 21069 that executes command lines until either the command
.B exit
or the
command
.B quit
is typed. The command
exit
from the RasMol server, the command
.B quit
both disconnects the current
session and terminates RasMol. This functionality may be tested using the
UNIX command
.B telnet <hostname> 21069.

.TP
.B Compiling RasWin with Borland and MetroWerks
A number of changes were made to the
source code in the transition from version 2.5 to 2.6 to allow
the Microsoft Windows version of RasMol to compile
using the Borland C/C++ compiler. These fixes include name changes for the
standard library and special code to avoid a bug in _fmemset.
Additional changes were made in the transition from 2.6 to 2.7 to
allow compilation with the MetroWerks compilers.

.SH BIBLIOGRAPHY

.B Molecular Graphics

[1] Nelson Max, "Computer Representation of Molecular Surfaces", IEEE
Computer Graphics and Applications, pp.21-29, August 1983.

[2] Arthur M. Lesk, "Protein Architecture: A Practical Approach", IRL
Press Publishers, 1991.

.B Molecular Graphics Programs

[3] Per J. Kraulis, "MOLSCRIPT: A Program to Produce both Detailed and
Schematic Plots of Protein Structures", Journal of Applied
Crystallography, Vol.24, pp.946-950, 1991.

[4] David Bacon and Wayne F. Anderson, "A Fast Algorithm for Rendering
Space-Filling Molecule Pictures", Journal of Molecular Graphics, Vol.6,
No.4, pp.219-220, December 1988.

[5] David C. Richardson and Jane S. Richardson, "The Kinemage: A tool
for Scientific Communication", Protein Science, Vol.1, No.1,pp.3-9,
January 1992.

[6] Mike Carson, "RIBBONS 2.0", Journal of Applied Crystallography,
Vol.24, pp.958-961, 1991.

[7] Conrad C. Huang, Eric F. Pettersen, Teri E. Klein, Thomas E.
Ferrin and Robert Langridge, "Conic: A Fast Renderer for
Space-Filling Molecules with Shadows", Journal of Molecular Graphics,
Vol.9, No.4, pp.230-236, December 1991.

.B Molecular Biology Algorithms

[8] Wolfgang Kabsch and Christian Sander, "Dictionary of Protein
Secondary Structure: Pattern Recognition of Hydrogen-Bonded and
Geometrical Features", Biopolymers, Vol.22, pp.2577-2637, 1983.

[9] Michael L. Connolly, "Solvent-Accessible Surfaces of Proteins and Nucleic
Acids", Science, Vol.221, No.4612, pp.709-713, August 1983.

[10] Khaled Belhadj-Mostefa, Ron Poet and E. James Milner-White,
"Displaying Inter-Main Chain Hydrogen Bond Patterns in Proteins",
Journal of Molecular Graphics, Vol.9, No.3, pp.194-197, September 1991.

[11] Mike Carson, "Ribbon Models of Macromolecules", Journal of
Molecular Graphics, Vol.5, No.2, pp.103-106, June 1987.

[12] Mike Carson and Charles E. Bugg, "Algorithm for Ribbon Models of
Proteins", Journal of Molecular Graphics, Vol.4, No.2, pp.121-122, June
1986.

[13] H. Iijima, J. B. Dunbar Jr. and G. Marshall, "Calibration of
Effective van der Waals Atomic Contact Radii for Proteins and
Peptides", Proteins: Structure, Functions and Genetics, Vol.2,
pp.330-339,1987.

.B Graphics Algorithms

[14] J. Foley, A. van Dam, S. Feiner and J. Hughes, "Computer Graphics:
Principles and Practice", 2nd Edition, Addison Wesley Publishers, 1990.

[15] J. Cleary and G. Wyvill, "Analysis of an Algorithm for Fast Ray
Tracing using Uniform Space Subdivision", The Visual Computer, Vol.4,
pp.65-83, 1988.

[16] Thomas Porter,"Spherical Shading", Computer Graphics Vol.12, ACM
SIGGRAPH, pp.282-285, 1978.

[17] Jean-Michel Cense, "Exact Visibility Calculation for Space-Filling
Molecular Models", Journal of Molecular Graphics, Vol.9, No.3,
pp.191-193, September 1991.

[18] Chris Schafmeister, "Fast Algorithm for Generating CPK Images on
Graphics Workstations", Journal of Molecular Graphics, Vol.8, No.4,
pp.201-206, December 1990.

[19] Bruce A. Johnson, "MSURF: A Rapid and General Program for the
Representation of Molecular Surfaces", Journal of Molecular Graphics,
Vol.5, No.3, pp.167-169, September 1987.

.B File Formats

[20] Frances C. Bernstein et al., "The Protein Data Bank: A
Computer-Based Archival File for Macromolecular Structures", Journal of
Molecular Biology, Vol.112, pp.535-542, 1977.

[21] Arthur Dalby, James G. Nourse, W. Douglas Hounshell, Ann K. I.
Gushurst, David L. Grier, Burton A. Leland and John Laufer, "Description
of Several Chemical File Formats Used by Computer Programs Developed at
Molecular Design Limited", Journal of Chemical Information and Computer
Sciences, Vol.32, No.3, pp.244-255, 1992.

[22] Adobe Systems Inc., "PostScript Language Reference Manual",
Addison-Wesley Publishers, Reading, Mass., 1985.

[23] Philip E. Bourne et al., "The Macromolecular Crystallographic
Information File (mmCIF)", Meth. Enzymol. (1997) 277, 571-590.

[24] Sydney R. Hall, "The STAR File: a New Format for Electronic Data
Transfer and Archiving", Journal of Chemical Information and Computer
Sciences, Vol. 31, 326-333, 1991.

.SH SEE ALSO
The RasMol User Manual!

.SH AUTHOR
1992-1998 by Roger Sayle (rasmol@ggr.co.uk)
