// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from User.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.usermgmt {
  public class User_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("usermgmt.User:1.0.1", null);

    public User_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public User_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new User_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new User_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_PASSWORD_UNCHANGED = 1;

    public const int ERR_PASSWORD_EMPTY = 2;

    public const int ERR_PASSWORD_TOO_SHORT = 3;

    public const int ERR_PASSWORD_TOO_LONG = 4;

    public const int ERR_PASSWORD_CTRL_CHARS = 5;

    public const int ERR_PASSWORD_NEED_LOWER = 6;

    public const int ERR_PASSWORD_NEED_UPPER = 7;

    public const int ERR_PASSWORD_NEED_NUMERIC = 8;

    public const int ERR_PASSWORD_NEED_SPECIAL = 9;

    public const int ERR_PASSWORD_IN_HISTORY = 10;

    public const int ERR_PASSWORD_TOO_SHORT_FOR_SNMP = 11;

    public const int ERR_INVALID_ARGUMENT = 12;

    public class GetInfoResult {
      public Com.Raritan.Idl.usermgmt.UserInfo _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.usermgmt.UserInfo.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.usermgmt.UserInfo.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetAccountPasswordResult {
      public int _ret_;
    }

    public SetAccountPasswordResult setAccountPassword(string password) {
      var _parameters = new LightJson.JsonObject();
      _parameters["password"] = password;

      var _result = RpcCall("setAccountPassword", _parameters);
      var _ret = new SetAccountPasswordResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setAccountPassword(string password, AsyncRpcResponse<SetAccountPasswordResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setAccountPassword(password, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setAccountPassword(string password, AsyncRpcResponse<SetAccountPasswordResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["password"] = password;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setAccountPassword", _parameters,
        _result => {
          try {
            var _ret = new SetAccountPasswordResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class UpdateAccountFullResult {
      public int _ret_;
    }

    public UpdateAccountFullResult updateAccountFull(string password, Com.Raritan.Idl.usermgmt.UserInfo info) {
      var _parameters = new LightJson.JsonObject();
      _parameters["password"] = password;
      _parameters["info"] = info.Encode();

      var _result = RpcCall("updateAccountFull", _parameters);
      var _ret = new UpdateAccountFullResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest updateAccountFull(string password, Com.Raritan.Idl.usermgmt.UserInfo info, AsyncRpcResponse<UpdateAccountFullResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return updateAccountFull(password, info, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest updateAccountFull(string password, Com.Raritan.Idl.usermgmt.UserInfo info, AsyncRpcResponse<UpdateAccountFullResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["password"] = password;
        _parameters["info"] = info.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("updateAccountFull", _parameters,
        _result => {
          try {
            var _ret = new UpdateAccountFullResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInfoAndPrivilegesResult {
      public Com.Raritan.Idl.usermgmt.UserInfo info;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.usermgmt.Role.Privilege> privileges;
    }

    public GetInfoAndPrivilegesResult getInfoAndPrivileges() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfoAndPrivileges", _parameters);
      var _ret = new GetInfoAndPrivilegesResult();
      _ret.info = Com.Raritan.Idl.usermgmt.UserInfo.Decode(_result["info"], agent);
      _ret.privileges = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Role.Privilege>(_result["privileges"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.usermgmt.Role.Privilege.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getInfoAndPrivileges(AsyncRpcResponse<GetInfoAndPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfoAndPrivileges(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfoAndPrivileges(AsyncRpcResponse<GetInfoAndPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfoAndPrivileges", _parameters,
        _result => {
          try {
            var _ret = new GetInfoAndPrivilegesResult();
            _ret.info = Com.Raritan.Idl.usermgmt.UserInfo.Decode(_result["info"], agent);
            _ret.privileges = new System.Collections.Generic.List<Com.Raritan.Idl.usermgmt.Role.Privilege>(_result["privileges"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.usermgmt.Role.Privilege.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPreferencesResult {
      public int _ret_;
    }

    public SetPreferencesResult setPreferences(Com.Raritan.Idl.usermgmt.Preferences prefs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["prefs"] = prefs.Encode();

      var _result = RpcCall("setPreferences", _parameters);
      var _ret = new SetPreferencesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPreferences(Com.Raritan.Idl.usermgmt.Preferences prefs, AsyncRpcResponse<SetPreferencesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPreferences(prefs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPreferences(Com.Raritan.Idl.usermgmt.Preferences prefs, AsyncRpcResponse<SetPreferencesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["prefs"] = prefs.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPreferences", _parameters,
        _result => {
          try {
            var _ret = new SetPreferencesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetCapabilitiesResult {
      public Com.Raritan.Idl.usermgmt.UserCapabilities _ret_;
    }

    public GetCapabilitiesResult getCapabilities() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCapabilities", _parameters);
      var _ret = new GetCapabilitiesResult();
      _ret._ret_ = Com.Raritan.Idl.usermgmt.UserCapabilities.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getCapabilities(AsyncRpcResponse<GetCapabilitiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCapabilities(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCapabilities(AsyncRpcResponse<GetCapabilitiesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCapabilities", _parameters,
        _result => {
          try {
            var _ret = new GetCapabilitiesResult();
            _ret._ret_ = Com.Raritan.Idl.usermgmt.UserCapabilities.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
