\name{write.fasta}
\alias{write.fasta}
\title{ Write FASTA Formated Sequences }
\description{
  Write aligned or un-aligned sequences to a FASTA format file.
}
\usage{
write.fasta(alignment=NULL, ids=NULL, seqs=alignment$ali, file, append = FALSE)
}
\arguments{
  \item{alignment}{  an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}}. }
  \item{ids}{ a vector of sequence names to serve as sequence identifers }
  \item{seqs}{ an sequence or alignment character matrix or vector with a row per sequence }
  \item{file}{ name of output file.  }
  \item{append}{ logical, if TRUE output will be appended to
    \code{file}; otherwise, it will overwrite the contents of
    \code{file}. }
}
\value{
  Called for its effect.
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
 }
\author{ Barry Grant }
\note{
  For a description of FASTA format see:
  \url{http://www.ebi.ac.uk/help/formats_frame.html}.
}
\seealso{ \code{\link{read.fasta}}, \code{\link{read.fasta.pdb}} }
\examples{
## Read a PDB file
pdb <- read.pdb(system.file("examples/1bg2.pdb", package="bio3d"))

## Extract sequence from PDB file
s <- aa321(pdb$seqres)                   # SEQRES
a <- aa321(pdb$atom[pdb$calpha,"resid"]) # ATOM

## Write simple fasta file
#write.fasta( seqs=seqbind(s,a), file="eg.fa")
#write.fasta( ids=c("seqres","atom"), seqs=seqbind(s,a), file="eg.fa" )

write.fasta(list( id=c("seqres"),ali=s ), file="eg.fa")
write.fasta(list( id=c("atom"),ali=a ), file="eg.fa", append=TRUE)

## Align seqres and atom records
#seqaln(seqbind(s,a))

## Read alignment
aln<-read.fasta(system.file("examples/kinesin_xray.fa",package="bio3d"))

## Cut all but positions 330 to 345
aln$ali=aln$ali[,330:345]

write.fasta(aln, file="eg2.fa")

}
\keyword{ IO }
