% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.prepareHTS.R
\name{ascat.getAlleleCounts}
\alias{ascat.getAlleleCounts}
\title{Obtain allele counts for a given set of loci through external program alleleCounter.}
\usage{
ascat.getAlleleCounts(
  seq.file,
  output.file,
  loci.file,
  min.base.qual = 20,
  min.map.qual = 35,
  allelecounter.exe = "alleleCounter",
  additional_allelecounter_flags = NA
)
}
\arguments{
\item{seq.file}{A BAM/CRAM alignment file on which the counter should be run.}

\item{output.file}{The file where output should go.}

\item{loci.file}{A file with SNP loci.}

\item{min.base.qual}{The minimum base quality required for it to be counted (optional, default=20).}

\item{min.map.qual}{The minimum mapping quality required for it to be counted (optional, default=35).}

\item{allelecounter.exe}{A pointer to where the alleleCounter executable can be found (optional, default points to $PATH).}

\item{additional_allelecounter_flags}{Additional flags passed on to alleleCounter, e.g., -r <FASTA> for parsing CRAMs (optional, default=NA).}
}
\description{
Obtain allele counts for a given set of loci through external program alleleCounter.
}
\author{
sd11, tl, jd
}
