% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.R
\name{ascat.runAscat}
\alias{ascat.runAscat}
\title{ascat.runAscat}
\usage{
ascat.runAscat(ASCATobj, gamma = 0.55, pdfPlot = F, y_limit = 5,
  circos = NA, rho_manual = NA, psi_manual = NA, img.dir = ".",
  img.prefix = "")
}
\arguments{
\item{ASCATobj}{an ASCAT object from ascat.aspcf}

\item{gamma}{technology parameter, compaction of Log R profiles (expected decrease in case of deletion in diploid sample, 100\% aberrant cells; 1 in ideal case, 0.55 of Illumina 109K arrays)}

\item{pdfPlot}{Optional flag if nonrounded plots and ASCAT profile in pdf format are desired. Default=F}

\item{y_limit}{Optional parameter determining the size of the y axis in the nonrounded plot and ASCAT profile. Default=5}

\item{circos}{Optional file to output the non-rounded values in Circos track format. Default=NA}

\item{rho_manual}{optional argument to override ASCAT optimization and supply rho parameter (not recommended)}

\item{psi_manual}{optional argument to override ASCAT optimization and supply psi parameter (not recommended)}

\item{img.dir}{directory in which figures will be written}

\item{img.prefix}{prefix for figure names}
}
\value{
an ASCAT output object, containing:\cr
1. nA: copy number of the A allele\cr
2. nB: copy number of the B allele\cr
3. aberrantcellfraction: the aberrant cell fraction of all arrays\cr
4. ploidy: the ploidy of all arrays\cr
5. failedarrays: arrays on which ASCAT analysis failed\cr
6. nonaberrantarrays: arrays on which ASCAT analysis indicates that they show virtually no aberrations\cr
7. segments: an array containing the copy number segments of each sample (not including failed arrays)\cr
8. segments_raw: an array containing the copy number segments of each sample without any rounding applied\cr
9. distance_matrix: distances for a range of ploidy and tumor percentage values
}
\description{
ASCAT main function, calculating the allele-specific copy numbers
}
\details{
Note: for copy number only probes, nA contains the copy number value and nB = 0.
}
