% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\docType{class}
\name{unitizerGlobalBase-class}
\alias{unitizerGlobalBase-class}
\alias{unitizerGlobalStatus-class}
\alias{unitizerGlobalDisabled-class}
\alias{unitizerGlobalTracking-class}
\alias{unitizerDummy-class}
\alias{unitizerGlobalTrackingStore-class}
\alias{unitizerGlobalState-class}
\alias{unitizerGlobalIndices-class}
\alias{unitizerGlobalStateFuns-class}
\alias{unitizerGlobalNsOptConflict-class}
\title{Structures For Tracking Global Options}
\description{
Immplemented as S4 classes just so we can ensure everything is guaranteed
to have the right slots.  This is done by defining a virtual class that has
a validity function that checks the required slots exist.
}
\details{
Not we don't use "ANY" slots here because that would allow partially
specified sub classes (i.e. classes with slots that are "ANY"), which we
do not want to allow.

\code{unitizerGlobalTrackingStore} is used to keep "compressed" versions of
\code{unitizerGlobal$tracking}.  The compressed versions obviously lose some
information.  In particular, environments or things that have environments
as parents, or large objects, are not stored and instead a reference to
a \code{unitizerDummy} object is stored.  This object unambiguously
identifies a non-stored object since no user or system code should
normally creating a \code{unitizerDummy} object.

\code{unitizerGlobalState} tracks a single state which is just one value from
each of the slots of \code{unitizerGlobalTrackingStore}

When comparing state between new and reference tests, only explicitly stored
items are compared (though any extra or missing items may be brought up as
possible mismatches).
}
\keyword{internal}
