% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_grid}
\alias{expand_grid}
\title{Create a tibble from all combinations of inputs}
\usage{
expand_grid(...)
}
\arguments{
\item{...}{Name-value pairs. The name will become the column name in the
output.}
}
\value{
A tibble with one column for each input in \code{...}. The output
will have one row for each combination of the inputs, i.e. the size
be equal to the product of the sizes of the inputs. This implies
that if any input has length 0, the output will have zero rows.
}
\description{
Create a tibble from all combinations of inputs
}
\section{Compared to \link{expand.grid}}{

\itemize{
\item Varies the first element fastest.
\item Never converts strings to factors.
\item Does not add any additional attributes.
\item Returns a tibble, not a data frame.
\item Can expand any generalised vector, including data frames.
}
}

\examples{
expand_grid(x = 1:3, y = 1:2)
expand_grid(l1 = letters, l2 = LETTERS)

# Can also expand data frames
expand_grid(df = data.frame(x = 1:2, y = c(2, 1)), z = 1:3)
# And matrices
expand_grid(x1 = matrix(1:4, nrow = 2), x2 = matrix(5:8, nrow = 2))
}
