% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsettable.R
\name{subsettable}
\alias{subsettable}
\alias{$.subsettable_type}
\alias{$.subsettable_which}
\title{Define a function as being 'subsettable' using $ operator}
\usage{
\method{$}{subsettable_type}(x, name)

\method{$}{subsettable_which}(x, name)
}
\arguments{
\item{x}{A \code{subsettable_type} function.}

\item{name}{The value to use for the \verb{type=} argument.}
}
\description{
In case a textual argument allows for selecting the result, for
instance, if \code{plot()} allows for several charts that you can choose with a
\verb{type=} or \verb{which=}, making the function 'subsettable' also allows to
indicate \code{fun$variant()}. See examples.
}
\examples{
foo <- structure(function(x, type = c("histogram", "boxplot"), ...) {
  type <- match.arg(type, c("histogram", "boxplot"))
  switch(type,
    histogram = hist(x, ...),
    boxplot = boxplot(x, ...),
    stop("unknow type")
  )
}, class = c("function", "subsettable_type"))
foo

# This function can be used as usual:
foo(rnorm(50), type = "histogram")
# ... but also this way:
foo$histogram(rnorm(50))
foo$boxplot(rnorm(50))
}
\concept{create 'subsettable' functions}
\keyword{utilities}
