% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escape.R
\name{stri_unescape_unicode}
\alias{stri_unescape_unicode}
\title{Un-escape All Escape Sequences}
\usage{
stri_unescape_unicode(str)
}
\arguments{
\item{str}{character vector}
}
\value{
Returns a character vector.
If an escape sequence is ill-formed,
the result will be \code{NA} and a warning will be given.
}
\description{
Un-escapes all known escape sequences.
}
\details{
Uses \pkg{ICU}'s facilities to un-escape Unicode character sequences.

The following escape sequences are recognized:
\code{\\a}, \code{\\b}, \code{\\t}, \code{\\n}, \code{\\v}, \code{\\?},
\code{\\e}, \code{\\f}, \code{\\r}, \code{\"}, \code{\'}, \code{\\\\},
\code{\\uXXXX} (4 hex digits),
\code{\\UXXXXXXXX} (8 hex digits),
\code{\\xXX} (1-2 hex digits),
\code{\\ooo} (1-3 octal digits),
\code{\\cX} (control-X; X is masked with 0x1F).
For \code{\\xXX} and \code{\\ooo}, beware of non-valid UTF-8 byte sequences.

Note that some versions of R on Windows cannot handle
characters defined with \code{\\UXXXXXXXX}.
}
\examples{
stri_unescape_unicode('a\\\\u0105!\\\\u0032\\\\n')

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other escape: 
\code{\link{stri_escape_unicode}()}
}
\concept{escape}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
