% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/time_format.R
\name{stri_datetime_fstr}
\alias{stri_datetime_fstr}
\title{[DRAFT API] Convert \code{strptime}-style Format Strings}
\usage{
stri_datetime_fstr(x)
}
\arguments{
\item{x}{character vector consisting of date/time format strings}
}
\value{
Returns a character vector.
}
\description{
A function to convert \code{\link{strptime}}/\code{\link{strftime}}-style
format strings to \pkg{ICU} format strings that may be used
in \code{\link{stri_datetime_parse}} and \code{\link{stri_datetime_format}}
functions.
}
\details{
For more details on conversion specifiers please refer to
the manual page of \code{\link{strptime}}. Most of the formatters
of the form \code{\%x}, where \code{x} is a letter, are supported.
Moreover, each \code{\%\%} is replaced with \code{\%}.

Warnings are given in case of \code{\%x}, \code{\%X}, \code{\%u}, \code{\%w},
\code{\%g}, \code{\%G}, \code{\%c}, \code{\%U} and \code{\%W}
as in such circumstances either \pkg{ICU} does not
support requested functionality using format-strings API
or there are some inconsistencies between base R and \pkg{ICU}.
}
\examples{
stri_datetime_fstr("\%Y-\%m-\%d \%H:\%M:\%S")
}
\seealso{
Other datetime: \code{\link{stri_datetime_add}},
  \code{\link{stri_datetime_add<-}};
  \code{\link{stri_datetime_create}};
  \code{\link{stri_datetime_fields}};
  \code{\link{stri_datetime_format}},
  \code{\link{stri_datetime_format}},
  \code{\link{stri_datetime_parse}};
  \code{\link{stri_datetime_now}};
  \code{\link{stri_datetime_symbols}};
  \code{\link{stri_timezone_get}},
  \code{\link{stri_timezone_set}};
  \code{\link{stri_timezone_info}};
  \code{\link{stri_timezone_list}}
}

